/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.NotEnoughReplicasAfterAppendException;
import org.apache.kafka.common.errors.NotEnoughReplicasException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001\u001d\u00111\u0004\u0015:pIV\u001cWM\u001d$bS2,(/\u001a%b]\u0012d\u0017N\\4UKN$(BA\u0002\u0005\u0003\r\t\u0007/\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\tYA!A\u0006j]R,wM]1uS>t\u0017BA\u0007\u000b\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\b\"B\b\u0001\t\u0003\u0001\u0012A\u0002\u001fj]&$h\bF\u0001\u0012!\t\u0011\u0002!D\u0001\u0003\u0011\u001d!\u0002A1A\u0005\nU\t!\u0003\u001d:pIV\u001cWM\u001d\"vM\u001a,'oU5{KV\ta\u0003\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0002J]RDa!\b\u0001!\u0002\u00131\u0012a\u00059s_\u0012,8-\u001a:Ck\u001a4WM]*ju\u0016\u0004\u0003bB\u0010\u0001\u0005\u0004%I!F\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0011\u0019\t\u0003\u0001)A\u0005-\u000512/\u001a:wKJlUm]:bO\u0016l\u0015\r\u001f\"zi\u0016\u001c\b\u0005C\u0004$\u0001\t\u0007I\u0011B\u000b\u0002;I,\u0007\u000f\\5dC\u001a+Go\u00195NCb\u0004\u0016M\u001d;ji&|gNQ=uKNDa!\n\u0001!\u0002\u00131\u0012A\b:fa2L7-\u0019$fi\u000eDW*\u0019=QCJ$\u0018\u000e^5p]\nKH/Z:!\u0011\u001d9\u0003A1A\u0005\nU\tAD]3qY&\u001c\u0017MR3uG\"l\u0015\r\u001f*fgB|gn]3CsR,7\u000f\u0003\u0004*\u0001\u0001\u0006IAF\u0001\u001ee\u0016\u0004H.[2b\r\u0016$8\r['bqJ+7\u000f]8og\u0016\u0014\u0015\u0010^3tA!91\u0006\u0001b\u0001\n\u0003)\u0012A\u00038v[N+'O^3sg\"1Q\u0006\u0001Q\u0001\nY\t1B\\;n'\u0016\u0014h/\u001a:tA!9q\u0006\u0001b\u0001\n\u0003\u0001\u0014aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003E\u0002\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA4G\u0001\u0006Qe>\u0004XM\u001d;jKNDaA\u000f\u0001!\u0002\u0013\t\u0014\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0011\u0015a\u0004\u0001\"\u0001>\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001 \u0011\u0007}:%J\u0004\u0002A\u000b:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IB\u0001\u0007yI|w\u000e\u001e \n\u0003eI!A\u0012\r\u0002\u000fA\f7m[1hK&\u0011\u0001*\u0013\u0002\u0004'\u0016\f(B\u0001$\u0019!\tYe*D\u0001M\u0015\tiE!\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u00131bS1gW\u0006\u001cuN\u001c4jO\"9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0016!\u00039s_\u0012,8-\u001a:2+\u0005\u0019\u0006\u0003\u0002+_A\u0002l\u0011!\u0016\u0006\u0003-^\u000b\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u00031f\u000bqa\u00197jK:$8O\u0003\u0002\u00065*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyVKA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM\u001d\t\u0004/\u0005\u001c\u0017B\u00012\u0019\u0005\u0015\t%O]1z!\t9B-\u0003\u0002f1\t!!)\u001f;f\u0011\u001d9\u0007\u00011A\u0005\n!\fQ\u0002\u001d:pIV\u001cWM]\u0019`I\u0015\fHCA5m!\t9\".\u0003\u0002l1\t!QK\\5u\u0011\u001dig-!AA\u0002M\u000b1\u0001\u001f\u00132\u0011\u0019y\u0007\u0001)Q\u0005'\u0006Q\u0001O]8ek\u000e,'/\r\u0011\t\u000fE\u0004\u0001\u0019!C\u0005%\u0006I\u0001O]8ek\u000e,'O\r\u0005\bg\u0002\u0001\r\u0011\"\u0003u\u00035\u0001(o\u001c3vG\u0016\u0014(g\u0018\u0013fcR\u0011\u0011.\u001e\u0005\b[J\f\t\u00111\u0001T\u0011\u00199\b\u0001)Q\u0005'\u0006Q\u0001O]8ek\u000e,'O\r\u0011\t\u000fe\u0004\u0001\u0019!C\u0005%\u0006I\u0001O]8ek\u000e,'o\r\u0005\bw\u0002\u0001\r\u0011\"\u0003}\u00035\u0001(o\u001c3vG\u0016\u00148g\u0018\u0013fcR\u0011\u0011. \u0005\b[j\f\t\u00111\u0001T\u0011\u0019y\b\u0001)Q\u0005'\u0006Q\u0001O]8ek\u000e,'o\r\u0011\t\u0011\u0005\r\u0001\u00011A\u0005\nI\u000b\u0011\u0002\u001d:pIV\u001cWM\u001d\u001b\t\u0013\u0005\u001d\u0001\u00011A\u0005\n\u0005%\u0011!\u00049s_\u0012,8-\u001a:5?\u0012*\u0017\u000fF\u0002j\u0003\u0017A\u0001\"\\A\u0003\u0003\u0003\u0005\ra\u0015\u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003T\u0003)\u0001(o\u001c3vG\u0016\u0014H\u0007\t\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+\ta\u0001^8qS\u000e\fTCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fk\u0005!A.\u00198h\u0013\u0011\t\t#a\u0007\u0003\rM#(/\u001b8h\u0011!\t)\u0003\u0001Q\u0001\n\u0005]\u0011a\u0002;pa&\u001c\u0017\u0007\t\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003+\ta\u0001^8qS\u000e\u0014\u0004\u0002CA\u0017\u0001\u0001\u0006I!a\u0006\u0002\u000fQ|\u0007/[23A!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0012!B:fiV\u0003H#A5)\t\u0005=\u0012q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b/\u0002\u000b),h.\u001b;\n\t\u0005\u0005\u00131\b\u0002\u0007\u0005\u00164wN]3\t\u000f\u0005\u0015\u0003\u0001\"\u0011\u00024\u0005AA/Z1s\t><h\u000e\u000b\u0003\u0002D\u0005%\u0003\u0003BA\u001d\u0003\u0017JA!!\u0014\u0002<\t)\u0011I\u001a;fe\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0012!\b;fgR$vn\u001c'be\u001e,'+Z2pe\u0012<\u0016\u000e\u001e5BG.TVM]8)\t\u0005=\u0013Q\u000b\t\u0005\u0003s\t9&\u0003\u0003\u0002Z\u0005m\"\u0001\u0002+fgRDq!!\u0018\u0001\t\u0003\t\u0019$\u0001\u000fuKN$Hk\\8MCJ<WMU3d_J$w+\u001b;i\u0003\u000e\\wJ\\3)\t\u0005m\u0013Q\u000b\u0005\b\u0003G\u0002A\u0011BA3\u0003-\u001a\u0007.Z2l)>|G*\u0019:hKJ+7m\u001c:e\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032dGcA5\u0002h!9\u0011\u0011NA1\u0001\u00041\u0012\u0001D7bq\u001a+Go\u00195TSj,\u0007bBA7\u0001\u0011\u0005\u00111G\u0001.i\u0016\u001cH\u000fU1si&$\u0018n\u001c8U_>d\u0015M]4f\r>\u0014(+\u001a9mS\u000e\fG/[8o/&$\b.Q2l\u00032d\u0007\u0006BA6\u0003+Bq!a\u001d\u0001\t\u0003\t\u0019$\u0001\u0017uKN$(+Z:q_:\u001cX\rV8p\u0019\u0006\u0014x-\u001a$peJ+\u0007\u000f\\5dCRLwN\\,ji\"\f5m[!mY\"\"\u0011\u0011OA+\u0011\u001d\tI\b\u0001C\u0001\u0003g\tA\u0003^3ti:{g.\u0012=jgR,g\u000e\u001e+pa&\u001c\u0007\u0006BA<\u0003+Bq!a \u0001\t\u0003\t\u0019$A\nuKN$xK]8oO\n\u0013xn[3s\u0019&\u001cH\u000f\u000b\u0003\u0002~\u0005U\u0003bBAC\u0001\u0011\u0005\u00111G\u0001\u0015i\u0016\u001cH/\u00138wC2LG\rU1si&$\u0018n\u001c8)\t\u0005\r\u0015Q\u000b\u0005\b\u0003\u0017\u0003A\u0011AA\u001a\u0003M!Xm\u001d;TK:$\u0017I\u001a;fe\u000ecwn]3eQ\u0011\tI)!\u0016\t\u000f\u0005E\u0005\u0001\"\u0001\u00024\u0005iB/Z:u\u0007\u0006tgn\u001c;TK:$Gk\\%oi\u0016\u0014h.\u00197U_BL7\r\u000b\u0003\u0002\u0010\u0006U\u0003bBAL\u0001\u0011\u0005\u00111G\u0001\u0016i\u0016\u001cHOT8u\u000b:|Wo\u001a5SKBd\u0017nY1tQ\u0011\t)*!\u0016\t\u000f\u0005u\u0005\u0001\"\u0001\u00024\u0005AC/Z:u\u001d>$XI\\8vO\"\u0014V\r\u001d7jG\u0006\u001c\u0018I\u001a;fe\n\u0013xn[3s'\",H\u000fZ8x]\"\"\u00111TA+\u0001")
public class ProducerFailureHandlingTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int replicaFetchMaxPartitionBytes = this.serverMessageMaxBytes() + 200;
    private final int replicaFetchMaxResponseBytes = this.replicaFetchMaxPartitionBytes() + 200;
    private final int numServers;
    private final Properties overridingProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer1;
    private KafkaProducer<byte[], byte[]> producer2;
    private KafkaProducer<byte[], byte[]> producer3;
    private KafkaProducer<byte[], byte[]> producer4;
    private final String topic1;
    private final String topic2;

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    private int replicaFetchMaxPartitionBytes() {
        return this.replicaFetchMaxPartitionBytes;
    }

    private int replicaFetchMaxResponseBytes() {
        return this.replicaFetchMaxResponseBytes;
    }

    public int numServers() {
        return this.numServers;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    private KafkaProducer<byte[], byte[]> producer1() {
        return this.producer1;
    }

    private void producer1_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer1 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer2() {
        return this.producer2;
    }

    private void producer2_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer2 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer3() {
        return this.producer3;
    }

    private void producer3_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer3 = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer4() {
        return this.producer4;
    }

    private void producer4_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer4 = x$1;
    }

    private String topic1() {
        return this.topic1;
    }

    private String topic2() {
        return this.topic2;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        String x$2 = this.brokerList();
        int x$3 = 0;
        long x$4 = 30000L;
        long x$5 = 10000L;
        long x$6 = this.producerBufferSize();
        int x$7 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$8 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$9 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$10 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$11 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$12 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$13 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$14 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer1_$eq(TestUtils$.MODULE$.createNewProducer(x$2, x$3, x$5, x$6, x$7, x$8, x$4, x$9, x$10, x$11, x$12, x$13, x$14));
        String x$15 = this.brokerList();
        int x$16 = 1;
        long x$17 = 30000L;
        long x$18 = 10000L;
        long x$19 = this.producerBufferSize();
        int x$20 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$21 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$22 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$23 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$24 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$25 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$26 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$27 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer2_$eq(TestUtils$.MODULE$.createNewProducer(x$15, x$16, x$18, x$19, x$20, x$21, x$17, x$22, x$23, x$24, x$25, x$26, x$27));
        String x$28 = this.brokerList();
        int x$29 = -1;
        long x$30 = 30000L;
        long x$31 = 10000L;
        long x$32 = this.producerBufferSize();
        int x$33 = TestUtils$.MODULE$.createNewProducer$default$5();
        long x$34 = TestUtils$.MODULE$.createNewProducer$default$6();
        SecurityProtocol x$35 = TestUtils$.MODULE$.createNewProducer$default$8();
        Option<File> x$36 = TestUtils$.MODULE$.createNewProducer$default$9();
        Option<Properties> x$37 = TestUtils$.MODULE$.createNewProducer$default$10();
        ByteArraySerializer x$38 = TestUtils$.MODULE$.createNewProducer$default$11();
        ByteArraySerializer x$39 = TestUtils$.MODULE$.createNewProducer$default$12();
        Option<Properties> x$40 = TestUtils$.MODULE$.createNewProducer$default$13();
        this.producer3_$eq(TestUtils$.MODULE$.createNewProducer(x$28, x$29, x$31, x$32, x$33, x$34, x$30, x$35, x$36, x$37, x$38, x$39, x$40));
    }

    @Override
    @After
    public void tearDown() {
        if (this.producer1() != null) {
            this.producer1().close();
        }
        if (this.producer2() != null) {
            this.producer2().close();
        }
        if (this.producer3() != null) {
            this.producer3().close();
        }
        if (this.producer4() != null) {
            this.producer4().close();
        }
        super.tearDown();
    }

    @Test
    public void testTooLargeRecordWithAckZero() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer1().send(record).get();
        Assert.assertNotNull((Object)recordMetadata);
        Assert.assertFalse((boolean)recordMetadata.hasOffset());
        Assert.assertEquals((long)-1L, (long)recordMetadata.offset());
    }

    @Test
    public void testTooLargeRecordWithAckOne() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)new byte[this.serverMessageMaxBytes() + 1]);
        this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer2().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }

    private void checkTooLargeRecordForReplicationWithAckAll(int maxFetchSize) {
        int maxMessageSize = maxFetchSize + 100;
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        topicConfig.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)maxMessageSize)).toString());
        String topic10 = "topic10";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic10, this.servers().size(), this.numServers(), (Seq<KafkaServer>)this.servers(), topicConfig);
        byte[] value = new byte[maxMessageSize - 61 - 21];
        ProducerRecord record = new ProducerRecord(topic10, null, (Object)value);
        RecordMetadata recordMetadata = (RecordMetadata)this.producer3().send(record).get();
        Assert.assertEquals((Object)topic10, (Object)recordMetadata.topic());
    }

    @Test
    public void testPartitionTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxPartitionBytes());
    }

    @Test
    public void testResponseTooLargeForReplicationWithAckAll() {
        this.checkTooLargeRecordForReplicationWithAckAll(this.replicaFetchMaxResponseBytes());
    }

    @Test
    public void testNonExistentTopic() {
        ProducerRecord record = new ProducerRecord(this.topic2(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer1().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
    }

    @Test
    public void testWrongBrokerList() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.producer4_$eq(TestUtils$.MODULE$.createNewProducer("localhost:8686,localhost:4242", 1, 10000L, this.producerBufferSize(), TestUtils$.MODULE$.createNewProducer$default$5(), TestUtils$.MODULE$.createNewProducer$default$6(), TestUtils$.MODULE$.createNewProducer$default$7(), TestUtils$.MODULE$.createNewProducer$default$8(), TestUtils$.MODULE$.createNewProducer$default$9(), TestUtils$.MODULE$.createNewProducer$default$10(), TestUtils$.MODULE$.createNewProducer$default$11(), TestUtils$.MODULE$.createNewProducer$default$12(), TestUtils$.MODULE$.createNewProducer$default$13()));
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer4().send(record).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
    }

    @Test
    public void testInvalidPartition() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord higherRecord = new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(1), (Object)"key".getBytes(), (Object)"value".getBytes());
        this.intercept((Function0 & Serializable & scala.Serializable)() -> this.producer1().send(higherRecord), ClassTag$.MODULE$.apply(KafkaException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    @Test
    public void testSendAfterClosed() {
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), 1, this.numServers(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        ProducerRecord record = new ProducerRecord(this.topic1(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer1().send(record).get();
        this.producer2().send(record).get();
        this.producer3().send(record).get();
        this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            this.producer1().close();
            return this.producer1().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            this.producer2().close();
            return this.producer2().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            this.producer3().close();
            return this.producer3().send(record);
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }

    @Test
    public void testCannotSendToInternalTopic() {
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaServer>)this.servers());
        ExecutionException thrown = (ExecutionException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (RecordMetadata)this.producer2().send(new ProducerRecord("__consumer_offsets", (Object)"test".getBytes(), (Object)"test".getBytes())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        Assert.assertTrue((String)("Unexpected exception while sending to an invalid topic " + thrown.getCause()), (boolean)(thrown.getCause() instanceof InvalidTopicException));
    }

    @Test
    public void testNotEnoughReplicas() {
        String topicName = "minisrtest";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)(this.numServers() + 1))).toString());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicName, 1, this.numServers(), (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        try {
            this.producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof NotEnoughReplicasException)) {
                throw this.fail("Expected NotEnoughReplicasException when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            }
            return;
        }
    }

    @Test
    public void testNotEnoughReplicasAfterBrokerShutdown() {
        String topicName = "minisrtest2";
        Properties topicProps = new Properties();
        topicProps.put("min.insync.replicas", ((Object)BoxesRunTime.boxToInteger((int)this.numServers())).toString());
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicName, 1, this.numServers(), (Seq<KafkaServer>)this.servers(), topicProps);
        ProducerRecord record = new ProducerRecord(topicName, null, (Object)"key".getBytes(), (Object)"value".getBytes());
        this.producer3().send(record).get();
        ((KafkaServer)this.servers().head()).shutdown();
        ((KafkaServer)this.servers().head()).awaitShutdown();
        try {
            this.producer3().send(record).get();
            throw this.fail("Expected exception when producing to topic with fewer brokers than min.insync.replicas", new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof NotEnoughReplicasException || e.getCause() instanceof NotEnoughReplicasAfterAppendException || e.getCause() instanceof TimeoutException)) {
                throw this.fail("Expected NotEnoughReplicasException or NotEnoughReplicasAfterAppendException when producing to topic with fewer brokers than min.insync.replicas, but saw " + e.getCause(), new Position("ProducerFailureHandlingTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            }
            ((KafkaServer)this.servers().head()).startup();
            return;
        }
    }

    public ProducerFailureHandlingTest() {
        this.producerBufferSize = 30000;
        this.numServers = 2;
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.serverMessageMaxBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxPartitionBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchResponseMaxBytesDoc(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMaxResponseBytes())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        this.producer1 = null;
        this.producer2 = null;
        this.producer3 = null;
        this.producer4 = null;
        this.topic1 = "topic-1";
        this.topic2 = "topic-2";
    }
}

