/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.List;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.cluster.Replica;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.Log;
import kafka.log.TimestampOffset;
import kafka.network.RequestChannel;
import kafka.security.auth.Authorizer;
import kafka.server.AdminManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.FetchManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001df\u0001B\u0001\u0003\u0001\u001d\u0011QbS1gW\u0006\f\u0005/[:UKN$(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012A\u0004:fcV,7\u000f^\"iC:tW\r\\\u000b\u0002-A\u0011qCG\u0007\u00021)\u0011\u0011\u0004B\u0001\b]\u0016$xo\u001c:l\u0013\tY\u0002D\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\t\ru\u0001\u0001\u0015!\u0003\u0017\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0003bB\u0010\u0001\u0005\u0004%I\u0001I\u0001\u0016e\u0016\fX/Z:u\u0007\"\fgN\\3m\u001b\u0016$(/[2t+\u0005\t\u0003C\u0001\u0012&\u001d\t92%\u0003\u0002%1\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017B\u0001\u0014(\u0005\u001diU\r\u001e:jGNT!\u0001\n\r\t\r%\u0002\u0001\u0015!\u0003\"\u0003Y\u0011X-];fgR\u001c\u0005.\u00198oK2lU\r\u001e:jGN\u0004\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005i\u0003C\u0001\n/\u0013\ty#A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\rE\u0002\u0001\u0015!\u0003.\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003bB\u001a\u0001\u0005\u0004%I\u0001N\u0001\u0011OJ|W\u000f]\"p_J$\u0017N\\1u_J,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQa\u001a:pkBT!A\u000f\u0003\u0002\u0017\r|wN\u001d3j]\u0006$xN]\u0005\u0003y]\u0012\u0001c\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:\t\ry\u0002\u0001\u0015!\u00036\u0003E9'o\\;q\u0007>|'\u000fZ5oCR|'\u000f\t\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u00031\tG-\\5o\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0005C\u0001\nD\u0013\t!%A\u0001\u0007BI6Lg.T1oC\u001e,'\u000f\u0003\u0004G\u0001\u0001\u0006IAQ\u0001\u000eC\u0012l\u0017N\\'b]\u0006<WM\u001d\u0011\t\u000f!\u0003!\u0019!C\u0005\u0013\u0006qA\u000f\u001f8D_>\u0014H-\u001b8bi>\u0014X#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055K\u0014a\u0003;sC:\u001c\u0018m\u0019;j_:L!a\u0014'\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_JDa!\u0015\u0001!\u0002\u0013Q\u0015a\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\t\u000fM\u0003!\u0019!C\u0005)\u0006Q1m\u001c8ue>dG.\u001a:\u0016\u0003U\u0003\"A\u0016-\u000e\u0003]S!a\u0015\u0003\n\u0005e;&aD&bM.\f7i\u001c8ue>dG.\u001a:\t\rm\u0003\u0001\u0015!\u0003V\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\t\u000fu\u0003!\u0019!C\u0005=\u0006A!p[\"mS\u0016tG/F\u0001`!\t\u00017-D\u0001b\u0015\t\u0011G!\u0001\u0002{W&\u0011A-\u0019\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\r\u0019\u0004\u0001\u0015!\u0003`\u0003%Q8n\u00117jK:$\b\u0005C\u0004i\u0001\t\u0007I\u0011B5\u0002\u000f5,GO]5dgV\t!\u000e\u0005\u0002li6\tAN\u0003\u0002i[*\u0011an\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015\u0001(BA9s\u0003\u0019\t\u0007/Y2iK*\t1/A\u0002pe\u001eL!A\n7\t\rY\u0004\u0001\u0015!\u0003k\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002=\u0001\u0005\u0004%I!_\u0001\tEJ|7.\u001a:JIV\t!\u0010\u0005\u0002\nw&\u0011AP\u0003\u0002\u0004\u0013:$\bB\u0002@\u0001A\u0003%!0A\u0005ce>\\WM]%eA!I\u0011\u0011\u0001\u0001C\u0002\u0013%\u00111A\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0005\u0005\u0015\u0001c\u0001\n\u0002\b%\u0019\u0011\u0011\u0002\u0002\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u0015\u0011AD7fi\u0006$\u0017\r^1DC\u000eDW\r\t\u0005\n\u0003#\u0001!\u0019!C\u0005\u0003'\t!\"Y;uQ>\u0014\u0018N_3s+\t\t)\u0002E\u0003\n\u0003/\tY\"C\u0002\u0002\u001a)\u0011aa\u00149uS>t\u0007\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0005CV$\bNC\u0002\u0002&\u0011\t\u0001b]3dkJLG/_\u0005\u0005\u0003S\tyB\u0001\u0006BkRDwN]5{KJD\u0001\"!\f\u0001A\u0003%\u0011QC\u0001\fCV$\bn\u001c:ju\u0016\u0014\b\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024\u0005\u00112\r\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s+\t\t)\u0004E\u0002\u0013\u0003oI1!!\u000f\u0003\u0005I\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:\t\u0011\u0005u\u0002\u0001)A\u0005\u0003k\t1c\u00197jK:$\u0018+^8uC6\u000bg.Y4fe\u0002B\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\u00023\rd\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\u000b\u0003\u0003\u000b\u00022AEA$\u0013\r\tIE\u0001\u0002\u001a\u00072LWM\u001c;SKF,Xm\u001d;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA#\u0003i\u0019G.[3oiJ+\u0017/^3tiF+x\u000e^1NC:\fw-\u001a:!\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019&A\nsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002VA\u0019!#a\u0016\n\u0007\u0005e#AA\fSKBd\u0017nY1uS>t\u0017+^8uC6\u000bg.Y4fe\"A\u0011Q\f\u0001!\u0002\u0013\t)&\u0001\u000bsKBd\u0017nY1Rk>$\u0018-T1oC\u001e,'\u000f\t\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003G\na!];pi\u0006\u001cXCAA3!\u0011\t9'a\u001f\u000f\t\u0005%\u0014q\u000f\b\u0005\u0003W\n)H\u0004\u0003\u0002n\u0005MTBAA8\u0015\r\t\tHB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0007\u0005e$!\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002~\u0005}$!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002z\tA\u0001\"a!\u0001A\u0003%\u0011QM\u0001\bcV|G/Y:!\u0011%\t9\t\u0001b\u0001\n\u0013\tI)\u0001\u0007gKR\u001c\u0007.T1oC\u001e,'/\u0006\u0002\u0002\fB\u0019!#!$\n\u0007\u0005=%A\u0001\u0007GKR\u001c\u0007.T1oC\u001e,'\u000f\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BAF\u000351W\r^2i\u001b\u0006t\u0017mZ3sA!I\u0011q\u0013\u0001C\u0002\u0013%\u0011\u0011T\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN,\"!a'\u0011\u0007I\ti*C\u0002\u0002 \n\u0011\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\u0011\u0005\r\u0006\u0001)A\u0005\u00037\u000b\u0011C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u0011%\t9\u000b\u0001b\u0001\n\u0013\tI+A\u0005dYV\u001cH/\u001a:JIV\u0011\u00111\u0016\t\u0005\u0003[\u000b9,\u0004\u0002\u00020*!\u0011\u0011WAZ\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0016\u0001\u00026bm\u0006LA!!/\u00020\n11\u000b\u001e:j]\u001eD\u0001\"!0\u0001A\u0003%\u00111V\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0003\"CAa\u0001\t\u0007I\u0011BAb\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003\u001bl!!!3\u000b\u0007\u0005-G!A\u0003vi&d7/\u0003\u0003\u0002P\u0006%'\u0001C'pG.$\u0016.\\3\t\u0011\u0005M\u0007\u0001)A\u0005\u0003\u000b\fQ\u0001^5nK\u0002Bq!a6\u0001\t\u0003\tI.\u0001\u0005uK\u0006\u0014Hi\\<o)\t\tY\u000eE\u0002\n\u0003;L1!a8\u000b\u0005\u0011)f.\u001b;)\t\u0005U\u00171\u001d\t\u0005\u0003K\fY/\u0004\u0002\u0002h*\u0019\u0011\u0011\u001e:\u0002\u000b),h.\u001b;\n\t\u00055\u0018q\u001d\u0002\u0006\u0003\u001a$XM\u001d\u0005\b\u0003c\u0004A\u0011AAz\u0003=\u0019'/Z1uK.\u000bgm[1Ba&\u001cH\u0003BA{\u0003w\u00042AEA|\u0013\r\tIP\u0001\u0002\n\u0017\u000647.Y!qSND!\"!@\u0002pB\u0005\t\u0019AA\u0000\u0003iIg\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003\t\u0005\u0019\u0011\r]5\n\t\t%!1\u0001\u0002\u000b\u0003BLg+\u001a:tS>t\u0007b\u0002B\u0007\u0001\u0011\u0005\u0011\u0011\\\u0001gg\"|W\u000f\u001c3UQJ|w/\u00168tkB\u0004xN\u001d;fIZ+'o]5p]\u0016C8-\u001a9uS>twJ\u001c%b]\u0012dW-\u00113e\u001f\u001a47/\u001a;U_RChNU3rk\u0016\u001cHo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0005\u0003\f\tE!q\u0003B\r!\u0011\t)Oa\u0005\n\t\tU\u0011q\u001d\u0002\u0005)\u0016\u001cH/\u0001\u0005fqB,7\r^3eG\t\u0011Y\u0002\u0005\u0003\u0003\u001e\t\rRB\u0001B\u0010\u0015\r\u0011\t#\\\u0001\u0007KJ\u0014xN]:\n\t\t\u0015\"q\u0004\u0002\u001c+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8\t\u000f\t%\u0002\u0001\"\u0001\u0002Z\u0006Q7\u000f[8vY\u0012$\u0006N]8x+:\u001cX\u000f\u001d9peR,GMV3sg&|g.\u0012=dKB$\u0018n\u001c8P]\"\u000bg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChNU3rk\u0016\u001cHo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7O_R\u001cV\u000f\u001d9peR,G\r\u000b\u0005\u0003(\tE!q\u0003B\r\u0011\u001d\u0011y\u0003\u0001C\u0001\u00033\fqm\u001d5pk2$G\u000b\u001b:poVs7/\u001e9q_J$X\r\u001a,feNLwN\\#yG\u0016\u0004H/[8o\u001f:D\u0015M\u001c3mKRChn\u00144gg\u0016$8i\\7nSR\u0014V-];fgR<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|GNT8u'V\u0004\bo\u001c:uK\u0012D\u0003B!\f\u0003\u0012\t]!\u0011\u0004\u0005\b\u0005k\u0001A\u0011AAm\u0003y\u001b\bn\\;mIRC'o\\<V]N,\b\u000f]8si\u0016$g+\u001a:tS>tW\t_2faRLwN\\(o\u0011\u0006tG\r\\3F]\u0012$\u0006P\u001c*fcV,7\u000f^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u001d>$8+\u001e9q_J$X\r\u001a\u0015\t\u0005g\u0011\tBa\u0006\u0003\u001a!9!1\b\u0001\u0005\u0002\u0005e\u0017aZ:i_VdG\r\u00165s_^,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]>s\u0007*\u00198eY\u0016<&/\u001b;f)btW*\u0019:lKJ\u001c(+Z9vKN$x\u000b[3o\u0013:$XM\u001d\"s_.,'\u000f\u0015:pi>\u001cw\u000e\u001c(piN+\b\u000f]8si\u0016$\u0007\u0006\u0003B\u001d\u0005#\u00119B!\u0007\t\u000f\t\u0005\u0003\u0001\"\u0001\u0002Z\u0006i6\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5V]N,\b\u000f]8si\u0016$gi\u001c:NKN\u001c\u0018mZ3G_Jl\u0017\r^(o\u0011\u0006tG\r\\3Xe&$X\r\u0016=o\u001b\u0006\u00148.\u001a:t/\",g.T1hS\u000edun^3s)\"\fgNU3rk&\u0014X\r\u001a\u0015\u0005\u0005\u007f\u0011\t\u0002C\u0004\u0003H\u0001!\t!!7\u0002kMDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00168l]><h\u000eV8qS\u000e<\u0006.\u001a8QCJ$\u0018\u000e^5p]&\u001bhj\u001c;I_N$X\r\u001a\u0015\u0005\u0005\u000b\u0012\t\u0002C\u0004\u0003N\u0001!\t!!7\u0002'NDw.\u001e7e%\u0016\u001c\bo\u001c8e/&$\b.\u00168tkB\u0004xN\u001d;fI6+7o]1hK\u001a{'/\\1u\r>\u0014()\u00193QCJ$\u0018\u000e^5p]\u0006sGMT8FeJ|'o\u001d$pe\u001e{w\u000e\u001a)beRLG/[8oQ\u0011\u0011YE!\u0005\t\u000f\tM\u0003\u0001\"\u0001\u0002Z\u0006\u00116\u000f[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5V].twn\u001e8U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u001a{'OQ1e!\u0006\u0014H/\u001b;j_:\fe\u000e\u001a(p\u000bJ\u0014xN]:G_J<un\u001c3QCJ$\u0018\u000e^5p]\"\"!\u0011\u000bB\t\u0011\u001d\u0011I\u0006\u0001C\u0001\u00033\f\u0011h\u001d5pk2$\u0017\t\u001d9f]\u0012$v\u000eT8h\u001f:<&/\u001b;f)btW*\u0019:lKJ\u001cx\u000b[3o\u0007>\u0014(/Z2u\u001b\u0006<\u0017n\u0019,feNLwN\u001c\u0015\u0005\u0005/\u0012\t\u0002C\u0004\u0003`\u0001!\t!!7\u0002wQ,7\u000f\u001e*fC\u0012,fnY8n[&$H/\u001a3D_:\u001cX/\\3s\u0019&\u001cHo\u00144gg\u0016$H*[7ji\u0016$\u0017\t\u001e%jO\"<\u0016\r^3s[\u0006\u00148\u000e\u000b\u0003\u0003^\tE\u0001b\u0002B3\u0001\u0011\u0005\u0011\u0011\\\u0001=i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'\u000fT5ti>3gm]3u\u0019&l\u0017\u000e^3e\u0003Rd\u0015m\u001d;Ti\u0006\u0014G.Z(gMN,G\u000f\u000b\u0003\u0003d\tE\u0001b\u0002B6\u0001\u0011%!QN\u0001\u001ci\u0016\u001cHoQ8ogVlWM\u001d'jgR|eMZ:fi2KW.\u001b;\u0015\t\u0005m'q\u000e\u0005\t\u0005c\u0012I\u00071\u0001\u0003t\u0005q\u0011n]8mCRLwN\u001c'fm\u0016d\u0007\u0003\u0002B;\u0005wj!Aa\u001e\u000b\u0007\teT.\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011iHa\u001e\u0003\u001d%\u001bx\u000e\\1uS>tG*\u001a<fY\"9!\u0011\u0011\u0001\u0005\u0002\u0005e\u0017A\u0012;fgR\u0014V-\u00193V]\u000e|W.\\5ui\u0016$7i\u001c8tk6,'\u000fT5ti>3gm]3u\u000b\u0006\u0014H.[3ti>3gm]3u\u000bF,\u0018\r\\:IS\u001eDw+\u0019;fe6\f'o\u001b\u0015\u0005\u0005\u007f\u0012\t\u0002C\u0004\u0003\b\u0002!\t!!7\u0002\u000fR,7\u000f\u001e*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d'jgR|eMZ:fi\u0016\u000b'\u000f\\5fgR|eMZ:fi\u0016\u000bX/\u00197t\u0019\u0006\u001cHo\u0015;bE2,wJ\u001a4tKRDCA!\"\u0003\u0012!9!Q\u0012\u0001\u0005\n\t=\u0015a\f;fgR\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;FCJd\u0017.Z:u\u001f\u001a47/\u001a;FcV\fGn\u001d'j[&$H\u0003BAn\u0005#C\u0001B!\u001d\u0003\f\u0002\u0007!1\u000f\u0005\b\u0005+\u0003A\u0011AAm\u0003-\"Xm\u001d;SK\u0006$WK\\2p[6LG\u000f^3e\u0007>t7/^7fe2K7\u000f^(gMN,G\u000fT1uKN$\b\u0006\u0002BJ\u0005#AqAa'\u0001\t\u0003\tI.A\u0015uKN$(+Z1e\u0007>lW.\u001b;uK\u0012\u001cuN\\:v[\u0016\u0014H*[:u\u001f\u001a47/\u001a;MCR,7\u000f\u001e\u0015\u0005\u00053\u0013\t\u0002C\u0004\u0003\"\u0002!\t!!7\u0002\u0013R,7\u000f^'fi\u0006$\u0017\r^1SKF,Xm\u001d;P]NC\u0017M]3e\u0019&\u001cH/\u001a8fe^KG\u000f[%oG>t7/[:uK:$H*[:uK:,'o]!de>\u001c8O\u0011:pW\u0016\u00148\u000f\u000b\u0003\u0003 \nE\u0001b\u0002BT\u0001\u0011\u0005\u0011\u0011\\\u0001Li\u0016\u001cH/T3uC\u0012\fG/\u0019*fcV,7\u000f^(o\t&\u001cH/\u001b8di2K7\u000f^3oKJ<\u0016\u000e\u001e5J]\u000e|gn]5ti\u0016tG\u000fT5ti\u0016tWM]:BGJ|7o\u001d\"s_.,'o\u001d\u0015\u0005\u0005K\u0013\t\u0002C\u0004\u0003.\u0002!IAa,\u0002YU\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3XSRD\u0017J\\2p]NL7\u000f^3oi2K7\u000f^3oKJ\u001cHC\u0001BY!\u001dI!1\u0017B\\\u0005oK1A!.\u000b\u0005\u0019!V\u000f\u001d7feA!!\u0011\u0018B_\u001b\t\u0011YL\u0003\u0002\u001a[&!!q\u0018B^\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\u0011\u0019\r\u0001C\u0005\u0005\u000b\fAf]3oI6+G/\u00193bi\u0006\u0014V-];fgR<\u0016\u000e\u001e5J]\u000e|gn]5ti\u0016tG\u000fT5ti\u0016tWM]:\u0015\t\t\u001d'Q\u001a\t\u0005\u0005k\u0012I-\u0003\u0003\u0003L\n]$\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011!\u0011yM!1A\u0002\t]\u0016a\u0004:fcV,7\u000f\u001e'jgR,g.\u001a:\t\u000f\tM\u0007\u0001\"\u0003\u0003V\u0006aB/Z:u\u0007>t7/^7fe2K7\u000f^(gMN,G\u000fT1uKN$H\u0003BAn\u0005/D\u0001B!\u001d\u0003R\u0002\u0007!1\u000f\u0005\b\u00057\u0004A\u0011\u0002Bo\u0003q\u0019'/Z1uK^\u0013\u0018\u000e^3Uq:l\u0015M]6feN\u0014V-];fgR$BAa8\u0003nB9\u0011Ba-\u0003b\n\u001d\b\u0003\u0002B;\u0005GLAA!:\u0003x\t1rK]5uKRCh.T1sW\u0016\u00148OU3rk\u0016\u001cH\u000fE\u0002#\u0005SL1Aa;(\u0005\u001d\u0011V-];fgRD\u0001Ba<\u0003Z\u0002\u0007!\u0011_\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0002Bz\u0005s\u0014i0\u0004\u0002\u0003v*!!q_AZ\u0003\u0011)H/\u001b7\n\t\tm(Q\u001f\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0003\u0000\u000e\u0005Q\"A7\n\u0007\r\rQN\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\r\u001d\u0001\u0001\"\u0003\u0004\n\u0005a!-^5mIJ+\u0017/^3tiV!11BB\n)\u0019\u0019ia!\n\u00048A9\u0011Ba-\u0004\u0010\t\u001d\b\u0003BB\t\u0007'a\u0001\u0001\u0002\u0005\u0004\u0016\r\u0015!\u0019AB\f\u0005\u0005!\u0016\u0003BB\r\u0007?\u00012!CB\u000e\u0013\r\u0019iB\u0003\u0002\b\u001d>$\b.\u001b8h!\u0011\u0011)h!\t\n\t\r\r\"q\u000f\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\"A1qEB\u0003\u0001\u0004\u0019I#A\u0004ck&dG-\u001a:\u0011\r\r-2\u0011GB\b\u001d\u0011\u0011)h!\f\n\t\r=\"qO\u0001\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti&!11GB\u001b\u0005\u001d\u0011U/\u001b7eKJTAaa\f\u0003x!Q1\u0011HB\u0003!\u0003\u0005\rAa.\u0002\u00191L7\u000f^3oKJt\u0015-\\3\t\u000f\ru\u0002\u0001\"\u0003\u0004@\u0005a!/Z1e%\u0016\u001c\bo\u001c8tKRA1\u0011IB$\u0007+\u001aI\u0006\u0005\u0003\u0003v\r\r\u0013\u0002BB#\u0005o\u0012\u0001#\u00112tiJ\f7\r\u001e*fgB|gn]3\t\u0011\t\u001511\ba\u0001\u0007\u0013\u0002Baa\u0013\u0004R5\u00111Q\n\u0006\u0004\u0007\u001fj\u0017\u0001\u00039s_R|7m\u001c7\n\t\rM3Q\n\u0002\b\u0003BL7*Z=t\u0011!\u00199fa\u000fA\u0002\r}\u0011a\u0002:fcV,7\u000f\u001e\u0005\t\u00077\u001aY\u00041\u0001\u0004^\u0005\u00012-\u00199ukJ,GMU3ta>t7/\u001a\t\u0007\u0007?\u001a)g!\u001b\u000e\u0005\r\u0005$bAB2e\u0006AQ-Y:z[>\u001c7.\u0003\u0003\u0004h\r\u0005$aB\"baR,(/\u001a\t\u0004E\r-\u0014bAB7O\tA!+Z:q_:\u001cX\rC\u0004\u0004r\u0001!Iaa\u001d\u0002?\u0015D\b/Z2u)\"\u0014x\u000e\u001e;mK\u000e\u000bG\u000e\u001c2bG.\fe\u000eZ%om>\\W\r\u0006\u0003\u0002\\\u000eU\u0004\u0002CB<\u0007_\u0002\ra!\u001f\u00021\r\f\u0007\u000f^;sK\u0012$\u0006N]8ui2,7)\u00197mE\u0006\u001c7\u000e\u0005\u0004\u0004`\r\u001541\u0010\t\u0007\u0013\ru$0a7\n\u0007\r}$BA\u0005Gk:\u001cG/[8oc!I11\u0011\u0001\u0012\u0002\u0013\u00051QQ\u0001\u001aGJ,\u0017\r^3LC\u001a\\\u0017-\u00119jg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\b*\"\u0011q`BEW\t\u0019Y\t\u0005\u0003\u0004\u000e\u000e]UBABH\u0015\u0011\u0019\tja%\u0002\u0013Ut7\r[3dW\u0016$'bABK\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\re5q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CBO\u0001E\u0005I\u0011BBP\u0003Y\u0011W/\u001b7e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012T\u0003BBQ\u0007K+\"aa)+\t\t]6\u0011\u0012\u0003\t\u0007+\u0019YJ1\u0001\u0004\u0018\u0001")
public class KafkaApisTest {
    private final RequestChannel requestChannel = (RequestChannel)EasyMock.createNiceMock(RequestChannel.class);
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)EasyMock.createNiceMock(RequestChannel.Metrics.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final GroupCoordinator groupCoordinator = (GroupCoordinator)EasyMock.createNiceMock(GroupCoordinator.class);
    private final AdminManager adminManager = (AdminManager)EasyMock.createNiceMock(AdminManager.class);
    private final TransactionCoordinator txnCoordinator = (TransactionCoordinator)EasyMock.createNiceMock(TransactionCoordinator.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private final MetadataCache metadataCache = new MetadataCache(this.brokerId());
    private final Option<Authorizer> authorizer = None$.MODULE$;
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)EasyMock.createNiceMock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)EasyMock.createNiceMock(ClientRequestQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager());
    private final FetchManager fetchManager = (FetchManager)EasyMock.createNiceMock(FetchManager.class);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final String clusterId;
    private final MockTime time = new MockTime();

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    private AdminManager adminManager() {
        return this.adminManager;
    }

    private TransactionCoordinator txnCoordinator() {
        return this.txnCoordinator;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private FetchManager fetchManager() {
        return this.fetchManager;
    }

    private BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    private String clusterId() {
        return this.clusterId;
    }

    private MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        this.quotas().shutdown();
        this.metrics().close();
    }

    public KafkaApis createKafkaApis(ApiVersion interBrokerProtocolVersion) {
        Properties properties = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zk", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerProtocolVersion.toString());
        properties.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), interBrokerProtocolVersion.toString());
        return new KafkaApis(this.requestChannel(), this.replicaManager(), this.adminManager(), this.groupCoordinator(), this.txnCoordinator(), this.controller(), this.zkClient(), this.brokerId(), new KafkaConfig((java.util.Map)properties), this.metadataCache(), this.metrics(), this.authorizer(), this.quotas(), this.fetchManager(), this.brokerTopicStats(), this.clusterId(), (Time)this.time(), null);
    }

    public ApiVersion createKafkaApis$default$1() {
        return ApiVersion$.MODULE$.latestVersion();
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddOffsetToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddOffsetsToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleAddPartitionsToTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleTxnOffsetCommitRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleAddPartitionToTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleEndTxnRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleEndTxnRequest(null);
    }

    @Test(expected=UnsupportedVersionException.class)
    public void shouldThrowUnsupportedVersionExceptionOnHandleWriteTxnMarkersRequestWhenInterBrokerProtocolNotSupported() {
        this.createKafkaApis((ApiVersion)KAFKA_0_10_2_IV0$.MODULE$).handleWriteTxnMarkersRequest(null);
    }

    @Test
    public void shouldRespondWithUnsupportedForMessageFormatOnHandleWriteTxnMarkersWhenMagicLowerThanRequired() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnknownTopicWhenPartitionIsNotHosted() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)None$.MODULE$);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
    }

    @Test
    public void shouldRespondWithUnsupportedMessageFormatForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tp2, responseCallback){
            private final TopicPartition tp2$1;
            private final Capture responseCallback$1;

            public void answer() {
                ((Function1)this.responseCallback$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$1), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.tp2$1 = tp2$1;
                this.responseCallback$1 = responseCallback$1;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldRespondWithUnknownTopicOrPartitionForBadPartitionAndNoErrorsForGoodPartition() {
        TopicPartition tp1 = new TopicPartition("t", 0);
        TopicPartition tp2 = new TopicPartition("t1", 0);
        Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> tuple2 = this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{tp1, tp2}));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        WriteTxnMarkersRequest writeTxnMarkersRequest = (WriteTxnMarkersRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeTxnMarkersRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        WriteTxnMarkersRequest writeTxnMarkersRequest2 = (WriteTxnMarkersRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        java.util.Map expectedErrors = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)Errors.NONE)}))).asJava();
        Capture capturedResponse = EasyMock.newCapture();
        Capture responseCallback = EasyMock.newCapture();
        EasyMock.expect((Object)this.replicaManager().getMagic(tp1)).andReturn((Object)None$.MODULE$);
        EasyMock.expect((Object)this.replicaManager().getMagic(tp2)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, tp2, responseCallback){
            private final TopicPartition tp2$2;
            private final Capture responseCallback$2;

            public void answer() {
                ((Function1)this.responseCallback$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2$2), (Object)new ProduceResponse.PartitionResponse(Errors.NONE))})));
            }
            {
                this.tp2$2 = tp2$2;
                this.responseCallback$2 = responseCallback$2;
            }
        });
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.replicaQuotaManager(), this.requestChannel()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request2);
        WriteTxnMarkersResponse markersResponse = (WriteTxnMarkersResponse)this.readResponse(ApiKeys.WRITE_TXN_MARKERS, (AbstractRequest)writeTxnMarkersRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertEquals((Object)expectedErrors, (Object)markersResponse.errors(1L));
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void shouldAppendToLogOnWriteTxnMarkersWhenCorrectMagicVersion() {
        TopicPartition topicPartition = new TopicPartition("t", 0);
        RequestChannel.Request request = (RequestChannel.Request)this.createWriteTxnMarkersRequest(Utils.mkList((Object[])new TopicPartition[]{topicPartition}))._2();
        EasyMock.expect((Object)this.replicaManager().getMagic(topicPartition)).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)2)));
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.anyObject(), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.createKafkaApis(this.createKafkaApis$default$1()).handleWriteTxnMarkersRequest(request);
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLimitedAtHighWatermark() {
        this.testConsumerListOffsetLimit(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLimitedAtLastStableOffset() {
        this.testConsumerListOffsetLimit(IsolationLevel.READ_COMMITTED);
    }

    private void testConsumerListOffsetLimit(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        Long timestamp = Predef$.MODULE$.long2Long(this.time().milliseconds());
        long limitOffset = 15L;
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        Replica replica = (Replica)EasyMock.mock(Replica.class);
        Log log = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLeaderReplicaIfLocal(tp)).andReturn((Object)replica);
        IsolationLevel isolationLevel2 = isolationLevel;
        IsolationLevel isolationLevel3 = IsolationLevel.READ_UNCOMMITTED;
        IExpectationSetters iExpectationSetters = !(isolationLevel2 != null ? !isolationLevel2.equals(isolationLevel3) : isolationLevel3 != null) ? EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())) : EasyMock.expect((Object)replica.lastStableOffset()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        EasyMock.expect((Object)this.replicaManager().getLog(tp)).andReturn((Object)new Some((Object)log));
        EasyMock.expect((Object)log.fetchOffsetsByTimestamp(Predef$.MODULE$.Long2long(timestamp))).andReturn((Object)new Some((Object)new TimestampOffset(Predef$.MODULE$.Long2long(timestamp), limitOffset)));
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel(), replica, log});
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)timestamp)}))).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetEarliestOffsetEqualsHighWatermark() {
        this.testConsumerListOffsetEarliestOffsetEqualsLimit(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetEarliestOffsetEqualsLastStableOffset() {
        this.testConsumerListOffsetEarliestOffsetEqualsLimit(IsolationLevel.READ_COMMITTED);
    }

    private void testConsumerListOffsetEarliestOffsetEqualsLimit(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long limitOffset = 15L;
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        Replica replica = (Replica)EasyMock.mock(Replica.class);
        Log log = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLeaderReplicaIfLocal(tp)).andReturn((Object)replica);
        IsolationLevel isolationLevel2 = isolationLevel;
        IsolationLevel isolationLevel3 = IsolationLevel.READ_UNCOMMITTED;
        IExpectationSetters iExpectationSetters = !(isolationLevel2 != null ? !isolationLevel2.equals(isolationLevel3) : isolationLevel3 != null) ? EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())) : EasyMock.expect((Object)replica.lastStableOffset()).andReturn((Object)new LogOffsetMetadata(limitOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        EasyMock.expect((Object)this.replicaManager().getLog(tp)).andReturn((Object)new Some((Object)log));
        EasyMock.expect((Object)log.fetchOffsetsByTimestamp(-2L)).andReturn((Object)new Some((Object)new TimestampOffset(-1L, limitOffset)));
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel(), replica, log});
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Predef$.MODULE$.long2Long(-2L))}))).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)limitOffset), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    @Test
    public void testReadUncommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_UNCOMMITTED);
    }

    @Test
    public void testReadCommittedConsumerListOffsetLatest() {
        this.testConsumerListOffsetLatest(IsolationLevel.READ_COMMITTED);
    }

    @Test
    public void testMetadataRequestOnSharedListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName plaintextListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = plaintextListener = (ListenerName)tuple2._1();
        ListenerName plaintextListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(plaintextListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @Test
    public void testMetadataRequestOnDistinctListenerWithInconsistentListenersAcrossBrokers() {
        ListenerName anotherListener;
        Tuple2<ListenerName, ListenerName> tuple2 = this.updateMetadataCacheWithInconsistentListeners();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListenerName listenerName = anotherListener = (ListenerName)tuple2._2();
        ListenerName anotherListener2 = listenerName;
        MetadataResponse response = this.sendMetadataRequestWithInconsistentListeners(anotherListener2);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.brokers()).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    private Tuple2<ListenerName, ListenerName> updateMetadataCacheWithInconsistentListeners() {
        ListenerName plaintextListener = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName anotherListener = new ListenerName("LISTENER2");
        scala.collection.immutable.Set brokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.Broker[]{new UpdateMetadataRequest.Broker(0, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker0", 9092, SecurityProtocol.PLAINTEXT, plaintextListener), new UpdateMetadataRequest.EndPoint("broker0", 9093, SecurityProtocol.PLAINTEXT, anotherListener)}))).asJava(), "rack"), new UpdateMetadataRequest.Broker(1, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequest.EndPoint[]{new UpdateMetadataRequest.EndPoint("broker1", 9092, SecurityProtocol.PLAINTEXT, plaintextListener)}))).asJava(), "rack")}));
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)brokers).asJava()).build();
        this.metadataCache().updateCache(0, updateMetadataRequest);
        return new Tuple2((Object)plaintextListener, (Object)anotherListener);
    }

    private MetadataResponse sendMetadataRequestWithInconsistentListeners(ListenerName requestListener) {
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.clientRequestQuotaManager(), this.requestChannel()});
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)MetadataRequest.Builder.allTopics(), requestListener);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        MetadataRequest metadataRequest = (MetadataRequest)tuple2._1();
        RequestChannel.Request requestChannelRequest = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metadataRequest, (Object)requestChannelRequest);
        Tuple2 tuple23 = tuple22;
        MetadataRequest metadataRequest2 = (MetadataRequest)tuple23._1();
        RequestChannel.Request requestChannelRequest2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleTopicMetadataRequest(requestChannelRequest2);
        return (MetadataResponse)this.readResponse(ApiKeys.METADATA, (AbstractRequest)metadataRequest2, (Capture<RequestChannel.Response>)capturedResponse);
    }

    private void testConsumerListOffsetLatest(IsolationLevel isolationLevel) {
        TopicPartition tp = new TopicPartition("foo", 0);
        long latestOffset = 15L;
        Capture capturedResponse = EasyMock.newCapture();
        Capture capturedThrottleCallback = EasyMock.newCapture();
        Replica replica = (Replica)EasyMock.mock(Replica.class);
        Log log = (Log)EasyMock.mock(Log.class);
        EasyMock.expect((Object)this.replicaManager().getLeaderReplicaIfLocal(tp)).andReturn((Object)replica);
        IsolationLevel isolationLevel2 = isolationLevel;
        IsolationLevel isolationLevel3 = IsolationLevel.READ_UNCOMMITTED;
        IExpectationSetters iExpectationSetters = !(isolationLevel2 != null ? !isolationLevel2.equals(isolationLevel3) : isolationLevel3 != null) ? EasyMock.expect((Object)replica.highWatermark()).andReturn((Object)new LogOffsetMetadata(latestOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())) : EasyMock.expect((Object)replica.lastStableOffset()).andReturn((Object)new LogOffsetMetadata(latestOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.expectThrottleCallbackAndInvoke((Capture<Function1<Object, BoxedUnit>>)capturedThrottleCallback);
        this.requestChannel().sendResponse((RequestChannel.Response)EasyMock.capture((Capture)capturedResponse));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.replicaManager(), this.clientRequestQuotaManager(), this.requestChannel(), replica, log});
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)true, (IsolationLevel)isolationLevel).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)Predef$.MODULE$.long2Long(-1L))}))).asJava());
        Tuple2 tuple2 = this.buildRequest((AbstractRequest.Builder)builder, this.buildRequest$default$2());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListOffsetRequest listOffsetRequest = (ListOffsetRequest)tuple2._1();
        RequestChannel.Request request = (RequestChannel.Request)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)listOffsetRequest, (Object)request);
        Tuple2 tuple23 = tuple22;
        ListOffsetRequest listOffsetRequest2 = (ListOffsetRequest)tuple23._1();
        RequestChannel.Request request2 = (RequestChannel.Request)tuple23._2();
        this.createKafkaApis(this.createKafkaApis$default$1()).handleListOffsetRequest(request2);
        ListOffsetResponse response = (ListOffsetResponse)this.readResponse(ApiKeys.LIST_OFFSETS, (AbstractRequest)listOffsetRequest2, (Capture<RequestChannel.Response>)capturedResponse);
        Assert.assertTrue((boolean)response.responseData().containsKey(tp));
        ListOffsetResponse.PartitionData partitionData = (ListOffsetResponse.PartitionData)response.responseData().get(tp);
        Assert.assertEquals((Object)Errors.NONE, (Object)partitionData.error);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)latestOffset), (Object)partitionData.offset);
        Assert.assertEquals((Object)BoxesRunTime.boxToLong((long)-1L), (Object)partitionData.timestamp);
    }

    private Tuple2<WriteTxnMarkersRequest, RequestChannel.Request> createWriteTxnMarkersRequest(List<TopicPartition> partitions) {
        WriteTxnMarkersRequest.Builder requestBuilder = new WriteTxnMarkersRequest.Builder(Utils.mkList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(1L, (short)1, 0, TransactionResult.COMMIT, partitions)}));
        return this.buildRequest((AbstractRequest.Builder)requestBuilder, this.buildRequest$default$2());
    }

    private <T extends AbstractRequest> Tuple2<T, RequestChannel.Request> buildRequest(AbstractRequest.Builder<T> builder, ListenerName listenerName) {
        AbstractRequest request = builder.build();
        ByteBuffer buffer = request.serialize(new RequestHeader(builder.apiKey(), request.version(), "", 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT);
        return new Tuple2((Object)request, (Object)new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics()));
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    private AbstractResponse readResponse(ApiKeys api, AbstractRequest request, Capture<RequestChannel.Response> capturedResponse) {
        Send send = (Send)((RequestChannel.Response)capturedResponse.getValue()).responseSend().get();
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((GatheringByteChannel)channel);
        channel.close();
        channel.buffer().getInt();
        ResponseHeader.parse((ByteBuffer)channel.buffer());
        Struct struct = api.responseSchema(request.version()).read(channel.buffer());
        return AbstractResponse.parseResponse((ApiKeys)api, (Struct)struct);
    }

    private void expectThrottleCallbackAndInvoke(Capture<Function1<Object, BoxedUnit>> capturedThrottleCallback) {
        this.clientRequestQuotaManager().maybeRecordAndThrottle((RequestChannel.Request)EasyMock.anyObject(), (Function1)EasyMock.capture(capturedThrottleCallback));
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, capturedThrottleCallback){
            private final Capture capturedThrottleCallback$1;

            public void answer() {
                Function1 callback = (Function1)this.capturedThrottleCallback$1.getValue();
                callback.apply$mcVI$sp(0);
            }
            {
                this.capturedThrottleCallback$1 = capturedThrottleCallback$1;
            }
        });
    }

    public KafkaApisTest() {
        this.brokerId = 1;
        this.clusterId = "clusterId";
    }
}

