/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.math.BigDecimal;
import net.sf.jasperreports.engine.fill.JRBigDecimalAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalCountIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalSumIncrementer;
import net.sf.jasperreports.engine.fill.JRBigDecimalVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;

public class JRBigDecimalIncrementerFactory
implements JRIncrementerFactory {
    protected static final BigDecimal ZERO = new BigDecimal(0.0);
    protected static final BigDecimal ONE = new BigDecimal(1.0);
    private static JRBigDecimalIncrementerFactory mainInstance = new JRBigDecimalIncrementerFactory();

    private JRBigDecimalIncrementerFactory() {
    }

    public static JRBigDecimalIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRBigDecimalCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRBigDecimalSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRBigDecimalAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRBigDecimalStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRBigDecimalVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

