/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.UIUtil;

public class SelectableLabel
extends JTextPane {
    private Color hyperlinkForeground;

    public SelectableLabel() {
        this((String)null);
    }

    public SelectableLabel(String text) {
        this.setText(text);
        this.labelize();
    }

    private void labelize() {
        Color sel;
        this.setBorder(null);
        this.setEditable(false);
        this.setOpaque(false);
        this.setBackground(new Color(0, 0, 0, 0));
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        this.setFont(font);
        Color fg = UIManager.getColor("Label.foreground");
        if (fg != null) {
            this.setForeground(fg);
        }
        if ((sel = UIManager.getColor("TextField.selectionBackground")) != null) {
            this.setSelectionColor(sel);
        }
    }

    public void setHyperlinkForeground(Color fg) {
        this.hyperlinkForeground = fg;
    }

    public void setText(String text) {
        if (text != null && text.startsWith("<html>")) {
            this.setContentType("text/html");
            this.updateDefaultHtmlFont();
        } else {
            this.setContentType("text/plain");
        }
        super.setText(text);
    }

    public void setUI(TextUI ui) {
        super.setUI(ui);
        this.labelize();
        if (this.getDocument() instanceof HTMLDocument) {
            this.updateDefaultHtmlFont();
        }
    }

    private void updateDefaultHtmlFont() {
        Color fg = UIManager.getColor("Label.foreground");
        Font font = UIManager.getFont("Label.font");
        if (font == null) {
            font = new JLabel().getFont();
        }
        if (fg == null) {
            fg = new JLabel().getForeground();
        }
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt" + "; color: " + UIUtil.getHTMLFormatForColor(fg) + "; }";
        doc.getStyleSheet().addRule(bodyRule);
        Color linkFG = this.hyperlinkForeground;
        if (linkFG == null) {
            linkFG = UIUtil.getHyperlinkForeground();
        }
        if (linkFG != null) {
            String aRule = "a { color: " + UIUtil.getHTMLFormatForColor(linkFG) + "; }";
            doc.getStyleSheet().addRule(aRule);
        }
    }
}

