/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.docktabdesktop.SmallTabButton;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnHeaderDisplay;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetViewer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeGeneral;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class ResultLabelNameSwitcher {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ResultLabelNameSwitcher.class);
    private final String _resultsTabTitle;
    private final int _tabIndex;
    private final JTabbedPane _tabResultTabs;
    private final ImageIcon _labeledIcon;
    private final ImageIcon _namedIcon;
    private ImageIcon _currentIcon;
    private SmallTabButton _btnLabelNameSwitch;
    private IDataSetViewer _dataSetViewer;

    public ResultLabelNameSwitcher(String resultsTabTitle, int tabIndex, ISession session, JTabbedPane tabResultTabs) {
        this._resultsTabTitle = resultsTabTitle;
        this._tabIndex = tabIndex;
        this._tabResultTabs = tabResultTabs;
        this._tabResultTabs.setTitleAt(tabIndex, resultsTabTitle);
        this._labeledIcon = session.getApplication().getResources().getIcon("labeled");
        this._namedIcon = session.getApplication().getResources().getIcon("named");
    }

    public void initLabelSwitch() {
        JPanel pnl = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 0, 1, 0), 0, 0);
        JLabel title = new JLabel(this._resultsTabTitle);
        pnl.add((Component)title, gbc);
        this._currentIcon = DataTypeGeneral.isUseColumnLabelInsteadColumnName() ? this._labeledIcon : this._namedIcon;
        this._btnLabelNameSwitch = new SmallTabButton(s_stringMgr.getString("ResultLabelNameSwitcher.buttonToolTipHtml"), this._currentIcon);
        this._btnLabelNameSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultLabelNameSwitcher.this.onSwitchLabelName();
            }
        });
        gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 2, 1, 0), 0, 0);
        pnl.add((Component)this._btnLabelNameSwitch, gbc);
        pnl.setOpaque(false);
        this._tabResultTabs.setTabComponentAt(this._tabIndex, pnl);
    }

    private void onSwitchLabelName() {
        if (this._currentIcon == this._namedIcon) {
            this._currentIcon = this._labeledIcon;
            this._dataSetViewer.switchColumnHeader(ColumnHeaderDisplay.COLUMN_LABEL);
        } else {
            this._dataSetViewer.switchColumnHeader(ColumnHeaderDisplay.COLUMN_NAME);
            this._currentIcon = this._namedIcon;
        }
        this._btnLabelNameSwitch.setIcon(this._currentIcon);
    }

    public void setCurrentResult(ResultSetDataSet rsds, IDataSetViewer dataSetViewer) {
        if (!this.needsLabelSwitch(rsds, dataSetViewer)) {
            return;
        }
        this._dataSetViewer = dataSetViewer;
        this.initLabelSwitch();
    }

    private boolean needsLabelSwitch(ResultSetDataSet rsds, IDataSetViewer dataSetViewer) {
        return dataSetViewer instanceof DataSetViewerTablePanel && this.hasLabelsDifferentFormNames(rsds);
    }

    private boolean hasLabelsDifferentFormNames(ResultSetDataSet rsds) {
        for (ColumnDisplayDefinition columnDisplayDefinition : rsds.getDataSetDefinition().getColumnDefinitions()) {
            if (Utilities.equalsRespectNull(columnDisplayDefinition.getColumnName(), columnDisplayDefinition.getLabel())) continue;
            return true;
        }
        return false;
    }

    public void moreResultsHaveBeenRead(ResultSetDataSet rsds) {
        if (!this.needsLabelSwitch(rsds, this._dataSetViewer)) {
            return;
        }
        if (this._currentIcon == this._namedIcon) {
            this._dataSetViewer.switchColumnHeader(ColumnHeaderDisplay.COLUMN_NAME);
        } else {
            this._dataSetViewer.switchColumnHeader(ColumnHeaderDisplay.COLUMN_LABEL);
        }
    }
}

