/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.keyring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.keyring.Bundle;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class Keyring {
    private static final RequestProcessor KEYRING_ACCESS = new RequestProcessor(Keyring.class);
    private static final long SAFE_DELAY = 70L;
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.keyring");
    private static KeyringProvider PROVIDER;

    private Keyring() {
    }

    private static synchronized KeyringProvider provider() {
        if (PROVIDER == null) {
            for (KeyringProvider keyringProvider : Lookup.getDefault().lookupAll(KeyringProvider.class)) {
                if (!keyringProvider.enabled()) continue;
                PROVIDER = keyringProvider;
                break;
            }
            if (PROVIDER == null) {
                PROVIDER = new DummyKeyringProvider();
            }
            LOG.log(Level.FINE, "Using provider: {0}", PROVIDER);
        }
        return PROVIDER;
    }

    private static synchronized char[] readImpl(String string) {
        LOG.log(Level.FINEST, "reading: {0}", string);
        return Keyring.provider().read(string);
    }

    @CheckForNull
    public static char[] read(final @NonNull String string) {
        Parameters.notNull((CharSequence)"key", (Object)string);
        try {
            Future future = KEYRING_ACCESS.submit((Callable)new Callable<char[]>(){

                @Override
                public char[] call() throws Exception {
                    return Keyring.readImpl(string);
                }
            });
            if (SwingUtilities.isEventDispatchThread() && !future.isDone()) {
                try {
                    return (char[])future.get(70L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    return (char[])ProgressUtils.showProgressDialogAndRun(new ProgressRunnable(future), (String)Bundle.MSG_KeyringAccess(), (boolean)false);
                }
            }
            return (char[])future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            LOG.log(Level.INFO, null, executionException);
        }
        return null;
    }

    private static synchronized void saveImpl(String string, char[] cArray, String string2) {
        LOG.log(Level.FINEST, "saving: {0}", string);
        Keyring.provider().save(string, cArray, string2);
        Arrays.fill(cArray, '\u0000');
    }

    public static void save(final @NonNull String string, final @NonNull char[] cArray, final @NullAllowed String string2) {
        Parameters.notNull((CharSequence)"key", (Object)string);
        Parameters.notNull((CharSequence)"password", (Object)cArray);
        KEYRING_ACCESS.post(new Runnable(){

            @Override
            public void run() {
                Keyring.saveImpl(string, cArray, string2);
            }
        });
    }

    private static synchronized void deleteImpl(String string) {
        LOG.log(Level.FINEST, "deleting: {0}", string);
        Keyring.provider().delete(string);
    }

    public static void delete(final @NonNull String string) {
        Parameters.notNull((CharSequence)"key", (Object)string);
        KEYRING_ACCESS.post(new Runnable(){

            @Override
            public void run() {
                Keyring.deleteImpl(string);
            }
        });
    }

    private static byte[] chars2Bytes(char[] cArray) {
        byte[] byArray = new byte[cArray.length * 2];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i * 2] = (byte)(cArray[i] / 256);
            byArray[i * 2 + 1] = (byte)(cArray[i] % 256);
        }
        return byArray;
    }

    private static char[] bytes2Chars(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(byArray[i * 2] * 256 + byArray[i * 2 + 1]);
        }
        return cArray;
    }

    private static class ProgressRunnable<T>
    implements org.netbeans.api.progress.ProgressRunnable<T>,
    Cancellable {
        private final Future<? extends T> task;

        public ProgressRunnable(Future<? extends T> future) {
            this.task = future;
        }

        public T run(ProgressHandle progressHandle) {
            try {
                return this.task.get();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                LOG.log(Level.INFO, null, executionException);
            }
            return null;
        }

        public boolean cancel() {
            return this.task.cancel(true);
        }
    }

    private static class DummyKeyringProvider
    implements KeyringProvider {
        private final Map<String, byte[]> passwords = new HashMap<String, byte[]>();

        private DummyKeyringProvider() {
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public char[] read(String string) {
            byte[] byArray = this.passwords.get(string);
            return byArray != null ? Keyring.bytes2Chars(byArray) : null;
        }

        @Override
        public void save(String string, char[] cArray, String string2) {
            this.passwords.put(string, Keyring.chars2Bytes(cArray));
        }

        @Override
        public void delete(String string) {
            this.passwords.remove(string);
        }
    }
}

