/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

public class FSFnv1aInterleavedChecksumCalculator {
    private static final int SCALING = 4;
    private static final int HASH_SIZE_IN_BYTES = 4;
    private static final long FNV1_BASE_32 = 2166136261L;
    private static final long FNV1_PRIME_32 = 16777619L;
    private final long[] hashes = new long[4];
    private final byte[] buffer = new byte[4];
    private int buffered;

    public FSFnv1aInterleavedChecksumCalculator() {
        this.resetChecksum();
    }

    public void update(byte[] data, int offset, int length) {
        int processed;
        if (this.buffered != 0) {
            int toCopy = 4 - this.buffered;
            if (toCopy > length) {
                System.arraycopy(data, offset, this.buffer, this.buffered, length);
                this.buffered += length;
                return;
            }
            System.arraycopy(data, offset, this.buffer, this.buffered, toCopy);
            offset += toCopy;
            length -= toCopy;
            this.fnv1aInterleaved(this.buffer, 0, 4);
            this.buffered = 0;
        }
        if ((processed = this.fnv1aInterleaved(data, offset, length)) != length) {
            this.buffered = length - processed;
            System.arraycopy(data, offset + processed, this.buffer, 0, length - processed);
        }
    }

    public int finalizeChecksum() {
        return this.finalizeChecksum(this.buffer, 0, this.buffered);
    }

    private int finalizeChecksum(byte[] data, int offset, int length) {
        byte[] finalData = new byte[19];
        assert (length < 4);
        for (int i = 0; i < 4; ++i) {
            long hash = this.hashes[i];
            for (int j = 0; j < 4; ++j) {
                byte b;
                finalData[i * 4 + (4 - j - 1)] = b = (byte)(hash & 0xFFL);
                hash >>= 8;
            }
        }
        if (length != 0) {
            System.arraycopy(data, offset, finalData, 16, length);
        }
        return (int)this.fnv1a(2166136261L, finalData, 0, 16 + length);
    }

    private int fnv1aInterleaved(byte[] data, int offset, int length) {
        int i = 0;
        while (i + 4 <= length) {
            this.hashes[0] = this.hashes[0] ^ (long)data[i + offset] & 0xFFL;
            this.hashes[0] = this.hashes[0] * 16777619L;
            this.hashes[1] = this.hashes[1] ^ (long)data[i + offset + 1] & 0xFFL;
            this.hashes[1] = this.hashes[1] * 16777619L;
            this.hashes[2] = this.hashes[2] ^ (long)data[i + offset + 2] & 0xFFL;
            this.hashes[2] = this.hashes[2] * 16777619L;
            this.hashes[3] = this.hashes[3] ^ (long)data[i + offset + 3] & 0xFFL;
            this.hashes[3] = this.hashes[3] * 16777619L;
            i += 4;
        }
        return i;
    }

    private long fnv1a(long hash, byte[] data, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            hash ^= (long)data[i + offset] & 0xFFL;
            hash *= 16777619L;
        }
        return hash;
    }

    protected void resetChecksum() {
        for (int i = 0; i < this.hashes.length; ++i) {
            this.hashes[i] = 2166136261L;
        }
        this.buffered = 0;
    }
}

