/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLDate
extends DataType
implements DateTimeDataValue {
    private int encodedDate;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDate.class);
    static final char ISO_SEPARATOR = '-';
    private static final char[] ISO_SEPARATOR_ONLY = new char[]{'-'};
    private static final char IBM_USA_SEPARATOR = '/';
    private static final char[] IBM_USA_SEPARATOR_ONLY = new char[]{'/'};
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_ONLY = new char[]{'.'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    int getEncodedDate() {
        return this.encodedDate;
    }

    public String getString() {
        if (!this.isNull()) {
            return SQLDate.encodedDateToString(this.encodedDate);
        }
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getTimeInMillis(calendar));
    }

    private long getTimeInMillis(Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.clear();
        SQLDate.setDateInCalendar(calendar, this.encodedDate);
        return calendar.getTimeInMillis();
    }

    static void setDateInCalendar(Calendar calendar, int n) {
        calendar.set(SQLDate.getYear(n), SQLDate.getMonth(n) - 1, SQLDate.getDay(n));
    }

    public Object getObject() {
        return this.getDate((Calendar)null);
    }

    public int getLength() {
        return 4;
    }

    public String getTypeName() {
        return "DATE";
    }

    public int getTypeFormatId() {
        return 298;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.encodedDate);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.encodedDate = objectInput.readInt();
    }

    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        this.encodedDate = arrayInputStream.readInt();
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLDate(this.encodedDate);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLDate();
    }

    public void restoreToNull() {
        this.encodedDate = 0;
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException, StandardException {
        this.setValue(resultSet.getDate(n), (Calendar)null);
    }

    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        int n = 0;
        n = dataValueDescriptor instanceof SQLDate ? ((SQLDate)dataValueDescriptor).encodedDate : SQLDate.computeEncodedDate(dataValueDescriptor.getDate(new GregorianCalendar()));
        int n2 = this.encodedDate > n ? 1 : (this.encodedDate < n ? -1 : 0);
        return n2;
    }

    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public SQLDate() {
    }

    public SQLDate(Date date) throws StandardException {
        this.parseDate(date);
    }

    private void parseDate(java.util.Date date) throws StandardException {
        this.encodedDate = SQLDate.computeEncodedDate(date);
    }

    private SQLDate(int n) {
        this.encodedDate = n;
    }

    public SQLDate(String string, boolean bl, LocaleFinder localeFinder) throws StandardException {
        this.parseDate(string, bl, localeFinder, null);
    }

    public SQLDate(String string, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        this.parseDate(string, bl, localeFinder, calendar);
    }

    private void parseDate(String string, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        boolean bl2 = true;
        DateTimeParser dateTimeParser = new DateTimeParser(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StandardException standardException = null;
        try {
            switch (dateTimeParser.nextSeparator()) {
                case '-': {
                    this.encodedDate = SQLTimestamp.parseDateOrTimestamp(dateTimeParser, false)[0];
                    return;
                }
                case '/': {
                    if (bl) {
                        bl2 = false;
                        break;
                    }
                    n2 = dateTimeParser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    n3 = dateTimeParser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    n = dateTimeParser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                case '.': {
                    if (bl) {
                        bl2 = false;
                        break;
                    }
                    n3 = dateTimeParser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    n2 = dateTimeParser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    n = dateTimeParser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                default: {
                    bl2 = false;
                    break;
                }
            }
        }
        catch (StandardException standardException2) {
            bl2 = false;
            standardException = standardException2;
        }
        if (bl2) {
            this.encodedDate = SQLDate.computeEncodedDate(n, n2, n3);
        } else {
            string = StringUtil.trimTrailing(string);
            DateFormat dateFormat = null;
            dateFormat = localeFinder == null ? DateFormat.getDateInstance() : (calendar == null ? localeFinder.getDateFormat() : (DateFormat)localeFinder.getDateFormat().clone());
            if (calendar != null) {
                dateFormat.setCalendar(calendar);
            }
            try {
                this.encodedDate = SQLDate.computeEncodedDate(dateFormat.parse(string), calendar);
            }
            catch (ParseException parseException) {
                try {
                    this.encodedDate = SQLTimestamp.parseLocalTimestamp(string, localeFinder, calendar)[0];
                }
                catch (ParseException parseException2) {
                    if (standardException != null) {
                        throw standardException;
                    }
                    throw StandardException.newException("22007.S.181");
                }
            }
        }
    }

    void setObject(Object object) throws StandardException {
        this.setValue((Date)object);
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLDate) {
            this.restoreToNull();
            this.encodedDate = ((SQLDate)dataValueDescriptor).encodedDate;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            this.setValue(dataValueDescriptor.getDate(gregorianCalendar), (Calendar)gregorianCalendar);
        }
    }

    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(date, calendar);
    }

    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(timestamp, calendar);
    }

    public void setValue(String string) throws StandardException {
        this.restoreToNull();
        if (string != null) {
            DatabaseContext databaseContext = (DatabaseContext)ContextService.getContext("Database");
            this.parseDate(string, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    public NumberDataValue getYear(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), numberDataValue);
    }

    public NumberDataValue getMonth(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), numberDataValue);
    }

    public NumberDataValue getDate(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), numberDataValue);
    }

    public NumberDataValue getHours(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getHours", (Object)"Date");
    }

    public NumberDataValue getMinutes(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getMinutes", (Object)"Date");
    }

    public NumberDataValue getSeconds(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", (Object)"getSeconds", (Object)"Date");
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getDate((Calendar)null).toString();
    }

    public int hashCode() {
        return this.encodedDate;
    }

    public int typePrecedence() {
        return 100;
    }

    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    public Date getDate(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getTimeInMillis(calendar));
    }

    static int getYear(int n) {
        return n >>> 16;
    }

    static int getMonth(int n) {
        return n >>> 8 & 0xFF;
    }

    static int getDay(int n) {
        return n & 0xFF;
    }

    static int computeEncodedDate(Calendar calendar) throws StandardException {
        return SQLDate.computeEncodedDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    static int computeEncodedDate(int n, int n2, int n3) throws StandardException {
        int n4 = 31;
        switch (n2) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n4 = 30;
                break;
            }
            case 2: {
                int n5 = n4 = n % 4 == 0 && (n % 100 != 0 || n % 400 == 0) ? 29 : 28;
            }
        }
        if (n < 1 || n > 9999 || n2 < 1 || n2 > 12 || n3 < 1 || n3 > n4) {
            throw StandardException.newException("22007.S.180");
        }
        return (n << 16) + (n2 << 8) + n3;
    }

    static void dateToString(int n, int n2, int n3, StringBuffer stringBuffer) {
        String string = Integer.toString(n);
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append('-');
        String string2 = Integer.toString(n2);
        String string3 = Integer.toString(n3);
        if (string2.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        stringBuffer.append('-');
        if (string3.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string3);
    }

    static String encodedDateToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        SQLDate.dateToString(SQLDate.getYear(n), SQLDate.getMonth(n), SQLDate.getDay(n), stringBuffer);
        return stringBuffer.toString();
    }

    static NumberDataValue setSource(int n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        numberDataValue.setValue(n);
        return numberDataValue;
    }

    private static int computeEncodedDate(java.util.Date date) throws StandardException {
        return SQLDate.computeEncodedDate(date, null);
    }

    static int computeEncodedDate(java.util.Date date, Calendar calendar) throws StandardException {
        if (date == null) {
            return 0;
        }
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.setTime(date);
        return SQLDate.computeEncodedDate(calendar);
    }

    public static DateTimeDataValue computeDateFunction(DataValueDescriptor dataValueDescriptor, DataValueFactory dataValueFactory) throws StandardException {
        try {
            if (dataValueDescriptor.isNull()) {
                return new SQLDate();
            }
            if (dataValueDescriptor instanceof SQLDate) {
                return (SQLDate)dataValueDescriptor.cloneValue(false);
            }
            if (dataValueDescriptor instanceof SQLTimestamp) {
                SQLDate sQLDate = new SQLDate();
                sQLDate.setValue(dataValueDescriptor);
                return sQLDate;
            }
            if (dataValueDescriptor instanceof NumberDataValue) {
                int n = dataValueDescriptor.getInt();
                if (n <= 0 || n > 3652059) {
                    throw StandardException.newException("22008.S", (Object)dataValueDescriptor.getString(), (Object)"date");
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(1970, 0, 1, 12, 0, 0);
                ((Calendar)gregorianCalendar).add(5, n - 1);
                return new SQLDate(SQLDate.computeEncodedDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5)));
            }
            String string = dataValueDescriptor.getString();
            if (string.length() == 7) {
                int n = SQLTimestamp.parseDateTimeInteger(string, 0, 4);
                int n2 = SQLTimestamp.parseDateTimeInteger(string, 4, 3);
                if (n2 < 1 || n2 > 366) {
                    throw StandardException.newException("22008.S", (Object)dataValueDescriptor.getString(), (Object)"date");
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n, 0, 1, 2, 0, 0);
                ((Calendar)gregorianCalendar).add(6, n2 - 1);
                int n3 = gregorianCalendar.get(1);
                if (n3 != n) {
                    throw StandardException.newException("22008.S", (Object)dataValueDescriptor.getString(), (Object)"date");
                }
                return new SQLDate(SQLDate.computeEncodedDate(n, gregorianCalendar.get(2) + 1, gregorianCalendar.get(5)));
            }
            return dataValueFactory.getDateValue(string, false);
        }
        catch (StandardException standardException) {
            if ("22007.S.181".startsWith(standardException.getSQLState())) {
                throw StandardException.newException("22008.S", (Object)dataValueDescriptor.getString(), (Object)"date");
            }
            throw standardException;
        }
    }

    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setDate(n, this.getDate((Calendar)null));
    }

    public DateTimeDataValue timestampAdd(int n, NumberDataValue numberDataValue, Date date, DateTimeDataValue dateTimeDataValue) throws StandardException {
        return this.toTimestamp().timestampAdd(n, numberDataValue, date, dateTimeDataValue);
    }

    private SQLTimestamp toTimestamp() throws StandardException {
        return new SQLTimestamp(this.getEncodedDate(), 0, 0);
    }

    public NumberDataValue timestampDiff(int n, DateTimeDataValue dateTimeDataValue, Date date, NumberDataValue numberDataValue) throws StandardException {
        return this.toTimestamp().timestampDiff(n, dateTimeDataValue, date, numberDataValue);
    }
}

