/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collections;
import java.util.List;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;

public class ArrayConstruction
extends JsonQuery {
    private JsonQuery q;

    public ArrayConstruction() {
        this(null);
    }

    public ArrayConstruction(JsonQuery q) {
        this.q = q;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayNode array = new ArrayNode(scope.getObjectMapper().getNodeFactory());
        if (this.q != null) {
            array.addAll(this.q.apply(scope, in));
        }
        return Collections.singletonList(array);
    }

    public String toString() {
        if (this.q == null) {
            return String.format("[]", new Object[0]);
        }
        return String.format("[%s]", this.q);
    }
}

