/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.AbstractCrypto;
import org.apache.ws.security.components.crypto.CredentialException;

public class Merlin
extends AbstractCrypto {
    public Merlin(Properties properties) throws CredentialException, IOException {
        super(properties);
    }

    public Merlin(Properties properties, ClassLoader loader) throws CredentialException, IOException {
        super(properties, loader);
    }

    public X509Certificate[] getX509Certificates(byte[] data, boolean reverse) throws WSSecurityException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        CertPath path = null;
        try {
            path = this.getCertificateFactory().generateCertPath(in);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
        List<? extends Certificate> l = path.getCertificates();
        X509Certificate[] certs = new X509Certificate[l.size()];
        Iterator<? extends Certificate> iterator = l.iterator();
        for (int i = 0; i < l.size(); ++i) {
            certs[reverse ? l.size() - 1 - i : i] = (X509Certificate)iterator.next();
        }
        return certs;
    }

    public byte[] getCertificateData(boolean reverse, X509Certificate[] certs) throws WSSecurityException {
        Vector<X509Certificate> list = new Vector<X509Certificate>();
        for (int i = 0; i < certs.length; ++i) {
            if (reverse) {
                list.insertElementAt(certs[i], 0);
                continue;
            }
            list.add(certs[i]);
        }
        try {
            CertPath path = this.getCertificateFactory().generateCertPath(list);
            return path.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new WSSecurityException(7, "encodeError");
        }
        catch (CertificateException e) {
            throw new WSSecurityException(7, "parseError");
        }
    }

    public boolean validateCertPath(X509Certificate[] certs) throws WSSecurityException {
        try {
            List<X509Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            PKIXParameters param = new PKIXParameters(this.keystore);
            param.setRevocationEnabled(false);
            String provider = this.properties.getProperty("org.apache.ws.security.crypto.merlin.cert.provider");
            CertPathValidator certPathValidator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            certPathValidator.validate(path, param);
        }
        catch (NoSuchProviderException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (CertificateException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (CertPathValidatorException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        catch (KeyStoreException ex) {
            throw new WSSecurityException(0, "certpath", new Object[]{ex.getMessage()}, ex);
        }
        return true;
    }
}

