/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.Db;
import com.sleepycat.db.DbClient;
import com.sleepycat.db.DbEnvFeedback;
import com.sleepycat.db.DbErrcall;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbLock;
import com.sleepycat.db.DbLockStat;
import com.sleepycat.db.DbLogStat;
import com.sleepycat.db.DbLsn;
import com.sleepycat.db.DbMpoolFStat;
import com.sleepycat.db.DbMpoolStat;
import com.sleepycat.db.DbOutputStreamErrcall;
import com.sleepycat.db.DbPreplist;
import com.sleepycat.db.DbRecoveryInit;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.DbTxnRecover;
import com.sleepycat.db.DbTxnStat;
import com.sleepycat.db.Dbt;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class DbEnv {
    private long private_dbobj_ = 0L;
    private long private_info_ = 0L;
    private int constructor_flags_ = 0;
    private Vector dblist_ = new Vector();
    private DbEnvFeedback feedback_ = null;
    private DbRecoveryInit recovery_init_ = null;
    private DbTxnRecover tx_recover_ = null;
    private DbOutputStreamErrcall errstream_ = new DbOutputStreamErrcall(System.err);
    DbErrcall errcall_ = this.errstream_;
    String errpfx_;

    public DbEnv(int n) {
        this.constructor_flags_ = n;
        this._init(this.errstream_, this.constructor_flags_);
    }

    DbEnv(Db db) {
        this._init_using_db(this.errstream_, db);
    }

    void _add_db(Db db) {
        this.dblist_.addElement(db);
    }

    void _remove_db(Db db) {
        this.dblist_.removeElement(db);
    }

    void _notify_dbs() {
        Enumeration enumeration = this.dblist_.elements();
        while (enumeration.hasMoreElements()) {
            Db db = (Db)enumeration.nextElement();
            db._notify_dbenv_close();
        }
        this.dblist_.removeAllElements();
    }

    public synchronized void close(int n) throws DbException {
        this._notify_dbs();
        this._close(n);
    }

    private native void _close(int var1) throws DbException;

    public native void err(int var1, String var2);

    public native void errx(String var1);

    protected void finalize() throws Throwable {
        this._notify_dbs();
        this._finalize(this.errcall_, this.errpfx_);
    }

    protected native void _finalize(DbErrcall var1, String var2) throws Throwable;

    private native void _init(DbErrcall var1, int var2);

    private native void _init_using_db(DbErrcall var1, Db var2);

    native void _notify_db_close();

    public native void open(String var1, int var2, int var3) throws DbException, FileNotFoundException;

    public synchronized native void remove(String var1, int var2) throws DbException, FileNotFoundException;

    public native void set_cachesize(int var1, int var2, int var3) throws DbException;

    public void set_errcall(DbErrcall dbErrcall) {
        this.errcall_ = dbErrcall;
        this._set_errcall(dbErrcall);
    }

    public native void _set_errcall(DbErrcall var1);

    public void set_error_stream(OutputStream outputStream) {
        DbOutputStreamErrcall dbOutputStreamErrcall = new DbOutputStreamErrcall(outputStream);
        this.set_errcall(dbOutputStreamErrcall);
    }

    public void set_errpfx(String string) {
        this.errpfx_ = string;
        this._set_errpfx(string);
    }

    private native void _set_errpfx(String var1);

    public void set_feedback(DbEnvFeedback dbEnvFeedback) throws DbException {
        this.feedback_ = dbEnvFeedback;
        this.feedback_changed(dbEnvFeedback);
    }

    private native void feedback_changed(DbEnvFeedback var1) throws DbException;

    public native void set_verbose(int var1, boolean var2) throws DbException;

    public native void set_data_dir(String var1) throws DbException;

    public native void set_lg_bsize(int var1) throws DbException;

    public native void set_lg_dir(String var1) throws DbException;

    public native void set_lg_max(int var1) throws DbException;

    public native void set_lg_regionmax(int var1) throws DbException;

    public native void set_lk_conflicts(byte[][] var1) throws DbException;

    public native void set_lk_detect(int var1) throws DbException;

    public native void set_lk_max(int var1) throws DbException;

    public native void set_lk_max_lockers(int var1) throws DbException;

    public native void set_lk_max_locks(int var1) throws DbException;

    public native void set_lk_max_objects(int var1) throws DbException;

    public native void set_mp_mmapsize(long var1) throws DbException;

    public native void set_mutexlocks(int var1) throws DbException;

    public static native void set_pageyield(int var0) throws DbException;

    public static native void set_panicstate(int var0) throws DbException;

    public void set_recovery_init(DbRecoveryInit dbRecoveryInit) throws DbException {
        this.recovery_init_ = dbRecoveryInit;
        this.recovery_init_changed(dbRecoveryInit);
    }

    private native void recovery_init_changed(DbRecoveryInit var1) throws DbException;

    public static native void set_region_init(int var0) throws DbException;

    public native void set_flags(int var1, boolean var2) throws DbException;

    public native void set_rpc_server(DbClient var1, String var2, long var3, long var5, int var7) throws DbException;

    public native void set_shm_key(long var1) throws DbException;

    public static native void set_tas_spins(int var0) throws DbException;

    public native void set_tmp_dir(String var1) throws DbException;

    public void set_tx_recover(DbTxnRecover dbTxnRecover) throws DbException {
        this.tx_recover_ = dbTxnRecover;
        this.tx_recover_changed(dbTxnRecover);
    }

    private native void tx_recover_changed(DbTxnRecover var1) throws DbException;

    public native void set_tx_max(int var1) throws DbException;

    public void set_tx_timestamp(Date date) throws DbException {
        this._set_tx_timestamp(date.getTime() / 1000L);
    }

    private native void _set_tx_timestamp(long var1) throws DbException;

    public static native int get_version_major();

    public static native int get_version_minor();

    public static native int get_version_patch();

    public static native String get_version_string();

    public static native String strerror(int var0);

    public native int lock_detect(int var1, int var2) throws DbException;

    public native DbLock lock_get(int var1, int var2, Dbt var3, int var4) throws DbException;

    public native int lock_id() throws DbException;

    public native DbLockStat lock_stat() throws DbException;

    public native String[] log_archive(int var1) throws DbException;

    public static native int log_compare(DbLsn var0, DbLsn var1);

    public native String log_file(DbLsn var1) throws DbException;

    public native void log_flush(DbLsn var1) throws DbException;

    public native void log_get(DbLsn var1, Dbt var2, int var3) throws DbException;

    public native void log_put(DbLsn var1, Dbt var2, int var3) throws DbException;

    public native DbLogStat log_stat() throws DbException;

    public native void log_register(Db var1, String var2) throws DbException;

    public native void log_unregister(Db var1) throws DbException;

    public native DbMpoolStat memp_stat() throws DbException;

    public native DbMpoolFStat[] memp_fstat() throws DbException;

    public native int memp_trickle(int var1) throws DbException;

    public native DbTxn txn_begin(DbTxn var1, int var2) throws DbException;

    public native int txn_checkpoint(int var1, int var2, int var3) throws DbException;

    public native DbPreplist[] txn_recover(int var1, int var2) throws DbException;

    public native DbTxnStat txn_stat() throws DbException;

    static {
        Db.load_db();
    }
}

