/*
 * Decompiled with CFR 0.152.
 */
package jd.core.util;

import java.util.ArrayList;
import jd.core.util.CharArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtil {
    public static int SkipSignature(char[] caSignature, int length, int index) {
        do {
            if (caSignature[index] == '[') {
                while (++index < length) {
                    if (caSignature[index] == 'L' && index + 1 < length && caSignature[index + 1] == '[') {
                        ++index;
                        --length;
                        continue;
                    }
                    if (caSignature[index] != '[') break;
                }
            }
            switch (caSignature[index]) {
                case '*': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    ++index;
                    break;
                }
                case '.': 
                case 'L': {
                    ++index;
                    int c = 46;
                    while (index < length) {
                        c = caSignature[index];
                        if (c == 59 || c == 60) break;
                        ++index;
                    }
                    if (c == 60) {
                        index = SignatureUtil.SkipSignature(caSignature, length, index + 1);
                        while (caSignature[index] != '>') {
                            index = SignatureUtil.SkipSignature(caSignature, length, index);
                        }
                        ++index;
                    }
                    if (caSignature[index] != ';') break;
                    ++index;
                    break;
                }
                case 'T': {
                    index = CharArrayUtil.IndexOf(caSignature, ';', index + 1) + 1;
                    break;
                }
                case '+': 
                case '-': {
                    index = SignatureUtil.SkipSignature(caSignature, length, index + 1);
                }
            }
        } while (index < length && caSignature[index] == '.');
        return index;
    }

    public static String GetSignatureFromType(int type) {
        switch (type) {
            case 4: {
                return "Z";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "B";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "J";
            }
        }
        return null;
    }

    public static int GetTypeFromSignature(String signature) {
        if (signature.length() != 1) {
            return 0;
        }
        switch (signature.charAt(0)) {
            case 'Z': {
                return 4;
            }
            case 'C': {
                return 5;
            }
            case 'F': {
                return 6;
            }
            case 'D': {
                return 7;
            }
            case 'B': {
                return 8;
            }
            case 'S': {
                return 9;
            }
            case 'I': {
                return 10;
            }
            case 'J': {
                return 11;
            }
        }
        return 0;
    }

    public static boolean IsPrimitiveSignature(String signature) {
        if (signature == null || signature.length() != 1) {
            return false;
        }
        switch (signature.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    public static boolean IsIntegerSignature(String signature) {
        if (signature == null || signature.length() != 1) {
            return false;
        }
        switch (signature.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': {
                return true;
            }
        }
        return false;
    }

    public static boolean IsObjectSignature(String signature) {
        if (signature == null || signature.length() <= 2) {
            return false;
        }
        return signature.charAt(0) == 'L';
    }

    public static String GetInternalName(String signature) {
        char[] caSignature = signature.toCharArray();
        int length = signature.length();
        int beginIndex = 0;
        while (beginIndex < length && caSignature[beginIndex] == '[') {
            ++beginIndex;
        }
        if (beginIndex < length && caSignature[beginIndex] == 'L') {
            return CharArrayUtil.Substring(caSignature, ++beginIndex, --length);
        }
        return beginIndex == 0 ? signature : CharArrayUtil.Substring(caSignature, beginIndex, length);
    }

    public static String CutArrayDimensionPrefix(String signature) {
        int beginIndex = 0;
        while (signature.charAt(beginIndex) == '[') {
            ++beginIndex;
        }
        return signature.substring(beginIndex);
    }

    public static int GetArrayDimensionCount(String signature) {
        int beginIndex = 0;
        while (signature.charAt(beginIndex) == '[') {
            ++beginIndex;
        }
        return beginIndex;
    }

    public static String GetInnerName(String signature) {
        signature = SignatureUtil.CutArrayDimensionPrefix(signature);
        switch (signature.charAt(0)) {
            case 'L': 
            case 'T': {
                return signature.substring(1, signature.length() - 1);
            }
        }
        return signature;
    }

    public static ArrayList<String> GetParameterSignatures(String methodSignature) {
        char[] caSignature = methodSignature.toCharArray();
        int length = caSignature.length;
        ArrayList<String> parameterTypes = new ArrayList<String>(1);
        int index = CharArrayUtil.IndexOf(caSignature, '(', 0);
        if (index != -1) {
            ++index;
            while (caSignature[index] != ')') {
                int newIndex = SignatureUtil.SkipSignature(caSignature, length, index);
                parameterTypes.add(methodSignature.substring(index, newIndex));
                index = newIndex;
            }
        }
        return parameterTypes;
    }

    public static String GetMethodReturnedSignature(String signature) {
        int index = signature.indexOf(41);
        if (index == -1) {
            return null;
        }
        return signature.substring(index + 1);
    }

    public static int GetParameterSignatureCount(String methodSignature) {
        char[] caSignature = methodSignature.toCharArray();
        int length = caSignature.length;
        int index = CharArrayUtil.IndexOf(caSignature, '(', 0);
        int count = 0;
        if (index != -1) {
            ++index;
            while (caSignature[index] != ')') {
                int newIndex;
                index = newIndex = SignatureUtil.SkipSignature(caSignature, length, index);
                ++count;
            }
        }
        return count;
    }

    public static int CreateTypesBitField(String signature) {
        switch (signature.charAt(0)) {
            case 'I': {
                return 8;
            }
            case 'S': {
                return 12;
            }
            case 'B': {
                return 14;
            }
            case 'C': {
                return 13;
            }
            case 'X': {
                return 31;
            }
            case 'Y': {
                return 15;
            }
            case 'Z': {
                return 16;
            }
        }
        return 0;
    }

    public static int CreateArgOrReturnBitFields(String signature) {
        switch (signature.charAt(0)) {
            case 'I': {
                return 15;
            }
            case 'S': {
                return 6;
            }
            case 'B': {
                return 2;
            }
            case 'C': {
                return 1;
            }
            case 'X': {
                return 31;
            }
            case 'Y': {
                return 15;
            }
            case 'Z': {
                return 16;
            }
        }
        return 0;
    }

    public static String GetSignatureFromTypesBitField(int typesBitField) {
        if ((typesBitField & 8) != 0) {
            return "I";
        }
        if ((typesBitField & 4) != 0) {
            return "S";
        }
        if ((typesBitField & 1) != 0) {
            return "C";
        }
        if ((typesBitField & 2) != 0) {
            return "B";
        }
        if ((typesBitField & 0x10) != 0) {
            return "Z";
        }
        return "I";
    }

    public static String CreateTypeName(String signature) {
        if (signature.length() == 0) {
            return signature;
        }
        switch (signature.charAt(0)) {
            case '[': {
                return signature;
            }
            case 'L': 
            case 'T': {
                if (signature.charAt(signature.length() - 1) != ';') break;
                return signature;
            }
        }
        return "L" + signature + ';';
    }
}

