/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.spdy.FlowControlStrategy;
import org.eclipse.jetty.spdy.ISession;
import org.eclipse.jetty.spdy.IStream;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.frames.WindowUpdateFrame;

public class SPDYv3FlowControlStrategy
implements FlowControlStrategy {
    private volatile int windowSize;

    @Override
    public int getWindowSize(ISession session) {
        return this.windowSize;
    }

    @Override
    public void setWindowSize(ISession session, int windowSize) {
        int prevWindowSize = this.windowSize;
        this.windowSize = windowSize;
        for (Stream stream : session.getStreams()) {
            ((IStream)stream).updateWindowSize(windowSize - prevWindowSize);
        }
    }

    @Override
    public void onNewStream(ISession session, IStream stream) {
        stream.updateWindowSize(this.windowSize);
    }

    @Override
    public void onWindowUpdate(ISession session, IStream stream, int delta) {
        if (stream != null) {
            stream.updateWindowSize(delta);
        }
    }

    @Override
    public void updateWindow(ISession session, IStream stream, int delta) {
        stream.updateWindowSize(delta);
    }

    @Override
    public void onDataReceived(ISession session, IStream stream, DataInfo dataInfo) {
    }

    @Override
    public void onDataConsumed(ISession session, IStream stream, DataInfo dataInfo, int delta) {
        int length = dataInfo.length();
        if (dataInfo.consumed() == length && !stream.isClosed() && length > 0) {
            WindowUpdateFrame windowUpdateFrame = new WindowUpdateFrame(session.getVersion(), stream.getId(), length);
            session.control(stream, windowUpdateFrame, 0L, TimeUnit.MILLISECONDS, null, null);
        }
    }
}

