<?php

/**
 * BaseReviewer
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int                                   $id                                 Type: integer(6), primary key
 * @property int                                   $reviewId                           Type: integer(11)
 * @property int                                   $employeeNumber                     Type: integer(11)
 * @property int                                   $status                             Type: integer(11)
 * @property int                                   $reviewerGroupId                    Type: integer(11)
 * @property string                                $completedDate                      Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @property string                                $comment                            Type: clob(65532)
 * @property Doctrine_Collection|ReviewerRating[]  $rating                             
 * @property ReviewerGroup                         $group                              
 * @property PerformanceReview                     $review                             
 * @property Employee                              $Employee                           
 *  
 * @method int                                     getId()                             Type: integer(6), primary key
 * @method int                                     getReviewid()                       Type: integer(11)
 * @method int                                     getEmployeenumber()                 Type: integer(11)
 * @method int                                     getStatus()                         Type: integer(11)
 * @method int                                     getReviewergroupid()                Type: integer(11)
 * @method string                                  getCompleteddate()                  Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method string                                  getComment()                        Type: clob(65532)
 * @method Doctrine_Collection|ReviewerRating[]    getRating()                         
 * @method ReviewerGroup                           getGroup()                          
 * @method PerformanceReview                       getReview()                         
 * @method Employee                                getEmployee()                       
 *  
 * @method Reviewer                                setId(int $val)                     Type: integer(6), primary key
 * @method Reviewer                                setReviewid(int $val)               Type: integer(11)
 * @method Reviewer                                setEmployeenumber(int $val)         Type: integer(11)
 * @method Reviewer                                setStatus(int $val)                 Type: integer(11)
 * @method Reviewer                                setReviewergroupid(int $val)        Type: integer(11)
 * @method Reviewer                                setCompleteddate(string $val)       Type: timestamp(25), Timestamp in ISO-8601 format (YYYY-MM-DD HH:MI:SS)
 * @method Reviewer                                setComment(string $val)             Type: clob(65532)
 * @method Reviewer                                setRating(Doctrine_Collection $val) 
 * @method Reviewer                                setGroup(ReviewerGroup $val)        
 * @method Reviewer                                setReview(PerformanceReview $val)   
 * @method Reviewer                                setEmployee(Employee $val)          
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseReviewer extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('ohrm_reviewer');
        $this->hasColumn('id', 'integer', 6, array(
             'type' => 'integer',
             'primary' => true,
             'autoincrement' => true,
             'length' => 6,
             ));
        $this->hasColumn('review_id as reviewId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('employee_number as employeeNumber', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('status as status', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('reviewer_group_id as reviewerGroupId', 'integer', 11, array(
             'type' => 'integer',
             'length' => 11,
             ));
        $this->hasColumn('completed_date as completedDate', 'timestamp', 25, array(
             'type' => 'timestamp',
             'length' => 25,
             ));
        $this->hasColumn('comment as comment', 'clob', 65532, array(
             'type' => 'clob',
             'length' => 65532,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasMany('ReviewerRating as rating', array(
             'local' => 'id',
             'foreign' => 'reviewer_id'));

        $this->hasOne('ReviewerGroup as group', array(
             'local' => 'reviewer_group_id',
             'foreign' => 'id'));

        $this->hasOne('PerformanceReview as review', array(
             'local' => 'review_id',
             'foreign' => 'id'));

        $this->hasOne('Employee', array(
             'local' => 'employee_number',
             'foreign' => 'emp_number'));
    }
}