/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.ide.browsers.OpenInBrowserRequest;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.BaseOpenInBrowserActionKt;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.HtmlUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "(Lcom/intellij/ide/browsers/WebBrowser;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getBrowser", "update", "Companion", "intellij.xml.impl"})
public final class BaseOpenInBrowserAction
extends DumbAwareAction {
    private final WebBrowser browser;
    public static final Companion Companion = new Companion(null);

    private final WebBrowser getBrowser() {
        if (WebBrowserManager.getInstance().isActive(this.browser) && this.browser.getPath() != null) {
            return this.browser;
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        OpenInBrowserRequest result2;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        WebBrowser browser2 = this.getBrowser();
        if (browser2 == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"unknown")) {
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"e.dataContext");
            OpenInBrowserRequest openInBrowserRequest = result2 = BaseOpenInBrowserActionKt.access$createRequest(dataContext, true);
            boolean isApplicable = openInBrowserRequest != null ? openInBrowserRequest.isPhysicalFile() : false;
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(isApplicable);
            if (!isApplicable) {
                return;
            }
            if (result2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            OpenInBrowserRequest openInBrowserRequest = Companion.doUpdate(e);
            if (openInBrowserRequest == null) {
                return;
            }
            result2 = openInBrowserRequest;
        }
        Presentation presentation = this.getTemplatePresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"templatePresentation");
        String description = presentation.getText();
        if (Intrinsics.areEqual((Object)"ContextToolbar", (Object)e.getPlace())) {
            boolean exists;
            Shortcut[] shortcuts;
            Shortcut[] shortcutArray;
            StringBuilder builder2 = new StringBuilder(description);
            builder2.append(" (");
            KeymapManager keymapManager2 = KeymapManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)keymapManager2, (String)"KeymapManager.getInstance()");
            Shortcut[] shortcutArray2 = keymapManager2.getActiveKeymap().getShortcuts("WebOpenInAction");
            Intrinsics.checkExpressionValueIsNotNull((Object)shortcutArray2, (String)"KeymapManager.getInstanc\u2026rtcuts(\"WebOpenInAction\")");
            Shortcut[] shortcutArray3 = shortcutArray = (shortcuts = shortcutArray2);
            boolean bl = exists = !(shortcutArray3.length == 0);
            if (exists) {
                builder2.append(KeymapUtil.getShortcutText((Shortcut)shortcuts[0]));
            }
            if (HtmlUtil.isHtmlFile((PsiElement)result2.getFile())) {
                builder2.append(exists ? ", " : "").append("hold Shift to open URL of local file");
            }
            builder2.append(')');
            description = builder2.toString();
        }
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setText(description);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block0: {
            WebBrowser webBrowser;
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            WebBrowser webBrowser2 = this.getBrowser();
            if (webBrowser2 == null) break block0;
            WebBrowser it = webBrowser = webBrowser2;
            BaseOpenInBrowserActionKt.openInBrowser(e, it);
        }
    }

    public BaseOpenInBrowserAction(@NotNull WebBrowser browser2) {
        Intrinsics.checkParameterIsNotNull((Object)browser2, (String)"browser");
        super(browser2.getName(), null, browser2.getIcon());
        this.browser = browser2;
    }

    @JvmStatic
    @Nullable
    public static final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
        return Companion.doUpdate(event);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/browsers/actions/BaseOpenInBrowserAction$Companion;", "", "()V", "doUpdate", "Lcom/intellij/ide/browsers/OpenInBrowserRequest;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.xml.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final OpenInBrowserRequest doUpdate(@NotNull AnActionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            DataContext dataContext = event.getDataContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"event.dataContext");
            OpenInBrowserRequest request = BaseOpenInBrowserActionKt.access$createRequest(dataContext, false);
            boolean applicable = request != null && WebBrowserServiceImpl.Companion.getProvider(request) != null;
            Presentation presentation = event.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"event.presentation");
            presentation.setEnabledAndVisible(applicable);
            return applicable ? request : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

