/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide.script;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class Jsr223IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManager.class);
    private final Future<ScriptEngineManager> myManagerFuture = PooledThreadExecutor.INSTANCE.submit(() -> {
        long start2 = System.currentTimeMillis();
        try {
            ScriptEngineManager scriptEngineManager = (ScriptEngineManager)ClassLoaderUtil.runWithClassLoader((ClassLoader)AllPluginsLoader.INSTANCE, () -> new ScriptEngineManager());
            return scriptEngineManager;
        }
        finally {
            long end = System.currentTimeMillis();
            LOG.info(ScriptEngineManager.class.getName() + " initialized in " + (end - start2) + " ms");
        }
    });

    Jsr223IdeScriptEngineManagerImpl() {
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        List list2 = ContainerUtil.map(this.getScriptEngineManager().getEngineFactories(), factory -> factory.getLanguageName());
        if (list2 == null) {
            Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> getFileExtensions(@Nullable String language) {
        ArrayList extensions = ContainerUtil.newArrayList();
        List<ScriptEngineFactory> factories = this.getScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            if (language != null && !factory.getLanguageName().equals(language)) continue;
            extensions.addAll(factory.getExtensions());
        }
        ArrayList arrayList = extensions;
        if (arrayList == null) {
            Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForLanguage(@NotNull String language, @Nullable ClassLoader loader) {
        if (language == null) {
            Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(2);
        }
        ClassLoader l = (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE);
        return (IdeScriptEngine)ClassLoaderUtil.runWithClassLoader((ClassLoader)l, () -> {
            if (language == null) {
                Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(6);
            }
            return Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(this.getScriptEngineManager().getEngineByName(language));
        });
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForFileExtension(@NotNull String extension, @Nullable ClassLoader loader) {
        if (extension == null) {
            Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(3);
        }
        ClassLoader l = (ClassLoader)ObjectUtils.notNull((Object)loader, (Object)AllPluginsLoader.INSTANCE);
        return (IdeScriptEngine)ClassLoaderUtil.runWithClassLoader((ClassLoader)l, () -> {
            if (extension == null) {
                Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(5);
            }
            return Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(this.getScriptEngineManager().getEngineByExtension(extension));
        });
    }

    @Override
    public boolean isInitialized() {
        return this.myManagerFuture.isDone();
    }

    @NotNull
    private ScriptEngineManager getScriptEngineManager() {
        ScriptEngineManager manager = null;
        try {
            manager = this.myManagerFuture.get();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        ScriptEngineManager scriptEngineManager = (ScriptEngineManager)ObjectUtils.assertNotNull((Object)manager);
        if (scriptEngineManager == null) {
            Jsr223IdeScriptEngineManagerImpl.$$$reportNull$$$0(4);
        }
        return scriptEngineManager;
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngine engine) {
        return engine == null ? null : Jsr223IdeScriptEngineManagerImpl.redirectOutputToLog(new Jsr223IdeScriptEngine(engine));
    }

    private static IdeScriptEngine redirectOutputToLog(IdeScriptEngine engine) {
        class Log
        extends Writer {
            final boolean error;

            Log(boolean error) {
                this.error = error;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                while (len > 0 && Character.isWhitespace(cbuf[off + len - 1])) {
                    --len;
                }
                if (len == 0) {
                    return;
                }
                String s = new String(cbuf, off, len);
                if (this.error) {
                    LOG.warn(s);
                } else {
                    LOG.info(s);
                }
            }
        }
        engine.setStdOut(new Log(false));
        engine.setStdErr(new Log(true));
        return engine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptEngineManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getEngineForLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEngineForFileExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEngineForFileExtension$4";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getEngineForLanguage$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final ConcurrentMap<Long, ClassLoader> myLuckyGuess = ContainerUtil.newConcurrentMap();

        AllPluginsLoader() {
            super(null);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            boolean hasBase = p0 > 0;
            int p1 = hasBase ? name.indexOf("$", p0 + 1) : -1;
            String base = hasBase ? name.substring(0, Math.max(p0, p1)) : name;
            long hash = StringHash.calc((String)base);
            Class<?> c = null;
            ClassLoader guess1 = (ClassLoader)this.myLuckyGuess.get(hash);
            ClassLoader guess2 = (ClassLoader)this.myLuckyGuess.get(0L);
            for (ClassLoader loader : JBIterable.of((Object[])new ClassLoader[]{guess1, guess2})) {
                if (loader == this) {
                    throw new ClassNotFoundException(name);
                }
                if (loader == null) continue;
                try {
                    c = loader.loadClass(name);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            if (c == null) {
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor.getPluginClassLoader();
                    if (l == null || l == guess1 || l == guess2) continue;
                    try {
                        if (hasBase) {
                            l.loadClass(base);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                        }
                        try {
                            c = l.loadClass(name);
                            this.myLuckyGuess.putIfAbsent(hash, l);
                            this.myLuckyGuess.put(0L, l);
                        }
                        catch (ClassNotFoundException e) {
                            if (hasBase || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.putIfAbsent(hash, this);
            throw new ClassNotFoundException(name);
        }

        private static boolean isAllowedPluginResource(String name) {
            return "META-INF/services/javax.script.ScriptEngineFactory".equals(name);
        }

        @Override
        protected URL findResource(String name) {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    URL url;
                    ClassLoader l = descriptor.getPluginClassLoader();
                    URL uRL = url = l == null ? null : l.getResource(name);
                    if (url == null) continue;
                    return url;
                }
            }
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            if (AllPluginsLoader.isAllowedPluginResource(name)) {
                LinkedHashSet result2 = null;
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    Enumeration<URL> urls;
                    ClassLoader l = descriptor.getPluginClassLoader();
                    Enumeration<URL> enumeration = urls = l == null ? null : l.getResources(name);
                    if (urls == null || !urls.hasMoreElements()) continue;
                    if (result2 == null) {
                        result2 = ContainerUtil.newLinkedHashSet();
                    }
                    ContainerUtil.addAll((Collection)result2, urls);
                }
                if (result2 != null) {
                    return Collections.enumeration(result2);
                }
            }
            return this.getClass().getClassLoader().getResources(name);
        }

        @NotNull
        public List<URL> getUrls() {
            List list2 = JBIterable.of((Object[])PluginManagerCore.getPlugins()).map(PluginDescriptor::getPluginClassLoader).unique().flatMap(o -> {
                try {
                    return (List)o.getClass().getMethod("getUrls", new Class[0]).invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    return Collections.emptyList();
                }
            }).unique().toList();
            if (list2 == null) {
                AllPluginsLoader.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$AllPluginsLoader", "getUrls"));
        }
    }

    static class Jsr223IdeScriptEngine
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        Jsr223IdeScriptEngine(ScriptEngine engine) {
            this.myEngine = engine;
            this.myLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Object getBinding(@NotNull String name) {
            if (name == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(0);
            }
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value) {
            if (name == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(1);
            }
            this.myEngine.put(name, value);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            Writer writer = this.myEngine.getContext().getWriter();
            if (writer == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(2);
            }
            return writer;
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            if (writer == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(3);
            }
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            Writer writer = this.myEngine.getContext().getErrorWriter();
            if (writer == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(4);
            }
            return writer;
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            if (writer == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(5);
            }
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            Reader reader = this.myEngine.getContext().getReader();
            if (reader == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(6);
            }
            return reader;
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            if (reader == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(7);
            }
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            String string = this.myEngine.getFactory().getLanguageName();
            if (string == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            List<String> list2 = this.myEngine.getFactory().getExtensions();
            if (list2 == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(9);
            }
            return list2;
        }

        @Override
        public Object eval(final @NotNull String script) throws IdeScriptException {
            if (script == null) {
                Jsr223IdeScriptEngine.$$$reportNull$$$0(10);
            }
            return ClassLoaderUtil.runWithClassLoader((ClassLoader)this.myLoader, (ThrowableComputable)new ThrowableComputable<Object, IdeScriptException>(){

                public Object compute() throws IdeScriptException {
                    try {
                        return myEngine.eval(script);
                    }
                    catch (Throwable ex) {
                        while (ex instanceof ScriptException && ex.getCause() != null) {
                            ex = ex.getCause();
                        }
                        throw new IdeScriptException(ex);
                    }
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writer";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reader";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdOut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdErr";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStdIn";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileExtensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getBinding";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setBinding";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdOut";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdErr";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setStdIn";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "eval";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

