/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.BladeBundle;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import org.jetbrains.annotations.NotNull;

public class BladeParser
implements PsiParser {
    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder) {
        if (root == null) {
            BladeParser.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            BladeParser.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker marker = builder.mark();
        while (!builder.eof()) {
            IElementType tokenType = builder.getTokenType();
            if (tokenType == BladeTokenTypes.TEMPLATE_HTML_TEXT || tokenType == BladeTokenTypes.TEMPLATE_PHP_TEXT) {
                BladeParser.parseTemplateCode(builder, tokenType);
                continue;
            }
            if (tokenType == BladeTokenTypes.TEXT_BLOCK_START) {
                BladeParser.parseTextBlock(builder);
                continue;
            }
            if (tokenType == BladeTokenTypes.ESCAPED_TEXT_BLOCK_START) {
                BladeParser.parseEscapedTextBlock(builder);
                continue;
            }
            if (tokenType == BladeTokenTypes.RAW_TEXT_BLOCK_START) {
                BladeParser.parseRawTextBlock(builder);
                continue;
            }
            if (BladeTokenSets.DIRECTIVES.contains(tokenType)) {
                BladeParser.parseDirective(builder);
                continue;
            }
            builder.advanceLexer();
        }
        marker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            BladeParser.$$$reportNull$$$0(2);
        }
        return aSTNode;
    }

    private static void parseTemplateCode(PsiBuilder builder, IElementType type) {
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        block0: while (true) {
            int i = 0;
            while (BladeTokenTypes.WHITESPACES.contains(builder.rawLookup(i))) {
                ++i;
            }
            if (builder.rawLookup(i) != type) break;
            int j = 0;
            while (true) {
                if (j >= i) continue block0;
                builder.advanceLexer();
                ++j;
            }
            break;
        }
        marker.collapse(type);
    }

    private static void parseTextBlock(PsiBuilder builder) {
        BladeParser.parseTextBlock(builder, BladeTokenTypes.TEXT_BLOCK_CONTENT, BladeTokenTypes.TEXT_BLOCK_END, BladeElementTypes.TEXT_BLOCK, BladeBundle.message("parser.error.displaying.text.should.be.closed", new Object[0]));
    }

    private static void parseRawTextBlock(PsiBuilder builder) {
        BladeParser.parseTextBlock(builder, BladeTokenTypes.RAW_TEXT_BLOCK_CONTENT, BladeTokenTypes.RAW_TEXT_BLOCK_END, BladeElementTypes.RAW_TEXT_BLOCK, BladeBundle.message("parser.error.displaying.raw.text.should.be.closed", new Object[0]));
    }

    private static void parseEscapedTextBlock(PsiBuilder builder) {
        BladeParser.parseTextBlock(builder, BladeTokenTypes.ESCAPED_TEXT_BLOCK_CONTENT, BladeTokenTypes.ESCAPED_TEXT_BLOCK_END, BladeElementTypes.ESCAPED_TEXT_BLOCK, BladeBundle.message("parser.error.displaying.escaped.text.should.be.closed", new Object[0]));
    }

    private static void parseTextBlock(PsiBuilder builder, IElementType content, IElementType end, IElementType resultElementType, @NotNull String closingErrorMessage) {
        if (closingErrorMessage == null) {
            BladeParser.$$$reportNull$$$0(3);
        }
        PsiBuilder.Marker marker = builder.mark();
        IElementType lookup = builder.lookAhead(1);
        builder.advanceLexer();
        if (lookup == content) {
            builder.advanceLexer();
            lookup = builder.getTokenType();
        } else {
            builder.mark().done(content);
        }
        if (lookup == end) {
            builder.advanceLexer();
        } else {
            builder.mark().error(closingErrorMessage);
        }
        marker.done(resultElementType);
    }

    private static void parseDirective(PsiBuilder builder) {
        if (builder.getTokenType() == BladeTokenTypes.PHP_DIRECTIVE) {
            BladeParser.parsePhpBlock(builder);
            return;
        }
        BladeParser.parseBasicDirective(builder);
    }

    private static void parsePhpBlock(PsiBuilder builder) {
        PsiBuilder.Marker phpDirectiveMarker = builder.mark();
        boolean hasParameter = BladeParser.parseBasicDirective(builder);
        if (hasParameter) {
            phpDirectiveMarker.drop();
            return;
        }
        if (builder.getTokenType() == BladeTokenTypes.PHP_DIRECTIVE_CONTENT) {
            PsiBuilder.Marker contentMark = builder.mark();
            builder.advanceLexer();
            contentMark.collapse(BladeTokenTypes.PHP_DIRECTIVE_CONTENT);
        }
        if (builder.getTokenType() == BladeTokenTypes.ENDPHP_DIRECTIVE) {
            BladeParser.parseBasicDirective(builder);
            phpDirectiveMarker.done(BladeElementTypes.PHP_DIRECTIVE_BLOCK);
        } else {
            phpDirectiveMarker.error(BladeBundle.message("parser.error.php.block.should.be.closed.with.endphp", new Object[0]));
        }
    }

    private static boolean parseBasicDirective(PsiBuilder builder) {
        PsiBuilder.Marker directiveMarker = builder.mark();
        builder.advanceLexer();
        IElementType tokenType = builder.getTokenType();
        boolean hasParam = false;
        if (tokenType == BladeTokenTypes.DIRECTIVE_LBRACE || tokenType == BladeTokenTypes.DIRECTIVE_RBRACE) {
            BladeParser.parseDirectiveParam(builder);
            hasParam = true;
        }
        directiveMarker.done(BladeElementTypes.DIRECTIVE);
        return hasParam;
    }

    private static void parseDirectiveParam(PsiBuilder builder) {
        if (builder.getTokenType() == BladeTokenTypes.DIRECTIVE_RBRACE) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.error(BladeBundle.message("parser.error.directive.parameter.is.not.opened.with", new Object[0]));
            return;
        }
        PsiBuilder.Marker paramMarker = builder.mark();
        builder.advanceLexer();
        IElementType type = builder.getTokenType();
        if (BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT == type) {
            builder.advanceLexer();
        } else {
            builder.mark().done(BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        }
        if (builder.getTokenType() == BladeTokenTypes.DIRECTIVE_RBRACE) {
            builder.advanceLexer();
        } else {
            builder.mark().error(BladeBundle.message("parser.error.directive.parameter.is.not.closed.with", new Object[0]));
        }
        paramMarker.done(BladeElementTypes.DIRECTIVE_PARAMETER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/parser/BladeParser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/parser/BladeParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseTextBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

