/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.interpreters;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterConfigurable;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.interpreters.PhpSdkType;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoUtil;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.phpunit.PhpUnitSettingsManager;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.ui.PhpNamedCloneableItemsListEditor;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInterpretersConfigurable
extends PhpNamedCloneableItemsListEditor<PhpInterpreter>
implements SearchableConfigurable {
    private static final Logger LOG = Logger.getInstance(PhpInterpretersConfigurable.class);
    private static final String ANOTHER_LOCAL = "Other Local...";
    private static final String LOCAL = "Local Path to Interpreter...";
    private static final String REMOTE = "From Docker, Vagrant, VM, Remote...";
    @NonNls
    private static final String DISPLAY_NAME = "CLI Interpreters";
    @NonNls
    private static final String SUBJ_DISPLAY_NAME = "interpreter";
    private static final String HELP_TOPIC = "reference.settings.php.interpreters";
    @NotNull
    private final Project myProject;

    public PhpInterpretersConfigurable(@NotNull Project project, @Nullable String initialElement) {
        if (project == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(0);
        }
        super(new Namer<PhpInterpreter>(){

            public String getName(PhpInterpreter interpreter) {
                return interpreter.getName();
            }

            public boolean canRename(PhpInterpreter item) {
                return true;
            }

            public void setName(PhpInterpreter interpreter, String name) {
                interpreter.setName(name);
            }
        }, () -> new PhpInterpreter(), interpreter -> interpreter.clone(), () -> {
            if (project == null) {
                PhpInterpretersConfigurable.$$$reportNull$$$0(10);
            }
            return new ArrayList<PhpInterpreter>(PhpInterpretersManagerImpl.getInstance(project).getInterpreters());
        }, items -> {
            if (project == null) {
                PhpInterpretersConfigurable.$$$reportNull$$$0(9);
            }
            PhpInterpretersManagerImpl.getInstance(project).setInterpreters(items);
        }, item -> {
            if (project == null) {
                PhpInterpretersConfigurable.$$$reportNull$$$0(8);
            }
            return new PhpInterpreterConfigurable(project, (PhpInterpreter)item);
        }, new PhpNamedCloneableItemsListEditor.DefaultItemModelHandler(), initialElement);
        this.myProject = project;
        this.setShowIcons(true);
        this.setSubjectDisplayName(SUBJ_DISPLAY_NAME);
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        if (HELP_TOPIC == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(2);
        }
        return HELP_TOPIC;
    }

    @Nls
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    protected AnAction createAddAction() {
        return new PhpNamedCloneableItemsListEditor.AddAction(){

            @Override
            public void actionPerformed(@NotNull AnActionEvent event) {
                List suggestions;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!(suggestions = PhpInterpretersConfigurable.getSuggestedSdkPaths()).isEmpty()) {
                    PhpInterpreterChooser phpHomeSteps = new PhpInterpreterChooser(suggestions){

                        @Override
                        protected void createFromFilePath(@NotNull VirtualFile file) {
                            Set<String> debuggerId;
                            if (file == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            PhpInterpreter interpreter = (PhpInterpreter)PhpInterpretersConfigurable.this.createItem();
                            interpreter.setHomePath(FileUtil.toSystemDependentName((String)file.getPath()));
                            PhpInfo phpInfo = PhpInfoUtil.getPhpInfo(PhpInterpretersConfigurable.this.myProject, interpreter, null);
                            if (phpInfo != null && !(debuggerId = PhpDebugUtil.getLoadedDebuggerIds(phpInfo)).isEmpty()) {
                                interpreter.setDebuggerId(debuggerId.iterator().next());
                            }
                            PhpInterpretersConfigurable.this.onItemCreated(interpreter);
                        }

                        @Override
                        protected void createRemote() {
                            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                            if (manager != null) {
                                PhpInterpreter newInterpreter = manager.addRemoteSdk(PhpInterpretersConfigurable.this.myProject, (Producer<PhpInterpreter>)((Producer)() -> (PhpInterpreter)PhpInterpretersConfigurable.this.createItem()));
                                if (newInterpreter != null) {
                                    PhpInterpretersConfigurable.this.onItemCreated(newInterpreter);
                                }
                            } else {
                                Messages.showErrorDialog((String)("The Remote Hosts Access plugin is missing. Please enable the plugin in " + ShowSettingsUtil.getSettingsMenuName() + " | Plugins."), (String)"Add Remote Interpreter");
                            }
                        }

                        @Override
                        protected void createLocal() {
                            PhpInterpretersConfigurable.this.onItemCreated(PhpInterpretersConfigurable.this.createItem());
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/config/interpreters/PhpInterpretersConfigurable$2$1", "createFromFilePath"));
                        }
                    };
                    ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)phpHomeSteps);
                    InputEvent inputEvent = event.getInputEvent();
                    if (inputEvent instanceof MouseEvent) {
                        Point locationOnScreen = ((MouseEvent)inputEvent).getLocationOnScreen();
                        popup.showInScreenCoordinates((Component)PhpInterpretersConfigurable.this.myWholePanel, locationOnScreen);
                    } else {
                        popup.showInBestPositionFor(event.getDataContext());
                    }
                } else {
                    super.actionPerformed(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/config/interpreters/PhpInterpretersConfigurable$2", "actionPerformed"));
            }
        };
    }

    @Override
    protected AnAction createDeleteAction() {
        return new PhpInterpreterDeleteAction((Condition<Object[]>)PhpInterpretersConfigurable.forAll(o -> this.canDelete((PhpInterpreter)((MasterDetailsComponent.MyNode)o).getConfigurable().getEditableObject())));
    }

    @Override
    @NotNull
    public String suggestUniqueName(PhpInterpreter interpreter) {
        PhpInfo phpInfo = PhpInfoUtil.getPhpInfo(this.myProject, interpreter, this.myWholePanel);
        String name = this.suggestUniqueName(this.suggestName(interpreter, phpInfo));
        PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject).setPhpInfo(name, phpInfo);
        String string = name;
        if (string == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected String suggestName(PhpInterpreter interpreter) {
        PhpInfo phpInfo = PhpInfoUtil.getPhpInfo(this.myProject, interpreter, null);
        String string = this.suggestName(interpreter, phpInfo);
        if (string == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String suggestName(@NotNull PhpInterpreter interpreter, @Nullable PhpInfo phpInfo) {
        if (interpreter == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(5);
        }
        String string = interpreter.getPhpSdkAdditionalData().suggestName(phpInfo);
        if (string == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static List<String> getSuggestedSdkPaths() {
        Collection<String> sdkHomes;
        ArrayList<String> paths = new ArrayList<String>();
        if (PhpRemoteInterpreterManager.getInstance() != null) {
            paths.add(REMOTE);
        }
        if ((sdkHomes = PhpSdkType.getInstance().suggestHomePaths()).isEmpty()) {
            paths.add(LOCAL);
        } else {
            ContainerUtil.addAll(paths, sdkHomes);
            paths.add(ANOTHER_LOCAL);
        }
        return paths;
    }

    @Override
    @NotNull
    protected PhpInterpreter cloneItem(PhpInterpreter item) {
        PhpInterpreter interpreter = super.cloneItem(item);
        interpreter.setId(PhpInterpreter.getNextId());
        PhpInterpreter phpInterpreter = interpreter;
        if (phpInterpreter == null) {
            PhpInterpretersConfigurable.$$$reportNull$$$0(7);
        }
        return phpInterpreter;
    }

    @Override
    protected void validate() throws ConfigurationException {
        HashSet<String> names = new HashSet<String>();
        for (PhpInterpreter interpreter : this.getItems()) {
            String name = interpreter.getName();
            if (names.contains(name)) {
                throw new ConfigurationException(PhpBundle.message("PhpInterpreter.configuration.duplicate.interpreter.name", name));
            }
            names.add(name);
        }
    }

    @Override
    protected void onApply() {
        PhpInterpretersPhpInfoCacheImpl phpInfoCache = PhpInterpretersPhpInfoCacheImpl.getInstance(this.myProject);
        phpInfoCache.clear();
        List<UnnamedConfigurable> itemConfigurables = this.getItemConfigurables();
        for (UnnamedConfigurable itemConfigurable : itemConfigurables) {
            if (!(itemConfigurable instanceof PhpInterpreterConfigurable)) continue;
            PhpInterpreterConfigurable interpreterConfigurable = (PhpInterpreterConfigurable)itemConfigurable;
            String interpreterName = interpreterConfigurable.getInterpreterName();
            PhpInfo phpInfo = interpreterConfigurable.getLastLoadedPhpInfo();
            phpInfoCache.setPhpInfo(interpreterName, phpInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/interpreters/PhpInterpretersConfigurable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = SUBJ_DISPLAY_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/interpreters/PhpInterpretersConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueName";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suggestName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$4";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PhpInterpreterDeleteAction
    extends MasterDetailsComponent.MyDeleteAction {
        PhpInterpreterDeleteAction(Condition<Object[]> availableCondition) {
            super((MasterDetailsComponent)PhpInterpretersConfigurable.this, availableCondition);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PhpInterpreter item;
            if (e == null) {
                PhpInterpreterDeleteAction.$$$reportNull$$$0(0);
            }
            if ((item = (PhpInterpreter)PhpInterpretersConfigurable.this.getSelectedItem()) != null && item.isRemote() && PhpUnitSettingsManager.getInstance(PhpInterpretersConfigurable.this.myProject).getSettingsByInterpreter(item) != null) {
                String title = PhpBundle.message("PhpInterpreter.php.dependent.configuration.exists.title", new Object[0]);
                String message = PhpBundle.message("PhpInterpreter.php.dependent.configuration.exists", "PHPUnit");
                int result = Messages.showYesNoDialog((Project)PhpInterpretersConfigurable.this.myProject, (String)message, (String)title, (Icon)UIUtil.getQuestionIcon());
                if (0 == result) {
                    super.actionPerformed(e);
                }
            } else {
                super.actionPerformed(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/config/interpreters/PhpInterpretersConfigurable$PhpInterpreterDeleteAction", "actionPerformed"));
        }
    }

    private static abstract class PhpInterpreterChooser
    extends BaseListPopupStep<String> {
        private int mySeparator;

        protected PhpInterpreterChooser(@NotNull List<String> suggestions) {
            if (suggestions == null) {
                PhpInterpreterChooser.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("PhpInterpreter.configuration.selection.list.title", new Object[0]), suggestions);
            this.mySeparator = -1;
            List values = this.getValues();
            if (values.size() > 2 && PhpInterpretersConfigurable.REMOTE.equals(this.getValues().get(0))) {
                this.mySeparator = 1;
            }
        }

        public ListSeparator getSeparatorAbove(String value) {
            List values;
            if (this.mySeparator != -1 && (values = this.getValues()).indexOf(value) == this.mySeparator) {
                return new ListSeparator();
            }
            return super.getSeparatorAbove((Object)value);
        }

        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
            return this.doFinalStep(() -> {
                if (PhpInterpretersConfigurable.LOCAL.equals(selectedValue) || PhpInterpretersConfigurable.ANOTHER_LOCAL.equals(selectedValue)) {
                    this.createLocal();
                } else if (PhpInterpretersConfigurable.REMOTE.equals(selectedValue)) {
                    this.createRemote();
                } else {
                    VirtualFile selectedFile = LocalFileSystem.getInstance().findFileByPath(selectedValue);
                    if (selectedFile == null) {
                        LOG.warn("Can not find php binary in " + selectedValue);
                        this.createLocal();
                    } else {
                        this.createFromFilePath(selectedFile);
                    }
                }
            });
        }

        protected abstract void createLocal();

        protected abstract void createRemote();

        protected abstract void createFromFilePath(@NotNull VirtualFile var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestions", "com/jetbrains/php/config/interpreters/PhpInterpretersConfigurable$PhpInterpreterChooser", "<init>"));
        }
    }
}

