/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.content.Content;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpInterpretersPhpInfoCacheImpl;
import com.jetbrains.php.config.phpInfo.PhpDebuggerInfo;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.config.phpInfo.PhpInfoDialog;
import com.jetbrains.php.config.phpInfo.PhpNonPersistedInfo;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfigurable;
import com.jetbrains.php.debug.PhpDebugSkippedPathsConfiguration;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugRuntimeEnvironment;
import com.jetbrains.php.debug.common.PhpStackFrame;
import com.jetbrains.php.debug.xdebug.XdebugExtension;
import com.jetbrains.php.debug.zend.ZendDebuggerExtension;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.util.PhpStringUtil;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDebugUtil {
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"PHP Debugger", (String)ToolWindowId.DEBUG, (boolean)false);
    public static final String NOTIFICATION_ID = "Debugger";
    private static final String STDOUT_CONSOLE_ID = "PHP_REMOTE_DEBUG_STDOUT_ID";
    private static final String STDOUT_CONSOLE_NAME = "Output";
    public static final String EXPR_PHP_IDE_CONFIG = "$_SERVER['PHP_IDE_CONFIG']";
    public static final String EXPR_GET_SERVER_ADDR = "$_SERVER['SERVER_ADDR']";
    public static final String EXPR_GET_SERVER_NAME = "$_SERVER['SERVER_NAME']";
    public static final String EXPR_GET_SERVER_PORT = "$_SERVER['SERVER_PORT']";
    public static final String EXPR_GET_REQUEST_URI = "$_SERVER['REQUEST_URI']";
    public static final String EXPR_FILE_EXISTS = "file_exists('%1$s')";
    public static final String CAST_TO_STRING = "(string)(%1$s)";
    public static final String EXPR_TRUE = "1";
    public static final String ZEND_DEBUGGER_ID = "php.debugger.ZendDebugger";
    public static final String XDEBUG_DEBUGGER_ID = "php.debugger.XDebug";
    public static final String PROTOCOL_HTTP = "http";
    public static final String IDE_EVAL_CACHE = "IDE_EVAL_CACHE";
    public static final String EXPR_IDE_EVAL_CACHE_VAR = "$GLOBALS['IDE_EVAL_CACHE']";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_NULL = "null";
    public static final byte[] EMPTY_FILE_CONTENT = ArrayUtil.EMPTY_BYTE_ARRAY;
    public static final int DEFAULT_EVAL_DEPTH = 1;

    private PhpDebugUtil() {
    }

    public static void addExternalStdoutTab(@NotNull RunContentDescriptor descriptor, @NotNull ConsoleView consoleView) {
        RunnerLayoutUi ui;
        if (descriptor == null) {
            PhpDebugUtil.$$$reportNull$$$0(0);
        }
        if (consoleView == null) {
            PhpDebugUtil.$$$reportNull$$$0(1);
        }
        if ((ui = descriptor.getRunnerLayoutUi()) != null) {
            Content content = ui.createContent(STDOUT_CONSOLE_ID, consoleView.getComponent(), STDOUT_CONSOLE_NAME, null, null);
            ui.addContent(content, 2, PlaceInGrid.bottom, false);
        }
    }

    public static void showWarningNotification(@Nullable Project project, @NotNull String title, @NotNull String text) {
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            PhpDebugUtil.$$$reportNull$$$0(3);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_ID, title, text, NotificationType.WARNING), (Project)project);
    }

    public static String getQuery(@NotNull Map<String, String> parameters) {
        if (parameters == null) {
            PhpDebugUtil.$$$reportNull$$$0(4);
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String parameterName : parameters.keySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                builder.append("&");
            }
            try {
                String value = parameters.get(parameterName);
                if (value != null) {
                    String encodedParameterValue = URLEncoder.encode(value, "UTF-8");
                    builder.append(parameterName);
                    builder.append("=");
                    builder.append(encodedParameterValue);
                    continue;
                }
                builder.append(parameterName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return builder.toString();
    }

    public static String getQuery(@NotNull MultiMap<String, String> parameters) {
        if (parameters == null) {
            PhpDebugUtil.$$$reportNull$$$0(5);
        }
        StringBuilder builder = new StringBuilder();
        boolean isFirst = true;
        for (String parameterName : parameters.keySet()) {
            try {
                if (!parameters.containsKey((Object)parameterName)) continue;
                Collection values = parameters.get((Object)parameterName);
                for (String value : values) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        builder.append("&");
                    }
                    String parameterArray = URLEncoder.encode(parameterName + "[]", "UTF-8");
                    String encodedParameterValue = URLEncoder.encode(value, "UTF-8");
                    builder.append(parameterArray);
                    builder.append("=");
                    builder.append(encodedParameterValue);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        }
        return builder.toString();
    }

    public static String joinUrl(@NotNull String url, @NotNull String query) {
        if (url == null) {
            PhpDebugUtil.$$$reportNull$$$0(6);
        }
        if (query == null) {
            PhpDebugUtil.$$$reportNull$$$0(7);
        }
        return url + (url.contains("?") ? "&" : "?") + query;
    }

    public static String createUrl(@NotNull String host, int port, @NotNull String protocol, @NotNull String path) {
        if (host == null) {
            PhpDebugUtil.$$$reportNull$$$0(8);
        }
        if (protocol == null) {
            PhpDebugUtil.$$$reportNull$$$0(9);
        }
        if (path == null) {
            PhpDebugUtil.$$$reportNull$$$0(10);
        }
        if (path.startsWith("/")) {
            return protocol + "://" + PhpDebugUtil.getWebServerName(host, port) + path;
        }
        return path;
    }

    public static String getWebServerName(@NotNull String host, int port) {
        if (host == null) {
            PhpDebugUtil.$$$reportNull$$$0(11);
        }
        if (port == 80) {
            return host;
        }
        return host + ":" + port;
    }

    @NotNull
    public static String getFileExistsExpression(@NotNull String remoteFilePath) {
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(12);
        }
        String string = String.format(EXPR_FILE_EXISTS, remoteFilePath);
        if (string == null) {
            PhpDebugUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isXDebug(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(14);
        }
        return XDEBUG_DEBUGGER_ID.equals(debuggerId);
    }

    public static boolean isZendDebugger(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(15);
        }
        return ZEND_DEBUGGER_ID.equals(debuggerId);
    }

    @NotNull
    public static PhpDebugExtension getDebugExtensionByDebuggerId(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(16);
        }
        if (PhpDebugUtil.isXDebug(debuggerId)) {
            XdebugExtension xdebugExtension = XdebugExtension.INSTANCE;
            if (xdebugExtension == null) {
                PhpDebugUtil.$$$reportNull$$$0(17);
            }
            return xdebugExtension;
        }
        if (PhpDebugUtil.isZendDebugger(debuggerId)) {
            ZendDebuggerExtension zendDebuggerExtension = ZendDebuggerExtension.INSTANCE;
            if (zendDebuggerExtension == null) {
                PhpDebugUtil.$$$reportNull$$$0(18);
            }
            return zendDebuggerExtension;
        }
        assert (false) : "Can not find debugger extension by id: '" + debuggerId + "'";
        if (null == null) {
            PhpDebugUtil.$$$reportNull$$$0(19);
        }
        return null;
    }

    public static boolean isUnderSkippedPath(@NotNull Project project, @Nullable String serverName, @NotNull String remoteFilePath) {
        PhpPathMapper pathMapper;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(20);
        }
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(21);
        }
        if (serverName == null) {
            pathMapper = PhpPathMapper.create(project);
        } else {
            PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName);
            if (server == null) {
                return false;
            }
            pathMapper = PhpPathMapper.create(server);
        }
        String localPath = pathMapper.getLocalPath(remoteFilePath);
        if (localPath == null) {
            return false;
        }
        PhpDebugSkippedPathsConfiguration.State state = PhpDebugSkippedPathsConfiguration.getInstance(project).getState();
        assert (state != null);
        List<String> ignoredFiles = state.getSkippedFiles();
        String[] localFilePath = PhpPathMapper.getPath(localPath);
        for (String ignoredFile : ignoredFiles) {
            if (!PhpStringUtil.isPrefix(localFilePath, PhpPathMapper.getPath(ignoredFile))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPhpInfoHelperScript(@NotNull Project project, @Nullable String serverName, @NotNull String remoteFilePath) {
        PhpPathMapper pathMapper;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(22);
        }
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(23);
        }
        if (serverName == null) {
            pathMapper = PhpPathMapper.create(project);
        } else {
            PhpServer server = PhpProjectConfigurationFacade.getInstance(project).findServer(serverName);
            if (server == null) {
                return false;
            }
            pathMapper = PhpPathMapper.create(server);
        }
        String localPath = pathMapper.getLocalPath(remoteFilePath);
        if (localPath == null) {
            return false;
        }
        return PhpStringUtil.isPrefix(PhpPathMapper.getPath(localPath), PhpPathMapper.getPath(PhpExecutionUtil.getHelperScriptFilePath("phpinfo.php")));
    }

    public static boolean isHelperScript(@NotNull String remotePath) {
        String fileName;
        if (remotePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(24);
        }
        return FileUtil.namesEqual((String)(fileName = PathUtil.getFileName((String)remotePath)), (String)"_intellij_phpdebug_validator.php") || FileUtil.namesEqual((String)fileName, (String)PhpExecutionUtil.getHelperScriptFileName("phpinfo.php"));
    }

    public static void notifyAboutSkippedFile(final @NotNull Project project, @NotNull String remoteFilePath) {
        PhpDebugSkippedPathsConfiguration.State state;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(25);
        }
        if (remoteFilePath == null) {
            PhpDebugUtil.$$$reportNull$$$0(26);
        }
        if ((state = PhpDebugSkippedPathsConfiguration.getInstance(project).getState()) != null && state.isNotify()) {
            UIUtil.invokeLaterIfNeeded(() -> {
                if (remoteFilePath == null) {
                    PhpDebugUtil.$$$reportNull$$$0(67);
                }
                if (project == null) {
                    PhpDebugUtil.$$$reportNull$$$0(68);
                }
                String message = PhpBundle.message("debug.file.is.ignored", PathUtil.getFileName((String)remoteFilePath)) + "\n" + PhpBundle.message("debug.edit.ignored.paths.list", new Object[0]);
                NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
                        if (notification2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PhpDebugSkippedPathsConfigurable(project));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "e";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/php/debug/PhpDebugUtil$1";
                        objectArray[2] = "hyperlinkUpdate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).notify(project);
            });
        }
    }

    @NotNull
    public static <T> List<Ref<T>> wrap(@NotNull List<T> list) {
        if (list == null) {
            PhpDebugUtil.$$$reportNull$$$0(27);
        }
        List list2 = ContainerUtil.map2List(list, s -> Ref.create((Object)s));
        if (list2 == null) {
            PhpDebugUtil.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    public static <T> Set<Ref<T>> wrap(@NotNull Set<T> list) {
        if (list == null) {
            PhpDebugUtil.$$$reportNull$$$0(29);
        }
        Set set = ContainerUtil.map2Set(list, s -> Ref.create((Object)s));
        if (set == null) {
            PhpDebugUtil.$$$reportNull$$$0(30);
        }
        return set;
    }

    @NotNull
    public static <T> List<T> unwrap(@NotNull List<? extends Ref<T>> list) {
        if (list == null) {
            PhpDebugUtil.$$$reportNull$$$0(31);
        }
        List list2 = ContainerUtil.map2List(list, s -> s.get());
        if (list2 == null) {
            PhpDebugUtil.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @NotNull
    public static String getDebugOutputEncoding(@NotNull Project project) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(33);
        }
        String string = EncodingProjectManager.getInstance((Project)project).getDefaultCharset().name();
        if (string == null) {
            PhpDebugUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    public static String getDebuggerNameById(@NotNull String debuggerId) {
        if (debuggerId == null) {
            PhpDebugUtil.$$$reportNull$$$0(35);
        }
        if (PhpDebugUtil.isXDebug(debuggerId)) {
            String string = PhpBundle.message("debug.xdebug", new Object[0]);
            if (string == null) {
                PhpDebugUtil.$$$reportNull$$$0(36);
            }
            return string;
        }
        if (PhpDebugUtil.isZendDebugger(debuggerId)) {
            String string = PhpBundle.message("debug.zend.debugger", new Object[0]);
            if (string == null) {
                PhpDebugUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        if ("" == null) {
            PhpDebugUtil.$$$reportNull$$$0(38);
        }
        return "";
    }

    @NotNull
    public static String getEvalCacheVariable(@NotNull String cacheKey) {
        if (cacheKey == null) {
            PhpDebugUtil.$$$reportNull$$$0(39);
        }
        String string = "$GLOBALS['IDE_EVAL_CACHE']['" + cacheKey + "']";
        if (string == null) {
            PhpDebugUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static Set<String> getLoadedDebuggerIds(@NotNull PhpInfo info) {
        if (info == null) {
            PhpDebugUtil.$$$reportNull$$$0(41);
        }
        HashSet ids = ContainerUtil.newHashSet();
        for (PhpDebuggerInfo debugger : info.getDebuggers()) {
            String id = PhpDebugUtil.getDebuggerId(debugger);
            if (!StringUtil.isNotEmpty((String)id)) continue;
            ids.add(id);
        }
        HashSet hashSet = ids;
        if (hashSet == null) {
            PhpDebugUtil.$$$reportNull$$$0(42);
        }
        return hashSet;
    }

    @Nullable
    public static String getDebuggerId(@NotNull PhpDebuggerInfo info) {
        if (info == null) {
            PhpDebugUtil.$$$reportNull$$$0(43);
        }
        if (StringUtil.equals((CharSequence)info.getDebugger(), (CharSequence)XdebugExtension.INSTANCE.getName())) {
            return XDEBUG_DEBUGGER_ID;
        }
        if (StringUtil.equals((CharSequence)info.getDebugger(), (CharSequence)ZendDebuggerExtension.INSTANCE.getName())) {
            return ZEND_DEBUGGER_ID;
        }
        return null;
    }

    public static void rebuildAllDebugViews(@NotNull Project project) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(44);
        }
        for (PhpDebugProcess process : XDebuggerManager.getInstance((Project)project).getDebugProcesses(PhpDebugProcess.class)) {
            XDebugSession session = process.getSession();
            if (!session.isSuspended()) continue;
            session.rebuildViews();
        }
    }

    public static void showFailsToConnectMessage(final Project project, final @Nullable String interpreterName) {
        final PhpInfo info = PhpInterpretersPhpInfoCacheImpl.getInstance(project).getPhpInfo(interpreterName);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String errorMessage = this.getErrorMessage();
                NotificationListener listener = new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                        if (notification2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (event == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            UIUtil.invokeLaterIfNeeded(() -> {
                                PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
                                if (interpreter == null) {
                                    String error = PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP Interpreter");
                                    PhpDebugUtil.showErrorNotification(project, error, null);
                                    return;
                                }
                                Pair<PhpInfo, PhpNonPersistedInfo> newInfo = PhpInterpretersPhpInfoCacheImpl.getInstance(project).updateAnGetWholeInfo(project, interpreter.getName(), null);
                                if (newInfo == null) {
                                    String error = PhpBundle.message("validation.value.is.not.specified.or.invalid", "PHP Interpreter");
                                    PhpDebugUtil.showErrorNotification(project, error, null);
                                    return;
                                }
                                List<PhpDebuggerInfo> newDebuggers = ((PhpInfo)newInfo.getFirst()).getDebuggers();
                                if (!newDebuggers.isEmpty() && !PhpDebugUtil.containDebugger(newDebuggers, interpreter.getDebuggerId())) {
                                    interpreter.setDebuggerId(PhpDebugUtil.getDebuggerId(newDebuggers.get(0)));
                                }
                                PhpDebugUtil.showErrorNotification(project, (PhpInfo)newInfo.getFirst(), (PhpNonPersistedInfo)newInfo.getSecond(), PhpDebugUtil.validatePhpInfo(interpreter, (PhpInfo)newInfo.getFirst(), info));
                            });
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "notification";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/php/debug/PhpDebugUtil$2$1";
                        objectArray[2] = "hyperlinkUpdate";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                PhpDebugUtil.showErrorNotification(project, errorMessage, listener);
            }

            private String getErrorMessage() {
                if (info == null) {
                    return PhpBundle.message("validation.connection.was.not.established", new Object[0]);
                }
                PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreter(interpreterName);
                if (info.getDebuggers().isEmpty() || interpreter == null || StringUtil.isEmpty((String)interpreter.getDebuggerId())) {
                    return PhpBundle.message("validation.connection.was.not.established.no.debug", new Object[0]);
                }
                if (info.getDebuggers().size() == 1) {
                    return PhpBundle.message("validation.connection.was.not.established.0", info.getDebuggers().get(0));
                }
                String debuggerId = interpreter.getDebuggerId();
                return PhpBundle.message("validation.connection.was.not.established.0", PhpDebugUtil.getDebuggerNameById(debuggerId));
            }
        });
    }

    private static boolean containDebugger(@NotNull List<? extends PhpDebuggerInfo> newDebuggers, @Nullable String debuggerId) {
        if (newDebuggers == null) {
            PhpDebugUtil.$$$reportNull$$$0(45);
        }
        if (!StringUtil.isEmpty((String)debuggerId)) {
            for (PhpDebuggerInfo phpDebuggerInfo : newDebuggers) {
                if (!StringUtil.equals((CharSequence)PhpDebugUtil.getDebuggerId(phpDebuggerInfo), (CharSequence)debuggerId)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String validatePhpInfo(@NotNull PhpInterpreter interpreter, @NotNull PhpInfo newInfo, @Nullable PhpInfo oldInfo) {
        if (interpreter == null) {
            PhpDebugUtil.$$$reportNull$$$0(46);
        }
        if (newInfo == null) {
            PhpDebugUtil.$$$reportNull$$$0(47);
        }
        if (newInfo.getDebuggers().isEmpty()) {
            String string = PhpBundle.message("validation.no.debug.extension.is.installed", new Object[0]);
            if (string == null) {
                PhpDebugUtil.$$$reportNull$$$0(48);
            }
            return string;
        }
        if (oldInfo == null || !oldInfo.getDebuggers().equals(newInfo.getDebuggers())) {
            String string = PhpBundle.message("validation.debug.extension.is.updated", new Object[0]);
            if (string == null) {
                PhpDebugUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        if (interpreter.isRemote()) {
            String newSsh;
            String debuggerId = interpreter.getDebuggerId();
            if (StringUtil.isNotEmpty((String)debuggerId) && StringUtil.equals((CharSequence)"Zend Debugger", (CharSequence)PhpDebugUtil.getDebuggerNameById(debuggerId))) {
                String string = PhpBundle.message("validation.ssh.remote.debug.support", "Zend Debugger");
                if (string == null) {
                    PhpDebugUtil.$$$reportNull$$$0(50);
                }
                return string;
            }
            String oldSsh = oldInfo.getRemoteHost();
            if (!StringUtil.equals((CharSequence)oldSsh, (CharSequence)(newSsh = newInfo.getRemoteHost()))) {
                String string = PhpBundle.message("validation.debug.extension.is.updated", new Object[0]);
                if (string == null) {
                    PhpDebugUtil.$$$reportNull$$$0(51);
                }
                return string;
            }
        }
        String debuggersList = StringUtil.join(newInfo.getDebuggers(), (String)", ");
        String string = PhpBundle.message("validation.0.extension.is.installed.check.configuration.options", debuggersList);
        if (string == null) {
            PhpDebugUtil.$$$reportNull$$$0(52);
        }
        return string;
    }

    private static void showErrorNotification(@NotNull Project project, @NotNull PhpInfo phpInfo, @NotNull PhpNonPersistedInfo phpNonPersistedInfo, @NotNull String message) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(53);
        }
        if (phpInfo == null) {
            PhpDebugUtil.$$$reportNull$$$0(54);
        }
        if (phpNonPersistedInfo == null) {
            PhpDebugUtil.$$$reportNull$$$0(55);
        }
        if (message == null) {
            PhpDebugUtil.$$$reportNull$$$0(56);
        }
        NotificationListener listener = PhpInfoDialog.createNotificationListener(project, phpInfo, phpNonPersistedInfo);
        PhpDebugUtil.showErrorNotification(project, message + " <a href='#a'>Show phpinfo</a>.", listener);
    }

    private static void showErrorNotification(@NotNull Project project, @NotNull String message, @Nullable NotificationListener listener) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(57);
        }
        if (message == null) {
            PhpDebugUtil.$$$reportNull$$$0(58);
        }
        NOTIFICATION_GROUP.createNotification("", message, NotificationType.ERROR, listener).notify(project);
    }

    public static void showWarningNotification(@NotNull Project project, @NotNull String title, @NotNull String message, @Nullable NotificationListener listener) {
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(59);
        }
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(60);
        }
        if (message == null) {
            PhpDebugUtil.$$$reportNull$$$0(61);
        }
        NOTIFICATION_GROUP.createNotification(title, message, NotificationType.WARNING, listener).notify(project);
    }

    public static void showWarningBalloon(@Nullable Project project, @NotNull String title, @NotNull String text, @Nullable NotificationListener listener) {
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(62);
        }
        if (text == null) {
            PhpDebugUtil.$$$reportNull$$$0(63);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_ID, title, text, NotificationType.WARNING, listener), (Project)project);
    }

    public static void showInformationBalloon(@Nullable Project project, @NotNull String title, @NotNull String text, @Nullable NotificationListener listener) {
        if (title == null) {
            PhpDebugUtil.$$$reportNull$$$0(64);
        }
        if (text == null) {
            PhpDebugUtil.$$$reportNull$$$0(65);
        }
        Notifications.Bus.notify((Notification)new Notification(NOTIFICATION_ID, title, text, NotificationType.INFORMATION, listener), (Project)project);
    }

    @Nullable
    public static PhpDebugRuntimeEnvironment getCurrentRuntimeEnvironment(@NotNull Project project) {
        XStackFrame frame;
        XDebuggerManager debuggerManager;
        XDebugSession session;
        if (project == null) {
            PhpDebugUtil.$$$reportNull$$$0(66);
        }
        if ((session = (debuggerManager = XDebuggerManager.getInstance((Project)project)).getCurrentSession()) != null && (frame = session.getCurrentStackFrame()) instanceof PhpStackFrame) {
            return ((PhpStackFrame)frame).getRuntimeEnvironment();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 2: 
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 21: 
            case 23: 
            case 26: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/debug/PhpDebugUtil";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerId";
                break;
            }
            case 20: 
            case 22: 
            case 25: 
            case 33: 
            case 44: 
            case 53: 
            case 57: 
            case 59: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDebuggers";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpInfo";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpNonPersistedInfo";
                break;
            }
            case 56: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/debug/PhpDebugUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExistsExpression";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugExtensionByDebuggerId";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugOutputEncoding";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerNameById";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvalCacheVariable";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedDebuggerIds";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "validatePhpInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExternalStdoutTab";
                break;
            }
            case 2: 
            case 3: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "showWarningNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQuery";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "joinUrl";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getWebServerName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileExistsExpression";
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isXDebug";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isZendDebugger";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDebugExtensionByDebuggerId";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isUnderSkippedPath";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isPhpInfoHelperScript";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isHelperScript";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notifyAboutSkippedFile";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDebugOutputEncoding";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerNameById";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getEvalCacheVariable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLoadedDebuggerIds";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDebuggerId";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "rebuildAllDebugViews";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "containDebugger";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "validatePhpInfo";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "showWarningBalloon";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "showInformationBalloon";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRuntimeEnvironment";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notifyAboutSkippedFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 28: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

