/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpFileImpl;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamespaceStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPsiUtil {
    public static final Condition<PsiElement> PSI_COMMENT_INSTANCEOF = e -> e instanceof PsiComment;
    public static final Condition<PsiElement> PSI_WHITE_SPACE_INSTANCEOF = e -> e instanceof PsiWhiteSpace;
    public static final Condition<PsiElement> PSI_ERROR_ELEMENT_INSTANCEOF = e -> e instanceof PsiErrorElement;

    private PhpPsiUtil() {
    }

    @Nullable
    @Contract(value="null, _ -> null", pure=true)
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(0);
        }
        return PhpPsiUtil.getParentByCondition(element, true, condition, null);
    }

    @Nullable
    @Contract(value="null, _, _ -> null", pure=true)
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(1);
        }
        return PhpPsiUtil.getParentByCondition(element, strict, condition, null);
    }

    @Nullable
    @Contract(value="null, _, _, _ -> null", pure=true)
    public static <T extends PsiElement> T getParentByCondition(@Nullable PsiElement element, boolean strict, @NotNull Condition<? super PsiElement> condition, @Nullable Condition<? super PsiElement> stopAt) {
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(2);
        }
        PsiElement curElement = strict ? PsiTreeUtil.getStubOrPsiParent((PsiElement)element) : element;
        while (curElement != null) {
            if (stopAt != null && stopAt.value((Object)curElement)) {
                return null;
            }
            if (condition.value((Object)curElement)) {
                return (T)curElement;
            }
            if (curElement instanceof PsiFile) {
                return null;
            }
            curElement = PsiTreeUtil.getStubOrPsiParent((PsiElement)curElement);
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends PsiElement> List<T> getChildren(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(3);
        }
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PhpPsiUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList result = null;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child.getNode() instanceof CompositeElement) || !condition.value((Object)child)) continue;
            if (result == null) {
                result = new SmartList();
            }
            result.add(child);
        }
        SmartList smartList = result != null ? result : Collections.emptyList();
        if (smartList == null) {
            PhpPsiUtil.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @Contract(value="null, _ -> null", pure=true)
    @Nullable
    public static <T extends PsiElement> T getChildByCondition(@Nullable PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(6);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child.getNode() instanceof CompositeElement) || !condition.value((Object)child)) continue;
            return (T)child;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@NotNull PsiElement element, @NotNull IElementType type) {
        ASTNode childNode;
        ASTNode elementNode;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(7);
        }
        if (type == null) {
            PhpPsiUtil.$$$reportNull$$$0(8);
        }
        if ((elementNode = element.getNode()) != null && (childNode = elementNode.findChildByType(type)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@NotNull PsiElement element, @NotNull TokenSet typesSet) {
        ASTNode childNode;
        ASTNode elementNode;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(9);
        }
        if (typesSet == null) {
            PhpPsiUtil.$$$reportNull$$$0(10);
        }
        if ((elementNode = element.getNode()) != null && (childNode = elementNode.findChildByType(typesSet)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getChildOfType(@NotNull PsiElement element, @NotNull IElementType type, @NotNull PsiElement anchor) {
        ASTNode childNode;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(11);
        }
        if (type == null) {
            PhpPsiUtil.$$$reportNull$$$0(12);
        }
        if (anchor == null) {
            PhpPsiUtil.$$$reportNull$$$0(13);
        }
        ASTNode elementNode = element.getNode();
        ASTNode anchorNode = anchor.getNode();
        if (anchorNode == null) {
            return null;
        }
        anchorNode = anchorNode.getTreeNext();
        if (elementNode != null && anchorNode != null && (childNode = elementNode.findChildByType(TokenSet.create((IElementType[])new IElementType[]{type}), anchorNode)) != null) {
            return childNode.getPsi();
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static PhpPsiElement[] getPhpPsiElementsInRange(@NotNull PsiElement beginRange, @NotNull PsiElement endRange) {
        if (beginRange == null) {
            PhpPsiUtil.$$$reportNull$$$0(14);
        }
        if (endRange == null) {
            PhpPsiUtil.$$$reportNull$$$0(15);
        }
        ArrayList<PhpPsiElement> elements = new ArrayList<PhpPsiElement>();
        if (beginRange == endRange) {
            if (PhpPsiElement.EMPTY_ARRAY == null) {
                PhpPsiUtil.$$$reportNull$$$0(16);
            }
            return PhpPsiElement.EMPTY_ARRAY;
        }
        for (PsiElement curChild = beginRange.getNextSibling(); curChild != null && curChild != endRange; curChild = curChild.getNextSibling()) {
            if (!(curChild instanceof PhpPsiElement)) continue;
            elements.add((PhpPsiElement)curChild);
        }
        if (elements.size() == 0) {
            if (PhpPsiElement.EMPTY_ARRAY == null) {
                PhpPsiUtil.$$$reportNull$$$0(17);
            }
            return PhpPsiElement.EMPTY_ARRAY;
        }
        PhpPsiElement[] phpPsiElementArray = elements.toArray(PhpPsiElement.EMPTY_ARRAY);
        if (phpPsiElementArray == null) {
            PhpPsiUtil.$$$reportNull$$$0(18);
        }
        return phpPsiElementArray;
    }

    @Contract(pure=true)
    @Nullable
    public static PhpScopeHolder getScopeHolder(@NotNull PsiElement variable) {
        PsiElement parentParentParent;
        PsiElement parentParent;
        PsiElement parent;
        if (variable == null) {
            PhpPsiUtil.$$$reportNull$$$0(19);
        }
        if ((parent = variable.getParent()) instanceof PhpUseList && (parentParent = parent.getParent()) instanceof Function && (parentParentParent = parentParent.getParent()) != null) {
            PhpScopeHolder parentOfType = (PhpScopeHolder)PhpPsiUtil.getParentByCondition(parentParentParent, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
            return parentOfType instanceof PhpDocMethod ? null : parentOfType;
        }
        PhpScopeHolder parentOfType = (PhpScopeHolder)PhpPsiUtil.getParentByCondition(variable, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
        return parentOfType instanceof PhpDocMethod ? null : parentOfType;
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<Variable> getUsedVariables(@NotNull Function function) {
        List<Variable> children;
        PhpUseList useList;
        if (function == null) {
            PhpPsiUtil.$$$reportNull$$$0(20);
        }
        if ((useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)) != null && !(children = PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF)).isEmpty()) {
            List<Variable> list = children;
            if (list == null) {
                PhpPsiUtil.$$$reportNull$$$0(21);
            }
            return list;
        }
        Set<Variable> set = Collections.emptySet();
        if (set == null) {
            PhpPsiUtil.$$$reportNull$$$0(22);
        }
        return set;
    }

    @Contract(pure=true)
    @Nullable
    public static Statement getLoopStatement(@NotNull PhpPsiElement element, int argument) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(23);
        }
        if (argument < 1) {
            argument = 1;
        }
        Statement loopStatement = (Statement)PhpPsiUtil.getParentByCondition((PsiElement)element, true, PhpCodeInsightUtil.LOOP_STATEMENTS, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
        while (loopStatement != null && --argument > 0) {
            loopStatement = (Statement)PhpPsiUtil.getParentByCondition((PsiElement)loopStatement, true, PhpCodeInsightUtil.LOOP_STATEMENTS, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
        }
        return loopStatement;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getPrevSiblingIgnoreWhitespace(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(24);
        }
        PsiElement prevSibling = strict ? element.getPrevSibling() : element;
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getNextSiblingIgnoreWhitespace(@NotNull PsiElement element, boolean strict) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(25);
        }
        PsiElement nextSibling = strict ? element.getNextSibling() : element;
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getNextSibling(@NotNull PsiElement element, Condition<PsiElement> ... ignored) {
        PsiElement nextSibling;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(26);
        }
        if (ignored == null) {
            PhpPsiUtil.$$$reportNull$$$0(27);
        }
        for (nextSibling = element.getNextSibling(); nextSibling != null && PhpPsiUtil.appliesAtLeastOne(nextSibling, ignored); nextSibling = nextSibling.getNextSibling()) {
        }
        return nextSibling;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement getPrevSibling(@NotNull PsiElement element, Condition<PsiElement> ... ignored) {
        PsiElement prevSibling;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(28);
        }
        if (ignored == null) {
            PhpPsiUtil.$$$reportNull$$$0(29);
        }
        for (prevSibling = element.getPrevSibling(); prevSibling != null && PhpPsiUtil.appliesAtLeastOne(prevSibling, ignored); prevSibling = prevSibling.getPrevSibling()) {
        }
        return prevSibling;
    }

    @Contract(pure=true)
    public static boolean appliesAtLeastOne(@NotNull PsiElement child, Condition<PsiElement> ... conditions) {
        if (child == null) {
            PhpPsiUtil.$$$reportNull$$$0(30);
        }
        if (conditions == null) {
            PhpPsiUtil.$$$reportNull$$$0(31);
        }
        for (Condition<PsiElement> condition : conditions) {
            if (!condition.value((Object)child)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T getNextSiblingByCondition(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(32);
        }
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(33);
        }
        for (PsiElement nextSibling = element.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!condition.value((Object)nextSibling)) continue;
            return (T)nextSibling;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T getPrevSiblingByCondition(@NotNull PsiElement element, @NotNull Condition<? super PsiElement> condition) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(34);
        }
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(35);
        }
        for (PsiElement prevSibling = element.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (!condition.value((Object)prevSibling)) continue;
            return (T)prevSibling;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement findNextSiblingOfAnyType(@NotNull PsiElement element, IElementType ... types) {
        ASTNode elementNode;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(36);
        }
        if (types == null) {
            PhpPsiUtil.$$$reportNull$$$0(37);
        }
        if ((elementNode = element.getNode()) == null) {
            return null;
        }
        for (ASTNode curNext = elementNode.getTreeNext(); curNext != null; curNext = curNext.getTreeNext()) {
            IElementType curType = curNext.getElementType();
            for (IElementType type : types) {
                if (!curType.equals(type)) continue;
                return curNext.getPsi();
            }
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PsiElement findPrevSiblingOfAnyType(@NotNull PsiElement element, IElementType ... types) {
        ASTNode elementNode;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(38);
        }
        if ((elementNode = element.getNode()) == null) {
            return null;
        }
        for (ASTNode curPrev = elementNode.getTreePrev(); curPrev != null; curPrev = curPrev.getTreePrev()) {
            IElementType curType = curPrev.getElementType();
            for (IElementType type : types) {
                if (!curType.equals(type)) continue;
                return curPrev.getPsi();
            }
        }
        return null;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, IElementType ... aType) {
        IElementType elementType;
        if (aType == null) {
            PhpPsiUtil.$$$reportNull$$$0(39);
        }
        return (elementType = PsiUtilCore.getElementType((PsiElement)element)) != null && ArrayUtil.contains((Object)elementType, (Object[])aType);
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, IElementType ... aType) {
        IElementType elementType;
        if (aType == null) {
            PhpPsiUtil.$$$reportNull$$$0(40);
        }
        return (elementType = PsiUtilCore.getElementType((ASTNode)node)) != null && ArrayUtil.contains((Object)elementType, (Object[])aType);
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            PhpPsiUtil.$$$reportNull$$$0(41);
        }
        return PsiUtilCore.getElementType((PsiElement)element) == type;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, @NotNull IElementType type) {
        if (type == null) {
            PhpPsiUtil.$$$reportNull$$$0(42);
        }
        return PsiUtilCore.getElementType((ASTNode)node) == type;
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable PsiElement element, @NotNull TokenSet types) {
        if (types == null) {
            PhpPsiUtil.$$$reportNull$$$0(43);
        }
        return types.contains(PsiUtilCore.getElementType((PsiElement)element));
    }

    @Contract(value="null, _ -> false", pure=true)
    public static boolean isOfType(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PhpPsiUtil.$$$reportNull$$$0(44);
        }
        return types.contains(PsiUtilCore.getElementType((ASTNode)node));
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends PsiElement> T getOuterParentOfType(@NotNull T element, @NotNull Class<T> parentType) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(45);
        }
        if (parentType == null) {
            PhpPsiUtil.$$$reportNull$$$0(46);
        }
        T t = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> {
            if (parentType == null) {
                PhpPsiUtil.$$$reportNull$$$0(66);
            }
            return !parentType.isInstance(e.getParent());
        }));
        if (t == null) {
            PhpPsiUtil.$$$reportNull$$$0(47);
        }
        return t;
    }

    @Contract(pure=true)
    public static boolean hasReferences(@NotNull Project project, @NotNull PsiElement psiElement) {
        if (project == null) {
            PhpPsiUtil.$$$reportNull$$$0(48);
        }
        if (psiElement == null) {
            PhpPsiUtil.$$$reportNull$$$0(49);
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters(psiElement, (SearchScope)scope, false);
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach((Processor)finder);
        return finder.isFound();
    }

    @Contract(pure=true)
    public static boolean hasReferencesInSearchScope(@NotNull SearchScope scope, @NotNull PsiElement psiElement, @NotNull CommonProcessors.FindProcessor<? super PsiReference> finder) {
        if (scope == null) {
            PhpPsiUtil.$$$reportNull$$$0(50);
        }
        if (psiElement == null) {
            PhpPsiUtil.$$$reportNull$$$0(51);
        }
        if (finder == null) {
            PhpPsiUtil.$$$reportNull$$$0(52);
        }
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters(psiElement, scope, true);
        ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach(finder);
        return finder.isFound();
    }

    @Contract(pure=true)
    @Nullable
    public static <T extends PsiElement> T findElementOfClassAtRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull Class<T> clazz, boolean first, boolean strictEnd) {
        if (file == null) {
            PhpPsiUtil.$$$reportNull$$$0(53);
        }
        if (clazz == null) {
            PhpPsiUtil.$$$reportNull$$$0(54);
        }
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement result = null;
        for (Language lang : viewProvider.getLanguages()) {
            PsiElement run;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            PsiElement prev = run = PsiTreeUtil.getParentOfType((PsiElement)elementAt, clazz, (boolean)false);
            while (run != null && run.getTextRange().getStartOffset() == startOffset && run.getTextRange().getEndOffset() <= endOffset) {
                prev = run;
                if (strictEnd ? run.getTextRange().getEndOffset() == endOffset && first : first) break;
                run = PsiTreeUtil.getParentOfType((PsiElement)run, clazz);
            }
            if (prev == null || strictEnd && prev.getTextRange().getEndOffset() != endOffset) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            if (elementStartOffset != startOffset || elementEndOffset > endOffset || result != null && result.getTextRange().getEndOffset() >= elementEndOffset) continue;
            result = prev;
        }
        return (T)result;
    }

    @Contract(pure=true)
    @Nullable
    public static PhpClass findClass(@NotNull PhpFile file, @NotNull Condition<? super PhpClass> condition) {
        if (file == null) {
            PhpPsiUtil.$$$reportNull$$$0(55);
        }
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(56);
        }
        return (PhpClass)ContainerUtil.getFirstItem(PhpPsiUtil.findClasses(file, condition));
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<PhpClass> findClasses(@NotNull PhpFile file, @NotNull Condition<? super PhpClass> condition) {
        if (file == null) {
            PhpPsiUtil.$$$reportNull$$$0(57);
        }
        if (condition == null) {
            PhpPsiUtil.$$$reportNull$$$0(58);
        }
        HashSet<PhpClass> classes = new HashSet<PhpClass>();
        StubElement fileStub = ((PhpFileImpl)file).getGreenStub();
        if (fileStub != null) {
            for (Object fileChildStub : fileStub.getChildrenStubs()) {
                if (fileChildStub instanceof PhpClassStub) {
                    PhpClass phpClass = (PhpClass)((PhpClassStub)fileChildStub).getPsi();
                    if (!condition.value((Object)phpClass)) continue;
                    classes.add(phpClass);
                    continue;
                }
                if (!(fileChildStub instanceof PhpNamespaceStub)) continue;
                for (StubElement namespaceChildStub : ((PhpNamespaceStub)fileChildStub).getChildrenStubs()) {
                    PhpClass phpClass;
                    if (!(namespaceChildStub instanceof PhpClassStub) || !condition.value((Object)(phpClass = (PhpClass)((PhpClassStub)namespaceChildStub).getPsi()))) continue;
                    classes.add(phpClass);
                }
            }
        } else {
            for (PhpNamedElement element : file.getTopLevelDefs().values()) {
                if (!(element instanceof PhpClass) || !condition.value((Object)((PhpClass)element))) continue;
                classes.add((PhpClass)element);
            }
        }
        Set<Object> set = classes.size() > 0 ? classes : Collections.emptySet();
        if (set == null) {
            PhpPsiUtil.$$$reportNull$$$0(59);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static Collection<PhpClass> findAllClasses(@NotNull PhpFile file) {
        if (file == null) {
            PhpPsiUtil.$$$reportNull$$$0(60);
        }
        Collection<PhpClass> collection = PhpPsiUtil.findClasses(file, (Condition<? super PhpClass>)Conditions.alwaysTrue());
        if (collection == null) {
            PhpPsiUtil.$$$reportNull$$$0(61);
        }
        return collection;
    }

    @Contract(value="null -> null", pure=true)
    @Nullable
    public static PhpReference getClassReferenceAt(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PhpReference classReference = (PhpReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
        if (classReference != null && PsiTreeUtil.findChildOfType((PsiElement)classReference, PhpNamespaceReference.class, (boolean)true) != null) {
            return classReference;
        }
        return null;
    }

    @Contract(pure=true)
    @Nullable
    public static PhpDocComment getDocCommentFor(@NotNull PhpPsiElement element) {
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(62);
        }
        return PhpPsiUtil.getDocCommentFor(element, (NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement>)((NullableFunction)e -> e));
    }

    @Contract(pure=true)
    @Nullable
    public static PhpDocComment getDocCommentFor(@NotNull PhpPsiElement element, @NotNull NullableFunction<? super PhpPsiElement, ? extends PhpPsiElement> docHolderExtractor) {
        StubElement parent;
        StubElement elementStub;
        if (element == null) {
            PhpPsiUtil.$$$reportNull$$$0(63);
        }
        if (docHolderExtractor == null) {
            PhpPsiUtil.$$$reportNull$$$0(64);
        }
        if (element instanceof StubBasedPsiElementBase && (elementStub = ((StubBasedPsiElementBase)element).getGreenStub()) != null && (parent = elementStub.getParentStub()) != null) {
            List children = parent.getChildrenStubs();
            int i = children.indexOf(elementStub);
            return i > 0 ? (PhpDocComment)ObjectUtils.tryCast((Object)((StubElement)children.get(i - 1)).getPsi(), PhpDocComment.class) : null;
        }
        PhpPsiElement docHolder = (PhpPsiElement)docHolderExtractor.fun((Object)element);
        if (docHolder != null) {
            PhpPsiElement prevPsiSibling = PhpPsiUtil.getPrevPsiSiblingSkippingCommentsWithOnlyNoInspectionTag(docHolder);
            return prevPsiSibling instanceof PhpDocComment ? (PhpDocComment)prevPsiSibling : null;
        }
        return null;
    }

    @Nullable
    private static PhpPsiElement getPrevPsiSiblingSkippingCommentsWithOnlyNoInspectionTag(@NotNull PhpPsiElement docHolder) {
        if (docHolder == null) {
            PhpPsiUtil.$$$reportNull$$$0(65);
        }
        PhpPsiElement prevPsiSibling = docHolder.getPrevPsiSibling();
        while (prevPsiSibling instanceof PhpDocComment && PhpDocUtil.hasOnlyNoInspectionTag((PhpDocComment)prevPsiSibling)) {
            prevPsiSibling = prevPsiSibling.getPrevPsiSibling();
        }
        return prevPsiSibling;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 47: 
            case 59: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 47: 
            case 59: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 47: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/PhpPsiUtil";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 45: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 12: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beginRange";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endRange";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 37: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aType";
                break;
            }
            case 46: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 53: 
            case 55: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docHolderExtractor";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/PhpPsiUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpPsiElementsInRange";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedVariables";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterParentOfType";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getParentByCondition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 47: 
            case 59: 
            case 61: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildByCondition";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getChildOfType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPhpPsiElementsInRange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getScopeHolder";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVariables";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getLoopStatement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingIgnoreWhitespace";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingIgnoreWhitespace";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appliesAtLeastOne";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getNextSiblingByCondition";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSiblingByCondition";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findNextSiblingOfAnyType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findPrevSiblingOfAnyType";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getOuterParentOfType";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasReferences";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "hasReferencesInSearchScope";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findElementOfClassAtRange";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findAllClasses";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentFor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getPrevPsiSiblingSkippingCommentsWithOnlyNoInspectionTag";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getOuterParentOfType$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 47: 
            case 59: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

