/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OracleConsoleUtils {
    OracleConsoleUtils() {
    }

    @Nullable
    static JdbcConsole getOracleConsole(AnActionEvent e) {
        JdbcConsole console = JdbcConsole.findConsole(e);
        if (console == null) {
            return null;
        }
        Dbms dbms = ((LocalDataSource)console.getTarget()).getDbms();
        return dbms.isOracle() ? console : null;
    }

    @Nullable
    static DatabaseConnection getConnection(DataRequest.Context context) {
        if (context.producer instanceof JdbcEngine) {
            return ((JdbcEngine)context.producer).getCurrentConnection();
        }
        return null;
    }

    @NotNull
    static List<String> queryForStrings(@NotNull DatabaseConnection connection2, @NotNull String query, @NotNull int[] placeholders, String ... params) throws SQLException {
        if (connection2 == null) {
            OracleConsoleUtils.$$$reportNull$$$0(0);
        }
        if (query == null) {
            OracleConsoleUtils.$$$reportNull$$$0(1);
        }
        if (placeholders == null) {
            OracleConsoleUtils.$$$reportNull$$$0(2);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        StatementParameters parameters = new StatementParameters().placeholdersOffsets(placeholders);
        for (String param : params) {
            parameters = parameters.text(param);
        }
        SmartStatements.poweredBy(connection2).parameterized(Configuration.sourced(SmartStatements.Source.SYSTEM)).noisy().execute(parameters.asData(query), (ExecutionMode)StandardExecutionMode.QUERY, StandardResultsProcessors.results((ThrowableConsumer<ResultSet, Exception>)((ThrowableConsumer)rset -> {
            while (rset.next()) {
                result2.add(rset.getString(1));
            }
        })));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            OracleConsoleUtils.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OracleConsoleUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OracleConsoleUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "queryForStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "queryForStrings";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

