/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlParenthesizedParametersBlock;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.model.SqlPrefixClauseBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlReturnBlock;
import com.intellij.sql.formatter.model.SqlRoutineBlock;
import com.intellij.sql.formatter.model.SqlRoutineDeclarationsSectionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0014J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\nJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0010\u00a2\u0006\u0002\b\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/formatter/model/SqlRoutineBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "()V", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "decideSpacing$intellij_database_sql_impl", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "determineRole$intellij_database_sql_impl", "makeBlock", "produceNestedBlocks", "nodes", "", "userRequiresExpand", "", "whetherToFlatten", "intellij.database.sql.impl"})
public final class SqlRoutineBlock
extends SqlNodeBlock {
    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        String string = node.getElementType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.elementType.toString()");
        String elementTypeStr = string;
        return Intrinsics.areEqual((Object)elementTypeStr, (Object)"PG_LAZY_CODE_BLOCK_PARENT") || Intrinsics.areEqual((Object)elementTypeStr, (Object)"PG_LAZY_CODE_BLOCK");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void produceNestedBlocks(@NotNull List<? extends ASTNode> nodes2) {
        Intrinsics.checkParameterIsNotNull(nodes2, (String)"nodes");
        int d2 = SqlUtilFun.indexOf$default(nodes2, 0, 0, 0, produceNestedBlocks.d.1.INSTANCE, 7, null);
        if (d2 > 0) {
            int n = nodes2.size();
            int b2 = SqlUtilFun.indexOf$default(nodes2, d2, 0, n, produceNestedBlocks.b.1.INSTANCE, 2, null);
            super.produceNestedBlocks(nodes2.subList(0, d2));
            if (d2 < b2) {
                void parent$iv;
                void $receiver$iv;
                Collection collection = this.getNestedBlocks();
                SqlRangeBlock sqlRangeBlock = new SqlRoutineDeclarationsSectionBlock();
                SqlBlock sqlBlock = this;
                List<? extends ASTNode> nodes$iv = nodes2.subList(d2, b2);
                $receiver$iv.setup$intellij_database_sql_impl((SqlBlock)parent$iv, nodes$iv);
                sqlRangeBlock = $receiver$iv;
                collection.add(sqlRangeBlock);
            }
            if (b2 < n) {
                super.produceNestedBlocks(nodes2.subList(b2, n));
            }
        } else {
            super.produceNestedBlocks(nodes2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_PARAMETER_LIST)) {
            void $receiver$iv;
            SqlRangeBlock sqlRangeBlock = new SqlParenthesizedParametersBlock();
            SqlBlock parent$iv = this;
            TextRange textRange = node.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"outerNode.textRange");
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$receiver$iv, BlockRole.AMENDMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_RETURNS_CLAUSE))) {
            SqlNodeBlock $receiver$iv = new SqlReturnBlock();
            SqlBlock parent$iv = this;
            $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
            sqlBlock = $receiver$iv;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_GENERIC_SETTINGS_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_CLAUSE)) {
            SqlFlowBlock sqlFlowBlock;
            if (SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ESSENCE) != null) {
                SqlRangeBlock $receiver$iv = new SqlPostfixClauseBlock();
                SqlBlock parent$iv = this;
                TextRange textRange = node.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"outerNode.textRange");
                $receiver$iv.setup$intellij_database_sql_impl(parent$iv, textRange, SqlFormattingModelFunKt.listChildren(node));
                sqlFlowBlock = $receiver$iv;
            } else {
                void var3_6;
                SqlNodeBlock $receiver$iv = new SqlPrefixClauseBlock();
                SqlBlock parent$iv = this;
                $receiver$iv.setup$intellij_database_sql_impl(parent$iv, node);
                sqlFlowBlock = (SqlFlowBlock)var3_6;
            }
            sqlBlock = sqlFlowBlock;
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    @NotNull
    public BlockRole determineRole$intellij_database_sql_impl(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"node.elementType");
        IElementType type = iElementType;
        return Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE) ? BlockRole.ALIAS1 : (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_BLOCK_STATEMENT) ? BlockRole.ESSENCE : (Intrinsics.areEqual((Object)type, (Object)SqlCompositeElementTypes.SQL_STRING_LITERAL) ? BlockRole.ESSENCE : (node instanceof SqlStatement ? BlockRole.ESSENCE : super.determineRole$intellij_database_sql_impl(node))));
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s = this.getContext().getSql();
        Wrap mainWrap = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, WrapType.ALWAYS, false, 2, null);
        Wrap prefixOptionsWrap = null;
        Wrap postfixOptionsWrap = null;
        boolean wasLQuote = false;
        for (SqlBlock b2 : this.getNestedBlocks()) {
            IElementType t = SqlFormattingModelFunKt.primaryElementType(b2);
            if (b2.getRole() == BlockRole.ESSENCE) {
                boolean toWrapEssence = wasLQuote ? s.ROUTINE_PG_L_QUOTE_WRAP_AFTER : true;
                b2.setMyWrap((Wrap)(toWrapEssence ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (b2 instanceof SqlRoutineDeclarationsSectionBlock) {
                b2.setMyWrap(mainWrap);
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b2 instanceof SqlPrefixClauseBlock) {
                if (prefixOptionsWrap == null) {
                    b2.setMyWrap(mainWrap);
                    prefixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                } else {
                    b2.setMyWrap(postfixOptionsWrap);
                }
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (b2 instanceof SqlPostfixClauseBlock) {
                if (postfixOptionsWrap == null) {
                    b2.setMyWrap(mainWrap);
                    postfixOptionsWrap = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(this, mainWrap, WrapType.CHOP_DOWN_IF_LONG, false, 4, null);
                } else {
                    b2.setMyWrap(postfixOptionsWrap);
                }
                b2.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_CREATE) {
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_AS || t == SqlTokens.SQL_IS) {
                b2.setMyWrap((Wrap)(s.ROUTINE_AS_WRAP ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t == SqlTokens.SQL_CUSTOM_LQUOTE) {
                b2.setMyWrap((Wrap)(s.ROUTINE_PG_L_QUOTE_WRAP_BEFORE ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                wasLQuote = true;
                continue;
            }
            if (t == SqlTokens.SQL_CUSTOM_RQUOTE) {
                b2.setMyWrap((Wrap)(s.ROUTINE_PG_R_QUOTE_WRAP_BEFORE ? mainWrap : null));
                b2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
                continue;
            }
            if (t != SqlTokens.SQL_LANGUAGE) continue;
            b2.setMyWrap(postfixOptionsWrap);
        }
        SqlCommonHandlersKt.configureAttributesForPostfixOptions(this, this.getNestedBlocks());
    }

    @Override
    public boolean userRequiresExpand() {
        return true;
    }

    @Override
    @Nullable
    public Spacing decideSpacing$intellij_database_sql_impl(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        IElementType t1 = SqlFormattingModelFunKt.primaryElementType(block1);
        IElementType t2 = SqlFormattingModelFunKt.primaryElementType(block2);
        if (block2 instanceof SqlParenthesizedParametersBlock) {
            switch (this.getContext().getSql().ROUTINE_ARG_OPENING) {
                case 1: {
                    spacing = this.getContext().makeSpace(this.getContext().getCom().SPACE_BEFORE_METHOD_PARENTHESES || ((SqlParenthesizedParametersBlock)block2).getOpeningBlock() == null, false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    spacing = SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null);
                    break;
                }
                default: {
                    spacing = SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null);
                    break;
                }
            }
        } else {
            IElementType iElementType;
            spacing = t2 == SqlCompositeElementTypes.SQL_CLAUSE || t2 == SqlTokens.SQL_LANGUAGE ? this.getContext().makeAutoSpacing(true) : (t1 == SqlTokens.SQL_CUSTOM_RQUOTE ? (Intrinsics.areEqual((Object)(iElementType = t2), (Object)SqlCommonTokens.SQL_SEMICOLON) ? SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null) : (this.getContext().getSql().ROUTINE_PG_R_QUOTE_WRAP_AFTER ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null))) : super.decideSpacing$intellij_database_sql_impl(block1, block2));
        }
        return spacing;
    }
}

