/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.AbstractVfsContainer;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.FileSystemKey;
import org.apache.commons.vfs2.provider.local.GenericFileNameParser;

public abstract class AbstractFileProvider
extends AbstractVfsContainer
implements FileProvider {
    private final Object myFileSystemsLock = new Object();
    private final Map<FileSystemKey, FileSystem> fileSystems = new TreeMap<FileSystemKey, FileSystem>();
    private FileNameParser parser = GenericFileNameParser.getInstance();

    protected FileNameParser getFileNameParser() {
        return this.parser;
    }

    protected void setFileNameParser(FileNameParser parser) {
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.myFileSystemsLock;
        synchronized (object) {
            this.fileSystems.clear();
        }
        super.close();
    }

    @Override
    public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions properties) throws FileSystemException {
        throw new FileSystemException("vfs.provider/not-layered-fs.error", (Object)scheme);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem addFileSystem(Comparable<?> key, FileSystem fs) throws FileSystemException {
        FileSystem existingFileSystem;
        FileSystemKey treeKey = new FileSystemKey(key, fs.getFileSystemOptions());
        ((AbstractFileSystem)fs).setCacheKey(treeKey);
        Object object = this.myFileSystemsLock;
        synchronized (object) {
            existingFileSystem = this.fileSystems.get(treeKey);
            if (existingFileSystem == null) {
                this.addComponent(fs);
                this.fileSystems.put(treeKey, fs);
                return fs;
            }
        }
        ((AbstractFileSystem)fs).close();
        return existingFileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileSystem findFileSystem(Comparable<?> key, FileSystemOptions fileSystemProps) {
        FileSystemKey treeKey = new FileSystemKey(key, fileSystemProps);
        Object object = this.myFileSystemsLock;
        synchronized (object) {
            return this.fileSystems.get(treeKey);
        }
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUnusedResources() {
        Object[] objectArray = this.myFileSystemsLock;
        synchronized (this.myFileSystemsLock) {
            Object[] item = this.fileSystems.values().toArray();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Object element : item) {
                AbstractFileSystem fs = (AbstractFileSystem)element;
                if (!fs.isReleaseable()) continue;
                fs.closeCommunicationLink();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFileSystem(FileSystem filesystem) {
        AbstractFileSystem fs = (AbstractFileSystem)filesystem;
        Object object = this.myFileSystemsLock;
        synchronized (object) {
            if (fs.getCacheKey() != null) {
                this.fileSystems.remove(fs.getCacheKey());
            }
        }
        this.removeComponent(fs);
        fs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryCloseFileSystem(FileSystem filesystem) {
        AbstractFileSystem fs = (AbstractFileSystem)filesystem;
        if (fs.tryClose()) {
            Object object = this.myFileSystemsLock;
            synchronized (object) {
                if (fs.getCacheKey() != null) {
                    this.fileSystems.remove(fs.getCacheKey());
                }
            }
            this.removeComponent(fs);
            return true;
        }
        return false;
    }

    @Override
    public FileName parseUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }

    @Override
    public FileName parseChildUri(FileName base, String uri) throws FileSystemException {
        if (this.getFileNameParser() != null) {
            return this.getFileNameParser().parseChildUri(this.getContext(), base, uri);
        }
        throw new FileSystemException("vfs.provider/filename-parser-missing.error");
    }
}

