/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmTaskTreeView;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmScriptsService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(PackageJsonFileManager.class);
    private static final NotNullLazyValue<NpmScriptsService> LAZY_INSTANCE = JsbtService.newLazyInstance(NpmScriptsService.class);
    private static final Key<CachedValue<NpmScriptsStructure>> STRUCTURE_KEY = Key.create((String)NpmScriptsService.class.getName());

    @NotNull
    public static NpmScriptsService getInstance() {
        NpmScriptsService npmScriptsService = (NpmScriptsService)LAZY_INSTANCE.getValue();
        if (npmScriptsService == null) {
            NpmScriptsService.$$$reportNull$$$0(0);
        }
        return npmScriptsService;
    }

    @Override
    @NotNull
    public String getName() {
        if ("npm" == null) {
            NpmScriptsService.$$$reportNull$$$0(1);
        }
        return "npm";
    }

    @Override
    @NotNull
    public String getMenuItemDisplayName() {
        if ("npm Scripts" == null) {
            NpmScriptsService.$$$reportNull$$$0(2);
        }
        return "npm Scripts";
    }

    @Override
    @NotNull
    public String getSearchEverywhereDescription() {
        if ("npm script" == null) {
            NpmScriptsService.$$$reportNull$$$0(3);
        }
        return "npm script";
    }

    @Override
    @NotNull
    public String getReloadTasksActionName() {
        if ("Reload scripts" == null) {
            NpmScriptsService.$$$reportNull$$$0(4);
        }
        return "Reload scripts";
    }

    @Override
    @NotNull
    public String getToolWindowSettingsActionName() {
        if ("&Edit npm Configurations..." == null) {
            NpmScriptsService.$$$reportNull$$$0(5);
        }
        return "&Edit npm Configurations...";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(6);
        }
        PackageJsonFileManager packageJsonFileManager = PackageJsonFileManager.getInstance(project);
        if (packageJsonFileManager == null) {
            NpmScriptsService.$$$reportNull$$$0(7);
        }
        return packageJsonFileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(8);
        }
        JsbtToolWindowManager jsbtToolWindowManager = new JsbtToolWindowManager(project, "npm", JavaScriptLanguageIcons.BuildTools.Npm.Npm_13, "reference.tool.window.npm", this);
        if (jsbtToolWindowManager == null) {
            NpmScriptsService.$$$reportNull$$$0(9);
        }
        return jsbtToolWindowManager;
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(10);
        }
        NpmTaskTreeView npmTaskTreeView = new NpmTaskTreeView(this, project, layoutPlace);
        if (npmTaskTreeView == null) {
            NpmScriptsService.$$$reportNull$$$0(11);
        }
        return npmTaskTreeView;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(12);
        }
        if (DumbService.isDumb((Project)project)) {
            List<VirtualFile> list = this.detectAllBuildfilesInContentRoots(project, false, false);
            if (list == null) {
                NpmScriptsService.$$$reportNull$$$0(13);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> {
            if (project == null) {
                NpmScriptsService.$$$reportNull$$$0(36);
            }
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            GlobalSearchScope scope = JSLibraryUtil.getContentScopeWithoutLibraries(project);
            Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)scope);
            return ContainerUtil.newArrayList((Iterable)files);
        });
        if (list == null) {
            NpmScriptsService.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(15);
        }
        List buildfiles = ContainerUtil.newSmartList();
        JsbtUtil.iterateOverContentRoots(project, webModulesOnly, (Consumer<? super VirtualFile>)((Consumer)contentRoot -> {
            if (project == null) {
                NpmScriptsService.$$$reportNull$$$0(35);
            }
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(contentRoot);
            LOG.info("Found package.json in " + contentRoot.getPath() + ": " + packageJson);
            if (packageJson != null && (!filterOutEmptyBuildfiles || NpmScriptsService.hasScripts(project, packageJson))) {
                buildfiles.add(packageJson);
            }
        }));
        List list = buildfiles;
        if (list == null) {
            NpmScriptsService.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static boolean hasScripts(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(17);
        }
        if (packageJson == null) {
            NpmScriptsService.$$$reportNull$$$0(18);
        }
        try {
            NpmScriptsStructure structure = NpmScriptsUtil.listTasks(project, packageJson);
            return !structure.getTaskNames().isEmpty();
        }
        catch (JsbtTaskFetchException jsbtTaskFetchException) {
            return false;
        }
    }

    @Override
    public String getBuildfileCommonName() {
        return "package.json";
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NpmScriptsService.$$$reportNull$$$0(19);
        }
        return PackageJsonUtil.isPackageJsonFile(file2);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            NpmScriptsService.$$$reportNull$$$0(20);
        }
        NpmScriptsStructure npmScriptsStructure = new NpmScriptsStructure(buildfile);
        if (npmScriptsStructure == null) {
            NpmScriptsService.$$$reportNull$$$0(21);
        }
        return npmScriptsStructure;
    }

    @Override
    @NotNull
    public NpmScriptsStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(22);
        }
        if (packageJson == null) {
            NpmScriptsService.$$$reportNull$$$0(23);
        }
        NpmScriptsStructure npmScriptsStructure = (NpmScriptsStructure)ReadAction.compute(() -> {
            if (project == null) {
                NpmScriptsService.$$$reportNull$$$0(31);
            }
            if (packageJson == null) {
                NpmScriptsService.$$$reportNull$$$0(32);
            }
            if (project.isDisposed()) {
                throw JsbtTaskFetchException.newGenericException(packageJson, project + " is disposed already");
            }
            if (!packageJson.isValid()) {
                throw JsbtTaskFetchException.newBuildfileSyntaxError(packageJson);
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(packageJson);
            if (psiFile == null) {
                throw JsbtTaskFetchException.newGenericException(packageJson, "Cannot find PSI file");
            }
            return (NpmScriptsStructure)CachedValuesManager.getCachedValue((PsiElement)psiFile, STRUCTURE_KEY, () -> {
                NpmScriptsStructure value;
                if (project == null) {
                    NpmScriptsService.$$$reportNull$$$0(33);
                }
                if (packageJson == null) {
                    NpmScriptsService.$$$reportNull$$$0(34);
                }
                try {
                    value = NpmScriptsUtil.listTasks(project, packageJson);
                }
                catch (JsbtTaskFetchException ignored) {
                    value = new NpmScriptsStructure(packageJson);
                }
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{psiFile});
            });
        });
        if (npmScriptsStructure == null) {
            NpmScriptsService.$$$reportNull$$$0(24);
        }
        return npmScriptsStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        NpmConfigurationType npmConfigurationType = NpmConfigurationType.getInstance();
        if (npmConfigurationType == null) {
            NpmScriptsService.$$$reportNull$$$0(25);
        }
        return npmConfigurationType;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            NpmScriptsService.$$$reportNull$$$0(26);
        }
        if (patternObject == null) {
            NpmScriptsService.$$$reportNull$$$0(27);
        }
        if (runConfiguration instanceof NpmRunConfiguration) {
            NpmRunSettings runSettings = ((NpmRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof NpmRunSettings) {
                NpmRunSettings patternRunSettings = (NpmRunSettings)patternObject;
                return patternRunSettings.getCommand() == runSettings.getCommand() && JsbtUtil.equalsOrderless(patternRunSettings.getScriptNames(), runSettings.getScriptNames()) && patternRunSettings.getPackageJsonSystemIndependentPath().equals(runSettings.getPackageJsonSystemIndependentPath());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return runSettings.getCommand() == NpmCommand.RUN_SCRIPT && JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getScriptNames()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getPackageJsonSystemIndependentPath());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            NpmScriptsService.$$$reportNull$$$0(28);
        }
        if (taskSet == null) {
            NpmScriptsService.$$$reportNull$$$0(29);
        }
        NpmScriptsStructure structure = (NpmScriptsStructure)taskSet.getStructure();
        NpmRunConfiguration npmRunConfiguration = (NpmRunConfiguration)runConfiguration;
        NpmRunSettings merged = npmRunConfiguration.getRunSettings().toBuilder().setPackageJsonPath(structure.getBuildfile().getPath()).setCommand(NpmCommand.RUN_SCRIPT).setScriptNames(taskSet.getTaskNames()).build();
        NpmRunConfigurationProducer.setupConfigurationFromSettings(npmRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextBuildfile) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(30);
        }
        this.editConfigurations(project);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 23: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMenuItemDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchEverywhereDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReloadTasksActionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowSettingsActionName";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolWindowManager";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTaskTreeView";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyFileStructure";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFileManager";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowManager";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTaskTreeView";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasScripts";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showTaskListingSettingsDialog";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fetchBuildfileStructure$3";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detectAllBuildfilesInContentRoots$1";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$detectAllBuildfiles$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

