/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeFromResolveResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyStaticContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSUnwrapPromiseTypeElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSThisType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    protected static final PsiElement EXPLICIT_TYPE_MARKER_ELEMENT = PsiUtilCore.NULL_PSI_ELEMENT;
    private static final ThreadLocal<JSRecursionGuard> recursionGuardHolder = new ThreadLocal();
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    private static final int MAX_MODULES_TO_EVALUATE = JSUtils.getSystemPropertySafely("idea.javascript.max.modules.to.process", 10);
    private static final Key<ParameterizedCachedValue<JSTypeEvaluationResult, PsiElement>> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final ParameterizedCachedValueProvider<JSTypeEvaluationResult, PsiElement> CACHE_PROVIDER_EXPRESSION_TYPE = param -> {
        JSTypeFromResolveResultProcessor typeProcessor = new JSTypeFromResolveResultProcessor(new JSSimpleTypeProcessor());
        PsiFile targetFile = param.getContainingFile();
        JSTypeEvaluator.doEvaluateExpressionOrElementTypes(targetFile, typeProcessor, param, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        JSTypeEvaluationResult type = typeProcessor.getResult();
        return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    };
    private static final String JQUERY_NS = "jQuery";
    protected final JSEvaluateContext myContext;
    protected final JSTypeProcessor myTypeProcessor;

    protected JSTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        this.myContext = context;
        this.myTypeProcessor = processor;
    }

    @Nullable
    public static JSType forceEvaluateType(@NotNull PsiElement target, @NotNull JSExpression expr, @NotNull PsiFile targetFile) {
        if (target == null) {
            JSTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(2);
        }
        JSTypeFromResolveResultProcessor typeProcessor = new JSTypeFromResolveResultProcessor(new JSSimpleTypeProcessor(target));
        JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor, JSEvaluateContext.JSEvaluationPlace.FORCE_EVALUATE_TYPE);
        JSTypeEvaluationResult result2 = typeProcessor.getResult();
        return result2 != null ? result2.getType() : null;
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(4);
        }
        JSTypeEvaluator.evaluateTypes(expr, expr.getContainingFile(), typeProcessor, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(7);
        }
        JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(11);
        }
        JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, typeProcessor, (PsiElement)expr, place);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(13);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (typeProcessor instanceof ResolveProcessor) {
            JSTypeEvaluator.processWithEvaluationGuard(element, place, el -> {
                if (targetFile == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(157);
                }
                if (typeProcessor == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(158);
                }
                if (place == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(159);
                }
                JSTypeEvaluator.doEvaluateExpressionOrElementTypes(targetFile, typeProcessor, el, place);
            });
        } else {
            JSTypeEvaluator.doEvaluateExpressionOrElementTypes(targetFile, typeProcessor, element, place);
        }
    }

    private static void doEvaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(19);
        }
        JSTypeEvaluator typeEvaluator = JSDialectSpecificHandlersFactory.forElement((PsiElement)targetFile).newTypeEvaluator(new JSEvaluateContext(targetFile), typeProcessor);
        if (element instanceof JSExpression) {
            if (typeEvaluator.myTypeProcessor instanceof ResolveProcessor) {
                typeEvaluator.doEvaluateTypes((JSExpression)element, place);
            } else {
                typeEvaluator.evaluateCachedTypes((JSExpression)element);
            }
        } else if (element instanceof JSDestructuringContainer) {
            typeEvaluator.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            typeEvaluator.addTypeFromResolveResult(element);
        }
    }

    @Nullable
    public static JSTypeEvaluationResult getExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(20);
        }
        return JSTypeEvaluator.getElementType((PsiElement)expression);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(21);
        }
        return JSTypeEvaluator.getElementType(element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(22);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(23);
        }
        if (!JSTypeEvaluator.canProcessWithEvaluationGuard(element, place)) {
            return null;
        }
        Ref result2 = Ref.create();
        JSTypeEvaluator.processWithEvaluationGuard(element, place, el -> {
            if (element == null) {
                JSTypeEvaluator.$$$reportNull$$$0(156);
            }
            result2.set(CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)element, CACHE_KEY_EXPRESSION_TYPE, CACHE_PROVIDER_EXPRESSION_TYPE, false, (Object)element));
        });
        return (JSTypeEvaluationResult)result2.get();
    }

    private void addTypeEvaluationResultElement(@NotNull JSTypeEvaluationResult.JSTypeEvaluationResultElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(24);
        }
        JSType originalType = element.getType();
        JSNamespace namespace = element.getNamespace();
        PsiElement source = element.getSource();
        this.myContext.withCombinedContext(element.getEvaluationContext(), () -> {
            JSType type = JSTypeEvaluator.getGuardedTypeByEvaluateContext(originalType, this.myContext, source);
            if (type != null) {
                JSTypeEvaluator.applyContextAndProcess(type, this.myContext, source, this.myTypeProcessor);
            } else if (namespace != null) {
                JSTypeEvaluator.applyContextAndProcessNamespace(namespace, this.myContext, source, this.myTypeProcessor);
            } else {
                assert (source != null);
                this.applyContextAndProcessResolvedElement(source);
            }
        });
    }

    public void addType(@Nullable JSType type, @Nullable PsiElement source) {
        if ((type = JSTypeEvaluator.getGuardedTypeByEvaluateContext(type, this.myContext, source)) == null) {
            return;
        }
        boolean wasGuessed = this.myContext.isTypeGuessed();
        if (!type.isSourceStrict()) {
            this.myContext.setTypeIsGuessed(true);
        }
        this.doAddType(type, source);
        this.myContext.setTypeIsGuessed(wasGuessed);
    }

    @Nullable
    public static JSType getGuardedTypeByEvaluateContext(@Nullable JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source) {
        JSReferenceExpression expression;
        PsiElement resolvedElement;
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(25);
        }
        if ((resolvedElement = context.getSource()) == null && source != null && source != EXPLICIT_TYPE_MARKER_ELEMENT && source.isValid()) {
            resolvedElement = source;
        }
        if (resolvedElement != null && (expression = context.getProcessedExpression()) != null && (DialectDetector.isTypeScript((PsiElement)expression) || context.isAstAccessAllowed()) && context.isJSElementsToApplyEmpty()) {
            JSType guardType;
            PsiElement namedCandidate = resolvedElement;
            if (resolvedElement instanceof TypeScriptMergedTypeImplicitElement) {
                namedCandidate = (PsiElement)ObjectUtils.coalesce((Object)((TypeScriptMergedTypeImplicitElement)resolvedElement).getExplicitElement(), (Object)resolvedElement);
            }
            return (guardType = JSTypeEvaluator.getTypeFromTypeGuard(namedCandidate, expression, type, resolvedElement)) == null ? type : guardType;
        }
        return type;
    }

    private void doAddType(@NotNull JSType type, @Nullable PsiElement source) {
        JSType unwrappedType;
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(26);
        }
        if ((unwrappedType = JSTypeUtils.unwrapDecorations(type)) instanceof JSRequireCallExpressionType) {
            Collection<PsiElement> elements;
            String referencedModule = ((JSRequireCallExpressionType)unwrappedType).getReferencedModule();
            PsiFile scope = ((JSRequireCallExpressionType)unwrappedType).getScope();
            if (scope != null && !(elements = JSFileReferencesUtil.resolveModuleReference(scope, referencedModule)).isEmpty()) {
                for (PsiElement element : elements) {
                    JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE_FROM_TYPE, module -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)module));
                }
                return;
            }
        } else {
            JSReferenceExpression processedExpression;
            if (unwrappedType instanceof JSApplyCallType) {
                JSType baseType = ((JSApplyCallType)unwrappedType).getBaseType();
                this.myContext.processWithJSElementToApply(JSApplyCallElement.EMPTY, () -> this.addType(baseType, source));
                return;
            }
            if (unwrappedType instanceof JSApplyNewType) {
                JSType baseType = ((JSApplyNewType)unwrappedType).getBaseType();
                this.myContext.processWithJSElementToApply(JSApplyInstanceContextElement.INSTANCE, () -> this.addType(baseType, source));
                return;
            }
            if (unwrappedType instanceof JSReferenceType) {
                PsiElement sourceElement = unwrappedType.getSource().getSourceElement();
                if (sourceElement != null) {
                    String referencedName = ((JSReferenceType)unwrappedType).getReferencedName();
                    PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(referencedName, sourceElement);
                    boolean addedFromResolveResult = false;
                    if (localResolve instanceof JSNamedElement) {
                        boolean bl = addedFromResolveResult = !this.processItem(sourceElement, JSEvaluateContext.JSEvaluationPlace.TYPEOF_TYPE, it -> this.addTypeFromResolveResult(localResolve));
                    }
                    if (!addedFromResolveResult) {
                        JSNamespace namespace = null;
                        if (localResolve instanceof JSElementBase) {
                            namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)localResolve, false);
                        }
                        if (namespace == null) {
                            namespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(referencedName, null), JSContext.STATIC, sourceElement, false, true, false);
                        }
                        this.addNamespace(namespace, sourceElement);
                    }
                    return;
                }
            } else if (unwrappedType instanceof JSThisType && (processedExpression = this.myContext.getProcessedExpression()) != null) {
                JSExpression qualifier = processedExpression.getQualifier();
                if (qualifier == null) {
                    this.addType((JSType)JSNamedTypeFactory.createNamespace(null, unwrappedType.getSource(), JSTypeContext.STATIC, false, false), source);
                } else {
                    this.evaluateCachedTypes(qualifier);
                }
                return;
            }
        }
        Collection<PsiElement> referencedJSDocModules = CommonJSUtil.resolveJSDocCommentModules(unwrappedType, null);
        for (PsiElement module2 : referencedJSDocModules) {
            if (!(module2 instanceof JSFile)) continue;
            JSTypeEvaluator.processWithEvaluationGuard(module2, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE_FROM_TYPE, m -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)m));
        }
        JSTypeEvaluator.applyContextAndProcess(type, this.myContext, source, this.myTypeProcessor);
    }

    public static void applyContextAndProcess(@NotNull JSType _type, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        if (_type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(29);
        }
        if (_type instanceof JSEvaluableType) {
            _type = _type.substitute();
        }
        _type = JSDialectSpecificHandlersFactory.forElement((PsiElement)context.getProcessedExpression()).getGenericTypeEvaluator().evaluateGenerics(_type, (JSExpression)context.getProcessedExpression(), null);
        if (!context.isJSElementsToApplyEmpty()) {
            JSType unwrapped;
            JSApplyContextElement pop = context.popJSElementToApply();
            if (pop instanceof JSApplyCallElement) {
                JSType returnType = JSTypeUtils.tryGetReturnType(_type, (JSApplyCallElement)pop);
                if (returnType == null) {
                    JSExpression expression = ((JSApplyCallElement)pop).getMethodExpression();
                    returnType = !(_type instanceof JSAnyType) && _type.isSourceStrict() && _type.isTypeScript() && expression != null ? new TypeScriptNeverJSTypeImpl((PsiElement)expression) : JSAnyType.get((PsiElement)expression, false);
                }
                JSTypeEvaluator.applyContextAndProcess(returnType, context, null, processor);
            } else if (pop instanceof JSApplyPropertyElement) {
                JSApplyContextUtil.processDestructuringProperty((JSApplyPropertyElement)pop, _type, (newType, element) -> {
                    if (context == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(154);
                    }
                    if (processor == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(155);
                    }
                    JSTypeEvaluator.applyContextAndProcess(JSTypeEvaluator.getGuardedTypeByEvaluateContext(newType, context, source), context, element, processor);
                });
            } else if (pop instanceof JSApplyIndexedAccessElement) {
                JSApplyContextUtil.processDestructuringArray((JSApplyIndexedAccessElement)pop, _type, type -> {
                    if (context == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(152);
                    }
                    if (processor == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(153);
                    }
                    JSTypeEvaluator.applyContextAndProcess(type, context, null, processor);
                });
            } else if (pop instanceof JSApplyInstanceContextElement) {
                JSType returnType;
                JSNewExpression newExpression = ((JSApplyInstanceContextElement)pop).getNewExpression();
                boolean processed = false;
                if (newExpression != null && (returnType = JSTypeUtils.tryGetReturnType(_type, (JSApplyInstanceContextElement)pop)) != null) {
                    processed = true;
                    if (!(returnType instanceof JSVoidType)) {
                        JSTypeEvaluator.applyContextAndProcess(returnType, context, source, processor);
                    }
                }
                if (!processed && _type instanceof JSNamedType && ((JSNamedType)_type).isStaticOrInstance() != JSContext.INSTANCE) {
                    _type = ((JSNamedType)_type).copyWithJSContext(JSContext.INSTANCE);
                    JSTypeEvaluator.applyContextAndProcess(_type, context, source, processor);
                }
            } else if (pop instanceof JSApplyStaticContextElement) {
                if (_type instanceof JSNamedType && ((JSNamedType)_type).isStaticOrInstance() != JSContext.STATIC) {
                    _type = ((JSNamedType)_type).copyWithJSContext(JSContext.STATIC);
                    JSTypeEvaluator.applyContextAndProcess(_type, context, source, processor);
                }
            } else if (pop instanceof JSUnwrapPromiseTypeElement && (unwrapped = JSTypeUtils.getPromiseComponentTypeOrNull(_type)) != null) {
                JSTypeEvaluator.applyContextAndProcess(unwrapped, context, source, processor);
            }
            context.pushJSElementToApply(pop);
            return;
        }
        JSType type2 = context.isTypeGuessed() && _type.getSource().isStrict() ? JSTypeUtils.copyWithStrictRecursive(_type, false) : _type;
        if ((type2 = JSCompositeTypeImpl.optimizeTypeForSubstitute(type2, (PsiElement)context.getProcessedExpression())) instanceof JSFreshObjectLiteralType && context.getSource() instanceof JSVariable) {
            type2 = ((JSFreshObjectLiteralType)type2).removeFreshness();
        }
        processor.process(type2, context, source);
    }

    @Deprecated
    protected void addType(@NotNull String type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(30);
        }
        this.addType(JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource(source, false), JSContext.UNKNOWN), source);
    }

    protected void addNamespace(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(31);
        }
        JSTypeEvaluator.applyContextAndProcessNamespace(namespace, this.myContext, source, this.myTypeProcessor);
    }

    static void applyContextAndProcessNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        List elementsToApply;
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(32);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(34);
        }
        List list = elementsToApply = context.isJSElementsToApplyEmpty() ? ContainerUtil.emptyList() : new SmartList();
        while (!context.isJSElementsToApplyEmpty()) {
            JSApplyContextElement peek = context.peekJSElementToApply();
            if (peek instanceof JSApplyInstanceContextElement) {
                namespace = JSNamedTypeFactory.copyWithJSContext(namespace, JSContext.INSTANCE);
            } else if (peek instanceof JSApplyStaticContextElement) {
                namespace = JSNamedTypeFactory.copyWithJSContext(namespace, JSContext.STATIC);
            } else {
                if (!(peek instanceof JSApplyPropertyElement)) break;
                String name = ((JSApplyPropertyElement)peek).getName();
                source = null;
                namespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, namespace.getQualifiedName()), JSContext.STATIC, null, namespace.isSourceStrict());
            }
            elementsToApply.add(context.popJSElementToApply());
        }
        if (context.isJSElementsToApplyEmpty()) {
            processor.processNamespace(namespace, context, source);
        }
        for (int i = elementsToApply.size() - 1; i >= 0; --i) {
            context.pushJSElementToApply((JSApplyContextElement)elementsToApply.get(i));
        }
    }

    protected void evaluateTypes(@Nullable JSExpression rawqualifier, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(35);
        }
        if (rawqualifier == null) {
            return;
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            this.processItem(rawqualifier, place, expression -> {
                if (place == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(151);
                }
                this.doEvaluateTypes(rawqualifier, place);
            });
        } else {
            this.evaluateCachedTypes(rawqualifier);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEvaluateTypes(JSExpression rawqualifier, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        JSType typecast;
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(36);
        }
        if (rawqualifier != null && (typecast = JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier)) != null) {
            this.addType(typecast, null);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)rawqualifier;
            if (referenceExpression.getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)), (PsiElement)rawqualifier);
                return;
            }
            this.processRefExpr(referenceExpression);
            return;
        }
        if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier, place);
            return;
        }
        if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier, place);
            return;
        }
        if (rawqualifier instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            JSCompositeTypeImpl evaluatedJsType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (JSSymbolUtil.isLiteralOrLiteralWithSign((JSExpression)prefixExpression)) {
                    this.addTypeFromLiteralExpression((JSExpression)prefixExpression);
                    return;
                }
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.addNumericOperatorType(prefixExpression.getExpression(), (JSExpression)prefixExpression);
                    return;
                }
                JSType type = this.getExpressionTypeInContext(prefixExpression.getExpression());
                if (type != null) {
                    evaluatedType = type.getTypeText();
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true, false);
                    evaluatedJsType = new JSCompositeTypeImpl(typeSource, ContainerUtil.map((Object[])JSCommonTypeNames.TYPEOF_VALUES, v -> new JSStringLiteralTypeImpl((String)v, false, typeSource)));
                } else {
                    evaluatedType = "string";
                }
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign) {
                this.myContext.pushJSElementToApply(JSUnwrapPromiseTypeElement.INSTANCE);
                if (prefixExpression.getExpression() == null) return;
                this.evaluateCachedTypes(prefixExpression.getExpression());
                return;
            }
            if (evaluatedJsType != null) {
                this.addType(evaluatedJsType, (PsiElement)rawqualifier);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true, false);
                JSType type = JSNamedTypeFactory.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type, (PsiElement)rawqualifier);
                return;
            }
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPostfixExpression) {
            JSPostfixExpression postfixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = postfixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS != sign) {
                if (JSTokenTypes.MINUSMINUS != sign) return;
            }
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                this.simpleEvalType(rawqualifier, postfixExpression.getExpression());
                return;
            }
            this.addNumericOperatorType(rawqualifier, rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand == null) return;
            if (rOperand == null) return;
            if (sign == JSTokenTypes.AS_KEYWORD) {
                this.resolveAsBinaryOperationExpression(rawqualifier, rOperand);
                return;
            }
            if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign) || sign == JSTokenTypes.IS_KEYWORD) {
                this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false), JSTypeContext.INSTANCE), null);
                return;
            }
            if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST || sign == JSTokenTypes.MULTMULT) {
                if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.MULTMULT || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.addNumericOperatorType(lOperand, rawqualifier);
                    return;
                }
                JSType lProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(lOperand));
                JSType rProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(rOperand));
                if (sign != JSTokenTypes.OROR && sign != JSTokenTypes.ANDAND && sign != JSTokenTypes.QUEST_QUEST) {
                    this.evaluatePlusType(binaryExpression, lProcType, rProcType);
                    return;
                }
                this.evaluateAndOrOrType(rawqualifier, sign, lProcType, rProcType);
                return;
            }
            if (!JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
                if (!JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) return;
                this.simpleEvalType(rawqualifier, lOperand);
                return;
            }
            JSTypeEvaluationResult result2 = null;
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                result2 = this.getTypeEvaluationResultInContext(lOperand);
            }
            if (result2 == null) {
                result2 = this.getTypeEvaluationResultInContext(rOperand);
            }
            if (result2 == null) {
                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                return;
            }
            Iterator<JSTypeEvaluationResult.JSTypeEvaluationResultElement> rProcType = result2.getResults().iterator();
            while (rProcType.hasNext()) {
                JSTypeEvaluationResult.JSTypeEvaluationResultElement element = rProcType.next();
                this.addTypeEvaluationResultElement(element);
            }
            return;
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSType type;
            JSArrayLiteralExpression literal = (JSArrayLiteralExpression)rawqualifier;
            if (!literal.isEmpty()) {
                type = this.getArrayTypeFromExpressions(literal, literal.getExpressionStream());
            } else {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                type = DialectDetector.isTypeScript((PsiElement)rawqualifier) ? new JSArrayTypeImpl(JSAnyType.get((PsiElement)rawqualifier, true), typeSource) : JSNamedTypeFactory.createType("Array", typeSource, JSContext.INSTANCE);
            }
            this.addType(type, (PsiElement)rawqualifier);
            if (!(this.myTypeProcessor instanceof ResolveProcessor)) return;
            ((ResolveProcessor)((Object)this.myTypeProcessor)).execute((PsiElement)rawqualifier, ResolveState.initial());
            return;
        }
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.addType(this.getIndexedPropertyAccessType((JSIndexedPropertyAccessExpression)rawqualifier), (PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.isFromCurrentFile((PsiElement)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression(), place);
            return;
        }
        if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
            return;
        }
        if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType == null) {
                if (elseType == null) return;
            }
            JSType common = TypeScriptTypeRelations.getBestChoiceType(thenType, elseType, (PsiElement)conditionalExpression);
            this.addType(common, (PsiElement)conditionalExpression);
            return;
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false)), (PsiElement)rawqualifier);
            return;
        }
        if (this.evaluateDialectSpecificTypes(rawqualifier)) return;
        if (rawqualifier == null) return;
        this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
    }

    private void addNumericOperatorType(JSExpression expressionToGetType, JSExpression evaluatedExpression) {
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)evaluatedExpression, false);
        JSType expressionType = this.getExpressionTypeInContext(expressionToGetType);
        if (expressionType instanceof JSBigIntType) {
            this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)evaluatedExpression);
        } else {
            this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)evaluatedExpression);
        }
    }

    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(37);
        }
        JSPrimitiveType evaluatedType = null;
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression, DialectDetector.isTypeScript((PsiElement)binaryExpression));
        if (lProcType instanceof JSStringType || rProcType instanceof JSStringType) {
            evaluatedType = new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
        } else if ((lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
            evaluatedType = new JSIntType(true, typeSource, JSTypeContext.INSTANCE);
        } else if ((lProcType instanceof JSNumberType || lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSNumberType || rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
            evaluatedType = new JSNumberType(true, typeSource, JSTypeContext.INSTANCE);
        } else if (lProcType instanceof JSBigIntType && rProcType instanceof JSBigIntType) {
            evaluatedType = new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE);
        }
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)binaryExpression);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)binaryExpression);
        }
    }

    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(38);
        }
        if (sign == null) {
            JSTypeEvaluator.$$$reportNull$$$0(39);
        }
        if (lProcType != null) {
            this.addType(lProcType, (PsiElement)rawqualifier);
        }
        if (rProcType != null) {
            this.addType(rProcType, (PsiElement)rawqualifier);
        }
        if (lProcType == null && rProcType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(40);
        }
        return this.addComponentTypeFromArrayExpression((JSExpression)rawqualifier, rawqualifier.getQualifier());
    }

    protected void addTypeFromImportCall(@NotNull ES6ImportCall importCall) {
        if (importCall == null) {
            JSTypeEvaluator.$$$reportNull$$$0(41);
        }
        for (PsiElement module : importCall.resolveReferencedElements()) {
            if (!(module instanceof JSFile)) continue;
            this.addTypeFromModuleFile((JSFile)module, (PsiElement)importCall, false);
        }
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        JSClass jsClass;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(42);
        }
        JSClass jSClass = jsClass = JSResolveUtil.ownerHasExplicitThisParameter((JSExpression)rawqualifier) ? null : JSResolveUtil.getClassOfContext((PsiElement)rawqualifier, true);
        if (jsClass != null) {
            JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
            this.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
        } else {
            PsiElement thisScope = JSPsiImplUtils.getExecutionScope((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
    }

    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        String name;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(43);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(44);
        }
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(45);
        }
        if ((name = jsClass.getQualifiedName()) != null) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            this.addType(this.createTypeForThisExpression(staticOrInstance, name, typeSource, DialectDetector.isTypeScript((PsiElement)rawqualifier)), (PsiElement)jsClass);
        }
    }

    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull String name, @NotNull JSTypeSource typeSource, boolean isTypeScript) {
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(46);
        }
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(47);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(48);
        }
        JSType jSType = JSNamedTypeFactory.createType(name, typeSource, staticOrInstance);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(49);
        }
        return jSType;
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        JSType type;
        if (thisQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(50);
        }
        if ((type = JSDocumentationUtils.findContextType(thisScope)) != null) {
            this.addType(type, null);
        } else {
            JSNamespace thisType = JSContextResolver.resolveContext((PsiElement)thisQualifier);
            if (thisType != null) {
                this.addType((JSType)thisType, (PsiElement)thisQualifier);
            } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope), this.getContextualExpectedTypeKind());
                if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType((JSType)thisType, (PsiElement)thisQualifier);
                }
            }
            if (thisType == null) {
                this.myTypeProcessor.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        JSType type;
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && (type = ((JSVariable)resolve).getType()) instanceof JSNamedType && "Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, false), (PsiElement)rawqualifier);
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand, false);
            this.addType(JSTypeUtils.createType(rOperand.getText(), source), null);
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        JSClass aClass;
        String name;
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0 && (name = (aClass = classes[0]).getQualifiedName()) != null) {
            this.addType(JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)aClass, false), JSContext.UNKNOWN), (PsiElement)aClass);
        }
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = this.getExpressionTypeInContext(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    @Nullable
    protected JSType getExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        return JSResolveUtil.getElementJSType((PsiElement)toEvaluate, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    @Nullable
    protected JSTypeEvaluationResult getTypeEvaluationResultInContext(@Nullable JSExpression toEvaluate) {
        return toEvaluate == null ? null : JSTypeEvaluator.getExpressionType(toEvaluate);
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(51);
        }
        if (expressions == null) {
            JSTypeEvaluator.$$$reportNull$$$0(52);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier);
        List providers = expressions.map(el -> {
            if (rawQualifier == null) {
                JSTypeEvaluator.$$$reportNull$$$0(149);
            }
            return () -> {
                if (rawQualifier == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(150);
                }
                return this.getExpressionTypeForArrayLiteral((JSExpression)rawQualifier, (JSExpression)el, holder, null);
            };
        }).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
        if (jSArrayTypeImpl == null) {
            JSTypeEvaluator.$$$reportNull$$$0(53);
        }
        return jSArrayTypeImpl;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression rawqualifier, @Nullable JSExpression expression, @Nullable DialectOptionHolder holder, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType exprType;
        JSType jSType = expression instanceof JSSpreadExpression ? this.getArrayElementTypeFromSpread((JSSpreadExpression)expression) : (exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(rawqualifier));
        if (exprType == null && (typesToEvaluateLimit == null || typesToEvaluateLimit.decrementAndGet() >= 0)) {
            exprType = this.getExpressionTypeInContext(expression);
        }
        return this.widenExpressionTypeByContextualType(expression, holder != null && holder.isTypeScript, exprType);
    }

    @Nullable
    private JSType getArrayElementTypeFromSpread(@NotNull JSSpreadExpression expression) {
        JSType type;
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(54);
        }
        return (type = this.getExpressionTypeInContext(expression.getExpression())) == null ? null : JSTypeUtils.getIndexableComponentType(type);
    }

    @Nullable
    protected JSType widenExpressionTypeByContextualType(JSExpression expression, boolean isTypeScript, JSType exprType) {
        return JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(exprType));
    }

    @NotNull
    protected JSType createNullType(@Nullable JSExpression rawqualifier) {
        JSType jSType = JSNamedTypeFactory.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(55);
        }
        return jSType;
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(JSNewExpression newExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(56);
        }
        JSExpression methodExpr = newExpression.getMethodExpression();
        this.myContext.processWithJSElementToApply(new JSApplyInstanceContextElement(newExpression), () -> {
            if (place == null) {
                JSTypeEvaluator.$$$reportNull$$$0(148);
            }
            this.evaluateTypes(methodExpr, place);
        });
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(57);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(58);
        }
        if (!this.getEvaluationContext().isAstAccessAllowed()) {
            JSExpression methodExpression = callExpression.getStubSafeMethodExpression();
            if (methodExpression != null) {
                JSApplyContextElement applyContextElement = callExpression instanceof JSNewExpression ? new JSApplyInstanceContextElement((JSNewExpression)callExpression) : new JSApplyCallElement(methodExpression, JSExpression.EMPTY_ARRAY);
                this.getEvaluationContext().processWithJSElementToApply(applyContextElement, () -> this.doEvaluateTypesStubSafely(methodExpression));
            }
            return;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)callExpression);
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = this.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else {
                if (this.processRequireMethodCall(callExpression, invoked, isTypeScript)) {
                    return;
                }
                if (JSGclReferenceContributor.isGoogRequireCall(methodExpression)) {
                    this.addTypeFromGclRequireCall(callExpression);
                    return;
                }
            }
        }
        JSApplyContextElement elementToApply = JSApplyContextUtil.fromCallExpression(callExpression);
        JSExpression finalMethodExpression = methodExpression;
        this.myContext.processWithJSElementToApply(elementToApply, () -> {
            if (place == null) {
                JSTypeEvaluator.$$$reportNull$$$0(147);
            }
            this.evaluateTypes(finalMethodExpression, place);
        });
    }

    private void addTypeFromGclRequireCall(@NotNull JSCallExpression callExpression) {
        boolean typeGuessed;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(59);
        }
        if (!(typeGuessed = this.myContext.isTypeGuessed()) && DialectDetector.isTypeScript((PsiElement)callExpression)) {
            this.myContext.setTypeIsGuessed(true);
        }
        boolean resolvedToModule = false;
        JSGclModuleReference reference = JSGclReferenceContributor.getGclModuleReference(callExpression);
        if (reference != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = reference.multiResolve(false)) {
                PsiFile file2;
                PsiElement element = result2.getElement();
                if (!(element instanceof JSImplicitElement) || !"gcl".equals(((JSImplicitElement)element).getUserString()) || !((file2 = element.getContainingFile()) instanceof JSFile)) continue;
                resolvedToModule = true;
                this.addTypeFromModuleFile((JSFile)file2);
            }
            if (!resolvedToModule) {
                JSQualifiedName qName = reference.getQualifiedName();
                JSNamespace namespace = JSNamedTypeFactory.createNamespace(qName, JSContext.STATIC, reference.getElement(), true);
                this.addNamespace(namespace, reference.getElement());
            }
        }
        this.myContext.setTypeIsGuessed(typeGuessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression, @Nullable JSReferenceExpression invoked, boolean isTypeScript) {
        Collection<PsiElement> modules;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(60);
        }
        if ((modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression)).size() > MAX_MODULES_TO_EVALUATE) {
            Logger.getInstance(JSTypeEvaluator.class).warn("Too many resolved modules (" + modules.size() + ") for " + callExpression.getText());
            this.myTypeProcessor.setUnknownElement((PsiElement)callExpression);
            return false;
        }
        if (!modules.isEmpty()) {
            if (JSAmdPsiUtil.isWithinAmdModule((PsiElement)callExpression)) {
                JSLiteralExpression amdModuleReference = (JSLiteralExpression)callExpression.getArguments()[0];
                boolean result2 = false;
                for (PsiElement module : modules) {
                    result2 |= this.addTypeFromAmdModule(amdModuleReference, module);
                }
                return result2;
            }
            JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
            try {
                boolean oldIsTypeGuessed = this.myContext.isTypeGuessed();
                if (isTypeScript) {
                    this.myContext.setTypeIsGuessed(true);
                }
                this.myContext.setProcessedExpression(invoked);
                for (PsiElement module : modules) {
                    this.addModuleFromRequire(module, callExpression);
                }
                if (isTypeScript) {
                    this.myContext.setTypeIsGuessed(oldIsTypeGuessed);
                }
            }
            finally {
                this.myContext.setProcessedExpression(previousProcessedExpression);
            }
            return true;
        }
        return false;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        Optional first;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (first = ((JSArrayLiteralExpression)qualifier).getExpressionStream().findFirst()).isPresent()) {
            return (JSExpression)first.get();
        }
        return methodExpression;
    }

    private JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        JSExpression qualifier;
        if (methodExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(61);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(62);
        }
        if ((qualifier = invoked.getQualifier()) != null) {
            Ref referencesLib = Ref.create((Object)false);
            this.processItem(qualifier, JSEvaluateContext.JSEvaluationPlace.CALL_FUNCTION, ref -> {
                ResolveResult[] results;
                if (invoked == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(146);
                }
                for (ResolveResult result2 : results = invoked.multiResolve(false)) {
                    String fileName;
                    PsiElement element = result2.getElement();
                    if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName)) continue;
                    referencesLib.set((Object)true);
                    return;
                }
            });
            if (((Boolean)referencesLib.get()).booleanValue()) {
                return qualifier;
            }
        }
        return methodExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(63);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(64);
        }
        Ref processed = Ref.create((Object)false);
        this.processItem(invoked, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION, ref -> {
            JSExpression[] arguments;
            JSExpression firstArgument;
            JSType type;
            JSFunctionItem functionItem;
            if (callExpression == null) {
                JSTypeEvaluator.$$$reportNull$$$0(145);
            }
            boolean hasExplicitReturnType = false;
            PsiElement resolve = ref.resolve();
            if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)ref, true)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
                hasExplicitReturnType = true;
            }
            JSExpression jSExpression = firstArgument = (arguments = callExpression.getArguments()).length > 0 ? arguments[0] : null;
            if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
                String typeString;
                String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : ((JSLiteralExpression)firstArgument).getStringValue();
                if (typeString != null) {
                    JSType type2 = JSNamedTypeFactory.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument, false), JSTypeContext.UNKNOWN);
                    this.addType(type2, (PsiElement)firstArgument);
                }
                processed.set((Object)true);
            }
        });
        return Boolean.TRUE.equals(processed.get());
    }

    protected void addModuleFromRequire(PsiElement element, JSCallExpression callExpression) {
        JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE, module -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)module));
    }

    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return;
        }
        if (resolve instanceof JSFile) {
            this.addTypeFromModuleFile((JSFile)resolve);
        } else if (resolve instanceof JsonFile) {
            this.applyContextAndProcessResolvedElement(resolve);
        } else if (resolve instanceof StylesheetFile) {
            this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
        } else {
            this.addTypeFromResolveResult(resolve);
        }
    }

    private void addTypeFromModuleFile(@NotNull JSFile jsFile) {
        JSReferenceExpression place;
        if (jsFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(65);
        }
        PsiFile placeFile = (place = this.myContext.getProcessedExpression()) != null ? place.getContainingFile() : null;
        boolean isEs6Module = placeFile instanceof JSFile && !((JSFile)placeFile).hasES6Syntax();
        this.addTypeFromModuleFile(jsFile, (PsiElement)place, isEs6Module);
    }

    protected void addTypeFromModuleFile(@NotNull JSFile jsFile, @Nullable PsiElement source, boolean processDefaultExportForLegacyCompatibility) {
        JSType innerAlias;
        if (jsFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(66);
        }
        this.applyContextAndProcessResolvedElement((PsiElement)jsFile);
        JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement(jsFile);
        if (exportedElement == null && source != null && DialectDetector.isJavaScript(source) && jsFile.hasES6Syntax() && processDefaultExportForLegacyCompatibility) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)jsFile);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                PsiElement resolvedExportAssignment = JSTypeEvaluator.resolveExportAssignmentLocally((JSExportAssignment)defaultExport);
                if (resolvedExportAssignment != null) {
                    exportedElement = resolvedExportAssignment;
                }
            } else if (defaultExport != null) {
                exportedElement = defaultExport;
            }
        }
        if (exportedElement != null) {
            JSTypeEvaluator.processWithEvaluationGuard(exportedElement, JSEvaluateContext.JSEvaluationPlace.EXPORTED_ELEMENT, this::addTypeFromResolveResult);
        }
        if ((innerAlias = jsFile.getExportsInnerAlias()) != null) {
            JSPsiElementBase finalExportedElement = exportedElement;
            JSApplyContextUtil.applyTypeToContext(innerAlias, this.myContext, (arg_0, arg_1) -> this.lambda$addTypeFromModuleFile$22((PsiElement)finalExportedElement, arg_0, arg_1));
        }
    }

    @Nullable
    private static PsiElement resolveExportAssignmentLocally(JSExportAssignment defaultExport) {
        String reference = defaultExport.getInitializerReference();
        if (reference != null) {
            PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)defaultExport);
            if (localResolve != null) {
                return localResolve;
            }
        } else {
            JSElement element = defaultExport.getStubSafeElement();
            if (element != null) {
                return element;
            }
        }
        return null;
    }

    private static void addDefaultExportNamespaces(@NotNull PsiElement source, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(67);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(68);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(69);
        }
        JSNamespace moduleExports = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromComponents("module", "exports"), JSContext.STATIC, source, true, true, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(moduleExports, context, source, processor);
        JSNamespace exports = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, source, true, true, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(exports, context, source, processor);
    }

    @NotNull
    protected JSEvaluateContext getEvaluationContext() {
        JSEvaluateContext jSEvaluateContext = this.myContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(70);
        }
        return jSEvaluateContext;
    }

    protected boolean processFunction(@NotNull JSFunction function) {
        boolean hasSomeType;
        boolean inCall;
        if (function == null) {
            JSTypeEvaluator.$$$reportNull$$$0(71);
        }
        if (!this.getEvaluationContext().isAstAccessAllowed()) {
            JSType type;
            JSApplyContextElement peek = this.getEvaluationContext().peekJSElementToApply();
            if (peek instanceof JSApplyCallElement) {
                JSType type2 = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)function);
                if (type2 != null) {
                    this.getEvaluationContext().processWithoutTopJSElementToApply(() -> {
                        if (function == null) {
                            JSTypeEvaluator.$$$reportNull$$$0(144);
                        }
                        this.addType(type2, (PsiElement)function);
                    });
                }
            } else if (peek instanceof JSApplyInstanceContextElement && (type = JSTypeEvaluator.getTypeFromConstructorName(function)) != null) {
                this.getEvaluationContext().processWithoutTopJSElementToApply(() -> {
                    if (function == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(143);
                    }
                    this.addType(type, (PsiElement)function);
                });
            }
            return true;
        }
        JSApplyContextElement elementToApply = this.myContext.peekJSElementToApply();
        boolean bl = inCall = elementToApply instanceof JSApplyCallElement || elementToApply instanceof JSApplyInstanceContextElement;
        if (function.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
            if (returnType != null) {
                this.addType(returnType, null);
            }
            hasSomeType = returnType != null;
        } else if (function.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function);
            if (parameterType != null) {
                this.addType(parameterType, null);
            }
            hasSomeType = parameterType != null;
        } else if (!inCall) {
            JSExpression returned;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function, false);
            if (source.getLanguage() == JSTypeSource.SourceLanguage.TS) {
                this.addType((JSType)TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function), (PsiElement)function);
            } else if (this.isFromCurrentFile((PsiElement)function) && (returned = (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(function.getContainingFile(), () -> {
                if (function == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(142);
                }
                return JSPsiImplUtils.getReturnedExpressionIfSingle(function);
            })) != null) {
                SmartList parameterTypes = new SmartList();
                for (JSParameterListElement parameter : function.getParameters()) {
                    parameterTypes.add(parameter.getTypeDecorator());
                }
                JSTypeSource explicitlyDeclaredSource = JSTypeSourceFactory.createTypeSource((PsiElement)function, true);
                JSFunctionTypeImpl type = new JSFunctionTypeImpl(explicitlyDeclaredSource, (List<? extends JSParameterTypeDecorator>)parameterTypes, this.getExpressionTypeInContext(returned));
                this.addType(type, (PsiElement)function);
            } else {
                String name;
                JSType functionType = source.getLanguage() == JSTypeSource.SourceLanguage.JS ? ((name = function.getQualifiedName()) != null ? JSNamedTypeFactory.createType(name, source, JSContext.STATIC) : JSNamedTypeFactory.createFunctionType(source, JSTypeContext.INSTANCE, false)) : JSNamedTypeFactory.createFunctionType(source, JSTypeContext.INSTANCE, false);
                this.addType(functionType, (PsiElement)function);
            }
            hasSomeType = true;
        } else {
            hasSomeType = this.myContext.processWithoutTopJSElementToApply((Processor<? super JSApplyContextElement>)((Processor)pop -> {
                JSQualifiedName namespace;
                JSType typeFromConstructorName;
                if (function == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(141);
                }
                JSExpression methodExpression = null;
                boolean isNewCall = pop instanceof JSApplyInstanceContextElement;
                if (pop instanceof JSApplyCallElement) {
                    methodExpression = ((JSApplyCallElement)pop).getMethodExpression();
                } else if (pop instanceof JSApplyInstanceContextElement) {
                    JSNewExpression newExpression = ((JSApplyInstanceContextElement)pop).getNewExpression();
                    methodExpression = newExpression != null ? newExpression.getMethodExpression() : null;
                }
                JSType jsType = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
                boolean hasSomeTypeInner = false;
                if (!JSTypeUtils.isRestrictiveType(jsType) && !DialectDetector.isTypeScript((PsiElement)function)) {
                    Collection<JSObjectLiteralExpression> objectLiterals = JSStubBasedPsiTreeUtil.findReturnedExpressions(function, JSObjectLiteralExpression.class);
                    for (JSObjectLiteralExpression objectLiteral : objectLiterals) {
                        this.addTypeFromObjectLiteralExpression(objectLiteral, false);
                    }
                    if (!objectLiterals.isEmpty()) {
                        jsType = null;
                        hasSomeTypeInner = true;
                    }
                }
                if (isNewCall && (jsType != null || !hasSomeTypeInner) && (typeFromConstructorName = JSTypeEvaluator.getTypeFromConstructorName(function)) != null) {
                    List<JSType> types = jsType instanceof JSCompositeTypeImpl ? ((JSCompositeTypeImpl)jsType).getTypes() : Collections.singletonList(jsType != null ? jsType : typeFromConstructorName);
                    List newTypes = ContainerUtil.filter(types, type -> !(type instanceof JSVoidType) && !(type instanceof JSUndefinedType) && (!(type instanceof JSPrimitiveType) || !((JSPrimitiveType)type).isPrimitive()));
                    if (newTypes.size() < types.size()) {
                        newTypes.add(0, typeFromConstructorName);
                    }
                    jsType = JSCompositeTypeImpl.getCommonType(newTypes, typeFromConstructorName.getSource(), false);
                }
                if (!isNewCall && (namespace = function.getJSNamespace().getQualifiedName()) instanceof JSQualifiedNameImpl && ((JSQualifiedNameImpl)namespace).matches(JQUERY_NS)) {
                    this.addJQueryType((PsiElement)function);
                }
                if (jsType != null) {
                    jsType = JSDialectSpecificHandlersFactory.forElement((PsiElement)methodExpression).getGenericTypeEvaluator().evaluateGenerics(jsType, methodExpression, (PsiElement)function);
                    this.addType(jsType, null);
                    hasSomeTypeInner = true;
                }
                return hasSomeTypeInner;
            }));
        }
        return hasSomeType;
    }

    @Nullable
    private static JSType getTypeFromConstructorName(@NotNull JSFunction function) {
        JSClass parentClass;
        if (function == null) {
            JSTypeEvaluator.$$$reportNull$$$0(72);
        }
        if (function.isConstructor() && (parentClass = JSUtils.getMemberContainingClass((PsiElement)function)) != null) {
            String qName = parentClass.getQualifiedName();
            if (qName != null) {
                return JSNamedTypeFactory.createType(qName, JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, false), JSContext.INSTANCE);
            }
        } else {
            if (function instanceof JSFunctionExpression && function.getName() == null && function.getContext() instanceof ES6ExportDefaultAssignment) {
                return JSNamedTypeFactory.createExplicitlyDeclaredType("\"default\"", (PsiElement)function);
            }
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)function);
            if (name != null) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)function, true);
                return JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedName(name), typeSource, JSTypeContext.INSTANCE, true, false);
            }
        }
        return null;
    }

    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        JSExpression qualifier;
        JSExpression exprQualifier;
        String referenceName;
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(73);
        }
        if ("prototype".equals(referenceName = expression.getReferenceName()) && !DialectDetector.isTypeScript((PsiElement)expression) && (exprQualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            this.myContext.processWithJSElementToApply(JSApplyInstanceContextElement.INSTANCE, () -> this.processRefExpr((JSReferenceExpression)exprQualifier));
            return;
        }
        if ("constructor".equals(referenceName) && DialectDetector.isJavaScript((PsiElement)expression) && (qualifier = expression.getQualifier()) != null) {
            this.myContext.processWithJSElementToApply(JSApplyStaticContextElement.INSTANCE, () -> this.evaluateTypes(qualifier, JSEvaluateContext.JSEvaluationPlace.DEFAULT));
            return;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression) && DialectDetector.isJavaScript((PsiElement)expression)) {
            JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)expression, this.myContext, this.myTypeProcessor);
            return;
        }
        boolean hasSomeType = this.myContext.processExpression(expression, () -> {
            if (expression == null) {
                JSTypeEvaluator.$$$reportNull$$$0(140);
            }
            boolean typeAdded = false;
            ResolveResult[] resolveResults = this.getResolveResultsFromQualifier(expression);
            if (resolveResults.length > 0 && !JSTypeEvaluator.shouldSkipProcessing(resolveResults)) {
                this.myContext.setTypeIsGuessed(this.myContext.isTypeGuessed() || !JSResolveUtil.isResolveStrict(expression, resolveResults));
                for (ResolveResult r : resolveResults) {
                    PsiElement element = r.getElement();
                    if (element == null) continue;
                    this.addLocalNamespaceFromImport(referenceName, r);
                    typeAdded |= this.addTypeFromResolveResult(element);
                }
            }
            return typeAdded;
        });
        if (!DialectDetector.isActionScript((PsiElement)expression)) {
            JSReferenceExpression localQualifier = JSUtils.findRefExprThatStartCallChaining(expression);
            hasSomeType |= this.addAdditionalTypes(localQualifier, expression);
        }
        if (!hasSomeType) {
            JSType typeFromReferenceExpression = JSSymbolUtil.createTypeFromReferenceExpression(expression, JSTypeContext.STATIC);
            if (typeFromReferenceExpression != null && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
                this.addType(typeFromReferenceExpression, (PsiElement)expression);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)expression);
            }
        }
    }

    private void addLocalNamespaceFromImport(String referenceName, ResolveResult r) {
        ES6ImportExportDeclarationPart anImport;
        if (r instanceof JSResolveResult && (anImport = ((JSResolveResult)r).getES6Import()) instanceof ES6ImportExportSpecifier && Objects.equals(referenceName, anImport.getDeclaredName())) {
            JSNamespace nsFromImport = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(referenceName, null), JSContext.STATIC, (PsiElement)anImport, true, true, true);
            this.addNamespace(nsFromImport, (PsiElement)anImport);
        }
    }

    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(74);
        }
        ResolveResult[] resolveResultArray = qualifier.multiResolve(false);
        if (resolveResultArray == null) {
            JSTypeEvaluator.$$$reportNull$$$0(75);
        }
        return resolveResultArray;
    }

    private static boolean shouldSkipProcessing(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            JSTypeEvaluator.$$$reportNull$$$0(76);
        }
        if (resolveResults.length < 20) {
            return false;
        }
        return !JSResolveUtil.isTypeScriptDeclarationMerging(resolveResults);
    }

    protected final boolean addTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(77);
        }
        this.myContext.setSource(resolveResult);
        if (resolveResult instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            resolveResult = ((TypeScriptProxyImplicitElementWithBackingItem)resolveResult).getBackingElement();
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.EP_NAME.getExtensionList()) {
            if (!(handler.addTypeFromResolveResult(this, this.myContext, resolveResult) | handler.addTypeFromResolveResult(this, resolveResult, false))) continue;
            return true;
        }
        if (resolveResult instanceof JSFieldVariable) {
            this.addTypeFromVariableResolveResult((JSFieldVariable)resolveResult);
            return true;
        }
        return this.addTypeFromElementResolveResult(resolveResult);
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        boolean useVariableType;
        JSType expanded;
        JSResolvedTypeInfo resolvedType;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(78);
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean wasGuessed = this.myContext.isTypeGuessed();
        int jsElementsToApplySize = this.myContext.getJSElementsToApply().size();
        JSType variableType = jsVariable.getType();
        boolean isDestructuringType = variableType instanceof JSDestructuringTypeImpl;
        if (isDestructuringType) {
            variableType = null;
        }
        if (variableType == null && jsVariable instanceof JSParameter && this.isFromCurrentFile((PsiElement)jsVariable)) {
            if (this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            variableType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)((JSParameter)jsVariable), this.myContext, this.getContextualExpectedTypeKind());
        }
        if (jsVariable instanceof JSParameter && ((JSParameter)jsVariable).isRest() && !JSTypeUtils.isNonArrayRestType(variableType)) {
            JSTypeSource typeSource = variableType != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, ((JSParameter)jsVariable).getTypeDecorator().isExplicitlyDeclared());
            variableType = new JSArrayTypeImpl(variableType, typeSource);
        }
        if ((variableType = this.substituteThisType(variableType, jsVariable)) instanceof JSResolvableType && (resolvedType = ((JSResolvableType)variableType).resolveType()).isEnum()) {
            variableType = this.modifyTypeForEnumType((JSResolvableType)variableType, jsVariable);
        }
        if ((expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(variableType)) instanceof JSTypeImpl) {
            JSResolvedTypeInfo resolvedType2 = ((JSResolvableType)expanded).resolveType();
            if (TypeScriptUtil.isImportType(expanded) && resolvedType2.getDeclarations().size() == 1 && ((JSTypeImpl)expanded).getTypeContext() == JSTypeContext.STATIC) {
                this.addTypeFromExternalModuleReferenceResolveResult(resolvedType2.getDeclarations().iterator().next());
                return;
            }
        }
        if ((useVariableType = this.useVariableType(variableType)) && variableType.isJavaScript() && variableType instanceof JSCodeBasedType && !(variableType instanceof JSRequireCallExpressionType) && this.isFromCurrentFile((PsiElement)jsVariable)) {
            useVariableType = false;
        }
        if (useVariableType) {
            this.addType(variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
        } else {
            JSExpression initializer;
            JSFunctionExpression functionExpression = jsVariable instanceof JSVariable ? ((initializer = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)jsVariable)) instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null) : null;
            if (functionExpression != null) {
                this.processFunction((JSFunction)functionExpression);
            } else if (this.isFromCurrentFile((PsiElement)jsVariable)) {
                JSExpression initializer2;
                JSEvaluateContext context;
                JSInitializerOwner parent;
                Condition searchTypeDeclaration;
                boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
                JSInitializerOwner initializerOwner = null;
                if (isTypeScript && (searchTypeDeclaration = owner -> owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null).value((Object)(parent = JSDestructuringUtil.findDestructuringParent((JSElement)jsVariable, context = new JSEvaluateContext(this.myContext.targetFile), (Condition<? super JSInitializerOwner>)searchTypeDeclaration)))) {
                    initializerOwner = parent;
                    for (JSApplyContextElement element : StreamEx.of(context.getJSElementsToApply().descendingIterator())) {
                        this.myContext.pushJSElementToApply(element);
                    }
                }
                if (initializerOwner == null) {
                    Condition condition = owner -> owner.hasOwnInitializer();
                    initializerOwner = JSDestructuringUtil.findDestructuringParent((JSElement)jsVariable, this.myContext, (Condition<? super JSInitializerOwner>)condition);
                }
                JSInitializerOwner finalInitializerOwner = initializerOwner;
                JSExpression jSExpression = initializer2 = initializerOwner != null ? (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(initializerOwner.getContainingFile(), () -> finalInitializerOwner.getInitializer()) : null;
                if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)initializerOwner).getTypeElement() != null) {
                    this.myContext.setTypeIsGuessed(!isDestructuringType);
                    this.addType(((JSTypeDeclarationOwner)initializerOwner).getType(), (PsiElement)initializerOwner);
                } else if (initializer2 != null) {
                    boolean isConst = jsVariable.isConst();
                    if (isConst) {
                        this.addTypeFromInitializer(initializer2);
                    } else {
                        PsiElement scope;
                        boolean isGuessed = wasGuessed;
                        if (jsVariable instanceof JSVariable && !isTypeScript && !((scope = ((JSVariable)jsVariable).getDeclarationScope()) instanceof JSBlockStatement) && !(scope instanceof JSFunction)) {
                            isGuessed = true;
                        }
                        this.myContext.setTypeIsGuessed(isGuessed);
                        this.addTypeFromInitializer(initializer2);
                    }
                } else if (variableType == null && jsVariable instanceof JSVariable && JSPsiImplUtils.isForStatementDeclaration((JSVariable)jsVariable)) {
                    PsiElement forOf = JSResolveUtil.findParent((PsiElement)jsVariable);
                    variableType = this.addLoopVariable(expression, (PsiElement)jsVariable, (JSForInStatement)forOf);
                } else if (expression != null && variableType == null) {
                    variableType = JSTypeEvaluator.getGuardedTypeByEvaluateContext(null, this.myContext, EXPLICIT_TYPE_MARKER_ELEMENT);
                    if (variableType != null) {
                        this.myContext.setTypeIsGuessed(JSTypeUtils.isStrictType(variableType));
                        this.doAddType(variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
                    } else {
                        this.myTypeProcessor.setUnknownElement((PsiElement)jsVariable);
                    }
                }
            } else {
                initializer = jsVariable.getInitializerOrStub();
                if (initializer != null) {
                    this.getEvaluationContext().withAstAccessForbidden(() -> this.evaluateCachedTypes(initializer));
                }
            }
        }
        if (!(isDestructuringType || useVariableType && JSTypeUtils.isStrictType(variableType))) {
            JSNamespace namespace = this.getNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)jsVariable, false);
            this.addNamespace(namespace, (PsiElement)jsVariable);
        }
        this.restoreEvaluationContextApplingElementsSize(jsElementsToApplySize);
        this.myContext.setTypeIsGuessed(wasGuessed);
    }

    private void restoreEvaluationContextApplingElementsSize(int sizeBefore) {
        while (this.myContext.getJSElementsToApply().size() > sizeBefore) {
            this.myContext.popJSElementToApply();
        }
    }

    protected JSType modifyTypeForEnumType(@NotNull JSResolvableType type, @NotNull JSFieldVariable jsVariable) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(79);
        }
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(80);
        }
        return type;
    }

    @Nullable
    public static JSType getTypeFromTypeGuard(@NotNull PsiElement namedElement, @Nullable JSReferenceExpression expression, @Nullable JSType preprocessedType, @Nullable PsiElement resolvedElement) {
        if (namedElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(81);
        }
        if (expression != null && JSTypeGuardChecker.isAvailable((PsiElement)expression, preprocessedType, namedElement)) {
            return JSTypeGuardChecker.createGuard(expression, preprocessedType, resolvedElement).getNarrowedType();
        }
        return preprocessedType;
    }

    @Nullable
    private JSType getTypeFromTypeGuard(@NotNull PsiElement element, @Nullable JSReferenceExpression expression, @Nullable JSType preprocessedType) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(82);
        }
        return JSTypeEvaluator.getTypeFromTypeGuard(element, expression, preprocessedType, this.myContext.getSource());
    }

    private void addTypeFromInitializer(@Nullable JSExpression initializer) {
        boolean inCall;
        if (initializer == null) {
            return;
        }
        boolean bl = inCall = !this.myContext.isJSElementsToApplyEmpty();
        if (DialectDetector.isTypeScript((PsiElement)initializer)) {
            JSType contextType = this.getExpressionTypeInContext(initializer);
            if (contextType != null) {
                this.addType(contextType, EXPLICIT_TYPE_MARKER_ELEMENT);
            }
            return;
        }
        if (!inCall && JSSymbolUtil.isNullLiteral(initializer)) {
            this.addType(JSAnyType.get((PsiElement)initializer, false), (PsiElement)initializer);
        } else if (!(DialectDetector.isJavaScript((PsiElement)initializer) && initializer instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)initializer).isEmpty())) {
            this.evaluateCachedTypes(initializer);
        }
    }

    private void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSInitializerOwner owner;
        if (destructuringContainer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(83);
        }
        if ((owner = JSDestructuringUtil.findDestructuringParent((JSElement)destructuringContainer, this.myContext, (Condition<? super JSInitializerOwner>)((Condition)e -> e.hasOwnInitializer() || e instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)e).getTypeElement() != null || e instanceof JSParameterListElement))) == null) {
            return;
        }
        if (owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null) {
            this.addType(((JSTypeDeclarationOwner)owner).getType(), (PsiElement)owner);
        }
        if (owner.hasOwnInitializer()) {
            boolean wasGuessed = this.myContext.isTypeGuessed();
            if (!(owner instanceof JSTypeDeclarationOwner) || !(((JSTypeDeclarationOwner)owner).getType() instanceof JSDestructuringTypeImpl)) {
                this.myContext.setTypeIsGuessed(true);
            }
            this.addTypeFromInitializer((JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(owner.getContainingFile(), () -> owner.getInitializer()));
            this.myContext.setTypeIsGuessed(wasGuessed);
        }
        if (owner instanceof JSParameterListElement) {
            ES6ImportCall importCall = ES6PsiUtil.getImportCallIfContinuationParameter((JSParameterListElement)owner);
            if (importCall != null) {
                this.addTypeFromImportCall(importCall);
            } else {
                this.addType(JSContextTypeEvaluator.getParameterType((JSParameterListElement)owner, this.myContext, JSExpectedTypeKind.EXPECTED), (PsiElement)owner);
            }
        }
    }

    protected JSType substituteThisType(JSType type, JSFieldVariable jsVariable) {
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSTypeEvaluator.$$$reportNull$$$0(84);
        }
        boolean result2 = false;
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve : modules) {
                result2 |= this.addTypeFromAmdModule(amdModuleReference, resolve);
            }
        }
        return result2;
    }

    private boolean addTypeFromAmdModule(@NotNull JSLiteralExpression amdModuleReference, @NotNull PsiElement resolve) {
        if (amdModuleReference == null) {
            JSTypeEvaluator.$$$reportNull$$$0(85);
        }
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(86);
        }
        boolean result2 = false;
        JSFunctionExpression moduleInitializer = null;
        if (resolve instanceof JSFile) {
            JSFunctionExpression amdModule = JSAmdModulesIndex.findDefaultAmdModule((JSFile)resolve);
            if (amdModule != null) {
                moduleInitializer = amdModule;
            } else {
                this.addTypeFromModuleFile((JSFile)resolve);
            }
            result2 = true;
        } else if (resolve instanceof JSFunctionExpression) {
            moduleInitializer = (JSFunctionExpression)resolve;
            JSType type = JSNamedTypeFactory.createType(JSAmdPsiUtil.unifyModuleName(amdModuleReference), JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
            this.addType(type, EXPLICIT_TYPE_MARKER_ELEMENT);
            result2 = true;
        }
        if (moduleInitializer != null) {
            JSFunctionExpression finalModuleInitializer = moduleInitializer;
            this.myContext.processWithJSElementToApply(new JSApplyCallElement(null, JSExpression.EMPTY_ARRAY), () -> this.addTypeFromResolveResult((PsiElement)finalModuleInitializer));
            JSNamespace exportsNamespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, (PsiElement)moduleInitializer, true, false, true);
            this.addType((JSType)exportsNamespace, (PsiElement)moduleInitializer);
        }
        return result2;
    }

    protected boolean useVariableType(JSType type) {
        return type != null;
    }

    public boolean isFromCurrentFile(@NotNull PsiElement element) {
        JSReferenceExpression context;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(87);
        }
        if ((context = this.myContext.getProcessedExpression()) == null) {
            context = this.myContext.targetFile;
        }
        return context != null && context.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)element.getContainingFile().getOriginalFile());
    }

    private void evaluateCachedTypes(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(88);
        }
        if (!this.myContext.isAstAccessAllowed() && expression instanceof StubBasedPsiElementBase && ((StubBasedPsiElementBase)expression).getStub() != null) {
            this.doEvaluateTypesStubSafely(expression);
            return;
        }
        if (!this.myContext.isJSElementsToApplyEmpty() || !this.myContext.isAstAccessAllowed()) {
            this.processItem(expression, JSEvaluateContext.JSEvaluationPlace.DEFAULT, el -> this.doEvaluateTypes((JSExpression)el, JSEvaluateContext.JSEvaluationPlace.DEFAULT));
            return;
        }
        JSTypeEvaluationResult result2 = this.getTypeEvaluationResultInContext(expression);
        if (result2 != null) {
            List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                this.addTypeEvaluationResultElement(element);
            }
        }
    }

    private void doEvaluateTypesStubSafely(JSExpression expression) {
        if (expression instanceof JSFunction) {
            this.processFunction((JSFunction)expression);
        } else if (expression instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)expression, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        } else if (expression instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)expression);
        } else if (expression instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expression, false);
        }
    }

    public void addTypeFromClassExpression(JSClassExpression<?> classExpression) {
    }

    protected boolean processInstanceContextForClass(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(89);
        }
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        assert (peek instanceof JSApplyInstanceContextElement);
        this.addTypeFromClassCandidate(jsClass);
        return true;
    }

    protected boolean addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        boolean hasSomeType = false;
        if (resolveResult instanceof TypeScriptMergedTypeImplicitElement) {
            this.addTypeFromMergedElementResolveResult((TypeScriptMergedTypeImplicitElement)resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            this.addTypeFromImplicitElementResolveResult(implicitElement);
            hasSomeType = true;
        } else if (resolveResult instanceof JSProperty) {
            hasSomeType = this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
            hasSomeType = this.processInstanceContextForClass((JSClass)resolveResult);
        } else if (resolveResult instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getContext() instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult.getContext());
            hasSomeType = true;
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getParent();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                parameterType = this.addLoopVariable(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
            hasSomeType = true;
        } else if (this.addTypeFromDialectSpecificElements(resolveResult)) {
            hasSomeType = true;
        } else if (resolveResult instanceof JSFunction) {
            if (this.processFunction((JSFunction)resolveResult)) {
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult, false), JSContext.STATIC);
                this.addType(jsType, resolveResult);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JsonElement) {
            this.applyContextAndProcessResolvedElement(resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSFile) {
            this.addTypeFromModuleFile((JSFile)resolveResult);
            hasSomeType = true;
        }
        return hasSomeType;
    }

    private void addTypeFromImplicitElementResolveResult(@NotNull JSImplicitElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(90);
        }
        boolean typeAdded = false;
        if (resolveResult instanceof JSLocalImplicitElementImpl) {
            PsiElement owner = resolveResult.getParent();
            JSType jsType = ((JSLocalImplicitElementImpl)resolveResult).getJSType();
            this.addType(jsType, owner);
            return;
        }
        String typeString = resolveResult.getTypeString();
        if (typeString != null) {
            JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, true));
            this.addType(type, (PsiElement)resolveResult);
            typeAdded = true;
        }
        if (!typeAdded && resolveResult.getType().providesNamespace()) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
            JSType jsType = JSNamedTypeFactory.createType(resolveResult.getQualifiedName(), typeSource, JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        } else {
            JSNamespace namespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)resolveResult), JSContext.STATIC, (PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
            this.addNamespace(namespace, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromMergedElementResolveResult(TypeScriptMergedTypeImplicitElement resolveResult) {
        boolean inCall;
        PsiElement explicitElement = resolveResult.getExplicitElement();
        JSType jsType = resolveResult.getJSType();
        JSApplyContextElement elementToApply = this.myContext.peekJSElementToApply();
        boolean bl = inCall = elementToApply instanceof JSApplyCallElement || elementToApply instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)elementToApply).getNewExpression() != null;
        if (inCall && explicitElement instanceof JSFunction) {
            JSExpression methodExpression = elementToApply instanceof JSApplyCallElement ? ((JSApplyCallElement)elementToApply).getMethodExpression() : ((JSApplyInstanceContextElement)elementToApply).getNewExpression();
            jsType = JSDialectSpecificHandlersFactory.forElement((PsiElement)methodExpression).getGenericTypeEvaluator().evaluateGenerics(jsType, methodExpression, explicitElement);
        }
        PsiElement source = explicitElement == null ? null : explicitElement.getParent();
        this.addType(jsType, source);
    }

    private boolean addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(91);
        }
        boolean typeAdded = false;
        boolean skipEvaluatingProps = false;
        JSType jsType = property.getType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)property);
            typeAdded = true;
            skipEvaluatingProps = !(jsType instanceof JSRecordType);
        } else if (this.tryAddTypeFromInitializerReference((PsiElement)property)) {
            typeAdded = true;
            skipEvaluatingProps = true;
        }
        if (!skipEvaluatingProps) {
            JSExpression value;
            JSDocComment docComment;
            JSNamespace type;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (type = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)property, (docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property)) != null && docComment.isClassExplicitly())) != null) {
                this.addType((JSType)type, (PsiElement)property);
                typeAdded = true;
            }
            if (functionInitializer != null || objectLiteralExpression != null) {
                if (functionInitializer != null) {
                    typeAdded |= this.processFunction(functionInitializer);
                } else {
                    this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                }
            } else if (this.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                this.evaluateCachedTypes(value);
            }
        }
        return typeAdded;
    }

    @NotNull
    protected JSNamespace getNamespaceFromQualifiedNamedElement(@NotNull JSQualifiedNamedElement element, boolean isStrict) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(92);
        }
        boolean isLocal = JSPsiImplUtils.getLexicalScope((JSNamedElement)element) != null;
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)element);
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace(qualifiedName, JSContext.STATIC, (PsiElement)element, isStrict, true, isLocal);
        if (jSNamespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(93);
        }
        return jSNamespace;
    }

    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(94);
        }
    }

    @Nullable
    private JSType addLoopVariable(@Nullable JSReferenceExpression expression, @NotNull PsiElement element, @Nullable JSForInStatement forInStatement) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(95);
        }
        if (forInStatement == null) {
            return null;
        }
        if (forInStatement.isForEach()) {
            List<JSType> types = this.getComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
            for (JSType type : types) {
                this.addType(type, (PsiElement)expression);
            }
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        JSForInStringType parameterType = new JSForInStringType(JSTypeSourceFactory.createTypeSource(element, true, false), JSTypeContext.INSTANCE);
        this.addType(parameterType, element);
        return parameterType;
    }

    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        return false;
    }

    @Nullable
    public final JSType addComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        List<JSType> types = this.getComponentTypeFromArrayExpression(rawqualifier, collectionExpression);
        for (JSType type : types) {
            this.addType(type, (PsiElement)rawqualifier);
        }
        return types.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        if (collectionExpression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(96);
            }
            return list;
        }
        JSTypeEvaluationResult result2 = this.getTypeEvaluationResultInContext(collectionExpression);
        if (result2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(97);
            }
            return list;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result2.getResults();
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(result2.getType());
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            JSExpression indexExpression;
            int index = -1;
            if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral()) {
                Object value = ((JSLiteralExpression)indexExpression).getValue();
                assert (value instanceof Double || value instanceof Long || value instanceof BigInteger) : indexExpression.getText();
                if (value instanceof Long && (Long)value >= 0L && (Long)value <= Integer.MAX_VALUE) {
                    index = Math.toIntExact((Long)value);
                } else if (value instanceof BigInteger && ((BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && ((BigInteger)value).compareTo(JSLiteralExpressionImpl.INT_MAX_VALUE_AS_BIGINT) <= 0) {
                    index = ((BigInteger)value).intValueExact();
                }
            }
            boolean processed = false;
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                PsiElement source = element.getSource();
                if (source instanceof JsonFile) {
                    source = ((JsonFile)source).getTopLevelValue();
                }
                if (source instanceof JSArrayLiteralExpression) {
                    JSExpression[] expressions = ((JSArrayLiteralExpression)source).getExpressions();
                    if (index >= 0 && index < expressions.length) {
                        this.addTypeFromElementResolveResult((PsiElement)expressions[index]);
                        processed = true;
                        continue;
                    }
                    for (JSExpression expr : expressions) {
                        if (!(expr instanceof JSObjectLiteralExpression)) continue;
                        this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expr, false);
                        processed = true;
                    }
                    continue;
                }
                if (!(source instanceof JsonArray)) continue;
                List values = ((JsonArray)source).getValueList();
                if (index < 0 || index >= values.size()) continue;
                this.applyContextAndProcessResolvedElement((PsiElement)values.get(index));
                processed = true;
            }
            if (!processed && type instanceof JSTupleType && ((JSTupleType)type).hasTypeByIndex(index)) {
                List<JSType> list = Collections.singletonList(((JSTupleType)type).getTypeByIndex(index));
                if (list == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(98);
                }
                return list;
            }
        }
        List<JSType> list = this.getComponentTypeFromProcessor(rawqualifier, type);
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(99);
        }
        return list;
    }

    @Nullable
    public final JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        List<JSType> types = this.getComponentTypeFromProcessor(rawqualifier, type);
        for (JSType jsType : types) {
            if (type == null) continue;
            this.addType(jsType, (PsiElement)rawqualifier);
        }
        return types.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        ArrayList result2 = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
        ArrayList arrayList = result2.isEmpty() ? ContainerUtil.newArrayList((Object[])new JSType[]{JSAnyType.get((PsiElement)rawqualifier, false)}) : result2;
        if (arrayList == null) {
            JSTypeEvaluator.$$$reportNull$$$0(100);
        }
        return arrayList;
    }

    @NotNull
    protected final List<JSType> getComponentTypeWithExpandingComposite(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(101);
            }
            return list;
        }
        if (type instanceof JSCompositeTypeImpl) {
            ArrayList result2 = ContainerUtil.newArrayList();
            for (JSType typeOption : ((JSCompositeTypeImpl)type).getTypes()) {
                result2.addAll(this.getComponentTypeFromProcessor(rawqualifier, typeOption));
            }
            ArrayList arrayList = result2;
            if (arrayList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(102);
            }
            return arrayList;
        }
        JSTypeSource prevSource = type.getSource();
        if ((type = JSTypeUtils.getIndexableComponentType(type)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(103);
            }
            return list;
        }
        type = JSTypeUtils.copyWithStrict(type, prevSource.isStrict() && type.isSourceStrict());
        List<JSType> list = Collections.singletonList(type);
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(104);
        }
        return list;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        JSType type;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(105);
        }
        if ((type = JSTypeEvaluator.getTypeFromConstant(rawqualifier)) != null) {
            if (type instanceof JSStringLiteralTypeImpl && this.getContextualExpectedTypeKind() == JSExpectedTypeKind.CONTEXTUAL) {
                PsiElement parent = rawqualifier.getParent();
                JSType keyType = TypeScriptLiteralKeyUtil.modifyStringLiteralTypeForTaggedLiteralType(rawqualifier, (JSStringLiteralTypeImpl)type, parent);
                if (keyType != null) {
                    this.addType(keyType, (PsiElement)rawqualifier);
                    return;
                }
                keyType = TypeScriptLiteralKeyUtil.modifyStringLiteralTypeByContextualType(rawqualifier, (JSStringLiteralTypeImpl)type);
                if (keyType != null) {
                    this.addType(keyType, (PsiElement)rawqualifier);
                    return;
                }
            }
            this.addType(type, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(106);
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        String type = JSTypeEvaluator.detectTypeByExpression(rawqualifier);
        if (type == "number" && DialectDetector.isActionScript((PsiElement)rawqualifier)) {
            String text = JSTypeEvaluator.getConstantLiteralText(rawqualifier);
            if (text != null && text.indexOf(46) == -1) {
                return JSTypeEvaluator.createConstantNamedType("int", rawqualifier);
            }
            return JSTypeEvaluator.createConstantNamedType(type, rawqualifier);
        }
        if (type == "number" && JSTypeEvaluator.isBigIntLiteral(rawqualifier)) {
            type = "bigint";
        }
        if ((type == "XMLList" || type == "XML") && (DialectDetector.isTypeScript((PsiElement)rawqualifier) || DialectDetector.isJSX((PsiElement)rawqualifier))) {
            return null;
        }
        if (type == "string" || DialectDetector.isTypeScript((PsiElement)rawqualifier) && (type == "number" || type == "boolean" || type == "bigint")) {
            Number literal;
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true, false);
            if (type == "string" && !DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier.getTextLength() > 4096) {
                return new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
            }
            String literalText = JSTypeEvaluator.getConstantLiteralText(rawqualifier);
            if (literalText == null) {
                literalText = "";
            }
            if (type == "string" && literalText.length() >= 2) {
                String literal2 = literalText.substring(1, literalText.length() - 1);
                return new JSStringLiteralTypeImpl(literal2, true, typeSource);
            }
            if (type == "boolean" && ("true".equals(literalText) || "false".equals(literalText))) {
                return new JSBooleanLiteralTypeImpl("true".equals(literalText), true, typeSource);
            }
            if (type == "number" && literalText.length() > 0 && (literal = JSNumberParser.tryParseNumericValue(literalText, true)) != null) {
                return new JSNumberLiteralTypeImpl((Double)literal, true, typeSource, literalText);
            }
            if (type == "bigint" && literalText.length() > 0 && (literal = JSNumberParser.tryParseBigInt(literalText)) != null) {
                return new JSBigIntLiteralTypeImpl((BigInteger)literal, true, typeSource, literalText);
            }
        }
        return type != null ? JSTypeEvaluator.createConstantNamedType(type, rawqualifier) : null;
    }

    private static boolean isBigIntLiteral(@NotNull JSExpression rawqualifier) {
        IElementType sign;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(107);
        }
        if (rawqualifier instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)rawqualifier).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            rawqualifier = ((JSPrefixExpression)rawqualifier).getExpression();
        }
        return rawqualifier instanceof JSLiteralExpression && ((JSLiteralExpression)rawqualifier).isBigInteger() && DialectDetector.hasFeature((PsiElement)rawqualifier, JSLanguageFeature.BIG_INT);
    }

    @NotNull
    private static JSType createConstantNamedType(@NotNull String name, @NotNull JSExpression rawqualifier) {
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(108);
        }
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(109);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true, false);
        JSType jSType = JSNamedTypeFactory.createType(name, typeSource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(110);
        }
        return jSType;
    }

    @Nullable
    private static String detectTypeByExpression(@NotNull JSExpression rawqualifier) {
        IElementType constantType;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(111);
        }
        if (rawqualifier instanceof JSPrefixExpression && JSSymbolUtil.isLiteralOrLiteralWithSign(rawqualifier)) {
            return "number";
        }
        ASTNode childNode = rawqualifier.getNode().getFirstChildNode();
        IElementType iElementType = constantType = childNode != null ? childNode.getElementType() : null;
        return constantType == JSTokenTypes.STRING_LITERAL || constantType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL || constantType == JSTokenTypes.BACKQUOTE ? "string" : (constantType == JSTokenTypes.NUMERIC_LITERAL ? "number" : (constantType == JSTokenTypes.REGEXP_LITERAL ? "RegExp" : (constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : (constantType == JSTokenTypes.XML_START_TAG_LIST ? "XMLList" : (constantType == JSTokenTypes.TRUE_KEYWORD || constantType == JSTokenTypes.FALSE_KEYWORD ? "boolean" : (constantType == JSTokenTypes.NULL_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "null" : (constantType == JSTokenTypes.UNDEFINED_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "undefined" : null)))))));
    }

    @Nullable
    private static String getConstantLiteralText(@NotNull JSExpression jsExpression) {
        if (jsExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(112);
        }
        String prefix = null;
        if (jsExpression instanceof JSPrefixExpression) {
            IElementType sign = ((JSPrefixExpression)jsExpression).getOperationSign();
            if (sign == JSTokenTypes.MINUS) {
                prefix = "-";
            }
            jsExpression = ((JSPrefixExpression)jsExpression).getExpression();
        }
        if (jsExpression == null) {
            return null;
        }
        ASTNode node = jsExpression.getNode();
        ASTNode childNode = node.getFirstChildNode();
        String text = childNode.getText();
        if (prefix != null && text.length() > 0) {
            return prefix + text;
        }
        return text;
    }

    private boolean addAdditionalTypes(@NotNull JSReferenceExpression localQualifier, @NotNull JSReferenceExpression qualifier) {
        Runnable addTypeRunnable;
        JSApplyContextElement peek;
        if (localQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(113);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(114);
        }
        if (DialectDetector.isTypeScript((PsiElement)localQualifier)) {
            return false;
        }
        boolean hasSomeType = false;
        if (JSSymbolUtil.isAccurateReferenceExpressionName(localQualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(localQualifier, JQUERY_NS) || JSSymbolUtil.isAccurateReferenceExpressionName(localQualifier, JQUERY_NS, "$")) {
            peek = this.myContext.peekJSElementToApply();
            addTypeRunnable = () -> {
                if (localQualifier == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(139);
                }
                this.addJQueryType((PsiElement)localQualifier);
            };
            if (peek instanceof JSApplyCallElement) {
                this.myContext.processWithoutTopJSElementToApply(addTypeRunnable);
            } else {
                addTypeRunnable.run();
            }
            hasSomeType = true;
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, JQUERY_NS)) {
            peek = this.myContext.peekJSElementToApply();
            addTypeRunnable = () -> {
                if (localQualifier == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(138);
                }
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
                this.addType(JSNamedTypeFactory.createType("HTMLElement", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            };
            if (peek instanceof JSApplyCallElement) {
                this.myContext.processWithoutTopJSElementToApply(addTypeRunnable);
            } else {
                addTypeRunnable.run();
            }
            hasSomeType = true;
        } else if ("getComponentById".equals(qualifier.getReferenceName())) {
            hasSomeType |= this.tryAddBindowsType(qualifier);
        }
        return hasSomeType;
    }

    private void addJQueryType(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(115);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, false);
        this.addType(JSNamedTypeFactory.createType(JQUERY_NS, typeSource, JSContext.UNKNOWN), source);
    }

    private boolean tryAddBindowsType(JSReferenceExpression qualifier) {
        JSIndexContent content;
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies;
        PsiFile containingFile;
        PsiElement element = qualifier.getParent();
        if (!(element instanceof JSCallExpression)) {
            return false;
        }
        JSArgumentList argumentList = ((JSCallExpression)element).getArgumentList();
        if (argumentList == null) {
            return false;
        }
        JSExpression[] expressions = argumentList.getArguments();
        if (expressions.length == 0 || !(expressions[0] instanceof JSLiteralExpression)) {
            return false;
        }
        String val = StringUtil.unquoteString((String)expressions[0].getText());
        PsiElement contextElement = qualifier.getContainingFile().getContext();
        if (contextElement != null && JSTagContextBuilder.isBindowsXml(containingFile = contextElement.getContainingFile()) && (proxies = (content = JSIndexContent.get(containingFile)).getImplicitElements().get(val)) != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                XmlTag tag;
                PsiElement elementAtOffset = proxy.toOffsetBasedImplicitElement(containingFile).getElementAtOffset();
                if (elementAtOffset == null || (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, XmlTag.class)) == null) continue;
                JSType type = JSNamedTypeFactory.createType(JSTagContextBuilder.getTypeName(tag), JSTypeSourceFactory.createTypeSource(elementAtOffset, false), JSContext.UNKNOWN);
                this.myTypeProcessor.process(type, this.myContext, elementAtOffset);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    protected void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        if (!(peek instanceof JSApplyPropertyElement) || !this.getEvaluationContext().isAstAccessAllowed()) {
            JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
            this.addType(recordType, (PsiElement)expression);
        } else {
            this.myContext.processWithoutTopJSElementToApply(() -> {
                JSDestructuringProperty destructuringProperty = ((JSApplyPropertyElement)peek).getProperty();
                if (destructuringProperty.isRest()) {
                    JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
                    JSApplyContextUtil.processDestructuringProperty((JSApplyPropertyElement)peek, recordType, (newType, newElement) -> this.addType((JSType)newType, (PsiElement)newElement));
                } else {
                    JSProperty property = expression.findProperty(destructuringProperty.getName());
                    if (property != null) {
                        this.addTypeFromProperty(property);
                    }
                }
            });
        }
    }

    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            JSObjectType jSObjectType = new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
            if (jSObjectType == null) {
                JSTypeEvaluator.$$$reportNull$$$0(116);
            }
            return jSObjectType;
        }
        JSElement[] properties = expression.getPropertiesIncludingSpreads();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true, false);
        HashMap propertyMembers = ContainerUtil.newHashMap();
        ArrayList nonPropertyMembers = ContainerUtil.newArrayList();
        ArrayList syntheticStringIndexerTypes = ContainerUtil.newArrayList();
        ArrayList syntheticNumericIndexerTypes = ContainerUtil.newArrayList();
        ArrayList genericSpreadItems = ContainerUtil.newArrayList();
        boolean hasComputedProps = false;
        for (JSElement property : properties) {
            JSType spreadType;
            if (property instanceof JSProperty) {
                ES6ComputedName computedPropertyName;
                JSRecordType.PropertySignature member = this.getTypeMemberFromSimplePropertyValue((JSProperty)property, evaluatePropertyTypes);
                if (member != null) {
                    propertyMembers.put(member.getMemberName(), member);
                }
                boolean hasComputedName = false;
                if (property instanceof JSComputedPropertyNameOwner && (computedPropertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName()) != null) {
                    hasComputedName = true;
                    hasComputedProps = true;
                    JSExpression jsExpression = computedPropertyName.getExpression();
                    JSType propNameType = this.getExpressionTypeInContext(jsExpression);
                    JSType propNameValuableType = JSTypeUtils.getValuableType(propNameType);
                    if (propNameValuableType instanceof JSStringType) {
                        ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)JSTypeEvaluator.getWidenedPropertyType(property));
                    }
                    if (propNameValuableType instanceof JSNumberType) {
                        JSType widenedPropertyType = JSTypeEvaluator.getWidenedPropertyType(property);
                        ContainerUtil.addIfNotNull((Collection)syntheticNumericIndexerTypes, (Object)widenedPropertyType);
                        ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)widenedPropertyType);
                    }
                }
                if (hasComputedName) continue;
                ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)JSTypeEvaluator.getWidenedPropertyType(property));
                continue;
            }
            if (!(property instanceof JSSpreadExpression) || !evaluatePropertyTypes || (spreadType = this.getObjectLiteralPropertyValueType(((JSSpreadExpression)property).getExpression())) == null) continue;
            if (spreadType instanceof JSAnyType) {
                JSTypeSource source = spreadType.getSource();
                Object object = spreadType.isTypeScript() ? spreadType : new JSRecordTypeImpl(source, Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, source, JSTypeContext.INSTANCE), spreadType, JSRecordMemberSourceFactory.createSource(spreadType.getSourceElement()))));
                if (object == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(117);
                }
                return object;
            }
            if (JSTypeUtils.hasForeignGenericParameter(spreadType)) {
                genericSpreadItems.add(spreadType);
                continue;
            }
            for (JSRecordType.TypeMember member : spreadType.asRecordType().getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    propertyMembers.put(((JSRecordType.PropertySignature)member).getMemberName(), member);
                    continue;
                }
                nonPropertyMembers.add(member);
            }
        }
        if (hasComputedProps && syntheticStringIndexerTypes.size() > 0) {
            nonPropertyMembers.add(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(typeSource, syntheticStringIndexerTypes)), (PsiElement)null));
        }
        if (hasComputedProps && syntheticNumericIndexerTypes.size() > 0) {
            nonPropertyMembers.add(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(typeSource, syntheticNumericIndexerTypes)), (PsiElement)null));
        }
        JSFreshObjectLiteralTypeImpl literalType = new JSFreshObjectLiteralTypeImpl(typeSource, ContainerUtil.concat((List)nonPropertyMembers, (List)ContainerUtil.newArrayList(propertyMembers.values())));
        if (genericSpreadItems.size() == 0) {
            JSFreshObjectLiteralTypeImpl jSFreshObjectLiteralTypeImpl = literalType;
            if (jSFreshObjectLiteralTypeImpl == null) {
                JSTypeEvaluator.$$$reportNull$$$0(118);
            }
            return jSFreshObjectLiteralTypeImpl;
        }
        genericSpreadItems.add(literalType);
        JSType jSType = JSCompositeTypeImpl.optimizeTypeIfComposite(new JSIntersectionTypeImpl(typeSource, genericSpreadItems));
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(119);
        }
        return jSType;
    }

    @Nullable
    private static JSType getWidenedPropertyType(JSElement property) {
        return JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(((JSProperty)property).getType()));
    }

    @Nullable
    private JSRecordType.PropertySignature getTypeMemberFromSimplePropertyValue(@NotNull JSProperty property, boolean evaluatePropertyTypes) {
        String name;
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(120);
        }
        if ((name = property.getName()) == null && property instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
        }
        if (name == null) {
            return null;
        }
        Object type = null;
        if (evaluatePropertyTypes) {
            type = property instanceof ES6FunctionProperty ? TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunction)property)) : this.getObjectLiteralPropertyValueType(property.getValue());
        }
        type = JSTypeEvaluator.modifyTypeIfAccessor(property, type);
        return new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)type, false, (PsiElement)property);
    }

    @Nullable
    private static JSType modifyTypeIfAccessor(@NotNull JSProperty property, @Nullable JSType type) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(121);
        }
        boolean isGetter = property.isGetProperty();
        boolean isSetter = property.isSetProperty();
        if (!isGetter && !isSetter) {
            return type;
        }
        if (type instanceof JSFunctionTypeImpl) {
            if (isGetter) {
                return ((JSFunctionTypeImpl)type).getReturnType();
            }
            List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
            if (parameters.size() >= 1) {
                return parameters.get(0).getType();
            }
        }
        return JSAnyType.get(JSTypeSourceFactory.createTypeSource((PsiElement)property, false));
    }

    private JSType getObjectLiteralPropertyValueType(@Nullable JSExpression expression) {
        return this.getExpressionTypeWithGuard(expression, true);
    }

    protected void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        boolean evaluateInitializer;
        boolean canHaveType;
        JSExpression initializer;
        JSType jsType;
        if (psiElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(122);
        }
        if ((jsType = psiElement.getType()) != null) {
            boolean isStrict = jsType.getSource().isStrict();
            if (isStrict) {
                this.addType(jsType, (PsiElement)psiElement);
            } else {
                this.addType(jsType, (PsiElement)psiElement);
            }
            if (isStrict) {
                return;
            }
        }
        JSFunctionExpression functionExpression = (initializer = psiElement.getInitializerOrStub()) instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null;
        boolean bl = canHaveType = functionExpression != null && !this.myContext.isJSElementsToApplyEmpty();
        if (canHaveType && this.processFunction((JSFunction)functionExpression)) {
            return;
        }
        boolean bl2 = evaluateInitializer = !this.myContext.isTypeGuessed() || CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)psiElement));
        if (evaluateInitializer) {
            boolean initializerProcessed = false;
            if (this.isFromCurrentFile((PsiElement)psiElement)) {
                JSExpression expr = JSPsiImplUtils.getRightmostOperand(psiElement);
                if (expr != null) {
                    this.evaluateCachedTypes(expr);
                    initializerProcessed = true;
                }
            } else if (initializer != null) {
                this.getEvaluationContext().withAstAccessForbidden(() -> this.evaluateCachedTypes(initializer));
            }
            if (!initializerProcessed) {
                this.tryAddTypeFromInitializerReference((PsiElement)psiElement);
            }
        }
        if (!canHaveType && jsType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)psiElement);
        }
        String type = psiElement.getQualifiedName();
        if (psiElement.isNamespaceExplicitlyDeclared() && type != null) {
            JSContext jsContext = this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement ? JSContext.INSTANCE : JSContext.STATIC;
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement);
            boolean explicitType = comment != null && comment.hasNamespaceTag();
            JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(type);
            boolean isLocal = CommonJSUtil.isExportNamespace(name);
            JSDocComment source = comment != null ? comment : psiElement;
            JSNamespace namespace = JSNamedTypeFactory.createNamespace(name, jsContext, (PsiElement)source, explicitType, true, isLocal);
            this.addNamespace(namespace, (PsiElement)(explicitType ? EXPLICIT_TYPE_MARKER_ELEMENT : psiElement));
        }
    }

    protected boolean tryAddTypeFromInitializerReference(@NotNull PsiElement resolveResult) {
        String initializerReference;
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(123);
        }
        String string = resolveResult instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolveResult).getInitializerReference() : (resolveResult instanceof JSProperty ? ((JSProperty)resolveResult).getInitializerReference() : (resolveResult instanceof JSVariable ? ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText() : (initializerReference = resolveResult instanceof JSExportAssignment ? ((JSExportAssignment)resolveResult).getInitializerReference() : null)));
        if (initializerReference == null || StringUtil.isQuotedString((String)initializerReference)) {
            return false;
        }
        PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult);
        if (localResolve instanceof JSNamedElement) {
            this.processItem(localResolve, JSEvaluateContext.JSEvaluationPlace.DEFAULT, e -> this.addTypeFromResolveResult((PsiElement)e));
            return true;
        }
        return false;
    }

    @NotNull
    protected JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = JSExpectedTypeKind.CONTEXTUAL;
        if (jSExpectedTypeKind == null) {
            JSTypeEvaluator.$$$reportNull$$$0(124);
        }
        return jSExpectedTypeKind;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = this.getExpressionTypeInContext(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    protected <T extends PsiElement> boolean processItem(@NotNull T element, @NotNull JSEvaluateContext.JSEvaluationPlace place, @NotNull Consumer<T> runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(125);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(126);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(127);
        }
        if (!JSTypeEvaluator.processWithEvaluationGuard(element, place, runnable)) {
            if (this.myTypeProcessor instanceof QualifiedItemProcessor) {
                ((QualifiedItemProcessor)this.myTypeProcessor).resolved = QualifiedItemProcessor.TypeResolveState.Undefined;
            }
            return false;
        }
        return true;
    }

    public static boolean canProcessWithEvaluationGuard(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        JSRecursionGuard context;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(128);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(129);
        }
        return (context = recursionGuardHolder.get()) == null || !context.isAlreadyProcessingItem(element, place);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PsiElement> boolean processWithEvaluationGuard(@NotNull T element, @NotNull JSEvaluateContext.JSEvaluationPlace place, @NotNull Consumer<T> runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(130);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(131);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(132);
        }
        JSRecursionGuard context = recursionGuardHolder.get();
        boolean created = false;
        if (context == null) {
            context = new JSRecursionGuard();
            recursionGuardHolder.set(context);
            created = true;
        }
        if (!created && context.isAlreadyProcessingItem(element, place)) {
            return false;
        }
        context.addProcessingItem(element, place);
        try {
            runnable.accept(element);
            boolean bl = true;
            return bl;
        }
        finally {
            context.removeProcessingItem(element, place);
            if (created) {
                recursionGuardHolder.set(null);
            }
        }
    }

    @Contract(value="null,_->null")
    public static JSType getExpressionTypeWithGuard(@Nullable JSExpression expression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(133);
        }
        if (expression == null) {
            return null;
        }
        return JSResolveUtil.getElementJSType((PsiElement)expression, place);
    }

    @Nullable
    public JSType getExpressionTypeWithGuard(@Nullable JSExpression expression, boolean widenIfNeeded) {
        if (expression == null) {
            return null;
        }
        JSType expressionType = this.getExpressionTypeInContext(expression);
        return widenIfNeeded ? this.widenExpressionTypeByContextualType(expression, DialectDetector.isTypeScript((PsiElement)expression), expressionType) : expressionType;
    }

    protected void applyContextAndProcessResolvedElement(@NotNull PsiElement resolve) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(134);
        }
        if (this.myContext.peekJSElementToApply() instanceof JSApplyPropertyElement) {
            this.myContext.processWithoutTopJSElementToApply((Processor<? super JSApplyContextElement>)((Processor)peek -> {
                if (resolve == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(137);
                }
                return this.applyDestructuringPropertyAndProcessResolvedElement(resolve, (JSApplyPropertyElement)peek);
            }));
            return;
        }
        this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
    }

    private boolean applyDestructuringPropertyAndProcessResolvedElement(@NotNull PsiElement resolve, @NotNull JSApplyPropertyElement property) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(135);
        }
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(136);
        }
        final String name = property.getName();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JSPsiNamedElementBase) || name.equals(((JSPsiNamedElementBase)element).getName())) {
                    JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXPORTED_ELEMENT, JSTypeEvaluator.this::addTypeFromResolveResult);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        if (place == null) {
            place = resolve;
        }
        return QualifiedItemProcessor.processResolvedElement(resolve, new JSEvaluateContext(this.myContext.targetFile), processor, (PsiElement)place);
    }

    private /* synthetic */ void lambda$addTypeFromModuleFile$22(PsiElement finalExportedElement, JSType newType, JSEvaluationResultContext newContext) {
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)typeComponent -> {
            if (!(typeComponent instanceof JSNamedType && finalExportedElement instanceof JSElementBase && typeComponent.getTypeText().equals(((JSElementBase)finalExportedElement).getQualifiedName()))) {
                this.addType((JSType)typeComponent, null);
            }
            return true;
        }), newType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 70: 
            case 75: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 110: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 70: 
            case 75: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 110: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 13: 
            case 17: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 23: 
            case 35: 
            case 36: 
            case 56: 
            case 58: 
            case 126: 
            case 129: 
            case 131: 
            case 133: 
            case 147: 
            case 148: 
            case 151: 
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: 
            case 18: 
            case 21: 
            case 22: 
            case 24: 
            case 82: 
            case 87: 
            case 92: 
            case 95: 
            case 125: 
            case 128: 
            case 130: 
            case 156: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: 
            case 54: 
            case 73: 
            case 88: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 25: 
            case 28: 
            case 33: 
            case 68: 
            case 152: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 30: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 29: 
            case 34: 
            case 69: 
            case 153: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCall";
                break;
            }
            case 44: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 47: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 70: 
            case 75: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 110: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 51: 
            case 149: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 57: 
            case 59: 
            case 60: 
            case 63: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 62: 
            case 64: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 65: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 67: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 71: 
            case 72: 
            case 141: 
            case 142: 
            case 143: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 74: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 77: 
            case 90: 
            case 94: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 78: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringContainer";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdModuleReference";
                break;
            }
            case 86: 
            case 134: 
            case 135: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 91: 
            case 120: 
            case 121: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsExpression";
                break;
            }
            case 113: 
            case 138: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localQualifier";
                break;
            }
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 127: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeFromExpressions";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createNullType";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationContext";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResultsFromQualifier";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceFromQualifiedNamedElement";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromArrayExpression";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeWithExpandingComposite";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantNamedType";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forceEvaluateType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementTypes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateExpressionOrElementTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addTypeEvaluationResultElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getGuardedTypeByEvaluateContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcess";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcessNamespace";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImportCall";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 70: 
            case 75: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 110: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: {
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeFromSpread";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNewExpressionTypes";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromGclRequireCall";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processRequireMethodCall";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processApplyOrCallMethodCall";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processCreateMethodCall";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromModuleFile";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultExportNamespaces";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstructorName";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "processRefExpr";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResultsFromQualifier";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipProcessing";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeForEnumType";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeGuard";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDestructuringContainer";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModule";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isFromCurrentFile";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCachedTypes";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceContextForClass";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImplicitElementResolveResult";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromProperty";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromQualifiedNamedElement";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addLoopVariable";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstant";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isBigIntLiteral";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createConstantNamedType";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeByExpression";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getConstantLiteralText";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalTypes";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "addJQueryType";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMemberFromSimplePropertyValue";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeIfAccessor";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromDefExpr";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "tryAddTypeFromInitializerReference";
                break;
            }
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "processItem";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "canProcessWithEvaluationGuard";
                break;
            }
            case 130: 
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "processWithEvaluationGuard";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTypeWithGuard";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcessResolvedElement";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "applyDestructuringPropertyAndProcessResolvedElement";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyContextAndProcessResolvedElement$45";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAdditionalTypes$40";
                break;
            }
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAdditionalTypes$39";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processRefExpr$30";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFunction$27";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFunction$25";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFunction$24";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFunction$23";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCreateMethodCall$19";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processApplyOrCallMethodCall$18";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateCallExpressionTypes$17";
                break;
            }
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateNewExpressionTypes$15";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getArrayTypeFromExpressions$14";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$13";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateTypes$11";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyContextAndProcess$10";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyContextAndProcess$9";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementType$2";
                break;
            }
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateExpressionOrElementTypes$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 49: 
            case 53: 
            case 55: 
            case 70: 
            case 75: 
            case 93: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 110: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

