/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.google.common.collect.Streams;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSInsertHandler;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.ES6DefaultAssignmentModuleIndex;
import com.intellij.lang.javascript.psi.stubs.ES6ExportedNamesIndex;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportCompletionUtil {
    @NotNull
    public static final JSInsertHandler IMPORT_INSERT_HANDLER = new JSInsertHandler(){

        @Override
        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            super.handleInsert(context, item);
            ES6ImportCompletionUtil.insertLookupItem(context, item, (Consumer<? super JSElement>)((Consumer)importedElement -> {
                PsiElement originalElement;
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (importedElement != null && (originalElement = context.getFile().findElementAt(context.getStartOffset())) != null) {
                    PsiElement toProcessPlace;
                    PsiElement psiElement = toProcessPlace = originalElement.getNode().getElementType() == JSTokenTypes.IDENTIFIER ? originalElement.getParent() : originalElement;
                    if (toProcessPlace instanceof JSReferenceExpression && toProcessPlace.isValid()) {
                        context.commitDocument();
                        PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
                        if (item.getPsiElement() == null) {
                            JSInsertHandler.insertBracesIfNeed(context, (PsiElement)importedElement, toProcessPlace);
                        }
                    }
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$handleInsert$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static void addExportedVariants(@NotNull JSReferenceExpression expression, @NotNull Iterable<?> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (expression == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(0);
        }
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(1);
        }
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(2);
        }
        assert (expression.getQualifier() == null);
        ES6ImportCompletionUtil.addExportedVariants((PsiElement)expression, sinkResults, completionResultSet);
    }

    public static void addExportedVariants(@NotNull ES6ImportExportSpecifier specifier, @NotNull Iterable<?> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        if (specifier == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(3);
        }
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(4);
        }
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(5);
        }
        ES6ImportCompletionUtil.addExportedVariants((PsiElement)specifier, sinkResults, completionResultSet);
    }

    private static void addExportedVariants(@NotNull PsiElement place, @NotNull Iterable<?> sinkResults, @NotNull CompletionResultSet completionResultSet) {
        int count;
        if (place == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(6);
        }
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(7);
        }
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(8);
        }
        if (ES6ImportCompletionUtil.skipPlace(place)) {
            return;
        }
        PsiFile containingFile = place.getContainingFile();
        PrefixMatcher matcher = completionResultSet.getPrefixMatcher();
        Set addedElements = ES6ImportCompletionUtil.getProcessedElementNames(sinkResults).stream().filter(el -> matcher.prefixMatches(el)).collect(Collectors.toSet());
        int limit = JSCompletionUtil.getCompletionLimit();
        if (!ES6ImportCompletionUtil.checkLimit(completionResultSet, limit, count = addedElements.size())) {
            return;
        }
        Project project = containingFile.getProject();
        JSInsertHandler handler = !(containingFile instanceof JSExpressionCodeFragment) ? IMPORT_INSERT_HANDLER : JSInsertHandler.DEFAULT;
        JSImportPlaceInfo info = new JSImportPlaceInfo(place);
        HashMap needToCheckConfigAccess = ContainerUtil.newHashMap();
        GlobalSearchScope scope = ES6CreateImportUtil.createSymbolToImportSearchScope(project, (PsiElement)containingFile);
        boolean isTypeScript = DialectDetector.isTypeScript(place);
        boolean isImportSpecifier = place instanceof ES6ImportSpecifier;
        boolean skipNodeModulesImports = !DialectDetector.isTypeScript(place) && (!(containingFile instanceof JSFile) || ((JSFile)containingFile).getModuleStatus() != JSFile.ModuleStatus.ES6);
        Predicate<String> filter = el -> !addedElements.contains(el) && matcher.prefixMatches(el);
        Set namedKeys = StubIndex.getInstance().getAllKeys(ES6ExportedNamesIndex.KEY, project).stream().filter(filter).collect(Collectors.toSet());
        ProgressManager.checkCanceled();
        Set defaultAssignmentKeys = !isImportSpecifier ? StubIndex.getInstance().getAllKeys(ES6DefaultAssignmentModuleIndex.KEY, project).stream().filter(filter).collect(Collectors.toSet()) : Collections.emptySet();
        List names = Streams.concat((Stream[])new Stream[]{namedKeys.stream(), defaultAssignmentKeys.stream()}).sorted().collect(Collectors.toList());
        for (String string : names) {
            ProgressManager.checkCanceled();
            if (!ES6ImportCompletionUtil.checkLimit(completionResultSet, limit, count)) {
                return;
            }
            HashSet elements = ContainerUtil.newHashSet();
            Predicate<JSElement> elementFilter = element -> ES6ImportCompletionUtil.isAcceptableForImport(info, isImportSpecifier, element);
            if (namedKeys.contains(string)) {
                StubIndex.getElements(ES6ExportedNamesIndex.KEY, (Object)string, (Project)project, (GlobalSearchScope)scope, JSElement.class).stream().filter(elementFilter).forEach(elements::add);
            }
            ProgressManager.checkCanceled();
            if (defaultAssignmentKeys.contains(string)) {
                StubIndex.getElements(ES6DefaultAssignmentModuleIndex.KEY, (Object)string, (Project)project, (GlobalSearchScope)scope, JSExportAssignment.class).stream().filter(elementFilter).forEach(elements::add);
            }
            if (elements.isEmpty()) continue;
            if (elements.stream().anyMatch(el -> ES6ImportCompletionUtil.needToCheckConfigAccess(el.getContainingFile(), isTypeScript))) {
                needToCheckConfigAccess.putIfAbsent(string, elements);
                continue;
            }
            ES6ImportCompletionUtil.fillLookupItemForElements(completionResultSet, handler, skipNodeModulesImports, string, elements);
            ++count;
        }
        for (Map.Entry entry : needToCheckConfigAccess.entrySet()) {
            ProgressManager.checkCanceled();
            if (!ES6ImportCompletionUtil.checkLimit(completionResultSet, limit, count)) {
                return;
            }
            String name = (String)entry.getKey();
            Collection elements = (Collection)entry.getValue();
            Set collect = (Set)((StreamEx)StreamEx.of((Collection)elements).filter(el -> TypeScriptConfigService.Provider.isAccessible(project, info.getFile(), el.getContainingFile().getVirtualFile()))).collect(Collectors.toSet());
            if (collect.isEmpty()) continue;
            ES6ImportCompletionUtil.fillLookupItemForElements(completionResultSet, handler, skipNodeModulesImports, name, collect);
            ++count;
        }
    }

    private static boolean checkLimit(@NotNull CompletionResultSet completionResultSet, int limit, int count) {
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(9);
        }
        if (count <= limit) {
            return true;
        }
        JSCompletionUtil.handleOverflow(completionResultSet);
        return false;
    }

    private static boolean needToCheckConfigAccess(@NotNull PsiFile file2, boolean isTypeScript) {
        if (file2 == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(10);
        }
        return isTypeScript && (!(file2 instanceof JSFile) || !((JSFile)file2).isCommonJSModule());
    }

    private static boolean isAcceptableForImport(JSImportPlaceInfo info, boolean isImportSpecifier, JSElement element) {
        if (element instanceof ES6ExportSpecifier && !ES6CreateImportUtil.isAcceptableExportSpecifier((ES6ExportSpecifier)element)) {
            return false;
        }
        return element instanceof JSExportAssignment || (isImportSpecifier ? ES6ImportHandler.isExternalModuleExport(element) : ES6CreateImportUtil.isAvailableForImport((PsiElement)element, info));
    }

    private static boolean skipPlace(@Nullable PsiElement place) {
        return TypeScriptPsiUtil.isTsIndexerType(place);
    }

    @NotNull
    public static Set<String> getProcessedElementNames(@NotNull Iterable sinkResults) {
        if (sinkResults == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(11);
        }
        THashSet addedElements = new THashSet();
        for (Object object : sinkResults) {
            if (object instanceof LookupElement) {
                addedElements.add((Object)((LookupElement)object).getLookupString());
                continue;
            }
            if (!(object instanceof JSElement)) continue;
            addedElements.add((Object)ES6ImportPsiUtil.getExportedElementName((JSElement)object));
        }
        THashSet tHashSet = addedElements;
        if (tHashSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(12);
        }
        return tHashSet;
    }

    private static void fillLookupItemForElements(@NotNull CompletionResultSet completionResultSet, JSInsertHandler handler, boolean skipNodeModulesImports, String name, Collection<JSElement> elements) {
        if (completionResultSet == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(13);
        }
        JSElement first = elements.iterator().next();
        JSElement toImport = elements.size() > 1 ? null : first;
        LookupElement element = ES6ImportCompletionUtil.createLookupElement(name, (PsiElement)first, handler, (PsiElement)toImport, skipNodeModulesImports);
        completionResultSet.addElement(element);
    }

    @NotNull
    private static LookupElement createLookupElement(@NotNull String name, @NotNull PsiElement element, @NotNull InsertHandler<LookupElement> handler, @Nullable PsiElement toImport, boolean skipNodeModulesImports) {
        if (name == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(14);
        }
        if (element == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(16);
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        boolean needInsertHandler = !skipNodeModulesImports || file2 == null || !NodeModuleUtil.hasNodeModulesDirInPath(file2, null);
        LookupElementBuilder base = toImport == null ? LookupElementBuilder.create((String)name).withTypeText(JSBundle.message((String)"javascript.completion.several.definitions", (Object[])new Object[0]), true) : JSLookupUtilImpl.createLookupElement(toImport, name);
        LookupElement lookupElement = JSCompletionUtil.withJSLookupPriority((LookupElement)base.withBoldness(false).withInsertHandler(needInsertHandler ? handler : null).withIcon(JSLookupUtilImpl.getIcon(element, false)), JSLookupPriority.NO_RELEVANT_NO_SMARTNESS_PRIORITY);
        if (lookupElement == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(17);
        }
        return lookupElement;
    }

    public static void insertLookupItem(@NotNull InsertionContext context, @NotNull LookupElement item, @Nullable Consumer<? super JSElement> afterInsert) {
        if (context == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(18);
        }
        if (item == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(19);
        }
        context.commitDocument();
        CaretModel model = context.getEditor().getCaretModel();
        if (model.getCaretCount() > 1 && model.getPrimaryCaret() != model.getCurrentCaret()) {
            return;
        }
        PsiElement originalElement = context.getFile().findElementAt(context.getStartOffset());
        if (originalElement == null || !ES6ImportCompletionUtil.shouldAddImportFromCompletion(originalElement)) {
            return;
        }
        String name = item.getLookupString();
        PsiElement psiElement = item.getPsiElement();
        ES6ImportAction action = ES6CreateImportUtil.createImportAction(context.getEditor(), originalElement, name, null, ES6ImportAction.DEFAULT_FILTER);
        if (psiElement instanceof JSElement) {
            action.executeFor((JSElement)psiElement, afterInsert);
        } else {
            action.executeForAllVariants(afterInsert);
        }
    }

    private static boolean shouldAddImportFromCompletion(@NotNull PsiElement element) {
        if (element == null) {
            ES6ImportCompletionUtil.$$$reportNull$$$0(20);
        }
        JSApplicationSettings settings = JSApplicationSettings.getInstance();
        return DialectDetector.isTypeScript(element) ? settings.hasTSImportCompletionEffective(element.getProject()) : settings.isUseJavaScriptAutoImport();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResults";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResultSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/completion/ES6ImportCompletionUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedElementNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addExportedVariants";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkLimit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "needToCheckConfigAccess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedElementNames";
                break;
            }
            case 12: 
            case 17: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fillLookupItemForElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "insertLookupItem";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddImportFromCompletion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

