/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.descriptor;

import com.intellij.util.ArrayUtil;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public enum CssContextType {
    ANY("any", "everywhere", true),
    NONE("none", "root of file", true),
    NONAME("noname", "regular ruleset", true),
    PAGE("@page", "@page", false),
    JQUERY("@jquery", "jquery selector", true),
    KEYFRAMES("@keyframes", "@keyframes", true),
    CHARSET("@charset", "@charset", true),
    MEDIA("@media", "@media", true),
    NAMESPACE("@namespace", "@namespace", true),
    FONTFACE("@font-face", "@font-face", false),
    VIEWPORT("@viewport", "@viewport", false),
    SUPPORTS("@supports", "@supports", false),
    PAGE_MARGIN("page-margin", "page margin rule", false),
    COLOR_PROFILE("@color-profile", "@color-profile", false),
    COUNTER_STYLE("@counter-style", "@counter-style", false),
    UNKNOWN("unknown", "unknown", false);

    public static final String[] PAGE_MARGIN_RULES;
    public static final Comparator<? super CssContextType> COMPARATOR;
    private final String myName;
    @NotNull
    private final String myPresentationName;
    public static final CssContextType[] EMPTY_ARRAY;
    private final boolean mySubsetOfAny;

    private CssContextType(String name, String presentationName, boolean isSubsetOfAny) {
        if (presentationName == null) {
            CssContextType.$$$reportNull$$$0(0);
        }
        this.myName = name;
        this.myPresentationName = presentationName;
        this.mySubsetOfAny = isSubsetOfAny;
    }

    @NotNull
    public static CssContextType fromString(@NotNull String s) {
        if (s == null) {
            CssContextType.$$$reportNull$$$0(1);
        }
        for (CssContextType type : CssContextType.values()) {
            if (!s.equals(type.getName())) continue;
            CssContextType cssContextType = type;
            if (cssContextType == null) {
                CssContextType.$$$reportNull$$$0(2);
            }
            return cssContextType;
        }
        if (ArrayUtil.contains((String)s, (String[])PAGE_MARGIN_RULES)) {
            CssContextType cssContextType = PAGE_MARGIN;
            if (cssContextType == null) {
                CssContextType.$$$reportNull$$$0(3);
            }
            return cssContextType;
        }
        throw new IllegalArgumentException("Unknown context type '" + s + "'");
    }

    private String getName() {
        return this.myName;
    }

    public boolean isSubsetOfAny() {
        return this.mySubsetOfAny;
    }

    @NotNull
    private String getPresentationName() {
        String string = this.myPresentationName;
        if (string == null) {
            CssContextType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.getPresentationName();
        if (string == null) {
            CssContextType.$$$reportNull$$$0(5);
        }
        return string;
    }

    static {
        PAGE_MARGIN_RULES = new String[]{"@top-left-corner", "@top-left", "@top-center", "@top-right", "@top-right-corner", "@bottom-left-corner", "@bottom-left", "@bottom-center", "@bottom-right", "@bottom-right-corner", "@left-top", "@left-middle", "@left-bottom", "@right-top", "@right-middle", "@right-bottom"};
        COMPARATOR = (o1, o2) -> o2.getName().compareTo(o1.getName());
        EMPTY_ARRAY = new CssContextType[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/descriptor/CssContextType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/descriptor/CssContextType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

