/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.List;

public class XMLMutationUtils {
    private XMLMutationUtils() {
    }

    public static void replaceTag(XmlTag tag, String newTag) throws IncorrectOperationException {
        PsiManager manager = tag.getManager();
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)manager.getProject());
        XmlTag replacementTag = HtmlUtil.isHtmlTag((XmlTag)tag) ? elementFactory.createHTMLTagFromText(newTag) : elementFactory.createTagFromText((CharSequence)newTag);
        PsiElement replacedTag = tag.replace((PsiElement)replacementTag);
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        styleManager.reformat(replacedTag);
    }

    public static String calculateStartTagString(XmlTag tag) {
        PsiElement[] children;
        StringBuilder out = new StringBuilder();
        for (PsiElement child : children = tag.getChildren()) {
            IElementType tokenType;
            String childText = child.getText();
            out.append(childText);
            if (child instanceof XmlToken && ((tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_TAG_END) || tokenType.equals(XmlTokenType.XML_EMPTY_ELEMENT_END))) break;
        }
        return out.toString();
    }

    public static String calculateContentsString(XmlTag tag) {
        StringBuilder out = new StringBuilder();
        PsiElement[] children = tag.getChildren();
        boolean inContents = false;
        for (PsiElement child : children) {
            IElementType tokenType;
            if (child instanceof XmlToken && (tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_END_TAG_START)) {
                inContents = false;
            }
            if (inContents) {
                String childText = child.getText();
                out.append(childText);
            }
            if (!(child instanceof XmlToken) || !(tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_TAG_END)) continue;
            inContents = true;
        }
        return out.toString();
    }

    public static List<PsiElement> calculateContents(XmlTag tag) {
        ArrayList<PsiElement> out = new ArrayList<PsiElement>();
        PsiElement[] children = tag.getChildren();
        boolean inContents = false;
        for (PsiElement child : children) {
            IElementType tokenType;
            if (child instanceof XmlToken && (tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_END_TAG_START)) {
                inContents = false;
            }
            if (inContents) {
                out.add(child);
            }
            if (!(child instanceof XmlToken) || !(tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_TAG_END)) continue;
            inContents = true;
        }
        return out;
    }

    public static String calculateEndTagString(XmlTag tag) {
        StringBuilder out = new StringBuilder();
        PsiElement[] children = tag.getChildren();
        boolean inEndTag = false;
        for (PsiElement child : children) {
            IElementType tokenType;
            if (child instanceof XmlToken && (tokenType = ((XmlToken)child).getTokenType()).equals(XmlTokenType.XML_END_TAG_START)) {
                inEndTag = true;
            }
            if (!inEndTag) continue;
            String childText = child.getText();
            out.append(childText);
        }
        return out.toString();
    }

    public static boolean tagHasContents(XmlTag tag) {
        IElementType tokenType;
        PsiElement[] children = tag.getChildren();
        PsiElement lastChild = children[children.length - 1];
        return !(lastChild instanceof XmlToken) || !(tokenType = ((XmlToken)lastChild).getTokenType()).equals(XmlTokenType.XML_EMPTY_ELEMENT_END);
    }

    public static boolean isSpecialJSPTag(XmlTag xmlTag) {
        PsiElement firstChild = xmlTag.getFirstChild();
        assert (firstChild != null);
        String text = firstChild.getText();
        return !"<".equals(text);
    }
}

