/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.tools.ant.BuildException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IvyArtifactReport
extends IvyPostResolveTask {
    private File tofile;
    private String pattern;

    public File getTofile() {
        return this.tofile;
    }

    public void setTofile(File file) {
        this.tofile = file;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (this.tofile == null) {
            throw new BuildException("no destination file name: please provide it through parameter 'tofile'");
        }
        this.pattern = this.getProperty(this.pattern, this.getSettings(), "ivy.retrieve.pattern");
        try {
            String[] stringArray = this.splitConfs(this.getConf());
            ModuleDescriptor moduleDescriptor = null;
            moduleDescriptor = this.getResolveId() != null ? (ModuleDescriptor)this.getResolvedDescriptor(this.getResolveId()) : (ModuleDescriptor)this.getResolvedDescriptor(this.getOrganisation(), this.getModule(), false);
            IvyNode[] ivyNodeArray = this.getIvyInstance().getResolveEngine().getDependencies(moduleDescriptor, ((ResolveOptions)new ResolveOptions().setLog(this.getLog())).setConfs(stringArray).setResolveId(this.getResolveId()).setValidate(this.doValidate(this.getSettings())), null);
            Map map = this.getIvyInstance().getRetrieveEngine().determineArtifactsToCopy(ModuleRevisionId.newInstance(this.getOrganisation(), this.getModule(), this.getRevision()), this.pattern, ((RetrieveOptions)new RetrieveOptions().setLog(this.getLog())).setConfs(stringArray).setResolveId(this.getResolveId()));
            HashMap<ModuleRevisionId, HashSet<ArtifactDownloadReport>> hashMap = new HashMap<ModuleRevisionId, HashSet<ArtifactDownloadReport>>();
            for (ArtifactDownloadReport artifactDownloadReport : map.keySet()) {
                HashSet<ArtifactDownloadReport> hashSet = (HashSet<ArtifactDownloadReport>)hashMap.get(artifactDownloadReport.getArtifact().getModuleRevisionId());
                if (hashSet == null) {
                    hashSet = new HashSet<ArtifactDownloadReport>();
                    hashMap.put(artifactDownloadReport.getArtifact().getModuleRevisionId(), hashSet);
                }
                hashSet.add(artifactDownloadReport);
            }
            this.generateXml(ivyNodeArray, hashMap, map);
        }
        catch (ParseException parseException) {
            this.log(parseException.getMessage(), 0);
            throw new BuildException("syntax errors in ivy file: " + parseException, (Throwable)parseException);
        }
        catch (IOException iOException) {
            throw new BuildException("impossible to generate report: " + iOException, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXml(IvyNode[] ivyNodeArray, Map map, Map map2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.tofile);
            try {
                TransformerHandler transformerHandler = this.createTransformerHandler(fileOutputStream);
                transformerHandler.startDocument();
                transformerHandler.startElement(null, "modules", "modules", new AttributesImpl());
                for (int i = 0; i < ivyNodeArray.length; ++i) {
                    IvyNode ivyNode = ivyNodeArray[i];
                    if (ivyNode.getModuleRevision() == null || ivyNode.isCompletelyEvicted()) continue;
                    this.startModule(transformerHandler, ivyNode);
                    Set set = (Set)map.get(ivyNode.getModuleRevision().getId());
                    if (set != null) {
                        for (ArtifactDownloadReport artifactDownloadReport : set) {
                            RepositoryCacheManager repositoryCacheManager = ivyNode.getModuleRevision().getArtifactResolver().getRepositoryCacheManager();
                            this.startArtifact(transformerHandler, artifactDownloadReport.getArtifact());
                            this.writeOriginLocationIfPresent(repositoryCacheManager, transformerHandler, artifactDownloadReport);
                            this.writeCacheLocationIfPresent(repositoryCacheManager, transformerHandler, artifactDownloadReport);
                            Set set2 = (Set)map2.get(artifactDownloadReport);
                            for (String string : set2) {
                                this.writeRetrieveLocation(transformerHandler, string);
                            }
                            transformerHandler.endElement(null, "artifact", "artifact");
                        }
                    }
                    transformerHandler.endElement(null, "module", "module");
                }
                transformerHandler.endElement(null, "modules", "modules");
                transformerHandler.endDocument();
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (SAXException sAXException) {
            throw new BuildException("impossible to generate report", (Throwable)sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new BuildException("impossible to generate report", (Throwable)transformerConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException("impossible to generate report", (Throwable)iOException);
        }
    }

    private TransformerHandler createTransformerHandler(FileOutputStream fileOutputStream) throws TransformerFactoryConfigurationError, TransformerConfigurationException, SAXException {
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler();
        transformerHandler.getTransformer().setOutputProperty("encoding", "UTF-8");
        transformerHandler.getTransformer().setOutputProperty("indent", "yes");
        transformerHandler.setResult(new StreamResult(fileOutputStream));
        return transformerHandler;
    }

    private void startModule(TransformerHandler transformerHandler, IvyNode ivyNode) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(null, "organisation", "organisation", "CDATA", ivyNode.getModuleId().getOrganisation());
        attributesImpl.addAttribute(null, "name", "name", "CDATA", ivyNode.getModuleId().getName());
        ResolvedModuleRevision resolvedModuleRevision = ivyNode.getModuleRevision();
        attributesImpl.addAttribute(null, "rev", "rev", "CDATA", resolvedModuleRevision.getId().getRevision());
        attributesImpl.addAttribute(null, "status", "status", "CDATA", resolvedModuleRevision.getDescriptor().getStatus());
        transformerHandler.startElement(null, "module", "module", attributesImpl);
    }

    private void startArtifact(TransformerHandler transformerHandler, Artifact artifact) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(null, "name", "name", "CDATA", artifact.getName());
        attributesImpl.addAttribute(null, "ext", "ext", "CDATA", artifact.getExt());
        attributesImpl.addAttribute(null, "type", "type", "CDATA", artifact.getType());
        transformerHandler.startElement(null, "artifact", "artifact", attributesImpl);
    }

    private void writeOriginLocationIfPresent(RepositoryCacheManager repositoryCacheManager, TransformerHandler transformerHandler, ArtifactDownloadReport artifactDownloadReport) throws IOException, SAXException {
        ArtifactOrigin artifactOrigin = artifactDownloadReport.getArtifactOrigin();
        if (!ArtifactOrigin.isUnknown(artifactOrigin)) {
            String string;
            String string2 = artifactOrigin.getLocation();
            boolean bl = artifactOrigin.isLocal();
            AttributesImpl attributesImpl = new AttributesImpl();
            if (bl) {
                attributesImpl.addAttribute(null, "is-local", "is-local", "CDATA", "true");
                string = string2.replace('\\', '/');
            } else {
                attributesImpl.addAttribute(null, "is-local", "is-local", "CDATA", "false");
                string = string2;
            }
            transformerHandler.startElement(null, "origin-location", "origin-location", attributesImpl);
            char[] cArray = string.toCharArray();
            transformerHandler.characters(cArray, 0, cArray.length);
            transformerHandler.endElement(null, "origin-location", "origin-location");
        }
    }

    private void writeCacheLocationIfPresent(RepositoryCacheManager repositoryCacheManager, TransformerHandler transformerHandler, ArtifactDownloadReport artifactDownloadReport) throws SAXException {
        File file = artifactDownloadReport.getLocalFile();
        if (file != null) {
            transformerHandler.startElement(null, "cache-location", "cache-location", new AttributesImpl());
            char[] cArray = file.getPath().replace('\\', '/').toCharArray();
            transformerHandler.characters(cArray, 0, cArray.length);
            transformerHandler.endElement(null, "cache-location", "cache-location");
        }
    }

    private void writeRetrieveLocation(TransformerHandler transformerHandler, String string) throws SAXException {
        string = this.removeLeadingPath(this.getProject().getBaseDir(), new File(string));
        transformerHandler.startElement(null, "retrieve-location", "retrieve-location", new AttributesImpl());
        char[] cArray = string.replace('\\', '/').toCharArray();
        transformerHandler.characters(cArray, 0, cArray.length);
        transformerHandler.endElement(null, "retrieve-location", "retrieve-location");
    }

    public String removeLeadingPath(File file, File file2) {
        String string;
        String string2 = file.getAbsolutePath();
        if (string2.equals(string = file2.getAbsolutePath())) {
            return "";
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        return string.startsWith(string2) ? string.substring(string2.length()) : string;
    }
}

