/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.schemainfo;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;

public class SchemaInfoUpdateCheck {
    private static final Pattern PATTERN_CREATE_TABLE = Pattern.compile("CREATE\\s+TABLE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_ALTER_TABLE = Pattern.compile("ALTER\\s+TABLE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_INSERT_INTO = Pattern.compile("SELECT\\s+INTO\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_VIEW = Pattern.compile("CREATE\\s+VIEW\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_MATERIALIZED_VIEW = Pattern.compile("CREATE\\s+MATERIALIZED\\s+VIEW\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_OR_REPLACE_VIEW = Pattern.compile("CREATE\\s+OR\\s+REPLACE\\s+VIEW\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_ALTER_VIEW = Pattern.compile("ALTER\\s+VIEW\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_PROCEDURE = Pattern.compile("CREATE\\s+PROCEDURE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_OR_REPLACE_PROCEDURE = Pattern.compile("CREATE\\s+OR\\s+REPLACE\\s+PROCEDURE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_ALTER_PROCEDURE = Pattern.compile("ALTER\\s+PROCEDURE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_FUNCTION = Pattern.compile("CREATE\\s+FUNCTION\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_CREATE_OR_REPLACE_FUNCTION = Pattern.compile("CREATE\\s+OR\\s+REPLACE\\s+FUNCTION\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_ALTER_FUNCTION = Pattern.compile("ALTER\\s+FUNCTION\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_DROP_TABLE = Pattern.compile("DROP\\s+TABLE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_DROP_VIEW = Pattern.compile("DROP\\s+VIEW\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_DROP_MATERIALIZED_VIEW = Pattern.compile("DROP\\s+MATERIALIZED\\s+VIEW\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_DROP_PROCEDURE = Pattern.compile("DROP\\s+PROCEDURE\\s+([A-Z0-9_\\.\"]+)");
    private static final Pattern PATTERN_DROP_FUNCTION = Pattern.compile("DROP\\s+FUNCTION\\s+([A-Z0-9_\\.\"]+)");
    private Set<IDatabaseObjectInfo> _updateDatabaseObjectInfos = new HashSet<IDatabaseObjectInfo>();
    private Set<String> _dropTableSimpleNames = new HashSet<String>();
    private Set<String> _dropProcedureSimpleNames = new HashSet<String>();
    private ISession _session;
    private SQLDatabaseMetaData _dmd;

    public SchemaInfoUpdateCheck(ISession session) {
        this._session = session;
        this._dmd = this._session.getSQLConnection().getSQLMetaData();
    }

    public void addExecutionInfo(SQLExecutionInfo exInfo) {
        String dpsn;
        if (null == exInfo || null == exInfo.getSQL()) {
            return;
        }
        TableInfo[] tis = this.getTableInfos(exInfo.getSQL());
        for (int i = 0; i < tis.length; ++i) {
            this._updateDatabaseObjectInfos.add(tis[i]);
        }
        ProcedureInfo[] pi = this.getProcedureInfos(exInfo.getSQL());
        for (int i = 0; i < pi.length; ++i) {
            this._updateDatabaseObjectInfos.add(pi[i]);
        }
        String dtsn = this.getDropTableSimpleName(exInfo.getSQL());
        if (null != dtsn) {
            this._dropTableSimpleNames.add(dtsn);
        }
        if (null != (dpsn = this.getDropProcedureSimpleName(exInfo.getSQL()))) {
            this._dropProcedureSimpleNames.add(dpsn);
        }
    }

    private String getDropProcedureSimpleName(String sql) {
        String upperSql = (sql = sql.trim()).toUpperCase();
        Matcher matcher = PATTERN_DROP_PROCEDURE.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, true)[0].getSimpleName();
        }
        matcher = PATTERN_DROP_FUNCTION.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, true)[0].getSimpleName();
        }
        return null;
    }

    private String getDropTableSimpleName(String sql) {
        String upperSql = (sql = sql.trim()).toUpperCase();
        Matcher matcher = PATTERN_DROP_TABLE.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "TABLE", true)[0].getSimpleName();
        }
        matcher = PATTERN_DROP_MATERIALIZED_VIEW.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "TABLE", true)[0].getSimpleName();
        }
        matcher = PATTERN_DROP_VIEW.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "VIEW", true)[0].getSimpleName();
        }
        return null;
    }

    public void flush() {
        if (60 < this._updateDatabaseObjectInfos.size() + this._dropTableSimpleNames.size() + this._dropProcedureSimpleNames.size()) {
            SQLDatabaseMetaData dmd = this._session.getSQLConnection().getSQLMetaData();
            DatabaseObjectInfo sessionOI = new DatabaseObjectInfo(null, null, "SessionDummy", DatabaseObjectType.SESSION, dmd);
            this._session.getSchemaInfo().reload(sessionOI, false);
        } else {
            for (IDatabaseObjectInfo doi : this._updateDatabaseObjectInfos) {
                this._session.getSchemaInfo().reload(doi);
            }
            for (String simpleTableName : this._dropTableSimpleNames) {
                this._session.getSchemaInfo().refershCacheForSimpleTableName(simpleTableName, false);
            }
            for (String simpleProcName : this._dropProcedureSimpleNames) {
                this._session.getSchemaInfo().refreshCacheForSimpleProcedureName(simpleProcName, false);
            }
        }
        if (0 < this._updateDatabaseObjectInfos.size() + this._dropTableSimpleNames.size() + this._dropProcedureSimpleNames.size()) {
            this._session.getSchemaInfo().fireSchemaInfoUpdate();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SchemaInfoUpdateCheck.this.repaintSqlEditor();
                }
            });
        }
        this._updateDatabaseObjectInfos.clear();
        this._dropTableSimpleNames.clear();
        this._dropProcedureSimpleNames.clear();
    }

    private void repaintSqlEditor() {
        ISQLEntryPanel sqlEntryPanel;
        ISessionWidget activeSessionWidget = this._session.getActiveSessionWindow();
        if (activeSessionWidget instanceof SQLInternalFrame) {
            sqlEntryPanel = ((SQLInternalFrame)activeSessionWidget).getSQLPanelAPI().getSQLEntryPanel();
            sqlEntryPanel.getTextComponent().repaint();
            this._session.getParserEventsProcessor(sqlEntryPanel.getIdentifier()).triggerParser();
        }
        if (activeSessionWidget instanceof SessionInternalFrame) {
            sqlEntryPanel = ((SessionInternalFrame)activeSessionWidget).getSQLPanelAPI().getSQLEntryPanel();
            sqlEntryPanel.getTextComponent().repaint();
            this._session.getParserEventsProcessor(sqlEntryPanel.getIdentifier()).triggerParser();
        }
    }

    private ProcedureInfo[] getProcedureInfos(String sql) {
        String upperSql = (sql = sql.trim()).toUpperCase();
        Matcher matcher = PATTERN_CREATE_OR_REPLACE_PROCEDURE.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, false);
        }
        matcher = PATTERN_CREATE_PROCEDURE.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, false);
        }
        matcher = PATTERN_ALTER_PROCEDURE.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, true);
        }
        matcher = PATTERN_CREATE_OR_REPLACE_FUNCTION.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, false);
        }
        matcher = PATTERN_CREATE_FUNCTION.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, false);
        }
        matcher = PATTERN_ALTER_FUNCTION.matcher(upperSql);
        if (matcher.find()) {
            return this.createProcdureInfos(matcher, sql, true);
        }
        return new ProcedureInfo[0];
    }

    private ProcedureInfo[] createProcdureInfos(Matcher matcher, String sql, boolean isAlterOrDrop) {
        int endIx = matcher.end(1);
        int len = matcher.group(1).length();
        String proc = sql.substring(endIx - len, endIx);
        String[] splits = proc.split("\\.");
        String simpleName = splits[splits.length - 1];
        simpleName = this.removeQuotes(simpleName);
        if (isAlterOrDrop) {
            String buf = this._session.getSchemaInfo().getCaseSensitiveProcedureName(simpleName);
            if (null != buf) {
                simpleName = buf;
            }
            return new ProcedureInfo[]{new ProcedureInfo(null, null, simpleName, null, 0, this._dmd)};
        }
        return new ProcedureInfo[]{new ProcedureInfo(null, null, simpleName, null, 0, this._dmd), new ProcedureInfo(null, null, simpleName.toUpperCase(), null, 0, this._dmd), new ProcedureInfo(null, null, simpleName.toLowerCase(), null, 0, this._dmd)};
    }

    private String removeQuotes(String simpleName) {
        if (simpleName.startsWith("\"")) {
            simpleName = simpleName.substring(1);
        }
        if (simpleName.endsWith("\"")) {
            simpleName = simpleName.substring(0, simpleName.length() - 1);
        }
        return simpleName;
    }

    private TableInfo[] getTableInfos(String sql) {
        String upperSql = (sql = sql.trim()).toUpperCase();
        Matcher matcher = PATTERN_CREATE_TABLE.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "TABLE", false);
        }
        matcher = PATTERN_ALTER_TABLE.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "TABLE", true);
        }
        matcher = PATTERN_INSERT_INTO.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "TABLE", false);
        }
        matcher = PATTERN_CREATE_OR_REPLACE_VIEW.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "VIEW", false);
        }
        matcher = PATTERN_CREATE_VIEW.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "VIEW", false);
        }
        matcher = PATTERN_CREATE_MATERIALIZED_VIEW.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "TABLE", false);
        }
        matcher = PATTERN_ALTER_VIEW.matcher(upperSql);
        if (matcher.find()) {
            return this.createTableInfos(matcher, sql, "VIEW", true);
        }
        return new TableInfo[0];
    }

    private TableInfo[] createTableInfos(Matcher matcher, String sql, String type, boolean isAlterOrDrop) {
        int endIx = matcher.end(1);
        int len = matcher.group(1).length();
        String table = sql.substring(endIx - len, endIx);
        String[] splits = table.split("\\.");
        String simpleName = splits[splits.length - 1];
        simpleName = this.removeQuotes(simpleName);
        if (isAlterOrDrop) {
            String buf = this._session.getSchemaInfo().getCaseSensitiveTableName(simpleName);
            if (null != buf) {
                simpleName = buf;
            }
            return new TableInfo[]{new TableInfo(null, null, simpleName, type, null, this._dmd)};
        }
        return new TableInfo[]{new TableInfo(null, null, simpleName, type, null, this._dmd), new TableInfo(null, null, simpleName.toUpperCase(), type, null, this._dmd), new TableInfo(null, null, simpleName.toLowerCase(), type, null, this._dmd)};
    }
}

