/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.swing.KeyStroke;

public abstract class Prefs {
    public Prefs() {
        this.setDefaults();
    }

    private static final String getColorString(Color c) {
        String str;
        if (c == null) {
            str = "$ff000000";
        } else {
            long argb = (long)c.getRGB() & 0xFFFFFFFFL;
            str = "$" + Long.toHexString(argb + 0x100000000L).substring(1);
        }
        return str;
    }

    private static final boolean isPrimitiveNumberType(Class type) {
        return Integer.TYPE == type || Long.TYPE == type || Short.TYPE == type || Byte.TYPE == type || Float.TYPE == type || Double.TYPE == type;
    }

    private static final boolean isSavable(Field field) {
        int mods = field.getModifiers();
        return (mods & 1) == 1 && (mods & 0x90) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.load(in);
        }
        finally {
            in.close();
        }
    }

    public void load(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        this.load(props);
    }

    public void load(Properties props) throws IOException {
        Class<?> clazz = this.getClass();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                String name = fields[i].getName();
                String value = props.getProperty(name);
                if (value == null) continue;
                Class<?> type = fields[i].getType();
                Object obj = null;
                if (Integer.TYPE == type) {
                    try {
                        obj = Integer.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                } else if (Long.TYPE == type) {
                    try {
                        obj = Long.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                } else if (Short.TYPE == type) {
                    try {
                        obj = Short.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                } else if (Byte.TYPE == type) {
                    try {
                        obj = Byte.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                } else if (Float.TYPE == type) {
                    try {
                        obj = Float.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                } else if (Double.TYPE == type) {
                    try {
                        obj = Double.valueOf(value);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                } else if (Boolean.TYPE == type) {
                    obj = Boolean.valueOf(value);
                } else if (Character.TYPE == type) {
                    if (value.length() > 0) {
                        obj = new Character(value.charAt(0));
                    }
                } else if (String.class == type) {
                    obj = value;
                } else if (String[].class == type) {
                    String[] temp = null;
                    int length = Integer.parseInt(value);
                    if (length > -1) {
                        temp = new String[length];
                        for (int j = 0; j < length; ++j) {
                            temp[j] = props.getProperty(name + "." + j);
                        }
                    }
                    obj = temp;
                } else if (Color.class == type) {
                    if (value.length() == 9 && value.charAt(0) == '$') {
                        long temp = Long.parseLong(value.substring(1), 16);
                        int rgba = (int)(temp & 0xFFFFFFFFFFFFFFFFL);
                        obj = new Color(rgba, true);
                    }
                } else if (File.class == type) {
                    if (value.length() > 0) {
                        obj = new File(value);
                    }
                } else if (KeyStroke.class == type) {
                    if (value.length() > 0) {
                        obj = KeyStroke.getKeyStroke(value);
                    }
                } else {
                    throw new IOException("Unhandled field type for field: " + name + " (" + type + ")");
                }
                if (obj == null) continue;
                fields[i].set(this, obj);
                continue;
            }
            catch (IllegalAccessException iae) {
                throw new IOException(iae.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.save(out);
        }
        finally {
            out.close();
        }
    }

    public void save(Properties props) throws IOException {
        Class<?> clazz = this.getClass();
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (!Prefs.isSavable(fields[i])) continue;
                String name = fields[i].getName();
                Class<?> type = fields[i].getType();
                Object value = fields[i].get(this);
                String strVal = null;
                if (Prefs.isPrimitiveNumberType(type) || Boolean.TYPE == type || Character.TYPE == type) {
                    strVal = value.toString();
                } else if (String.class == type) {
                    strVal = (String)value;
                } else if (String[].class == type) {
                    String[] array = (String[])value;
                    if (array == null) {
                        strVal = "-1";
                    } else {
                        strVal = Integer.toString(array.length);
                        for (int j = 0; j < array.length; ++j) {
                            if (array[j] == null) continue;
                            props.setProperty(name + "." + j, array[j]);
                        }
                    }
                } else if (Color.class == type) {
                    Color c = (Color)value;
                    strVal = Prefs.getColorString(c);
                } else if (File.class == type) {
                    if (value != null) {
                        File file = (File)value;
                        strVal = file.getAbsolutePath();
                    }
                } else if (KeyStroke.class == type) {
                    if (value != null) {
                        KeyStroke ks = (KeyStroke)value;
                        strVal = ks.toString();
                    }
                } else {
                    throw new IOException("Unhandled field type for field: " + name + " (" + type + ")");
                }
                if (strVal == null) {
                    strVal = "";
                }
                props.setProperty(name, strVal);
                continue;
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
                throw new IOException(iae.getMessage());
            }
        }
    }

    public void save(OutputStream out) throws IOException {
        Class<?> clazz = this.getClass();
        Properties props = new Properties();
        this.save(props);
        String header = "Preferences for the " + clazz.getName() + " class";
        props.store(out, header);
    }

    public abstract void setDefaults();
}

