/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.broker.transport;

import org.apache.activemq.apollo.util.ClassFinder;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportServer;

public class TransportFactory {
    public static final ClassFinder<Provider> providers = new ClassFinder("META-INF/services/org.apache.activemq.apollo/transport-factory.index", Provider.class);

    public static Transport connect(String location) throws Exception {
        for (Provider provider : providers.jsingletons()) {
            Transport rc = provider.connect(location);
            if (rc == null) continue;
            return rc;
        }
        throw new IllegalArgumentException("Unknown transport connect uri: " + location);
    }

    public static TransportServer bind(String location) throws Exception {
        for (Provider spi : providers.jsingletons()) {
            TransportServer rc = spi.bind(location);
            if (rc == null) continue;
            return rc;
        }
        throw new IllegalArgumentException("Unknown transport bind uri: " + location);
    }

    public static interface Provider {
        public TransportServer bind(String var1) throws Exception;

        public Transport connect(String var1) throws Exception;
    }
}

