/*
 * Decompiled with CFR 0.152.
 */
package free.jin.ui;

import free.jin.I18n;
import free.jin.Jin;
import free.jin.ui.AboutPanel;
import free.jin.ui.LicensePanel;
import free.util.swing.UrlDisplayingAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class HelpMenu
extends JMenu {
    public HelpMenu() {
        I18n.get(HelpMenu.class).initAbstractButton(this, "this");
        this.add(this.createWebsiteMenuItem());
        this.add(this.createCreditsMenuItem());
        this.add(this.createBugReportMenuItem());
        this.add(this.createFeatureRequestMenuItem());
        this.add(this.createAboutMenuItem());
    }

    private JMenuItem createWebsiteMenuItem() {
        JMenuItem jMenuItem = I18n.get(HelpMenu.class).createMenuItem("jinWebsiteMenuItem");
        jMenuItem.addActionListener(new UrlDisplayingAction("http://www.jinchess.com"));
        return jMenuItem;
    }

    private JMenuItem createCreditsMenuItem() {
        JMenuItem jMenuItem = I18n.get(HelpMenu.class).createMenuItem("creditsMenuItem");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new LicensePanel().display();
            }
        });
        return jMenuItem;
    }

    private JMenuItem createBugReportMenuItem() {
        JMenuItem jMenuItem = I18n.get(HelpMenu.class).createMenuItem("reportBugMenuItem");
        jMenuItem.addActionListener(new UrlDisplayingAction("https://sourceforge.net/tracker/?group_id=50386&atid=459537"));
        return jMenuItem;
    }

    private JMenuItem createFeatureRequestMenuItem() {
        JMenuItem jMenuItem = I18n.get(HelpMenu.class).createMenuItem("suggestFeatureMenuItem");
        jMenuItem.addActionListener(new UrlDisplayingAction("https://sourceforge.net/tracker/?group_id=50386&atid=459540"));
        return jMenuItem;
    }

    private JMenuItem createAboutMenuItem() {
        JMenuItem jMenuItem = I18n.get(HelpMenu.class).createMenuItem("aboutJinMenuItem", new Object[]{Jin.getInstance().getAppName()});
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new AboutPanel().display();
            }
        });
        return jMenuItem;
    }
}

