/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.BitrateProberConfig;
import org.jitsi.nlj.rtp.bandwidthestimation2.BitrateProberKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.PacedPacketInfo;
import org.jitsi.nlj.rtp.bandwidthestimation2.ProbeClusterConfig;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.InstantKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002()B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0012J\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0012J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020 0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProber;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "configIn", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProberConfig;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProberConfig;)V", "logger", "setEnabled", "", "enable", "", "setAllowProbeWithoutMediaPacket", "allow", "isProbing", "onIncomingPacket", "packetSize", "Lorg/jitsi/nlj/util/DataSize;", "createProbeCluster", "clusterConfig", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/ProbeClusterConfig;", "nextProbeTime", "Ljava/time/Instant;", "now", "currentCluster", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacedPacketInfo;", "recommendedMinProbeSize", "probeSent", "size", "calculateNextProbeTime", "cluster", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProber$ProbeCluster;", "maybeSetActiveState", "readyToSetActiveState", "probingState", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProber$ProbingState;", "clusters", "Lkotlin/collections/ArrayDeque;", "config", "ProbingState", "ProbeCluster", "jitsi-media-transform"})
public final class BitrateProber {
    @NotNull
    private final Logger logger;
    @NotNull
    private ProbingState probingState;
    @NotNull
    private final ArrayDeque<ProbeCluster> clusters;
    @NotNull
    private Instant nextProbeTime;
    @NotNull
    private BitrateProberConfig config;

    public BitrateProber(@NotNull Logger parentLogger, @NotNull BitrateProberConfig configIn) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(configIn, "configIn");
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.probingState = ProbingState.kInactive;
        this.clusters = new ArrayDeque();
        Instant instant = Instant.MAX;
        Intrinsics.checkNotNullExpressionValue(instant, "MAX");
        this.nextProbeTime = instant;
        this.config = BitrateProberConfig.copy$default(configIn, null, null, false, 7, null);
    }

    public /* synthetic */ BitrateProber(Logger logger, BitrateProberConfig bitrateProberConfig, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            bitrateProberConfig = new BitrateProberConfig(null, null, false, 7, null);
        }
        this(logger, bitrateProberConfig);
    }

    public final void setEnabled(boolean enable) {
        if (enable) {
            if (this.probingState == ProbingState.kDisabled) {
                this.probingState = ProbingState.kInactive;
                this.logger.info("Bandwidth probing enabled, set to inactive");
            }
        } else {
            this.probingState = ProbingState.kDisabled;
            this.logger.info("Bandwidth probing disabled");
        }
    }

    public final void setAllowProbeWithoutMediaPacket(boolean allow) {
        this.config.setAllowStartProbingImmediately(allow);
        this.maybeSetActiveState(DataSize.Companion.getZERO());
    }

    public final boolean isProbing() {
        return this.probingState == ProbingState.kActive;
    }

    public final void onIncomingPacket(@NotNull DataSize packetSize) {
        Intrinsics.checkNotNullParameter(packetSize, "packetSize");
        this.maybeSetActiveState(packetSize);
    }

    public final void createProbeCluster(@NotNull ProbeClusterConfig clusterConfig) {
        Duration duration;
        Intrinsics.checkNotNullParameter(clusterConfig, "clusterConfig");
        if (!(this.probingState != ProbingState.kDisabled)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(clusterConfig.getMinProbeDelta().compareTo(Duration.ZERO) > 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        while (!((Collection)this.clusters).isEmpty() && (Duration.between(this.clusters.first().getRequestedAt(), clusterConfig.getAtTime()).compareTo(BitrateProberKt.access$getKProbeClusterTimeout$p()) > 0 || this.clusters.size() > BitrateProberKt.access$getKMaxPendingProbeClusters$p())) {
            this.clusters.removeFirst();
        }
        Instant instant = clusterConfig.getAtTime();
        int n = clusterConfig.getTargetProbeCount();
        int n2 = (int)BandwidthKt.times-SimD6oM(clusterConfig.getTargetDataRate-rlWvAKk(), clusterConfig.getTargetDuration()).getBytes();
        int n3 = clusterConfig.getId();
        Object object = new PacedPacketInfo(n3, n, n2, 0L, 8, null);
        ProbeCluster cluster = new ProbeCluster((PacedPacketInfo)object, 0, 0, duration = clusterConfig.getMinProbeDelta(), instant, null, 38, null);
        if (!(cluster.getPaceInfo().getProbeClusterMinBytes() >= 0)) {
            object = "Check failed.";
            throw new IllegalStateException(object.toString());
        }
        cluster.getPaceInfo().setSendBitrate-_2icLw0(clusterConfig.getTargetDataRate-rlWvAKk());
        this.clusters.addLast(cluster);
        this.maybeSetActiveState(DataSize.Companion.getZERO());
        if (!(this.probingState == ProbingState.kActive || this.probingState == ProbingState.kInactive)) {
            object = "Check failed.";
            throw new IllegalStateException(object.toString());
        }
        this.logger.info(() -> BitrateProber.createProbeCluster$lambda$0(cluster, this));
    }

    @NotNull
    public final Instant nextProbeTime(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.probingState != ProbingState.kActive || this.clusters.isEmpty()) {
            Instant instant = Instant.MAX;
            Intrinsics.checkNotNullExpressionValue(instant, "MAX");
            return instant;
        }
        return this.nextProbeTime;
    }

    @Nullable
    public final PacedPacketInfo currentCluster(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter(now, "now");
        if (this.clusters.isEmpty() || this.probingState != ProbingState.kActive) {
            return null;
        }
        if (InstantKt.isFinite(this.nextProbeTime) && Duration.between(this.nextProbeTime, now).compareTo(this.config.getMaxProbeDelay()) > 0) {
            this.logger.warn("Probe delay too high (next:" + this.nextProbeTime + ", now:" + now + ")discarding probe cluster.");
            this.clusters.removeFirst();
            if (this.clusters.isEmpty()) {
                this.probingState = ProbingState.kInactive;
                return null;
            }
        }
        PacedPacketInfo info = PacedPacketInfo.copy-EuOYGdc$default(this.clusters.first().getPaceInfo(), 0, 0, 0, 0L, 15, null);
        info.setProbeClusterBytesSent(this.clusters.first().getSentBytes());
        return info;
    }

    @NotNull
    public final DataSize recommendedMinProbeSize() {
        if (this.clusters.isEmpty()) {
            return DataSize.Companion.getZERO();
        }
        long sendRate = this.clusters.first().getPaceInfo().getSendBitrate-rlWvAKk();
        return BandwidthKt.times-SimD6oM(sendRate, this.clusters.first().getMinProbeDelta());
    }

    public final void probeSent(@NotNull Instant now, @NotNull DataSize size) {
        Intrinsics.checkNotNullParameter(now, "now");
        Intrinsics.checkNotNullParameter(size, "size");
        if (!(this.probingState == ProbingState.kActive)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!(!Intrinsics.areEqual(size, DataSize.Companion.getZERO()))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!((Collection)this.clusters).isEmpty()) {
            ProbeCluster cluster = this.clusters.first();
            if (cluster.getSentProbes() == 0) {
                if (!InstantKt.isInfinite(cluster.getStartedAt())) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                cluster.setStartedAt(now);
            }
            cluster.setSentBytes(cluster.getSentBytes() + (int)size.getBytes());
            cluster.setSentProbes(cluster.getSentProbes() + 1);
            this.nextProbeTime = this.calculateNextProbeTime(cluster);
            if (cluster.getSentBytes() >= cluster.getPaceInfo().getProbeClusterMinBytes() && cluster.getSentProbes() >= cluster.getPaceInfo().getProbeClusterMinProbes()) {
                this.clusters.removeFirst();
            }
            if (this.clusters.isEmpty()) {
                this.probingState = ProbingState.kInactive;
            }
        }
    }

    private final Instant calculateNextProbeTime(ProbeCluster cluster) {
        if (!(Bandwidth.compareTo-_2icLw0(cluster.getPaceInfo().getSendBitrate-rlWvAKk(), BandwidthKt.getBps(0)) >= 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!InstantKt.isFinite(cluster.getStartedAt())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        DataSize sentBytes = DataSizeKt.getBytes(cluster.getSentBytes());
        long sendBitrate = cluster.getPaceInfo().getSendBitrate-rlWvAKk();
        Duration delta = BandwidthKt.div-ERFH51c(sentBytes, sendBitrate);
        Instant instant = cluster.getStartedAt().plus(delta);
        Intrinsics.checkNotNullExpressionValue(instant, "plus(...)");
        return instant;
    }

    private final void maybeSetActiveState(DataSize packetSize) {
        if (this.readyToSetActiveState(packetSize)) {
            this.nextProbeTime = Instant.MIN;
            this.probingState = ProbingState.kActive;
        }
    }

    private final boolean readyToSetActiveState(DataSize packetSize) {
        if (this.clusters.isEmpty()) {
            if (!(this.probingState == ProbingState.kDisabled || this.probingState == ProbingState.kInactive)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            return false;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.probingState.ordinal()]) {
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                if (this.config.getAllowStartProbingImmediately()) {
                    return true;
                }
                return packetSize.compareTo(DataSizeKt.min(this.recommendedMinProbeSize(), this.config.getMinPacketSize())) >= 0;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final String createProbeCluster$lambda$0(ProbeCluster $cluster, BitrateProber this$0) {
        Intrinsics.checkNotNullParameter($cluster, "$cluster");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return "Probe cluster (bitrate_bps:min bytes:min packets): (" + Bandwidth.toString-impl($cluster.getPaceInfo().getSendBitrate-rlWvAKk()) + ":" + $cluster.getPaceInfo().getProbeClusterMinBytes() + ":" + $cluster.getPaceInfo().getProbeClusterMinProbes() + ", " + this$0.probingState + ")";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003JE\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001d\u00a8\u0006-"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProber$ProbeCluster;", "", "paceInfo", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacedPacketInfo;", "sentProbes", "", "sentBytes", "minProbeDelta", "Ljava/time/Duration;", "requestedAt", "Ljava/time/Instant;", "startedAt", "<init>", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacedPacketInfo;IILjava/time/Duration;Ljava/time/Instant;Ljava/time/Instant;)V", "getPaceInfo", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/PacedPacketInfo;", "getSentProbes", "()I", "setSentProbes", "(I)V", "getSentBytes", "setSentBytes", "getMinProbeDelta", "()Ljava/time/Duration;", "setMinProbeDelta", "(Ljava/time/Duration;)V", "getRequestedAt", "()Ljava/time/Instant;", "setRequestedAt", "(Ljava/time/Instant;)V", "getStartedAt", "setStartedAt", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "jitsi-media-transform"})
    private static final class ProbeCluster {
        @NotNull
        private final PacedPacketInfo paceInfo;
        private int sentProbes;
        private int sentBytes;
        @NotNull
        private Duration minProbeDelta;
        @NotNull
        private Instant requestedAt;
        @NotNull
        private Instant startedAt;

        public ProbeCluster(@NotNull PacedPacketInfo paceInfo, int sentProbes, int sentBytes, @NotNull Duration minProbeDelta, @NotNull Instant requestedAt, @NotNull Instant startedAt) {
            Intrinsics.checkNotNullParameter(paceInfo, "paceInfo");
            Intrinsics.checkNotNullParameter(minProbeDelta, "minProbeDelta");
            Intrinsics.checkNotNullParameter(requestedAt, "requestedAt");
            Intrinsics.checkNotNullParameter(startedAt, "startedAt");
            this.paceInfo = paceInfo;
            this.sentProbes = sentProbes;
            this.sentBytes = sentBytes;
            this.minProbeDelta = minProbeDelta;
            this.requestedAt = requestedAt;
            this.startedAt = startedAt;
        }

        public /* synthetic */ ProbeCluster(PacedPacketInfo pacedPacketInfo, int n, int n2, Duration duration, Instant instant, Instant instant2, int n3, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            if ((n3 & 8) != 0) {
                duration = Duration.ZERO;
            }
            if ((n3 & 0x10) != 0) {
                instant = Instant.MIN;
            }
            if ((n3 & 0x20) != 0) {
                instant2 = Instant.MIN;
            }
            this(pacedPacketInfo, n, n2, duration, instant, instant2);
        }

        @NotNull
        public final PacedPacketInfo getPaceInfo() {
            return this.paceInfo;
        }

        public final int getSentProbes() {
            return this.sentProbes;
        }

        public final void setSentProbes(int n) {
            this.sentProbes = n;
        }

        public final int getSentBytes() {
            return this.sentBytes;
        }

        public final void setSentBytes(int n) {
            this.sentBytes = n;
        }

        @NotNull
        public final Duration getMinProbeDelta() {
            return this.minProbeDelta;
        }

        public final void setMinProbeDelta(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter(duration, "<set-?>");
            this.minProbeDelta = duration;
        }

        @NotNull
        public final Instant getRequestedAt() {
            return this.requestedAt;
        }

        public final void setRequestedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.requestedAt = instant;
        }

        @NotNull
        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.startedAt = instant;
        }

        @NotNull
        public final PacedPacketInfo component1() {
            return this.paceInfo;
        }

        public final int component2() {
            return this.sentProbes;
        }

        public final int component3() {
            return this.sentBytes;
        }

        @NotNull
        public final Duration component4() {
            return this.minProbeDelta;
        }

        @NotNull
        public final Instant component5() {
            return this.requestedAt;
        }

        @NotNull
        public final Instant component6() {
            return this.startedAt;
        }

        @NotNull
        public final ProbeCluster copy(@NotNull PacedPacketInfo paceInfo, int sentProbes, int sentBytes, @NotNull Duration minProbeDelta, @NotNull Instant requestedAt, @NotNull Instant startedAt) {
            Intrinsics.checkNotNullParameter(paceInfo, "paceInfo");
            Intrinsics.checkNotNullParameter(minProbeDelta, "minProbeDelta");
            Intrinsics.checkNotNullParameter(requestedAt, "requestedAt");
            Intrinsics.checkNotNullParameter(startedAt, "startedAt");
            return new ProbeCluster(paceInfo, sentProbes, sentBytes, minProbeDelta, requestedAt, startedAt);
        }

        public static /* synthetic */ ProbeCluster copy$default(ProbeCluster probeCluster, PacedPacketInfo pacedPacketInfo, int n, int n2, Duration duration, Instant instant, Instant instant2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                pacedPacketInfo = probeCluster.paceInfo;
            }
            if ((n3 & 2) != 0) {
                n = probeCluster.sentProbes;
            }
            if ((n3 & 4) != 0) {
                n2 = probeCluster.sentBytes;
            }
            if ((n3 & 8) != 0) {
                duration = probeCluster.minProbeDelta;
            }
            if ((n3 & 0x10) != 0) {
                instant = probeCluster.requestedAt;
            }
            if ((n3 & 0x20) != 0) {
                instant2 = probeCluster.startedAt;
            }
            return probeCluster.copy(pacedPacketInfo, n, n2, duration, instant, instant2);
        }

        @NotNull
        public String toString() {
            return "ProbeCluster(paceInfo=" + this.paceInfo + ", sentProbes=" + this.sentProbes + ", sentBytes=" + this.sentBytes + ", minProbeDelta=" + this.minProbeDelta + ", requestedAt=" + this.requestedAt + ", startedAt=" + this.startedAt + ")";
        }

        public int hashCode() {
            int result = this.paceInfo.hashCode();
            result = result * 31 + Integer.hashCode(this.sentProbes);
            result = result * 31 + Integer.hashCode(this.sentBytes);
            result = result * 31 + this.minProbeDelta.hashCode();
            result = result * 31 + this.requestedAt.hashCode();
            result = result * 31 + this.startedAt.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProbeCluster)) {
                return false;
            }
            ProbeCluster probeCluster = (ProbeCluster)other;
            if (!Intrinsics.areEqual(this.paceInfo, probeCluster.paceInfo)) {
                return false;
            }
            if (this.sentProbes != probeCluster.sentProbes) {
                return false;
            }
            if (this.sentBytes != probeCluster.sentBytes) {
                return false;
            }
            if (!Intrinsics.areEqual(this.minProbeDelta, probeCluster.minProbeDelta)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.requestedAt, probeCluster.requestedAt)) {
                return false;
            }
            return Intrinsics.areEqual(this.startedAt, probeCluster.startedAt);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/BitrateProber$ProbingState;", "", "<init>", "(Ljava/lang/String;I)V", "kDisabled", "kInactive", "kActive", "jitsi-media-transform"})
    private static final class ProbingState
    extends Enum<ProbingState> {
        public static final /* enum */ ProbingState kDisabled = new ProbingState();
        public static final /* enum */ ProbingState kInactive = new ProbingState();
        public static final /* enum */ ProbingState kActive = new ProbingState();
        private static final /* synthetic */ ProbingState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProbingState[] values() {
            return (ProbingState[])$VALUES.clone();
        }

        public static ProbingState valueOf(String value2) {
            return Enum.valueOf(ProbingState.class, value2);
        }

        @NotNull
        public static EnumEntries<ProbingState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = probingStateArray = new ProbingState[]{ProbingState.kDisabled, ProbingState.kInactive, ProbingState.kActive};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProbingState.values().length];
            try {
                nArray[ProbingState.kDisabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProbingState.kActive.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProbingState.kInactive.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

