/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.NodeStatsProducer;
import org.jitsi.nlj.util.NodeStatsBlockExtensionsKt;
import org.jitsi.nlj.util.UtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001NB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020/\u00a2\u0006\u0002\u00108J\u001b\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00020/\u00a2\u0006\u0002\u00109J\u0010\u0010:\u001a\u00020\u00042\u0006\u0010;\u001a\u00020/H\u0002J%\u0010<\u001a\u00020\b2\u0006\u00105\u001a\u00028\u00002\u0006\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00108J\u0015\u0010=\u001a\u00020>2\u0006\u00105\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010?J&\u0010@\u001a\u000e\u0018\u00010\u0015R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00106\u001a\u00020/2\b\b\u0002\u0010A\u001a\u00020\bH\u0007J$\u0010B\u001a\u000e\u0018\u00010\u0015R\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u00106\u001a\u00020/2\u0006\u0010A\u001a\u00020\bH\u0002J\u000e\u0010C\u001a\u00020\b2\u0006\u00106\u001a\u00020/J\u0010\u0010D\u001a\u00020\b2\u0006\u00106\u001a\u00020/H\u0002J\u0018\u0010E\u001a\u00020>2\u0006\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020/H\u0004J\u0018\u0010F\u001a\u00020>2\u0006\u00106\u001a\u00020/2\u0006\u00107\u001a\u00020/H\u0002J\u001a\u0010G\u001a\u00020>2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0006J\u001c\u0010I\u001a\u00020>2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0006H\u0002J\u0006\u0010J\u001a\u00020>J\b\u0010K\u001a\u00020>H\u0002J\b\u0010L\u001a\u00020MH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u0012\u0012\u000e\u0012\f0\u0015R\b\u0012\u0004\u0012\u00028\u00000\u00000\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000e\"\u0004\b\"\u0010\u001fR\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000eR\u0011\u0010(\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000eR\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0010\u00a8\u0006O"}, d2={"Lorg/jitsi/nlj/util/ArrayCache;", "T", "Lorg/jitsi/nlj/transform/NodeStatsProducer;", "size", "", "cloneItem", "Lkotlin/Function1;", "synchronize", "", "clock", "Ljava/time/Clock;", "<init>", "(ILkotlin/jvm/functions/Function1;ZLjava/time/Clock;)V", "getSize", "()I", "getSynchronize", "()Z", "getClock", "()Ljava/time/Clock;", "cache", "", "Lorg/jitsi/nlj/util/ArrayCache$Container;", "[Lorg/jitsi/nlj/util/ArrayCache$Container;", "syncRoot", "", "getSyncRoot", "()Ljava/lang/Object;", "head", "numInserts", "getNumInserts", "setNumInserts", "(I)V", "numOldInserts", "getNumOldInserts", "setNumOldInserts", "_numHits", "Ljava/util/concurrent/atomic/AtomicInteger;", "_numMisses", "numHits", "getNumHits", "numMisses", "getNumMisses", "hitRate", "", "getHitRate", "()D", "lastIndex", "", "getLastIndex", "()J", "empty", "getEmpty", "insertItem", "item", "index", "timeAdded", "(Ljava/lang/Object;JJ)Z", "(Ljava/lang/Object;J)Z", "position", "diff", "doInsert", "discardItem", "", "(Ljava/lang/Object;)V", "getContainer", "shouldCloneItem", "doGet", "containsIndex", "doContains", "updateTimeAdded", "doUpdateTimeAdded", "forEachDescending", "predicate", "doForEachDescending", "flush", "doFlush", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "Container", "jitsi-media-transform"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE", "RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="False positives.")
@SourceDebugExtension(value={"SMAP\nArrayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayCache.kt\norg/jitsi/nlj/util/ArrayCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
public class ArrayCache<T>
implements NodeStatsProducer {
    private final int size;
    @NotNull
    private final Function1<T, T> cloneItem;
    private final boolean synchronize;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Container[] cache;
    @NotNull
    private final Object syncRoot;
    private int head;
    private int numInserts;
    private int numOldInserts;
    @NotNull
    private final AtomicInteger _numHits;
    @NotNull
    private final AtomicInteger _numMisses;

    public ArrayCache(int size, @NotNull Function1<? super T, ? extends T> cloneItem, boolean synchronize, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(cloneItem, "cloneItem");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.size = size;
        this.cloneItem = cloneItem;
        this.synchronize = synchronize;
        this.clock = clock;
        int n = 0;
        int n2 = this.size;
        Container[] containerArray = new Container[n2];
        ArrayCache arrayCache = this;
        while (n < n2) {
            int n3 = n++;
            containerArray[n3] = new Container(this, null, 0L, 0L, 7, null);
        }
        arrayCache.cache = containerArray;
        this.syncRoot = new Object();
        this.head = -1;
        this._numHits = new AtomicInteger();
        this._numMisses = new AtomicInteger();
    }

    public /* synthetic */ ArrayCache(int n, Function1 function1, boolean bl, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n2 & 4) != 0) {
            bl = true;
        }
        if ((n2 & 8) != 0) {
            clock = Clock.systemUTC();
        }
        this(n, function1, bl, clock);
    }

    public final int getSize() {
        return this.size;
    }

    protected final boolean getSynchronize() {
        return this.synchronize;
    }

    @NotNull
    protected final Clock getClock() {
        return this.clock;
    }

    @NotNull
    protected final Object getSyncRoot() {
        return this.syncRoot;
    }

    public final int getNumInserts() {
        return this.numInserts;
    }

    public final void setNumInserts(int n) {
        this.numInserts = n;
    }

    public final int getNumOldInserts() {
        return this.numOldInserts;
    }

    public final void setNumOldInserts(int n) {
        this.numOldInserts = n;
    }

    public final int getNumHits() {
        return this._numHits.get();
    }

    public final int getNumMisses() {
        return this._numMisses.get();
    }

    public final double getHitRate() {
        return (double)this._numHits.get() * 1.0 / (double)Integer.max(1, this._numHits.get() + this._numMisses.get());
    }

    protected final long getLastIndex() {
        return this.head == -1 ? -1L : this.cache[this.head].getIndex();
    }

    public final boolean getEmpty() {
        return this.head == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean insertItem(T item, long index, long timeAdded) {
        boolean bl;
        if (this.synchronize) {
            Object object = this.syncRoot;
            synchronized (object) {
                boolean bl2 = false;
                boolean bl3 = this.doInsert(item, index, timeAdded);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var6_4
                bl = bl3;
            }
        } else {
            bl = this.doInsert(item, index, timeAdded);
        }
        return bl;
    }

    public final boolean insertItem(T item, long index) {
        return this.insertItem(item, index, this.clock.millis());
    }

    private final int position(long diff) {
        return (int)UtilKt.floorMod((long)this.head + diff, (long)this.size);
    }

    private final boolean doInsert(T item, long index, long timeAdded) {
        int n;
        long diff = this.head == -1 ? -1L : index - this.cache[this.head].getIndex();
        if (this.head == -1) {
            n = this.head = 0;
        } else {
            if (diff <= (long)(-this.size)) {
                int n2 = this.numOldInserts;
                this.numOldInserts = n2 + 1;
                return false;
            }
            n = diff < 0L ? this.position(diff) : (this.head = this.position(diff));
        }
        int position = n;
        int n3 = this.numInserts;
        this.numInserts = n3 + 1;
        Object t2 = this.cache[position].getItem();
        if (t2 != null) {
            Object it = t2;
            boolean bl = false;
            this.discardItem(it);
        }
        this.cache[position].setItem(this.cloneItem.invoke(item));
        this.cache[position].setIndex(index);
        this.cache[position].setTimeAdded(timeAdded);
        return true;
    }

    protected void discardItem(T item) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @Nullable
    public final Container getContainer(long index, boolean shouldCloneItem) {
        int n;
        Container result;
        Container container;
        if (this.synchronize) {
            Object object = this.syncRoot;
            synchronized (object) {
                boolean $i$a$-synchronized-ArrayCache$getContainer$result$22 = false;
                Container $i$a$-synchronized-ArrayCache$getContainer$result$22 = this.doGet(index, shouldCloneItem);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl9 : MonitorExitStatement: MONITOREXIT : var5_3
                container = $i$a$-synchronized-ArrayCache$getContainer$result$22;
            }
        } else {
            container = this.doGet(index, shouldCloneItem);
        }
        Container container2 = result = container;
        if (container2 != null) {
            Container it = container2;
            boolean bl = false;
            n = this._numHits.incrementAndGet();
        } else {
            n = this._numMisses.incrementAndGet();
        }
        return result;
    }

    public static /* synthetic */ Container getContainer$default(ArrayCache arrayCache, long l, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getContainer");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return arrayCache.getContainer(l, bl);
    }

    private final Container doGet(long index, boolean shouldCloneItem) {
        if (index < 0L) {
            return null;
        }
        if (this.head == -1) {
            return null;
        }
        long diff = index - this.cache[this.head].getIndex();
        if (diff > 0L) {
            return null;
        }
        int position = this.position(diff);
        if (this.cache[position].getIndex() == index) {
            return this.cache[position].clone(shouldCloneItem);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsIndex(long index) {
        boolean bl;
        if (this.synchronize) {
            Object object = this.syncRoot;
            synchronized (object) {
                boolean bl2 = false;
                boolean bl3 = this.doContains(index);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var3_2
                bl = bl3;
            }
        } else {
            bl = this.doContains(index);
        }
        return bl;
    }

    private final boolean doContains(long index) {
        if (this.head == -1) {
            return false;
        }
        long diff = index - this.cache[this.head].getIndex();
        if (diff > 0L) {
            return false;
        }
        int position = this.position(diff);
        return this.cache[position].getIndex() == index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateTimeAdded(long index, long timeAdded) {
        if (this.synchronize) {
            Object object = this.syncRoot;
            synchronized (object) {
                boolean bl = false;
                this.doUpdateTimeAdded(index, timeAdded);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.doUpdateTimeAdded(index, timeAdded);
        }
    }

    private final void doUpdateTimeAdded(long index, long timeAdded) {
        if (this.head == -1 || index > this.cache[this.head].getIndex()) {
            return;
        }
        long diff = index - this.cache[this.head].getIndex();
        int position = this.position(diff);
        if (this.cache[position].getIndex() == index) {
            this.cache[position].setTimeAdded(timeAdded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachDescending(@NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, "predicate");
        if (this.synchronize) {
            Object object = this.syncRoot;
            synchronized (object) {
                boolean bl = false;
                this.doForEachDescending(predicate);
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.doForEachDescending(predicate);
        }
    }

    private final void doForEachDescending(Function1<? super T, Boolean> predicate) {
        if (this.head == -1) {
            return;
        }
        LongProgression indexRange = RangesKt.downTo(this.cache[this.head].getIndex(), Long.max(this.cache[this.head].getIndex() - (long)this.size, 1L));
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            int position = UtilKt.floorMod(this.head - i, this.size);
            if (!CollectionsKt.contains(indexRange, this.cache[position].getIndex())) continue;
            Object t2 = this.cache[position].getItem();
            Intrinsics.checkNotNull(t2);
            if (predicate.invoke(t2).booleanValue()) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        if (this.synchronize) {
            Object object = this.syncRoot;
            synchronized (object) {
                boolean bl = false;
                this.doFlush();
                Unit unit = Unit.INSTANCE;
            }
        } else {
            this.doFlush();
        }
    }

    private final void doFlush() {
        Container[] containerArray = this.cache;
        int n = containerArray.length;
        for (int i = 0; i < n; ++i) {
            Container container;
            Container $this$doFlush_u24lambda_u249 = container = containerArray[i];
            boolean bl = false;
            $this$doFlush_u24lambda_u249.setIndex(-1L);
            if ($this$doFlush_u24lambda_u249.getItem() != null) {
                Object it;
                boolean bl2 = false;
                this.discardItem(it);
            }
            $this$doFlush_u24lambda_u249.setItem(null);
            $this$doFlush_u24lambda_u249.setTimeAdded(-1L);
        }
        this.head = -1;
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2410 = nodeStatsBlock = new NodeStatsBlock("ArrayCache");
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2410.addNumber("size", this.size);
        $this$getNodeStats_u24lambda_u2410.addNumber("numInserts", this.numInserts);
        $this$getNodeStats_u24lambda_u2410.addNumber("numOldInserts", this.numOldInserts);
        $this$getNodeStats_u24lambda_u2410.addNumber("numHits", this.getNumHits());
        $this$getNodeStats_u24lambda_u2410.addNumber("numMisses", this.getNumMisses());
        $this$getNodeStats_u24lambda_u2410.addNumber("numRequests", this.getNumHits() + this.getNumMisses());
        NodeStatsBlockExtensionsKt.addRatio($this$getNodeStats_u24lambda_u2410, "hitRate", "numHits", "numRequests", 1);
        return nodeStatsBlock;
    }

    @JvmOverloads
    @Nullable
    public final Container getContainer(long index) {
        return ArrayCache.getContainer$default(this, index, false, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u001e\u0010\u0002\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jitsi/nlj/util/ArrayCache$Container;", "", "item", "index", "", "timeAdded", "<init>", "(Lorg/jitsi/nlj/util/ArrayCache;Ljava/lang/Object;JJ)V", "getItem", "()Ljava/lang/Object;", "setItem", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getIndex", "()J", "setIndex", "(J)V", "getTimeAdded", "setTimeAdded", "clone", "Lorg/jitsi/nlj/util/ArrayCache;", "shouldCloneItem", "", "jitsi-media-transform"})
    @SourceDebugExtension(value={"SMAP\nArrayCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayCache.kt\norg/jitsi/nlj/util/ArrayCache$Container\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,282:1\n1#2:283\n*E\n"})
    public final class Container {
        @Nullable
        private T item;
        private long index;
        private long timeAdded;
        final /* synthetic */ ArrayCache<T> this$0;

        public Container(@Nullable ArrayCache this$0, T item, long index, long timeAdded) {
            this.this$0 = this$0;
            this.item = item;
            this.index = index;
            this.timeAdded = timeAdded;
        }

        public /* synthetic */ Container(ArrayCache arrayCache, Object object, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                object = null;
            }
            if ((n & 2) != 0) {
                l = -1L;
            }
            if ((n & 4) != 0) {
                l2 = -1L;
            }
            this(arrayCache, object, l, l2);
        }

        @Nullable
        public final T getItem() {
            return this.item;
        }

        public final void setItem(@Nullable T t2) {
            this.item = t2;
        }

        public final long getIndex() {
            return this.index;
        }

        public final void setIndex(long l) {
            this.index = l;
        }

        public final long getTimeAdded() {
            return this.timeAdded;
        }

        public final void setTimeAdded(long l) {
            this.timeAdded = l;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Container clone(boolean shouldCloneItem) {
            Object t2;
            ArrayCache arrayCache = this.this$0;
            Object t3 = this.item;
            if (t3 != null) {
                void it;
                Object t4 = t3;
                ArrayCache arrayCache2 = this.this$0;
                Object t5 = t4;
                ArrayCache arrayCache3 = arrayCache;
                boolean bl = false;
                t2 = shouldCloneItem ? arrayCache2.cloneItem.invoke(it) : it;
                arrayCache = arrayCache3;
            } else {
                t2 = null;
            }
            long l = this.timeAdded;
            long l2 = this.index;
            Object t6 = t2;
            ArrayCache arrayCache4 = arrayCache;
            return new Container(arrayCache4, t6, l2, l);
        }
    }
}

