/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.Session;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.VersionConfig;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelStringMessage;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.ClientHelloMessage;
import org.jitsi.videobridge.message.EndpointMessage;
import org.jitsi.videobridge.message.EndpointStats;
import org.jitsi.videobridge.message.LastNMessage;
import org.jitsi.videobridge.message.ReceiverAudioSubscriptionMessage;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.message.ServerHelloMessage;
import org.jitsi.videobridge.message.SourceVideoTypeMessage;
import org.jitsi.videobridge.message.VideoTypeMessage;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.util.MultiStreamCompatibilityKt;
import org.jitsi.videobridge.websocket.ColibriWebSocket;
import org.json.simple.JSONObject;

public class EndpointMessageTransport
extends AbstractEndpointMessageTransport
implements DataChannelStack.DataChannelMessageListener,
ColibriWebSocket.EventHandler {
    private ColibriWebSocket webSocket;
    private final Object webSocketSyncRoot = new Object();
    private boolean webSocketLastActive = false;
    private WeakReference<DataChannel> dataChannel = new WeakReference<Object>(null);
    private final AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler eventHandler;
    private final AtomicInteger numOutgoingMessagesDropped = new AtomicInteger(0);
    private final Map<String, AtomicLong> sentMessagesCounts = new ConcurrentHashMap<String, AtomicLong>();
    @NotNull
    private final Endpoint endpoint;

    EndpointMessageTransport(@NotNull Endpoint endpoint, AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler eventHandler, Logger parentLogger) {
        super(parentLogger);
        this.endpoint = endpoint;
        this.eventHandler = eventHandler;
    }

    @Override
    protected void notifyTransportChannelConnected() {
        this.endpoint.endpointMessageTransportConnected();
        this.eventHandler.endpointMessageTransportConnected(this.endpoint);
    }

    @Override
    public BridgeChannelMessage clientHello(ClientHelloMessage message) {
        return this.createServerHello();
    }

    @Override
    public BridgeChannelMessage videoType(VideoTypeMessage videoTypeMessage) {
        return this.sourceVideoType(new SourceVideoTypeMessage(videoTypeMessage.getVideoType(), MultiStreamCompatibilityKt.endpointIdToSourceName(this.endpoint.getId()), videoTypeMessage.getEndpointId()));
    }

    @Override
    public BridgeChannelMessage sourceVideoType(SourceVideoTypeMessage sourceVideoTypeMessage) {
        String sourceName = sourceVideoTypeMessage.getSourceName();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Received video type of " + sourceName + ": " + String.valueOf((Object)sourceVideoTypeMessage.getVideoType()));
        }
        this.endpoint.setVideoType(sourceName, sourceVideoTypeMessage.getVideoType());
        Conference conference = this.endpoint.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn("Unable to forward SourceVideoTypeMessage, conference is expired");
            return null;
        }
        sourceVideoTypeMessage.setEndpointId(this.endpoint.getId());
        conference.sendMessage(sourceVideoTypeMessage, Collections.emptyList(), true);
        return null;
    }

    @Override
    public BridgeChannelMessage receiverAudioSubscription(@NotNull ReceiverAudioSubscriptionMessage receiverAudioSubscriptionMessage) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Received audio subscription: " + String.valueOf(receiverAudioSubscriptionMessage));
        }
        this.endpoint.setAudioSubscription(receiverAudioSubscriptionMessage);
        return null;
    }

    @Override
    public void unhandledMessage(@NotNull BridgeChannelMessage message) {
        this.getLogger().warn("Received a message with an unexpected type: " + message.getClass().getSimpleName());
    }

    @Override
    protected void sendMessage(Object dst, BridgeChannelMessage message) {
        super.sendMessage(dst, message);
        if (dst instanceof ColibriWebSocket) {
            this.sendMessage((ColibriWebSocket)dst, message);
        } else if (dst instanceof DataChannel) {
            this.sendMessage((DataChannel)dst, message);
        } else {
            throw new IllegalArgumentException("unknown transport:" + String.valueOf(dst));
        }
    }

    private void sendMessage(DataChannel dst, BridgeChannelMessage message) {
        dst.sendString(message.toJson());
        VideobridgeMetrics.dataChannelMessagesSent.inc();
    }

    private void sendMessage(ColibriWebSocket dst, BridgeChannelMessage message) {
        dst.sendString(message.toJson());
        VideobridgeMetrics.colibriWebSocketMessagesSent.inc();
    }

    @Override
    public void onDataChannelMessage(DataChannelMessage dataChannelMessage) {
        this.webSocketLastActive = false;
        VideobridgeMetrics.dataChannelMessagesReceived.inc();
        if (dataChannelMessage instanceof DataChannelStringMessage) {
            DataChannelStringMessage dataChannelStringMessage = (DataChannelStringMessage)dataChannelMessage;
            this.onMessage(this.dataChannel.get(), dataChannelStringMessage.data);
        }
    }

    @Override
    protected void sendMessage(@NotNull BridgeChannelMessage msg) {
        Object dst = this.getActiveTransportChannel();
        if (dst == null) {
            this.getLogger().debug("No available transport channel, can't send a message");
            this.numOutgoingMessagesDropped.incrementAndGet();
        } else {
            this.sentMessagesCounts.computeIfAbsent(msg.getClass().getSimpleName(), k -> new AtomicLong()).incrementAndGet();
            this.sendMessage(dst, msg);
        }
    }

    private Object getActiveTransportChannel() {
        DataChannel dataChannel = (DataChannel)this.dataChannel.get();
        ColibriWebSocket webSocket = this.webSocket;
        Object dst = null;
        if (this.webSocketLastActive) {
            dst = webSocket;
        }
        if (dst == null && dataChannel != null && dataChannel.isReady()) {
            dst = dataChannel;
        }
        if (dst == null && webSocket != null) {
            dst = webSocket;
        }
        return dst;
    }

    @Override
    public boolean isConnected() {
        return this.getActiveTransportChannel() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webSocketConnected(ColibriWebSocket ws) {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            Session session;
            if (this.webSocket != null && (session = this.webSocket.getSession()) != null) {
                session.close(1000, "replaced");
            }
            this.webSocket = ws;
            this.webSocketLastActive = true;
            this.sendMessage(ws, (BridgeChannelMessage)this.createServerHello());
        }
        try {
            this.notifyTransportChannelConnected();
        }
        catch (Exception e) {
            this.getLogger().warn("Caught an exception in notifyTransportConnected", e);
        }
    }

    private ServerHelloMessage createServerHello() {
        if (VersionConfig.config.announceVersion()) {
            return new ServerHelloMessage(this.endpoint.getConference().getVideobridge().getVersion().toString());
        }
        return new ServerHelloMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webSocketClosed(ColibriWebSocket ws, int statusCode, String reason) {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            if (ws != null && ws.equals(this.webSocket)) {
                this.webSocket = null;
                this.webSocketLastActive = false;
                this.getLogger().info(() -> "Websocket closed, statusCode " + statusCode + " ( " + reason + ").");
                if (statusCode == 1000 || statusCode == 1001 || statusCode == 1005) {
                    VideobridgeMetrics.colibriWebSocketCloseNormal.inc();
                } else {
                    VideobridgeMetrics.colibriWebSocketCloseAbnormal.inc();
                }
            }
        }
    }

    @Override
    public void webSocketError(ColibriWebSocket ws, Throwable cause) {
        this.getLogger().error("Colibri websocket error: " + cause.getMessage());
        VideobridgeMetrics.colibriWebSocketErrors.inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            if (this.webSocket != null) {
                this.webSocket.getSession().close(1001, "endpoint closed");
                this.webSocket = null;
                this.getLogger().debug(() -> "Endpoint expired, closed colibri web-socket.");
            }
        }
    }

    @Override
    public void webSocketTextReceived(ColibriWebSocket ws, String message) {
        if (ws == null || !ws.equals(this.webSocket)) {
            this.getLogger().warn("Received text from an unknown web socket.");
            return;
        }
        VideobridgeMetrics.colibriWebSocketMessagesReceived.inc();
        this.webSocketLastActive = true;
        this.onMessage(ws, message);
    }

    void setDataChannel(DataChannel dataChannel) {
        DataChannel prevDataChannel = (DataChannel)this.dataChannel.get();
        if (prevDataChannel == null) {
            this.dataChannel = new WeakReference<DataChannel>(dataChannel);
            dataChannel.onDataChannelEvents(this::notifyTransportChannelConnected);
            if (dataChannel.isReady()) {
                this.notifyTransportChannelConnected();
            }
        } else {
            if (prevDataChannel == dataChannel) {
                throw new Error("Re-setting the same data channel");
            }
            throw new Error("Overwriting a previous data channel!");
        }
        dataChannel.onDataChannelMessage(this);
    }

    @Override
    public JSONObject getDebugState() {
        JSONObject debugState = super.getDebugState();
        debugState.put("numOutgoingMessagesDropped", this.numOutgoingMessagesDropped.get());
        JSONObject sentCounts = new JSONObject();
        sentCounts.putAll(this.sentMessagesCounts);
        debugState.put("sent_counts", sentCounts);
        return debugState;
    }

    @Override
    @Nullable
    public BridgeChannelMessage receiverVideoConstraints(@NotNull ReceiverVideoConstraintsMessage message) {
        this.endpoint.setBandwidthAllocationSettings(message);
        return null;
    }

    @Override
    public BridgeChannelMessage lastN(LastNMessage message) {
        this.endpoint.setLastN(message.getLastN());
        return null;
    }

    @Override
    public BridgeChannelMessage endpointMessage(EndpointMessage message) {
        if (this.endpoint.getVisitor()) {
            this.getLogger().warn("Not forwarding endpoint message from visitor endpoint");
            return null;
        }
        String from = this.endpoint.getId();
        message.setFrom(from);
        Conference conference = this.endpoint.getConference();
        if (conference == null || conference.isExpired()) {
            this.getLogger().warn("Unable to send EndpointMessage, conference is null or expired");
            return null;
        }
        if (message.isBroadcast()) {
            LinkedList<Endpoint> targets = new LinkedList<Endpoint>(conference.getLocalEndpoints());
            targets.remove(this.endpoint);
            conference.sendMessage(message, targets, true);
        } else {
            String to = message.getTo();
            AbstractEndpoint targetEndpoint = conference.getEndpoint(to);
            if (targetEndpoint instanceof Endpoint) {
                ((Endpoint)targetEndpoint).sendMessage(message);
            } else if (targetEndpoint instanceof RelayedEndpoint) {
                ((RelayedEndpoint)targetEndpoint).getRelay().sendMessage(message);
            } else if (targetEndpoint != null) {
                conference.sendMessage(message, Collections.emptyList(), true);
            } else {
                this.getLogger().warn("Unable to find endpoint to send EndpointMessage to: " + to);
            }
        }
        return null;
    }

    @Override
    public BridgeChannelMessage endpointStats(@NotNull EndpointStats message) {
        if (this.endpoint.getVisitor()) {
            this.getLogger().warn("Not forwarding endpoint stats from visitor endpoint");
            return null;
        }
        String from = this.endpoint.getId();
        message.setFrom(from);
        Conference conference = this.endpoint.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn("Unable to send EndpointStats, conference is null or expired");
            return null;
        }
        List<Endpoint> targets = conference.getLocalEndpoints().stream().filter(ep -> ep != this.endpoint && ep.wantsStatsFrom(this.endpoint)).collect(Collectors.toList());
        conference.sendMessage(message, targets, true);
        return null;
    }
}

