/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.SimpleScrollPane;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicJidePopupMenuUI
extends BasicPopupMenuUI {
    public static ComponentUI createUI(JComponent c) {
        return new BasicJidePopupMenuUI();
    }

    public Popup getPopup(JPopupMenu popupMenu, int x, int y) {
        Popup popup = BasicJidePopupMenuUI.addScrollPaneIfNecessary(popupMenu, x, y);
        return popup == null ? super.getPopup(popupMenu, x, y) : popup;
    }

    public static Popup addScrollPaneIfNecessary(final JPopupMenu popupMenu, int x, int y) {
        final SimpleScrollPane contents = new SimpleScrollPane(popupMenu, 20, 31);
        if (popupMenu instanceof JidePopupMenu && popupMenu.getPreferredSize().height != ((JidePopupMenu)popupMenu).getPreferredScrollableViewportSize().height) {
            Component[] components;
            if (popupMenu.getLayout() instanceof DefaultMenuLayout && SystemInfo.isJdk6Above()) {
                popupMenu.setLayout(new BoxLayout(popupMenu, ((DefaultMenuLayout)popupMenu.getLayout()).getAxis()));
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            contents.getScrollUpButton().setOpaque(true);
            contents.getScrollDownButton().setOpaque(true);
            contents.setBorder(BorderFactory.createEmptyBorder());
            for (Component component : components = popupMenu.getComponents()) {
                if (!(component instanceof JMenuItem)) continue;
                ((JMenuItem)component).addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        if (e.getSource() instanceof JMenuItem && ((JMenuItem)e.getSource()).getModel().isArmed()) {
                            popupMenu.scrollRectToVisible(((JMenuItem)e.getSource()).getBounds());
                            Point position = contents.getViewport().getViewPosition();
                            contents.getScrollUpButton().setEnabled(position.y > 2);
                            contents.getScrollDownButton().setEnabled(position.y < contents.getViewport().getViewSize().height - contents.getViewport().getViewRect().height - 2);
                        }
                    }
                });
            }
            return popupFactory.getPopup(popupMenu.getInvoker(), contents, x, y);
        }
        return null;
    }
}

