/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.compose.service.commands.DockerCommandModalityMode;
import com.intellij.docker.compose.service.commands.SharedVolume;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerProcessUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessConnectionData;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.RemoteProcessUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.console.RubyConsoleProcessHandler;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;

public class RubyDockerComposeProcessUtil {
    private static final Logger LOG = Logger.getInstance(RubyDockerComposeProcessUtil.class);

    @NotNull
    public static RubyConsoleProcessHandler startDockerComposeConsole(@Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data, @NotNull GeneralCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(1);
        }
        if (pathMapper == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(2);
        }
        KillableColoredProcessHandler processHandler = RubyDockerComposeProcessUtil.createDockerComposeProcess(project, data, commandLine, pathMapper, false);
        RubyConsoleProcessHandler rubyConsoleProcessHandler = new RubyConsoleProcessHandler(processHandler.getProcess(), commandLine.getCommandLineString());
        if (rubyConsoleProcessHandler == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(3);
        }
        return rubyConsoleProcessHandler;
    }

    @NotNull
    public static ProcessHandler startDockerComposeProcess(@Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data, @NotNull GeneralCommandLine commandLine, @NotNull AbstractPathMapper pathMapper, boolean composeUp) throws RemoteSdkException {
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(4);
        }
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(6);
        }
        KillableColoredProcessHandler killableColoredProcessHandler = RubyDockerComposeProcessUtil.createDockerComposeProcess(project, data, commandLine, pathMapper, composeUp);
        if (killableColoredProcessHandler == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(7);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    private static KillableColoredProcessHandler createDockerComposeProcess(@Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data, @NotNull GeneralCommandLine commandLine, @NotNull AbstractPathMapper pathMapper, boolean composeUp) throws RemoteSdkException {
        KillableColoredProcessHandler killableColoredProcessHandler;
        DockerContainerSettings containerSettings;
        List dockerComposePorts;
        RubyCommandLineData rubyCommandLineData;
        Collection portForwardings;
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(8);
        }
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(9);
        }
        if (pathMapper == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(10);
        }
        if (Registry.is((String)"ruby.docker.verbose.logging")) {
            LOG.info(String.format("[DOCKER]: %s", commandLine.getCommandLineString()));
        }
        Collection collection = portForwardings = (rubyCommandLineData = (RubyCommandLineData)commandLine.getUserData(RubyCommandLine.COMMAND_LINE_DATA_KEY)) != null ? (Collection)rubyCommandLineData.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY) : null;
        if (portForwardings == null) {
            dockerComposePorts = Collections.emptyList();
        } else {
            dockerComposePorts = new ArrayList();
            for (PortForwarding portForwarding : portForwardings) {
                DockerComposePort dockerComposePort = new DockerComposePort(null, Integer.valueOf(portForwarding.getLocalPort()), Integer.valueOf(portForwarding.getRemotePort()));
                dockerComposePorts.add(dockerComposePort);
            }
        }
        HashMap env = ContainerUtil.newHashMap((Map)commandLine.getEnvironment());
        List commandList = commandLine.getCommandLineList(commandLine.getExePath());
        String workingDir = commandLine.getWorkDirectory() != null ? commandLine.getWorkDirectory().getPath() : null;
        workingDir = RemoteProcessUtil.toRemoteFileSystemStyle((String)workingDir);
        DockerContainerSettings dockerContainerSettings = containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        if (containerSettings != null) {
            for (DockerVolumeBindingImpl binding : containerSettings.getVolumeBindings()) {
                ((PathMappingSettings)pathMapper).addMapping(binding.getHostPath(), binding.getContainerPath());
            }
        }
        String[] command = RemoteProcessUtil.buildRemoteCommand((AbstractPathMapper)pathMapper, (Collection)commandList);
        String[] shCommand = RubyCommandLine.patchWithSh((String[])command);
        VolumesBuilder volumesBinds = DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)containerSettings);
        try {
            RemoteDockerRuntime dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)data.getAccount(), (Project)project);
            SharedVolume sharedVolume = RubyDockerProcessUtil.getSharedVolume(dockerRuntime);
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            DockerCommandModalityMode modalityMode = ApplicationManager.getApplication().isDispatchThread() ? DockerCommandModalityMode.MODAL : DockerCommandModalityMode.BACKGROUND;
            ComposeServiceUpCmd cmd = composeUp ? serviceClient.upServicesCmd() : serviceClient.runServiceCmd().withNoPty(true);
            AbstractServiceCmd servicesCmd = cmd.withConfigurationPath(data.getComposeFilePaths()).withEnvs(data.getEnvs()).withServiceName(data.getComposeServiceName()).withEnvironment((Map)env).withCommand(shCommand).withWorkingDir(workingDir).withSharedVolume(sharedVolume).withPorts(dockerComposePorts).withVolumes(volumesBinds.build()).withModalityMode(modalityMode);
            killableColoredProcessHandler = servicesCmd.execute();
        }
        catch (WrappedInternalServerErrorException e) {
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        catch (Throwable e) {
            throw new RemoteSdkException(e.getMessage(), e);
        }
        if (killableColoredProcessHandler == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(11);
        }
        return killableColoredProcessHandler;
    }

    @NotNull
    public static DockerComposeCredentialsHolder getDockerComposeCredentialsHolder(@NotNull RubyRemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(12);
        }
        final Ref result = Ref.create();
        commonCredentials.switchOnConnectionType(new CredentialsCase[]{new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                result.set((Object)credentials);
            }
        }});
        if (result.isNull()) {
            throw new IllegalArgumentException();
        }
        DockerComposeCredentialsHolder dockerComposeCredentialsHolder = (DockerComposeCredentialsHolder)result.get();
        if (dockerComposeCredentialsHolder == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(13);
        }
        return dockerComposeCredentialsHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeProcessUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeProcessUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startDockerComposeConsole";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "startDockerComposeProcess";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerComposeProcess";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeCredentialsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startDockerComposeConsole";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "startDockerComposeProcess";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDockerComposeProcess";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeCredentialsHolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

