/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetEnvironment;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetProjectFilesListener;
import com.intellij.lang.puppet.project.PuppetProjectListener;
import com.intellij.lang.puppet.project.PuppetScopeManager;
import com.intellij.lang.puppet.project.meta.PuppetHeadlessModuleMetadata;
import com.intellij.lang.puppet.project.meta.PuppetModuleMetadata;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryIndex;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetProjectManager
implements Disposable,
ProjectComponent {
    public static final Topic<PuppetProjectListener> PUPPET_PROJECT_TOPIC = new Topic("Puppet project change", PuppetProjectListener.class);
    public static final String MODULE_META_FILE = "metadata.json";
    public static final String ENVIRONMENT_META_FILE = "environment.conf";
    public static final String PUPPET_FILE = "Puppetfile";
    private final Map<VirtualFile, PuppetEntity> myRootsMap = ContainerUtil.newConcurrentMap();
    private final MultiMap<VirtualFile, VirtualFile> myImplicitRootsMap = MultiMap.createConcurrentSet();
    @NotNull
    private final Project myProject;
    private final PuppetScopeManager myScopeManager;
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("Updating UI on puppet project structure change", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    private final MessageBus myMessageBus;

    public PuppetProjectManager(Project project, PuppetScopeManager puppetScopeManager) {
        this.myProject = project;
        this.myScopeManager = puppetScopeManager;
        this.myMessageBus = project.getMessageBus();
        this.myMessageBus.connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                PuppetProjectManager.this.rescanProjectStructure();
            }
        });
    }

    public void projectOpened() {
        this.myMessageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new PuppetProjectFilesListener(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanProjectStructure() {
        Map<VirtualFile, PuppetEntity> map = this.myRootsMap;
        synchronized (map) {
            this.myRootsMap.clear();
            this.myImplicitRootsMap.clear();
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        ((PuppetProjectListener)this.myMessageBus.syncPublisher(PUPPET_PROJECT_TOPIC)).projectUpdated();
        this.scanScopeForEntities(ProjectScope.getContentScope((Project)this.myProject));
    }

    public void dispose() {
    }

    private void scanScopeForEntities(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PuppetProjectManager.$$$reportNull$$$0(0);
        }
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
            if (scope == null) {
                PuppetProjectManager.$$$reportNull$$$0(21);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            THashSet rootSet = new THashSet();
            Processor processor = arg_0 -> PuppetProjectManager.lambda$null$0((Set)rootSet, arg_0);
            FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)MODULE_META_FILE, (boolean)true, (GlobalSearchScope)scope).forEach(arg_0 -> ((Processor)processor).process(arg_0));
            FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)ENVIRONMENT_META_FILE, (boolean)true, (GlobalSearchScope)scope).forEach(arg_0 -> ((Processor)processor).process(arg_0));
            FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)PUPPET_FILE, (boolean)true, (GlobalSearchScope)scope).forEach(arg_0 -> ((Processor)processor).process(arg_0));
            rootSet.forEach(virtualFile -> {
                ProgressManager.checkCanceled();
                this.updateMetadata((VirtualFile)virtualFile);
                this.projectUpdated();
            });
        });
    }

    private void scanForImplicitModules(@NotNull PuppetEntity<?> explicitEntity) {
        if (explicitEntity == null) {
            PuppetProjectManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (explicitEntity == null) {
                PuppetProjectManager.$$$reportNull$$$0(19);
            }
            if (!explicitEntity.isValid()) {
                return;
            }
            explicitEntity.getAllDependenciesRoots().stream().flatMap(file -> Arrays.stream(file.getChildren())).filter(file -> file.isValid() && file.isDirectory() && this.getPuppetModuleOrEnvironment((VirtualFile)file) == null).forEach(implicitRoot -> {
                if (explicitEntity == null) {
                    PuppetProjectManager.$$$reportNull$$$0(20);
                }
                this.addImplicitModule((VirtualFile)implicitRoot, explicitEntity.getRoot());
            });
        });
    }

    void updateMetadata(@Nullable VirtualFile root) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (root == null || this.myProject.isDisposed()) {
            return;
        }
        if (root.isValid()) {
            VirtualFile keyFile = root.findChild(MODULE_META_FILE);
            PuppetEntity newEntity = null;
            if (keyFile != null) {
                PuppetModuleMetadata moduleMetadata = PuppetModuleMetadata.readMetadata(keyFile);
                if (moduleMetadata != null) {
                    newEntity = new PuppetModule(this.myProject, root, moduleMetadata);
                }
            } else if (root.findChild(ENVIRONMENT_META_FILE) != null || root.findChild(PUPPET_FILE) != null) {
                newEntity = new PuppetEnvironment(this.myProject, root);
            }
            if (newEntity != null) {
                this.removeRoot(root);
                this.addRoot(root, newEntity);
                this.scanForImplicitModules(newEntity);
            } else {
                PuppetEntity existingEntity = this.getPuppetModuleOrEnvironment(root);
                if (existingEntity instanceof PuppetEnvironment || existingEntity instanceof PuppetModule && !((PuppetModule)existingEntity).isHeadless()) {
                    this.removeRoot(root);
                }
            }
        }
    }

    @NotNull
    public List<VirtualFile> getAllRoots() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myRootsMap.keySet());
        if (arrayList == null) {
            PuppetProjectManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<PuppetModule> getAllModules() {
        Map<VirtualFile, PuppetEntity> map = this.myRootsMap;
        // MONITORENTER : map
        List list = ContainerUtil.mapNotNull(this.myRootsMap.values(), entity -> entity instanceof PuppetModule ? (PuppetModule)entity : null);
        // MONITOREXIT : map
        if (list != null) return list;
        PuppetProjectManager.$$$reportNull$$$0(3);
        return list;
    }

    void projectUpdated() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myScopeManager.clearCache();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myUpdateQueue.queue(new Update("update puppet tree"){

                public void run() {
                    ProjectView.getInstance((Project)PuppetProjectManager.this.myProject).refresh();
                }
            });
        }
    }

    private void addImplicitModule(@NotNull VirtualFile implicitRoot, @NotNull VirtualFile parentRoot) {
        if (implicitRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(4);
        }
        if (parentRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(5);
        }
        this.addImplicitRoot(implicitRoot, new PuppetModule(this.myProject, implicitRoot, new PuppetHeadlessModuleMetadata(implicitRoot.getName())), parentRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addImplicitRoot(@NotNull VirtualFile root, @NotNull PuppetEntity entity, @NotNull VirtualFile parentRoot) {
        if (root == null) {
            PuppetProjectManager.$$$reportNull$$$0(6);
        }
        if (entity == null) {
            PuppetProjectManager.$$$reportNull$$$0(7);
        }
        if (parentRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, PuppetEntity> map = this.myRootsMap;
        synchronized (map) {
            this.addRoot(root, entity);
            this.myImplicitRootsMap.putValue((Object)parentRoot, (Object)root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoot(@NotNull VirtualFile root, @NotNull PuppetEntity entity) {
        if (root == null) {
            PuppetProjectManager.$$$reportNull$$$0(9);
        }
        if (entity == null) {
            PuppetProjectManager.$$$reportNull$$$0(10);
        }
        Map<VirtualFile, PuppetEntity> map = this.myRootsMap;
        synchronized (map) {
            this.myRootsMap.put(root, entity);
        }
        ((PuppetProjectListener)this.myMessageBus.syncPublisher(PUPPET_PROJECT_TOPIC)).projectUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoot(@NotNull VirtualFile root) {
        if (root == null) {
            PuppetProjectManager.$$$reportNull$$$0(11);
        }
        Map<VirtualFile, PuppetEntity> map = this.myRootsMap;
        synchronized (map) {
            if (!this.myRootsMap.containsKey(root)) {
                return;
            }
            this.myRootsMap.remove(root);
            Iterator iterator = this.myImplicitRootsMap.get((Object)root).iterator();
            while (iterator.hasNext()) {
                this.myRootsMap.remove(iterator.next());
                iterator.remove();
            }
        }
        ((PuppetProjectListener)this.myMessageBus.syncPublisher(PUPPET_PROJECT_TOPIC)).projectUpdated();
    }

    void clearMetaData(@NotNull VirtualFile entityRoot) {
        if (entityRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(12);
        }
        this.removeRoot(entityRoot);
    }

    @Nullable
    public PuppetEntity getPuppetModuleOrEnvironment(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        return this.myRootsMap.get(root);
    }

    @Nullable
    public PuppetEntity findExplicitModuleOrEnvironmentForFile(@Nullable VirtualFile file) {
        while (file != null) {
            PuppetEntity entity = this.findModuleOrEnvironmentForFile(file);
            if (entity instanceof PuppetModule && ((PuppetModule)entity).isHeadless()) {
                file = entity.getRoot().getParent();
                continue;
            }
            return entity;
        }
        return null;
    }

    @Nullable
    public PuppetEntity findModuleOrEnvironmentForFile(@NotNull VirtualFile file) {
        PuppetDirectoryInfo puppetDirectoryInfo;
        if (file == null) {
            PuppetProjectManager.$$$reportNull$$$0(13);
        }
        if (!(puppetDirectoryInfo = PuppetDirectoryIndex.getInstance(this.myProject).getInfoForFile(file)).isAvailable()) {
            return null;
        }
        return this.getPuppetModuleOrEnvironment(puppetDirectoryInfo.getPuppetRoot());
    }

    @NotNull
    public List<PuppetModule> getModulesInRoot(@Nullable VirtualFile root) {
        if (root == null || !root.isValid()) {
            List<PuppetModule> list = Collections.emptyList();
            if (list == null) {
                PuppetProjectManager.$$$reportNull$$$0(14);
            }
            return list;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<PuppetModule> result = new ArrayList<PuppetModule>();
        for (PuppetModule module : this.getAllModules()) {
            VirtualFile moduleRoot = module.getRoot();
            if (!moduleRoot.isValid() || !root.equals(moduleRoot.getParent())) continue;
            result.add(module);
        }
        ArrayList<PuppetModule> arrayList = result;
        if (arrayList == null) {
            PuppetProjectManager.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public Collection<PuppetModule> findModules(@NotNull String name) {
        if (name == null) {
            PuppetProjectManager.$$$reportNull$$$0(16);
        }
        return ContainerUtil.filter(this.getAllModules(), module -> {
            if (name == null) {
                PuppetProjectManager.$$$reportNull$$$0(18);
            }
            return name.equals(module.getName()) || name.equals(module.getShortName());
        });
    }

    public Pair<Map<VirtualFile, PuppetEntity>, MultiMap<VirtualFile, VirtualFile>> getRootsData() {
        return Pair.create(this.myRootsMap, this.myImplicitRootsMap);
    }

    public static PuppetProjectManager getInstance(@NotNull Project project) {
        if (project == null) {
            PuppetProjectManager.$$$reportNull$$$0(17);
        }
        return (PuppetProjectManager)project.getComponent(PuppetProjectManager.class);
    }

    private static /* synthetic */ boolean lambda$null$0(Set rootSet, VirtualFile file) {
        ProgressManager.checkCanceled();
        VirtualFile root = file.getParent();
        if (root != null) {
            rootSet.add(root);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitEntity";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetProjectManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitRoot";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRoot";
                break;
            }
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityRoot";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetProjectManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModules";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scanScopeForEntities";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scanForImplicitModules";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitModule";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitRoot";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clearMetaData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOrEnvironmentForFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findModules$8";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scanForImplicitModules$6";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scanScopeForEntities$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

