/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkConfigurator;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public abstract class RubyRemoteSdkConfigurator
extends RubySdkConfigurator {
    private static final Logger LOG = Logger.getInstance(RubyRemoteSdkConfigurator.class);

    public abstract RubyRemoteSdkTransfer buildRemoteTransfer(@Nullable Project var1, @NotNull RubyRemoteSdkAdditionalData var2) throws ExecutionException, InterruptedException;

    public void initSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(0);
        }
        LOG.info("initializing " + sdk);
        super.initSdk(sdk);
        RubyRemoteSdkAdditionalData remoteSdkData = (RubyRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
        assert (remoteSdkData != null);
        String localGemsRootPath = RubyRemoteSdkConfigurator.getLocalGemsRootPath(sdk);
        LinkedHashSet remoteRootPaths = ContainerUtil.newLinkedHashSet((Iterable)RubyGemsEnvironment.getGemPaths((Sdk)sdk));
        remoteSdkData.setGemsMappings(this.createMappingSettings(localGemsRootPath, remoteRootPaths));
        remoteSdkData.setGemsRootUrls(this.createGemsRootList(localGemsRootPath, remoteRootPaths));
        this.mapGemsBinDirectory(sdk, localGemsRootPath);
        this.synchronizeFilesBetweenLocalAndRemoteHost(sdk);
    }

    protected void synchronizeFilesBetweenLocalAndRemoteHost(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(1);
        }
        RubyRemoteInterpreterManager.getInstance().updateHelpers(sdk);
        RubyRemoteInterpreterManager.getInstance().updateGemsCopy(sdk, null, true);
    }

    private PathMappingSettings createMappingSettings(String localGemsRootPath, Set<String> remoteRootPaths) {
        PathMappingSettings result = new PathMappingSettings();
        for (String remoteRootPath : remoteRootPaths) {
            String localRootPath = this.getLocalGemPath(localGemsRootPath, remoteRootPath);
            RubyRemoteSdkConfigurator.addMapping(result, remoteRootPath, localRootPath, "bin", "gems", "specifications", "bundler");
        }
        return result;
    }

    private List<String> createGemsRootList(String localGemsRootPath, Set<String> remoteRootPaths) {
        ArrayList result = Lists.newArrayList();
        for (String remoteRootPath : remoteRootPaths) {
            String localRootPath = this.getLocalGemPath(localGemsRootPath, remoteRootPath);
            result.add(VirtualFileUtil.constructLocalUrl((String)(localRootPath + "/gems")));
            result.add(VirtualFileUtil.constructLocalUrl((String)(localRootPath + '/' + "bundler" + "/gems")));
        }
        return result;
    }

    protected void mapGemsBinDirectory(Sdk sdk, String localGemsRootPath) {
        RubyRemoteSdkAdditionalData remoteSdkData = (RubyRemoteSdkAdditionalData)sdk.getSdkAdditionalData();
        assert (remoteSdkData != null);
        String gemsBinDirectory = RubyGemsEnvironment.getExecutableDirectory((Sdk)sdk);
        if (gemsBinDirectory == null) {
            throw new RuntimeException("Could not find gems binaries directory");
        }
        String localGemsBinPath = this.getLocalGemPath(localGemsRootPath, gemsBinDirectory);
        LOG.info("localGemsBinPath=" + localGemsBinPath + ", remoteGemsBinPath=" + gemsBinDirectory);
        remoteSdkData.setGemsBinDirectory(localGemsBinPath);
        try {
            VfsUtil.createDirectories((String)localGemsBinPath);
        }
        catch (IOException e) {
            String errorMessage = "Unable to create a local gems bin path: " + localGemsBinPath;
            LOG.error(errorMessage, (Throwable)e);
            throw new RuntimeException(errorMessage, e);
        }
        remoteSdkData.getPathMappings().addMapping(localGemsBinPath, gemsBinDirectory);
    }

    @NotNull
    protected String getLocalGemPath(@NotNull String rootPath, @NotNull String remotePath) {
        if (rootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(2);
        }
        if (remotePath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(3);
        }
        String string = rootPath + File.separator + FileUtil.toSystemIndependentName((String)remotePath).hashCode();
        if (string == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getLocalGemsRootPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(5);
        }
        String sep = File.separator;
        String sdkHome = sdk.getHomePath();
        assert (sdkHome != null);
        String path = FileUtil.toCanonicalPath((String)(PathManager.getSystemPath() + sep + "ruby_stubs" + sep + FileUtil.toSystemIndependentName((String)sdkHome).hashCode()));
        assert (path != null);
        String string = path;
        if (string == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static void addMapping(@NotNull PathMappingSettings mappingSettings, @NotNull String remoteRootPath, @NotNull String localRootPath, String ... subDirs) {
        if (mappingSettings == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(7);
        }
        if (remoteRootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(8);
        }
        if (localRootPath == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(9);
        }
        if (subDirs == null) {
            RubyRemoteSdkConfigurator.$$$reportNull$$$0(10);
        }
        for (String subDir : subDirs) {
            String localPath = new File(localRootPath, subDir).getAbsolutePath();
            String remotePath = RemoteFile.createRemoteFile((String)remoteRootPath, (String)subDir).getPath();
            LOG.info("localPath=" + localPath + ", remotePath=" + remotePath);
            mappingSettings.addMapping(localPath, remotePath);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubyRemoteSdkConfigurator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRootPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRootPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubyRemoteSdkConfigurator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalGemsRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "synchronizeFilesBetweenLocalAndRemoteHost";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemPath";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalGemsRootPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

