/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum JSLintOption {
    BITWISE(Type.BOOLEAN, "Tolerate bitwise operators", "check if bitwise operators should be allowed"),
    BROWSER(Type.BOOLEAN, "Assume a browser", "check if the standard browser globals should be predefined"),
    COUCH(Type.BOOLEAN, "Assume CouchDB", "check if Couch DB globals should be predefined"),
    DEVEL(Type.BOOLEAN, "Assume in development", "check if browser globals that are useful in development should be predefined"),
    ES6(Type.BOOLEAN, "ES6", "check if using the good parts of ECMAScript Sixth Edition, it adds ES6 globals"),
    EVAL(Type.BOOLEAN, "Tolerate eval", "check if eval should be allowed"),
    FOR(Type.BOOLEAN, "Tolerate for statement", "check if for statement should be allowed"),
    MAXERR(Type.INTEGER, "Maximum number of errors", "Maximum number of warnings reported"),
    MAXLEN(Type.INTEGER, "Maximum line length", "Maximum number of characters in a line"),
    MULTIVAR(Type.BOOLEAN, "multiple vars", "check if a var, let, or const statement can declare two or more variables in a single statement"),
    NODE(Type.BOOLEAN, "Assume Node.js", "check if Node.js globals should be predefined"),
    GLOBALS(Type.STRING, "Globals ( , separated)", "An array of strings, the names of predefined global variables, or an object whose keys are global variable names, and whose values are booleans that determine if each variable is assignable. predef is used with the option object, but not with the /*jslint */ directive. You can also use the var statement to declare global variables in a script file."),
    SINGLE(Type.BOOLEAN, "Tolerate single quote strings", "check if ' (single quote) should be allowed to enclose string literals"),
    THIS(Type.BOOLEAN, "Tolerate this", "check if this should be allowed"),
    WHITE(Type.BOOLEAN, "Tolerate whitespace mess", "check if the whitespace rules should be ignored");

    private final String myOptionName;
    private final Type myType;
    private final String myDescription;
    private final String myMeaning;
    private static final ImmutableMap<String, JSLintOption> OPTION_BY_NAME_MAP;

    private JSLintOption(@NotNull Type type, String description, String meaning) {
        if (type == null) {
            JSLintOption.$$$reportNull$$$0(0);
        }
        if (description == null) {
            JSLintOption.$$$reportNull$$$0(1);
        }
        if (meaning == null) {
            JSLintOption.$$$reportNull$$$0(2);
        }
        this.myOptionName = this.name().toLowerCase(Locale.US);
        this.myType = type;
        this.myDescription = description;
        this.myMeaning = meaning;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            JSLintOption.$$$reportNull$$$0(3);
        }
        return type;
    }

    @NotNull
    public String getOptionName() {
        String string = this.myOptionName;
        if (string == null) {
            JSLintOption.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            JSLintOption.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getMeaning() {
        String string = this.myMeaning;
        if (string == null) {
            JSLintOption.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static JSLintOption findByName(@NotNull String optionName) {
        if (optionName == null) {
            JSLintOption.$$$reportNull$$$0(7);
        }
        return (JSLintOption)((Object)OPTION_BY_NAME_MAP.get((Object)optionName));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (JSLintOption option : JSLintOption.values()) {
            builder.put((Object)option.getOptionName(), (Object)option);
        }
        OPTION_BY_NAME_MAP = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meaning";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jslint/JSLintOption";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOption";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMeaning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        BOOLEAN((Class)Boolean.class){

            @Override
            public Boolean createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    1.$$$reportNull$$$0(0);
                }
                return Boolean.parseBoolean(valueStr);
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                return value == Boolean.FALSE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valueStr";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDefault";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public String createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    2.$$$reportNull$$$0(0);
                }
                return valueStr;
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    2.$$$reportNull$$$0(1);
                }
                return "".equals(value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valueStr";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDefault";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        INTEGER((Class)Integer.class){

            @Override
            public Integer createObject(@NotNull String valueStr) {
                if (valueStr == null) {
                    3.$$$reportNull$$$0(0);
                }
                try {
                    return Integer.parseInt(valueStr);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public boolean isDefault(@NotNull Object value) {
                if (value == null) {
                    3.$$$reportNull$$$0(1);
                }
                return false;
            }

            @Override
            public boolean isProperValue(@Nullable Object obj) {
                if (obj == null) {
                    return true;
                }
                if (obj instanceof Integer || obj instanceof Long) {
                    Number n = (Number)obj;
                    return n.intValue() >= 0;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "valueStr";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOption$Type$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isDefault";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        private final Class<?> myClass;

        private Type(Class<?> clazz) {
            this.myClass = clazz;
        }

        @Nullable
        public abstract Object createObject(@NotNull String var1);

        public abstract boolean isDefault(@NotNull Object var1);

        public boolean isProperValue(@Nullable Object obj) {
            return obj == null || this.myClass.isInstance(obj);
        }
    }
}

