/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class DottedBorder
implements Border {
    private final int myTop;
    private final int myBottom;
    private final int myLeft;
    private final int myRight;
    private final Color myColor;

    public DottedBorder(Insets insets, Color color) {
        this.myTop = insets.top;
        this.myBottom = insets.bottom;
        this.myLeft = insets.left;
        this.myRight = insets.right;
        this.myColor = color;
    }

    public DottedBorder(Color color) {
        this((Insets)JBUI.insets((int)1), color);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.myColor);
        UIUtil.drawDottedRectangle((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)(y + height - 1));
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.myTop, this.myLeft, this.myBottom, this.myRight);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

