/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.content;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.HeadingMap;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class InlineConverter
extends ConverterHelper {
    public InlineConverter(Config config, ConverterPalette palette) {
        super(config, palette);
    }

    public void traverseInlineText(Element node, LaTeXDocumentPortion ldp, Context oc, boolean styled) {
        if (this.onlyNote(node)) {
            styled = false;
        }
        boolean bNoFootnotes = false;
        String styleName = node.getAttribute("text:style-name");
        this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(styleName));
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.palette.getCharSc().applyTextStyle(styleName, ba, ic);
        if (styled && !ic.isInFootnote()) {
            bNoFootnotes = true;
        }
        if (styled) {
            if (bNoFootnotes) {
                ic.setNoFootnotes(true);
            }
            ldp.append(ba.getBefore());
        }
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) break;
                        ldp.append(this.palette.getI18n().convert(s, false, ic.getLang()));
                        break;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (child.getNodeName().startsWith("draw:")) {
                            this.palette.getDrawCv().handleDrawElement(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:s")) {
                            if (this.config.ignoreDoubleSpaces()) {
                                ldp.append(" ");
                                break;
                            }
                            int count = Misc.getPosInteger(child.getAttribute("text:c"), 1);
                            String sSpace = this.config.ignoreDoubleSpaces() ? " " : "\\ ";
                            while (count > 0) {
                                ldp.append("\\ ");
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop")) {
                            if (ic.isInHeaderFooter()) {
                                ldp.append("\\hfill ");
                                break;
                            }
                            ldp.append(" ");
                            break;
                        }
                        if (sName.equals("text:line-break")) {
                            if (!ic.isInHeaderFooter() && !this.config.ignoreHardLineBreaks()) {
                                ldp.append("\\newline").nl();
                                break;
                            }
                            ldp.append(" ");
                            break;
                        }
                        if (sName.equals("text:span")) {
                            if (ic.isVerbatim()) {
                                this.traverseVerbatimInlineText(child, ldp, ic, true);
                                break;
                            }
                            this.traverseInlineText(child, ldp, ic, true);
                            break;
                        }
                        if (sName.equals("text:a")) {
                            this.palette.getFieldCv().handleAnchor(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("office:annotation")) {
                            this.handleOfficeAnnotation(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:page-number")) {
                            this.palette.getFieldCv().handlePageNumber(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:page-count")) {
                            this.palette.getFieldCv().handlePageCount(child, ldp, ic);
                            break;
                        }
                        if (ic.isInHeaderFooter()) {
                            if (sName.equals("text:chapter")) {
                                this.handleChapterField(child, ldp, ic);
                                break;
                            }
                            if (!sName.startsWith("text:")) break;
                            this.traverseInlineText(child, ldp, ic, false);
                            break;
                        }
                        if (sName.equals("text:footnote")) {
                            this.palette.getNoteCv().handleFootnote(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:endnote")) {
                            this.palette.getNoteCv().handleEndnote(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:sequence")) {
                            this.palette.getFieldCv().handleSequence(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:sequence-ref")) {
                            this.palette.getFieldCv().handleSequenceRef(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:footnote-ref")) {
                            this.palette.getNoteCv().handleFootnoteRef(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:endnote-ref")) {
                            this.palette.getNoteCv().handleEndnoteRef(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:reference-mark")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:reference-mark-start")) {
                            this.palette.getFieldCv().handleReferenceMark(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:reference-ref")) {
                            this.palette.getFieldCv().handleReferenceRef(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:bookmark")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:bookmark-start")) {
                            this.palette.getFieldCv().handleBookmark(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:bookmark-ref")) {
                            this.palette.getFieldCv().handleBookmarkRef(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:bibliography-mark")) {
                            this.palette.getIndexCv().handleBibliographyMark(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, ic);
                            break;
                        }
                        if (sName.equals("text:alphabetical-index-mark-start")) {
                            this.palette.getIndexCv().handleAlphabeticalIndexMark(child, ldp, ic);
                            break;
                        }
                        if (!sName.startsWith("text:")) break;
                        this.traverseInlineText(child, ldp, ic, false);
                        break;
                    }
                }
                ++i;
            }
        }
        if (styled) {
            ldp.append(ba.getAfter());
            ic.setNoFootnotes(false);
            if (!ic.isInFootnote()) {
                this.palette.getNoteCv().flushFootnotes(ldp, oc);
            }
        }
        this.palette.getI18n().popSpecialTable();
    }

    public void traversePlainInlineText(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            String styleName = node.getAttribute("text:style-name");
            this.palette.getI18n().pushSpecialTable(this.palette.getCharSc().getFontName(styleName));
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) break;
                        ldp.append(this.palette.getI18n().convert(s, false, oc.getLang()));
                        break;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (sName.equals("text:s")) {
                            int count = Misc.getPosInteger(child.getAttribute("text:c"), 1);
                            while (count > 0) {
                                ldp.append("\\ ");
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop")) {
                            ldp.append(" ");
                            break;
                        }
                        if (sName.equals("text:footnote") || sName.equals("text:endnote") || !sName.startsWith("text:")) break;
                        this.traversePlainInlineText(child, ldp, oc);
                        break;
                    }
                }
                ++i;
            }
            this.palette.getI18n().popSpecialTable();
        }
    }

    public void traverseVerbatimInlineText(Element node, LaTeXDocumentPortion ldp, Context oc, boolean bInline) {
        if (node.hasChildNodes()) {
            NodeList nList = node.getChildNodes();
            int len = nList.getLength();
            int i = 0;
            while (i < len) {
                Node childNode = nList.item(i);
                short nodeType = childNode.getNodeType();
                switch (nodeType) {
                    case 3: {
                        String s = childNode.getNodeValue();
                        if (s.length() <= 0) break;
                        ldp.append(s);
                        break;
                    }
                    case 1: {
                        Element child = (Element)childNode;
                        String sName = child.getTagName();
                        if (sName.equals("text:s")) {
                            int count = Misc.getPosInteger(child.getAttribute("text:c"), 1);
                            while (count > 0) {
                                ldp.append(" ");
                                --count;
                            }
                            break;
                        }
                        if (sName.equals("text:tab-stop")) {
                            ldp.append(" ");
                            break;
                        }
                        if (sName.equals("text:line-break")) {
                            if (bInline) break;
                            ldp.nl();
                            break;
                        }
                        if (sName.equals("text:footnote") || sName.equals("text:endnote") || !sName.startsWith("text:")) break;
                        this.traverseVerbatimInlineText(child, ldp, oc, bInline);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void traversePCDATA(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    ldp.append(this.palette.getI18n().convert(nl.item(i).getNodeValue(), false, oc.getLang()));
                }
                ++i;
            }
        }
    }

    private void handleChapterField(Element node, LaTeXDocumentPortion ldp, Context oc) {
        HeadingMap hm = this.config.getHeadingMap();
        int nLevel = Misc.getPosInteger(node.getAttribute("text:outline-level"), 1);
        if (nLevel <= hm.getMaxLevel()) {
            int nLaTeXLevel = hm.getLevel(nLevel);
            if (nLaTeXLevel == 1) {
                this.palette.getPageSc().setChapterField1(node.getAttribute("text:display"));
                ldp.append("{\\leftmark}");
            } else if (nLaTeXLevel == 2) {
                this.palette.getPageSc().setChapterField2(node.getAttribute("text:display"));
                ldp.append("{\\rightmark}");
            }
        }
    }

    private void handleOfficeAnnotation(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append("%").nl().append("%");
        Element paragraph = Misc.getChildByTagName(node, "text:p");
        if (paragraph != null) {
            this.traversePCDATA(paragraph, ldp, oc);
        }
        ldp.nl();
    }

    private boolean onlyNote(Node node) {
        if (!node.hasChildNodes()) {
            return false;
        }
        NodeList nList = node.getChildNodes();
        int nLen = nList.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nList.item(i);
            short nType = child.getNodeType();
            String sName = child.getNodeName();
            switch (nType) {
                case 3: {
                    return false;
                }
                case 1: {
                    if ("text:footnote".equals(sName) || "text:endnote".equals(sName)) break;
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

