/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class float_sign
extends Primitive {
    private static final Primitive FLOAT_SIGN = new float_sign();

    private float_sign() {
        super("float-sign", "float-1 &optional float-2");
    }

    @Override
    public LispObject execute(LispObject arg) {
        if (arg instanceof SingleFloat) {
            float f = ((SingleFloat)arg).value;
            int bits = Float.floatToRawIntBits(f);
            return bits < 0 ? SingleFloat.MINUS_ONE : SingleFloat.ONE;
        }
        if (arg instanceof DoubleFloat) {
            double d = ((DoubleFloat)arg).value;
            long bits = Double.doubleToRawLongBits(d);
            return bits < 0L ? DoubleFloat.MINUS_ONE : DoubleFloat.ONE;
        }
        return Lisp.type_error(arg, Symbol.FLOAT);
    }

    @Override
    public LispObject execute(LispObject first, LispObject second) {
        if (!first.floatp()) {
            return Lisp.type_error(first, Symbol.FLOAT);
        }
        if (!second.floatp()) {
            return Lisp.type_error(second, Symbol.FLOAT);
        }
        if (first.minusp()) {
            if (second.minusp()) {
                return second;
            }
            return Fixnum.ZERO.subtract(second);
        }
        return second.ABS();
    }
}

