/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.Utf8CPInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.MethodInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.Utils;

public final class ClassFile {
    private MethodInfo[] methods;
    private String sourceFile;
    private String fullname;
    private int access_flags;

    public ClassFile(InputStream is) throws IOException {
        int j;
        int attributes_count;
        DataInputStream dis = new DataInputStream(is);
        ConstantPool constantPool = new ConstantPool();
        int magic = dis.readInt();
        short minor = dis.readShort();
        short major = dis.readShort();
        constantPool.read(dis);
        constantPool.resolve();
        this.access_flags = dis.readShort();
        short this_class = dis.readShort();
        this.fullname = ((ClassCPInfo)constantPool.getEntry(this_class)).getClassName().replace('/', '.');
        short super_class = dis.readShort();
        short count = dis.readShort();
        dis.skipBytes(count * 2);
        int numFields = dis.readShort();
        for (int i = 0; i < numFields; ++i) {
            dis.skip(6L);
            attributes_count = dis.readUnsignedShort();
            for (j = 0; j < attributes_count; ++j) {
                dis.skipBytes(2);
                int len = dis.readInt();
                dis.skipBytes(len);
            }
        }
        int method_count = dis.readShort();
        this.methods = new MethodInfo[method_count];
        for (int i = 0; i < method_count; ++i) {
            this.methods[i] = new MethodInfo();
            this.methods[i].read(constantPool, dis);
        }
        attributes_count = dis.readUnsignedShort();
        for (j = 0; j < attributes_count; ++j) {
            short attr_id = dis.readShort();
            int len = dis.readInt();
            String attr_name = Utils.getUTF8Value(constantPool, attr_id);
            if ("SourceFile".equals(attr_name)) {
                short name_index = dis.readShort();
                this.sourceFile = ((Utf8CPInfo)constantPool.getEntry(name_index)).getValue();
                continue;
            }
            dis.skipBytes(len);
        }
    }

    public int getAccess() {
        return this.access_flags;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public MethodInfo[] getMethods() {
        return this.methods;
    }

    public String getFullName() {
        return this.fullname;
    }

    public String getName() {
        String name = this.getFullName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(pos + 1);
    }

    public String getPackage() {
        String name = this.getFullName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(0, pos);
    }
}

