/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.FloatLookupContainer;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import java.util.Arrays;

abstract class AbstractFloatCollection
implements FloatCollection {
    AbstractFloatCollection() {
    }

    @Override
    public int removeAll(FloatLookupContainer c) {
        final FloatLookupContainer c2 = c;
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(FloatLookupContainer c) {
        final FloatLookupContainer c2 = c;
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return !c2.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final FloatPredicate predicate) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public float[] toArray() {
        int size = this.size();
        float[] array = new float[size];
        int i = 0;
        for (FloatCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

