/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import java.nio.ByteBuffer;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.tables.HashEntries;
import org.caffinitas.ohc.tables.Uns;
import org.caffinitas.ohc.tables.Util;

class DirectValueAccessImpl
implements DirectValueAccess {
    private final long hashEntryAdr;
    volatile boolean closed;
    private final ByteBuffer buffer;

    public DirectValueAccessImpl(long hashEntryAdr) {
        this(hashEntryAdr, HashEntries.getKeyLen(hashEntryAdr), HashEntries.getValueLen(hashEntryAdr));
    }

    DirectValueAccessImpl(long hashEntryAdr, long keyLen, long valueLen) {
        this.hashEntryAdr = hashEntryAdr;
        this.buffer = Uns.directBufferFor(hashEntryAdr, 40L + Util.roundUpTo8(keyLen), valueLen, false);
    }

    @Override
    public ByteBuffer buffer() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
        return this.buffer;
    }

    @Override
    public void close() {
        this.deref();
    }

    private void deref() {
        if (!this.closed) {
            this.closed = true;
            HashEntries.dereference(this.hashEntryAdr);
        }
    }
}

