/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketWrapper;

public class InternalOutputBuffer
extends AbstractOutputBuffer<Socket>
implements ByteChunk.ByteOutputChannel {
    protected OutputStream outputStream;
    private final ByteChunk socketBuffer;
    private boolean useSocketBuffer = false;

    public InternalOutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.outputStreamOutputBuffer = new OutputStreamOutputBuffer();
        this.socketBuffer = new ByteChunk();
        this.socketBuffer.setByteOutputChannel((ByteChunk.ByteOutputChannel)this);
    }

    @Override
    public void setSocketBuffer(int socketBufferSize) {
        if (socketBufferSize > 500) {
            this.useSocketBuffer = true;
            this.socketBuffer.allocate(socketBufferSize, socketBufferSize);
        } else {
            this.useSocketBuffer = false;
        }
    }

    @Override
    public void init(SocketWrapper<Socket> socketWrapper, AbstractEndpoint<Socket> endpoint) throws IOException {
        this.outputStream = socketWrapper.getSocket().getOutputStream();
    }

    @Override
    public void recycle() {
        super.recycle();
        this.outputStream = null;
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.socketBuffer.recycle();
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.outputStream.write(Constants.ACK_BYTES);
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            if (this.useSocketBuffer) {
                this.socketBuffer.append(this.headerBuffer, 0, this.pos);
            } else {
                this.outputStream.write(this.headerBuffer, 0, this.pos);
            }
        }
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.outputStream.write(cbuf, off, len);
        }
    }

    @Override
    protected boolean hasMoreDataToFlush() {
        return false;
    }

    @Override
    protected void registerWriteInterest() {
    }

    @Override
    protected boolean flushBuffer(boolean block) throws IOException {
        if (this.useSocketBuffer) {
            this.socketBuffer.flushBuffer();
        }
        return false;
    }

    protected class OutputStreamOutputBuffer
    implements OutputBuffer {
        protected OutputStreamOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            try {
                int length = chunk.getLength();
                if (InternalOutputBuffer.this.useSocketBuffer) {
                    InternalOutputBuffer.this.socketBuffer.append(chunk.getBuffer(), chunk.getStart(), length);
                } else {
                    InternalOutputBuffer.this.outputStream.write(chunk.getBuffer(), chunk.getStart(), length);
                }
                InternalOutputBuffer.this.byteCount += (long)chunk.getLength();
                return chunk.getLength();
            }
            catch (IOException ioe) {
                InternalOutputBuffer.this.response.action(ActionCode.CLOSE_NOW, ioe);
                throw ioe;
            }
        }

        @Override
        public long getBytesWritten() {
            return InternalOutputBuffer.this.byteCount;
        }
    }
}

