package org.cdavies.itunes.request;

import java.net.*;
import java.io.*;
import java.util.*;

import itunes.FieldPair;
import org.cdavies.itunes.Database;
import org.cdavies.itunes.hash.*;

public class LegacyDatabaseRequest extends Request implements DatabaseRequest {
	
	protected ArrayList mlclDataFields;
	protected ArrayList mlitDataFields;
	
	private Database[] _dbNames;
	
	public LegacyDatabaseRequest(String server, int port, int sessionId) {
		
		super(server, port, "databases?session-id=" + sessionId);
		
	}
	
	
	public void runQuery() throws NoServerPermissionException {
		
		try {
			
			DataInputStream _in = new DataInputStream(_conn.getInputStream());
			
			int _len = _conn.getContentLength();
			
			if (_len == -1)
				return;
			
			data = new byte[_len];
			_in.readFully(data);
			
		} 
		catch (MalformedURLException _e) {
			
			/* Should never happen */
			_e.printStackTrace();
			System.exit(1);
			
		} 
		catch (IOException _e) {
			
			throw new NoServerPermissionException(_e.getMessage());
			
		}
		
	}
	
	public void process() throws NoServerPermissionException {
		
		super.process();
		parseMLCL();
		
		_dbNames = new Database[mlitDataFields.size()];
		
		for (int _i = 0; _i < mlitDataFields.size(); _i++) {
			
			ArrayList _fps = ((ArrayList)mlitDataFields.get(_i));
			String _name=null;
			int _id=0;
			int _tracks = 0;
			
			for (int _j = 0; _j < _fps.size(); _j++) {
				
				FieldPair _fp =((FieldPair)_fps.get(_j));
				
				if (_fp.name.equals("miid")) 
					_id = Request.readInt(_fp.value,0); 
				else if (_fp.name.equals("minm")) 
					_name = Request.readString(_fp.value,0,_fp.value.length);
				else if (_fp.name.equals("mimc")) 
					_tracks = Request.readInt(_fp.value,0);
				
			}
			
			_dbNames[_i] = new Database(_id, _name, _tracks);
			
		}
		
	}
	
	private void parseMLIT() {
		
		mlitDataFields = new ArrayList(); 
		
		for (int _i = 0; _i < mlitIndexes.size(); _i++) {
			
			byte[] _mlitData = ((FieldPair)mlclDataFields.get(((Integer)mlitIndexes.get(_i)).intValue())).value;
			mlitDataFields.add(processDataFields(_mlitData, 0)); 
			
		}
		
	}
	
	protected void parseMLCL() {
		
		for (int i = 0; i < mlclIndexes.size(); i++) {
			
			byte[] mlclData = ((FieldPair)fieldPairs.get(((Integer)mlclIndexes.get(i)).intValue())).value;
			mlclDataFields = this.processDataFields(mlclData,0);
			
		}
		
		parseMLIT();
		
	}
	
	
	public Database[] getDatabases() {
		
		return _dbNames;
		
	}
	
}
