/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import ints.IntArray;
import java.util.Arrays;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.RefGTRec;
import vcf.Samples;

public class SeqCodedRefGTRec
implements RefGTRec {
    private final Marker marker;
    private final Samples samples;
    private final IntArray hapToSeq;
    private final IntArray seqToAllele;

    public SeqCodedRefGTRec(Marker marker, Samples samples, IntArray intArray, IntArray intArray2) {
        if (intArray.size() != 2 * samples.size()) {
            throw new IllegalArgumentException("inconsistent data");
        }
        this.marker = marker;
        this.samples = samples;
        this.hapToSeq = intArray;
        this.seqToAllele = intArray2;
    }

    @Override
    public boolean isPhased(int n) {
        if (n < 0 || n >= this.samples().size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public boolean isPhased() {
        return true;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return this.hapToSeq.size();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public int[][] hapIndices() {
        int n;
        int n2;
        int[] nArray = new int[this.marker().nAlleles()];
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.get(n2);
            nArray[n4] = nArray[n4] + 1;
        }
        n2 = 0;
        for (n3 = 1; n3 < nArray.length; ++n3) {
            if (nArray[n3] <= nArray[n2]) continue;
            n2 = n3;
        }
        int[][] nArrayArray = new int[nArray.length][];
        for (n = 0; n < nArray.length; ++n) {
            if (n == n2) continue;
            nArrayArray[n] = new int[nArray[n]];
        }
        Arrays.fill(nArray, 0);
        int n5 = this.size();
        for (n = 0; n < n5; ++n) {
            int n6 = this.get(n);
            if (n6 == n2) continue;
            int n7 = n6;
            int n8 = nArray[n7];
            nArray[n7] = n8 + 1;
            nArrayArray[n6][n8] = n;
        }
        return nArrayArray;
    }

    @Override
    public boolean isAlleleCoded() {
        return false;
    }

    @Override
    public int majorAllele() {
        int[][] nArray = this.hapIndices();
        int n = -1;
        for (int i = 0; i < nArray.length && n == -1; ++i) {
            if (nArray[i] != null) continue;
            n = i;
        }
        return n;
    }

    @Override
    public int alleleCount(int n) {
        int[][] nArray = this.hapIndices();
        if (nArray[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return nArray[n].length;
    }

    @Override
    public int allele1(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n << 1));
    }

    @Override
    public int allele2(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n << 1 | 1));
    }

    @Override
    public int get(int n) {
        return this.seqToAllele.get(this.hapToSeq.get(n));
    }

    @Override
    public int[] alleles() {
        return IntStream.range(0, this.hapToSeq.size()).map(n -> this.get(n)).toArray();
    }

    @Override
    public int hapIndex(int n, int n2) {
        int[][] nArray = this.hapIndices();
        if (nArray[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return nArray[n][n2];
    }

    @Override
    public boolean isCarrier(int n, int n2) {
        return this.get(n2) == n;
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }

    @Override
    public int nMaps() {
        return 2;
    }

    @Override
    public IntArray[] maps() {
        return new IntArray[]{this.hapToSeq, this.seqToAllele};
    }

    @Override
    public IntArray map(int n) {
        if (n == 0) {
            return this.hapToSeq;
        }
        if (n == 1) {
            return this.seqToAllele;
        }
        throw new IndexOutOfBoundsException(String.valueOf(n));
    }
}

